/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sso;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DCConfiguration.DCConfigUtil;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.admin.FilterHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class NTLMHandler {
    private static Logger logger = Logger.getLogger(NTLMHandler.class.getName());
    private static String[] defaultSSOAttribs = new String[]{"excludes", "jespa.log.path", "jespa.log.level", "jespa.account.canonicalForm", "http.parameter.username.name", "http.parameter.password.name", "http.parameter.logout.name", "authority.dns.names.resolve"};
    private static String[] defaultSSOValues = new String[]{"*.css, *.js, *.png, *.bmp, *.jpg, *.gif, /accounts/*, /m/*, *showLogin.cc*, *adminLogin.cc*, *.html", "../logs/", "4", "3", "j_username", "j_password", "logout", "false"};

    public static JSONObject getSSOProps(String domainName) {
        return NTLMHandler.getSSOProps(new ArrayList<String>(Arrays.asList(domainName)));
    }

    public static JSONObject getSSOProps(ArrayList domainNameList) {
        JSONObject ssoProps = new JSONObject();
        try {
            String tableName = "SSPSSOConfig";
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainNameList.toArray(new String[domainNameList.size()]), 8, false);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!dObj.isEmpty()) {
                for (int i = 0; i < domainNameList.size(); ++i) {
                    String domainName = (String)domainNameList.get(i);
                    Properties props = new Properties();
                    Row r = dObj.getRow(tableName, new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
                    if (r != null) {
                        String dnsSite;
                        props.setProperty("jespa.service.acctname", (String)r.get("ACCOUNT_NAME"));
                        props.setProperty("jespa.service.password", (String)r.get("PASSWORD"));
                        String dnsName = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "DOMAIN_DNS_NAME");
                        props.setProperty("jespa.bindstr", dnsName);
                        String dnsServers = (String)r.get("DNS_SERVERS");
                        if (dnsServers != null && !dnsServers.equals("")) {
                            props.setProperty("jespa.dns.servers", dnsServers);
                        }
                        if ((dnsSite = (String)r.get("DNS_SITE")) != null && !dnsSite.equals("")) {
                            props.setProperty("jespa.dns.site", dnsSite);
                        }
                        for (int j = 0; j < defaultSSOAttribs.length; ++j) {
                            String value = defaultSSOValues[j];
                            if (defaultSSOAttribs[j].equalsIgnoreCase("jespa.log.path")) {
                                value = value + domainName + "_jespa.log";
                            } else if (defaultSSOAttribs[j].equalsIgnoreCase("authority.dns.names.resolve") && value.equals("false")) {
                                String dcName = DCConfigUtil.getFirstDC(domainName);
                                if (dcName.toLowerCase().indexOf(dnsName.toLowerCase()) == -1) {
                                    dcName = dcName + "." + dnsName;
                                }
                                props.setProperty("jespa.bindstr", dcName);
                            }
                            props.setProperty(defaultSSOAttribs[j], value);
                        }
                    }
                    ssoProps.put(domainName, (Object)props);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ssoProps;
    }

    public static void setSSOProps(String domainName, Properties ssoProps, boolean createComputerAccount) throws Exception {
        try {
            Credential cred = AuthUtil.getUserCredential();
            Long loginId = cred.getLoginId();
            JSONObject domainJsonObj = DomainHandler.getDomainDetails(domainName);
            String domainDNSName = domainJsonObj.getString("DOMAIN_DNS_NAME");
            String defaultNamingContext = domainJsonObj.getString("DEFAULT_NAMING_CONTEXT");
            String computerName = ssoProps.getProperty("ACCOUNT_NAME") + "$";
            String password = ssoProps.getProperty("PASSWORD");
            String searchString = "(&(objectClass=computer)(objectCategory=computer)(samAccountName=" + StrUtil.ldapEscape(computerName) + "))";
            logger.log(Level.INFO, "Checking the existence of computer account with query : " + searchString);
            ArrayList computerPropsList = ADHandler.getComputers(domainName, new String[]{"samAccountName", "objectGUID", "objectSid", "distinguishedName"}, searchString, defaultNamingContext);
            Boolean isComputerAccExist = computerPropsList != null && computerPropsList.size() > 0;
            if (!isComputerAccExist.booleanValue() && !createComputerAccount) {
                throw new Exception("adssp.error.native.nosuch_object_on_the_server");
            }
            if (isComputerAccExist.booleanValue() && createComputerAccount) {
                throw new Exception("adssp.error.native.obj_already_exists");
            }
            if (createComputerAccount) {
                logger.log(Level.INFO, "CreateComputerAccount starts");
                String containerDN = "CN=Computers," + defaultNamingContext;
                NativeError err = ADHandler.addComputer(domainName, loginId, containerDN, ssoProps.getProperty("ACCOUNT_NAME"), computerName, password, new ArrayList(), new ArrayList(), new ArrayList());
                err.checkForException(containerDN);
                err.checkForException(ssoProps.getProperty("ACCOUNT_NAME"));
            }
            String tableName = "SSPSSOConfig";
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            Row r = dObj.getRow(tableName);
            boolean add = false;
            if (r == null) {
                r = new Row(tableName);
                r.set("DOMAIN_NAME", (Object)domainName);
                add = true;
            }
            r.set("ACCOUNT_NAME", (Object)(computerName + "@" + domainDNSName));
            r.set("PASSWORD", (Object)password);
            if (ssoProps.containsKey("DNS_SERVERS")) {
                r.set("DNS_SERVERS", ssoProps.get("DNS_SERVERS"));
            }
            if (ssoProps.containsKey("DNS_SITE")) {
                r.set("DNS_SITE", ssoProps.get("DNS_SITE"));
            }
            if (add) {
                dObj.addRow(r);
            } else {
                dObj.updateRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
            FilterHandler.getInstance().setNTLMService(domainJsonObj.getString("DOMAIN_FLAT_NAME"), null);
        }
        catch (NativeException e) {
            logger.log(Level.INFO, "setSSOProps Exception : " + e.getExceptionMsg());
            throw new Exception(e.getExceptionMsg());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "setSSOProps Exception : " + e.getMessage());
            throw new Exception(e.getMessage());
        }
    }
}

