/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.reports.enrollment.EnrollUtil;
import com.adventnet.sym.adsm.common.server.scheduler.ScheduleAutoEnrollHandler;
import com.adventnet.sym.adsm.common.server.util.CSVReader;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoEnrollment
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        String forward = "page";
        String statusMessage = "";
        Boolean overWrite = false;
        Long policyId = 0L;
        Long queId = 0L;
        Integer importColumn = 2;
        try {
            Long scheduleId = taskContext.getScheduleID();
            Hashtable props = ScheduleAutoEnrollHandler.getSchedulerProps(scheduleId, null);
            ArrayList policyIds = (ArrayList)props.get("SCHEDULED_POLICY_IDS");
            policyId = (Long)policyIds.get(0);
            if (PolicyHandler.isEnrollAllowed(policyId)) {
                reportLogger.log(Level.INFO, "Scheduling the Auto Enrollment Starting............");
                props.put("CSV_FILE", new File((String)props.get("FILE_PATH")));
                Hashtable hash = EnrollUtil.enrollFromCSV(props);
                reportLogger.log(Level.INFO, "Scheduling the Auto Enrollment Ending............");
            } else {
                reportLogger.log(Level.INFO, "The policy doesn't have enroll permission");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "AutoEnrollment";
    }

    private static Hashtable getListFromCSV(File file) {
        Vector headerVector = new Vector();
        Hashtable<String, AbstractList> hashTab = new Hashtable<String, AbstractList>();
        ArrayList<Vector> list = new ArrayList<Vector>();
        try {
            Boolean header = true;
            FileInputStream stream = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, System.getProperty("file.encoding")));
            CSVReader csvReader = new CSVReader(reader);
            try {
                if (header.booleanValue()) {
                    headerVector = csvReader.getAllFieldsInLine();
                    hashTab.put("HeaderVector", headerVector);
                }
            }
            catch (Exception ex) {
                csvReader.close();
            }
            try {
                while (true) {
                    Vector valuesVector;
                    if ((valuesVector = csvReader.getAllFieldsInLine()).isEmpty() || valuesVector.size() == 0) {
                        continue;
                    }
                    list.add(valuesVector);
                }
            }
            catch (EOFException eofexception) {
                csvReader.close();
                hashTab.put("CsvList", list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashTab;
    }

    private int getHeaderIndex(Hashtable hash) {
        int i = 1;
        Enumeration e = hash.elements();
        while (e.hasMoreElements()) {
            Boolean bool = (Boolean)e.nextElement();
            if (!bool.booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private Hashtable getHeaderIndex(ArrayList<Vector> list, int hIndex, Vector headerVector, Hashtable impColHash) throws Exception {
        Hashtable<String, Integer> indexing = new Hashtable<String, Integer>();
        try {
            int sANPos = -1;
            int quePos = -1;
            int ansPos = -1;
            int mobilePos = -1;
            int mailPos = -1;
            if (list.size() == 0) {
                throw new Exception("adssp.admin.policies.import_ans.file_no_content");
            }
            if (headerVector.size() == 0) {
                throw new Exception("adssp.admin.policies.import_ans.provide_header");
            }
            if (hIndex != headerVector.size()) {
                throw new Exception("adssp.admin.policies.import_ans.mismatch_option");
            }
            int allField = 0;
            for (int j = 0; j < hIndex; ++j) {
                String key = (String)headerVector.get(j);
                if (key.equalsIgnoreCase("samaccountname") || impColHash.get(key.toLowerCase()) != null && ((Boolean)impColHash.get(key.toLowerCase())).booleanValue()) {
                    if (key.equalsIgnoreCase("samaccountname") && sANPos == -1) {
                        sANPos = j;
                        ++allField;
                        continue;
                    }
                    if (key.equalsIgnoreCase("question") && quePos == -1) {
                        quePos = j;
                        ++allField;
                        continue;
                    }
                    if (key.equalsIgnoreCase("answer") && ansPos == -1) {
                        ansPos = j;
                        ++allField;
                        continue;
                    }
                    if (key.equalsIgnoreCase("mobile") && mobilePos == -1) {
                        mobilePos = j;
                        ++allField;
                        continue;
                    }
                    if (key.equalsIgnoreCase("mail") && mailPos == -1) {
                        mailPos = j;
                        ++allField;
                        continue;
                    }
                    throw new Exception("adssp.admin.policies.import_ans.provide_header");
                }
                throw new Exception("adssp.admin.policies.import_ans.mismatch_option");
            }
            if (allField != hIndex || sANPos == -1) {
                throw new Exception("adssp.admin.policies.import_ans.provide_header");
            }
            indexing.put("sANPos", sANPos);
            indexing.put("quePos", quePos);
            indexing.put("ansPos", ansPos);
            indexing.put("mobilePos", mobilePos);
            indexing.put("mailPos", mailPos);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return indexing;
    }
}

