/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.taskengine.MSIPatchUpdate;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GinaUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomizeGina
implements Task {
    private static Logger out = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            out.log(Level.INFO, "CustomizeGina TaskEngine called");
            Long scheduleId = taskContext.getScheduleID();
            Long agentAuditId = GinaUtil.addToAgentAuditActions(new Long(-1L), "SCHED_CUSTOM_GINA");
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPASConfiguration", new Criteria(new Column("SSPASConfiguration", "SCHEDULE_ID"), (Object)scheduleId, 0));
            Row r = dObj.getFirstRow("SSPASConfiguration");
            Long agentId = (Long)r.get("AGENT_ID");
            Properties customProps = AgentSchedulerUtil.getCustomProps(new Long(-1L));
            String configTableName = new String("SSPASConfiguration");
            Table configTable = new Table(configTableName);
            SelectQueryImpl query = new SelectQueryImpl(configTable);
            Criteria crit = new Criteria(new Column(configTableName, "SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(crit);
            Join pendCompJoin = new Join("SSPASConfiguration", "SSPASPendingComputers", new String[]{"AGENT_ID"}, new String[]{"AGENT_ID"}, 2);
            query.addJoin(pendCompJoin);
            query.addSelectColumn(new Column("SSPASPendingComputers", "OBJECT_GUID"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            String randId = MSIPatchUpdate.getUniqueID();
            while (dataSet.next()) {
                CustomizeGina.customize((String)dataSet.getValue("OBJECT_GUID"), customProps, agentAuditId);
            }
            Row auditRow = taskContext.getAuditRow();
            Long scheduleAuditId = (Long)auditRow.get("AUDIT_ID");
            AgentSchedulerUtil.mapAgentAuditAction(agentId, scheduleAuditId, agentAuditId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    public static void customize(String objGuid, Properties customProps, Long actionId) {
        String status = new String();
        try {
            Properties machineProp = AgentSchedulerUtil.getDetails(objGuid);
            if (!machineProp.isEmpty()) {
                if (GinaUtil.isMac(machineProp.getProperty("os"))) {
                    machineProp.setProperty("installAction", "customize");
                    ArrayList arrList = CommonUtil.getDomainUserDetails(machineProp.getProperty("domainName"));
                    if (arrList.size() > 0) {
                        GinaUtil.installMacPackage(machineProp, (String)arrList.get(0), (String)arrList.get(1), null);
                        status = machineProp.getProperty("installStatus");
                    }
                } else {
                    status = ADHandler.UpdateRegistry(machineProp.getProperty("sAMAccountName"), customProps, machineProp.getProperty("domainName"));
                }
                out.log(Level.FINE, "Gina customization status [" + machineProp.getProperty("sAMAccountName") + "] : " + status);
                if (status.equals("adssp.config.management.agent_scheduler.update_registry_success") || status.equals("adssp_admin_gina_install_success")) {
                    AgentSchedulerUtil.removePendingComp(objGuid);
                }
            }
        }
        catch (ADSSPException aE) {
            status = aE.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            AgentSchedulerUtil.addToAuditActionResult(objGuid, actionId, status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

