/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.BackupSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseBackup
implements Task {
    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        Logger OUT = Logger.getLogger("DatabaseBackup");
        String dbName = PersistenceInitializer.getConfigurationValue((String)"DBName");
        Boolean isBuiltInDB = BackupSchedulerUtil.isBuiltInDB();
        if (!dbName.equalsIgnoreCase("mssql") && isBuiltInDB.booleanValue()) {
            String backupDir = BackupSchedulerUtil.getBackupLocation(taskContext);
            OUT.log(Level.INFO, " Backup Status {0} ", BackupSchedulerUtil.executeDBBackupOperation(backupDir));
        } else {
            OUT.log(Level.INFO, "The auto back-up facility is available only for the product-default database");
            try {
                Criteria c = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)"adssp.admin.customization.dbbackup_scheduler", 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", c);
                Row r = obj.getRow("Schedule");
                Long scheduleId = (Long)r.get("SCHEDULE_ID");
                Criteria crit = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", crit);
                if (!dObj.isEmpty()) {
                    r = dObj.getFirstRow("Scheduled_Task");
                    r.set("ADMIN_STATUS", (Object)new Integer(4));
                    dObj.updateRow(r);
                    CommonUtil.getPersistence(new boolean[0]).update(dObj);
                    OUT.log(Level.INFO, " Automatic DB Scheduler is disabled ");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopTask() {
    }
}

