/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.sym.adsm.common.server.admin.AdvancedPolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.SoonToExpireHandler;
import com.adventnet.sym.adsm.common.server.configuration.EnrollmentNotifyHandler;
import com.adventnet.sym.adsm.common.server.scheduler.ScheduleEnrollHandler;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnrollmentNotification
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        try {
            reportLogger.log(Level.INFO, "Scheduling the Enrollment Notification Starting............");
            Properties mailProp = ADSMPersUtil.getMailServerSettings();
            String mail_server = (String)mailProp.get("MAIL_SERVER");
            Long scheduleId = taskContext.getScheduleID();
            Hashtable props = ScheduleEnrollHandler.getSchedulerProps(scheduleId, null);
            Properties mailConfig = new Properties();
            for (String str : ServerUtil.MAIL_PARAMS) {
                mailConfig.put(str, mailProp.get(str));
            }
            String subject = (String)props.get("MAIL_SUBJECT");
            String mailText = (String)props.get("MAIL_CONTENT");
            Hashtable inputParams = (Hashtable)props.get("inputParams");
            String toAddress = "POLICY".equals((String)inputParams.get("NOTIFICATION_FILTER")) ? "policy" : "domains";
            int notifyVia = Integer.parseInt(props.get("NOTIFY_VIA").toString());
            ArrayList notifyModes = SoonToExpireHandler.getInstance().getselectedNotifyModes(notifyVia);
            if (toAddress.equals("policy")) {
                ArrayList policyIds = (ArrayList)props.get("SCHEDULED_POLICY_IDS");
                ArrayList<String> domainNames = new ArrayList<String>();
                for (int i = 0; i < policyIds.size(); ++i) {
                    String domainName = AdvancedPolicyHandler.getRequiredPCValue((Long)policyIds.get(i), "DOMAIN_NAME", "PolicyConfiguration");
                    if (domainName.equals("") || domainNames.contains(domainName)) continue;
                    domainNames.add(domainName);
                    if (notifyModes.contains("MAIL") && !mail_server.equals("")) {
                        EnrollmentNotifyHandler.sendEnrollmentMailReq(domainName, mailConfig, subject, mailText, toAddress, "", null, policyIds, true);
                    }
                    if (!notifyModes.contains("PushNotification")) continue;
                    EnrollmentNotifyHandler.sendEnrollmentPNReqPerDevice(domainName, subject, mailText, toAddress, null, policyIds, 1);
                }
            } else {
                Hashtable domains = (Hashtable)props.get("DOMAIN_VS_OUS");
                Enumeration enumer = domains.keys();
                while (enumer.hasMoreElements()) {
                    String domainName = (String)enumer.nextElement();
                    ArrayList ouList = (ArrayList)domains.get(domainName);
                    if (notifyModes.contains("MAIL") && !mail_server.equals("")) {
                        EnrollmentNotifyHandler.sendEnrollmentMailReq(domainName, mailConfig, subject, mailText, toAddress, "", ouList, null, true);
                    }
                    if (!notifyModes.contains("PushNotification")) continue;
                    EnrollmentNotifyHandler.sendEnrollmentPNReqPerDevice(domainName, subject, mailText, toAddress, ouList, null, 1);
                }
            }
            reportLogger.log(Level.INFO, "Scheduling the Enrollment Notification Ending............");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "EnrollmentNotification";
    }
}

