/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.reports.ServerThreadPool;
import com.adventnet.sym.adsm.common.server.taskengine.MSIPatchUpdate;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GinaUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallGina
implements Task {
    private static Logger out = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            out.log(Level.INFO, "InstallGina TaskEngine called");
            Long scheduleId = taskContext.getScheduleID();
            Long agentAuditId = GinaUtil.addToAgentAuditActions(new Long(-1L), "SCHED_INSTALL_GINA");
            String configTableName = new String("SSPASConfiguration");
            Table configTable = new Table(configTableName);
            SelectQueryImpl query = new SelectQueryImpl(configTable);
            Criteria crit = new Criteria(new Column(configTableName, "SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(crit);
            Join configFilterJoin = new Join(configTableName, "SSPASDomainOUs", new String[]{"AGENT_ID"}, new String[]{"AGENT_ID"}, 2);
            query.addJoin(configFilterJoin);
            query.addSelectColumn(new Column("SSPASDomainOUs", "DOMAIN_NAME"));
            query.addSelectColumn(new Column("SSPASDomainOUs", "OU_DN"));
            query.addSelectColumn(new Column(configTableName, "AGENT_ID"));
            RelationalAPI rApi = RelationalAPI.getInstance();
            connection = rApi.getConnection();
            dataSet = rApi.executeQuery((Query)query, connection);
            Hashtable<String, ArrayList<String>> ouTable = new Hashtable<String, ArrayList<String>>();
            Long agentId = new Long(-1L);
            while (dataSet.next()) {
                agentId = (Long)dataSet.getValue("AGENT_ID");
                String domainName = (String)dataSet.getValue("DOMAIN_NAME");
                ArrayList<String> ouList = (ArrayList<String>)ouTable.get(domainName);
                if (ouList == null) {
                    ouList = new ArrayList<String>();
                }
                ouList.add((String)dataSet.getValue("OU_DN"));
                ouTable.put(domainName, ouList);
            }
            String randId = MSIPatchUpdate.getUniqueID();
            ServerThreadPool serverPool = ServerThreadPool.getInstance();
            serverPool.addSessionId(randId);
            Enumeration e = ouTable.keys();
            while (e.hasMoreElements()) {
                String keyName = (String)e.nextElement();
                ArrayList arrList = CommonUtil.getDomainUserDetails(keyName);
                ArrayList compList = AgentSchedulerUtil.getComputerList(keyName, (ArrayList)ouTable.get(keyName));
                Properties machineProps = new Properties();
                for (int z = 0; z < compList.size(); ++z) {
                    machineProps = (Properties)compList.get(z);
                    out.log(Level.INFO, "INSTALL_NEW :: The machine name is " + machineProps.get("sAMAccountName"));
                    MSIPatchUpdate.AgentRunnable agentRunnable = new MSIPatchUpdate.AgentRunnable(machineProps, (String)arrList.get(0), (String)arrList.get(1), agentAuditId);
                    serverPool.runTask(randId, agentRunnable);
                }
            }
            serverPool.removeSessionId(randId);
            Row auditRow = taskContext.getAuditRow();
            Long scheduleAuditId = (Long)auditRow.get("AUDIT_ID");
            AgentSchedulerUtil.mapAgentAuditAction(agentId, scheduleAuditId, agentAuditId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

