/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.reports.ServerThreadPool;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GinaUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MSIPatchUpdate
implements Task {
    private static Logger out = Logger.getLogger("ReportLogger");
    private String tableName = "AgentComputerDetails";

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        try {
            out.log(Level.INFO, "Scheduling the Patch Update.");
            Long agentAuditId = GinaUtil.addToAgentAuditActions(new Long(-1L), "PATCH_UPDATE_GINA");
            String productInstallPath = System.getProperty("server.home");
            String randId = MSIPatchUpdate.getUniqueID();
            Hashtable packageDetails = CommonUtil.getPackageDetails(productInstallPath);
            String serverAgentVersion = (String)packageDetails.get("AgentVersion");
            Table table = new Table(this.tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria critInstallSuccess = new Criteria(new Column(this.tableName, "INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 0);
            critInstallSuccess = critInstallSuccess.or(new Criteria(new Column(this.tableName, "INSTALL_STATUS"), (Object)"adssp_admin_gina_reinstall_success", 0));
            query.addSelectColumn(new Column(null, "*"));
            query.setCriteria(critInstallSuccess);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            ServerThreadPool serverPool = ServerThreadPool.getInstance();
            serverPool.addSessionId(randId);
            Iterator iterator = dataObject.getRows(this.tableName);
            while (iterator.hasNext()) {
                Properties properties = new Properties();
                Row row = (Row)iterator.next();
                String clientInstalledVersion = (String)row.get("AGENT_VERSION");
                properties.setProperty("sAMAccountName", (String)row.get("COMPUTER_NAME"));
                properties.setProperty("objectGUID", (String)row.get("OBJECT_GUID"));
                if (!clientInstalledVersion.equalsIgnoreCase(serverAgentVersion)) {
                    out.log(Level.INFO, "Version differs for " + (String)row.get("COMPUTER_NAME"));
                    String domainName = (String)row.get("DOMAIN_NAME");
                    properties.put("domainName", domainName);
                    properties.put("COMPUTER_DN", (String)row.get("COMPUTER_DN"));
                    properties.put("installAction", "Reinstall");
                    ArrayList arrList = CommonUtil.getDomainUserDetails(domainName);
                    AgentRunnable agentRunnable = new AgentRunnable(properties, (String)arrList.get(0), (String)arrList.get(1), agentAuditId, false);
                    serverPool.runTask(randId, agentRunnable);
                    continue;
                }
                out.log(Level.INFO, "Updated version is present in the client machine " + (String)row.get("COMPUTER_NAME"));
            }
            serverPool.removeSessionId(randId);
            out.log(Level.INFO, "The patch update completed");
            this.disableScheduler(serverAgentVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disableScheduler(String serverAgentVersion) {
        out.log(Level.INFO, "disableScheduler is called. serverAgentVersion :: " + serverAgentVersion);
        Connection connection = null;
        int colCount = 0;
        try {
            Table table = new Table(this.tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(new Column(this.tableName, "AGENT_VERSION"), (Object)serverAgentVersion, 1);
            Criteria critInstallSuccess = new Criteria(new Column(this.tableName, "INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 0);
            critInstallSuccess = critInstallSuccess.or(new Criteria(new Column(this.tableName, "INSTALL_STATUS"), (Object)"adssp_admin_gina_reinstall_success", 0));
            criteria = criteria.and(critInstallSuccess);
            Column col = new Column(this.tableName, "OBJECT_GUID").count();
            query.addSelectColumn(col);
            query.setCriteria(criteria);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            out.log(Level.INFO, "SQL Query ... : " + relAPI.getSelectSQL((Query)query));
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                colCount = (Integer)dataSet.getValue(1);
            }
            dataSet.close();
            out.log(Level.INFO, "colCount :: " + colCount);
            if (colCount == 0) {
                Long taskId = 0L;
                Criteria crit = new Criteria(new Column("Schedule", "SCHEDULE_NAME"), (Object)"PatchUpdateScheduler", 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
                if (!obj.isEmpty()) {
                    Row r = obj.getFirstRow("Schedule");
                    UpdateQueryImpl upQuery = new UpdateQueryImpl("Task_Input");
                    upQuery.setCriteria(new Criteria(new Column("Task_Input", "SCHEDULE_ID"), r.get("SCHEDULE_ID"), 0));
                    upQuery.setUpdateColumn("ADMIN_STATUS", (Object)4);
                    DataAccess.update((UpdateQuery)upQuery);
                }
                out.log(Level.INFO, "Disabling the Scheduler");
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void enableScheduler() {
        out.log(Level.INFO, "enableScheduler is called.");
        try {
            Long taskId = 0L;
            Criteria crit = new Criteria(new Column("Schedule", "SCHEDULE_NAME"), (Object)"PatchUpdateScheduler", 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("Schedule");
                UpdateQueryImpl upQuery = new UpdateQueryImpl("Task_Input");
                upQuery.setCriteria(new Criteria(new Column("Task_Input", "SCHEDULE_ID"), r.get("SCHEDULE_ID"), 0));
                upQuery.setUpdateColumn("ADMIN_STATUS", (Object)3);
                DataAccess.update((UpdateQuery)upQuery);
            }
            out.log(Level.INFO, "Enabled the Scheduler");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    public static String getUniqueID() {
        int NUM_CHARS = 32;
        String chars = "abcdefghijklmonpqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random r = new Random();
        char[] buf = new char[NUM_CHARS];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = chars.charAt(r.nextInt(chars.length()));
        }
        return new String(buf);
    }

    static class AgentRunnable
    implements Runnable {
        private Properties machineProp = new Properties();
        String userName = new String();
        String passWord = new String();
        Long actionId = new Long(-1L);
        boolean forceUpdate = true;

        AgentRunnable(Properties machineProperty, String user, String password, Long actionID) {
            this.machineProp = machineProperty;
            this.userName = user;
            this.passWord = password;
            this.actionId = actionID;
        }

        AgentRunnable(Properties machineProperty, String user, String password, Long actionID, boolean update) {
            this.machineProp = machineProperty;
            this.userName = user;
            this.passWord = password;
            this.actionId = actionID;
            this.forceUpdate = update;
        }

        @Override
        public void run() {
            String status = new String();
            String objGuid = (String)this.machineProp.get("objectGUID");
            try {
                GinaUtil.installPackage(this.machineProp, this.userName, this.passWord, "sAMAccountName");
                status = (String)this.machineProp.get("installStatus");
                out.log(Level.INFO, " Agent Runnable....Thread..... installStatus : " + status);
                if (status != null && status.equalsIgnoreCase("adssp_admin_gina_reinstall_success") || this.forceUpdate) {
                    GinaUtil.addOrUpdateComputer(this.machineProp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            AgentSchedulerUtil.addToAuditActionResult(objGuid, this.actionId, status);
        }
    }
}

