/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.sym.adsm.common.server.util.licensing.LicenseManager;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ads.fw.license.alarm.LicenseExpiryAlarm;
import com.manageengine.ads.fw.license.alarm.LicenseUsageAlarm;
import com.manageengine.ads.fw.mail.MailHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ProductUsageMailer
implements Task {
    private static Logger out = Logger.getLogger("ADSLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        try {
            out.log(Level.INFO, "ProductUsageMailer TaskEngine called");
            JSONObject serverProps = MailHandler.getMailSettings();
            if (serverProps.length() != 0 && !LicenseManager.getInstance().isFreeTool()) {
                out.log(Level.INFO, "ProductUsageMailer : Usage Mailer Task");
                if (LicenseUsageAlarm.constructMail().booleanValue()) {
                    taskContext.setAuditStatusMessage("LIC_LIMIT_SENT");
                } else {
                    out.log(Level.INFO, "ProductUsageMailer : Expiry Mailer Task");
                    Boolean isMailSent = LicenseExpiryAlarm.constructMail().getBoolean("IS_MAIL_SENT");
                    if (isMailSent.booleanValue()) {
                        taskContext.setAuditStatusMessage("LIC_EXP_SENT");
                    }
                }
            } else {
                out.log(Level.INFO, "Mail setting is not configured");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopTask() {
    }

    public static boolean isNotifyAllowed(String param, int days) {
        Long currentTimeInMillis = System.currentTimeMillis();
        try {
            Long diffInMillis;
            Long daysSent;
            String lastNotifyTime = ADSMPersUtil.getSyMParameter(param);
            if (lastNotifyTime != null && !lastNotifyTime.equalsIgnoreCase("DENY") ? (daysSent = Long.valueOf((diffInMillis = Long.valueOf(currentTimeInMillis - Long.parseLong(lastNotifyTime))) / 86400000L)) < (long)days : lastNotifyTime != null) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

