/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.taskengine.SchedulerConfiguration;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PwdExpiredTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        boolean dashBoardScheduler;
        reportLogger.log(Level.INFO, "Scheduling the Password Expired Report Task Starting............");
        Hashtable<String, Serializable> props = new Hashtable<String, Serializable>();
        Long scheduleId = taskContext.getScheduleID();
        props.put("SCHEDULE_ID", scheduleId);
        SchedulerHandler.getInstance();
        SchedulerHandler.getSchedulerProps(scheduleId, props);
        Hashtable inputs = (Hashtable)props.get("inputParams");
        boolean bl = dashBoardScheduler = inputs == null || "true".equals(inputs.get("UpdateDashBoard"));
        if (!dashBoardScheduler) {
            SchedulerConfiguration.fillPolicyContainers(scheduleId, props);
        } else {
            SchedulerHandler.getInstance();
            SchedulerHandler.deleteScheduleDomainMapping(scheduleId);
        }
        ArrayList<Integer> repIds = new ArrayList<Integer>();
        repIds.add(new Integer(3));
        props.put("SCHEDULED_REPORT_IDS", repIds);
        Hashtable result = ReportHandler.executeReport(props);
        if (!dashBoardScheduler) {
            Enumeration e = result.keys();
            while (e.hasMoreElements()) {
                String domainName = (String)e.nextElement();
                Properties schedulerProps = (Properties)result.get(domainName);
                Long generationId = (Long)schedulerProps.get("GENERATION_ID");
                ReportHandler.resetPassword(generationId, scheduleId);
            }
        }
        reportLogger.log(Level.INFO, "Scheduling the Password Expired Report Task Ending............");
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "PwdExpiredTask";
    }
}

