/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.scheduler.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EnrollmentReminderUtil;
import com.adventnet.sym.adsm.common.server.util.GinaUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemindToEnroll
implements Task {
    private static Logger out = Logger.getLogger(RemindToEnroll.class.getName());

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        try {
            out.log(Level.INFO, "RemindToEnroll called");
            Long scheduleId = taskContext.getScheduleID();
            Long agentAuditId = GinaUtil.addToAgentAuditActions(new Long(-1L), "SCHED_REM_ENROLL");
            RemindToEnroll.getUsersAndSetScript(scheduleId, agentAuditId, true, true);
            Row auditRow = taskContext.getAuditRow();
            Long scheduleAuditId = (Long)auditRow.get("AUDIT_ID");
            AgentSchedulerUtil.mapAgentAuditAction(new Long(-1L), scheduleAuditId, agentAuditId);
            out.log(Level.INFO, "RemindToEnroll Finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getUsersAndSetScript(Long schedOrPolicyId, Long agentAuditId, Boolean isSetPath, Boolean isScheudleId) {
        DataSet dataSet = null;
        Connection connection = null;
        Long agentId = new Long(-1L);
        try {
            Hashtable<Long, Hashtable> policyMap;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"PolicyCriteria"));
            Criteria finalCrit = null;
            if (isScheudleId.booleanValue()) {
                Join polCritJoin = new Join("PolicyCriteria", "SSPEnrollmentLogonScript", new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 2);
                Join polConfigJoin = new Join("PolicyCriteria", "PolicyConfiguration", new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 2);
                query.addJoin(polConfigJoin);
                query.addJoin(polCritJoin);
                finalCrit = new Criteria(Column.getColumn((String)"SSPEnrollmentLogonScript", (String)"SCHEDULE_ID"), (Object)schedOrPolicyId, 0);
                Criteria isRPUA = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"RESET_PASSWORD"), (Object)true, 0);
                isRPUA = isRPUA.or(new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"UNLOCK_ACCOUNT"), (Object)true, 0));
                finalCrit = finalCrit.and(isRPUA);
            } else {
                finalCrit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"POLICY_ID"), (Object)schedOrPolicyId, 0);
            }
            Join domainGuidJoin = new Join("PolicyCriteria", "ADSMDomainGeneralDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            Join ouGuidJoin = new Join("PolicyCriteria", "ADSMOUDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            query.addJoin(domainGuidJoin);
            query.addJoin(ouGuidJoin);
            query.setCriteria(finalCrit);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            RelationalAPI rApi = RelationalAPI.getInstance();
            connection = rApi.getConnection();
            dataSet = rApi.executeQuery((Query)query, connection);
            Hashtable ouTable = new Hashtable();
            int count = 0;
            while (dataSet.next()) {
                ++count;
                String domainName = (String)dataSet.getValue("DOMAIN_NAME");
                Long policyId = (Long)dataSet.getValue("POLICY_ID");
                policyMap = (Hashtable<Long, Hashtable>)ouTable.get(domainName);
                Hashtable objectMaps = new Hashtable();
                if (policyMap == null || policyMap.get(policyId) == null) {
                    if (policyMap == null) {
                        policyMap = new Hashtable<Long, Hashtable>();
                    }
                    objectMaps.put("OU", new ArrayList());
                    objectMaps.put("GROUP", new ArrayList());
                    policyMap.put(policyId, objectMaps);
                }
                objectMaps = (Hashtable)policyMap.get(policyId);
                ArrayList ouList = (ArrayList)objectMaps.get("OU");
                ArrayList groupList = (ArrayList)objectMaps.get("GROUP");
                if ("OU".equalsIgnoreCase((String)dataSet.getValue("OBJECT_CLASS"))) {
                    ouList.add((String)dataSet.getValue("DISTINGUISHED_NAME"));
                    objectMaps.put("OU", ouList);
                } else {
                    groupList.add((String)dataSet.getValue("DISTINGUISHED_NAME"));
                    objectMaps.put("GROUP", groupList);
                }
                policyMap.put(policyId, objectMaps);
                ouTable.put(domainName, policyMap);
            }
            if (count == 0 && isScheudleId.booleanValue() && isSetPath.booleanValue()) {
                out.log(Level.INFO, "Disabling Enrollment Reminder Scheduler as NO RP/UA policy");
                RemindToEnroll.disableScheduler(schedOrPolicyId.toString());
            }
            Enumeration e = ouTable.keys();
            while (e.hasMoreElements()) {
                String keyName = (String)e.nextElement();
                policyMap = (Hashtable)ouTable.get(keyName);
                EnrollmentReminderUtil.addScriptPath(keyName, policyMap, agentAuditId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void disableScheduler(String scheduleId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", c);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("Task_Input");
                r.set("ADMIN_STATUS", (Object)SchedulerUtil.ADMIN_STATUS_DISABLE);
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
                out.log(Level.INFO, "Scheduler Disabled for " + scheduleId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

