/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GinaUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoveScriptPath
implements Task {
    private static Logger logger = Logger.getLogger(RemoveScriptPath.class.getName());

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        Long scheduleId = taskContext.getScheduleID();
        Long instanceId = taskContext.getID();
        logger.log(Level.INFO, "RemoveScriptPath scheduler started for Instance Id : " + instanceId);
        try {
            Long agentAuditId = GinaUtil.addToAgentAuditActions(new Long(-1L), "RSP_SCHED_REMOVAL");
            Iterator defTaskInputIter = taskContext.getDefaultTaskInputs();
            while (defTaskInputIter.hasNext()) {
                Row defTaskInputRow = (Row)defTaskInputIter.next();
                String sidString = (String)defTaskInputRow.get("VARIABLE_NAME");
                if ((String)defTaskInputRow.get("VARIABLE_VALUE") == null) continue;
                String status = ADHandler.removeScriptPath((String)defTaskInputRow.get("VARIABLE_VALUE"), sidString, "ADSelfService_Enroll.hta");
                AgentSchedulerUtil.addToAuditActionResult(sidString, agentAuditId, status);
                if (!status.equals("adssp.common.text.success")) continue;
                this.removeFromDefTaskInput(instanceId, (String)defTaskInputRow.get("VARIABLE_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "RemoveScriptPath scheduler ends for Instance Id : " + instanceId);
    }

    public void stopTask() throws TaskExecutionException {
    }

    public void removeFromDefTaskInput(Long instanceId, String variableName) {
        Criteria delCrit = new Criteria(Column.getColumn((String)"Default_Task_Input", (String)"INSTANCE_ID"), (Object)instanceId, 0);
        delCrit = delCrit.and(new Criteria(Column.getColumn((String)"Default_Task_Input", (String)"VARIABLE_NAME"), (Object)variableName, 0));
        try {
            CommonUtil.getPersistence(new boolean[0]).delete(delCrit);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }
}

