/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.ProviderHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQAFetcher
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskcontext) throws TaskExecutionException {
        try {
            reportLogger.log(Level.INFO, "Scheduling the QA Fetcher Starting............");
            Long scheduleId = taskcontext.getScheduleID();
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSQAVerification", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("SSPSQAVerification", crit);
            if (!dataobject.isEmpty()) {
                Iterator iterator = dataobject.getRows("SSPSQAVerification");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Long policyId = (Long)row.get("POLICY_ID");
                    Long verId = (Long)row.get("VERIFICATION_ID");
                    Boolean overwrite = (Boolean)row.get("OVERWRITE");
                    reportLogger.log(Level.INFO, "Fetcher Scheduler Started for " + (String)row.get("VERIFICATION_NAME"));
                    Hashtable hashtable = ProviderHandler.fetchData(verId, null);
                    ArrayList arraylist = new ArrayList();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        arraylist.add(hashtable.get((Integer)enumeration.nextElement()));
                    }
                    Hashtable hash = ProviderHandler.populate(arraylist, policyId, overwrite);
                    this.printStatusMessage(hash);
                }
            }
            reportLogger.log(Level.INFO, "Scheduling the QA Fetcher Ending............");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void printStatusMessage(Hashtable hashtable) {
        try {
            int size = (Integer)hashtable.get("TOTALSIZE");
            ArrayList failedList = (ArrayList)hashtable.get("FAILED");
            String msg = size == 0 ? "adssp.admin.policies.external_sources.sqa_no_users_found" : (size == failedList.size() ? "adssp.admin.policies.external_sources.sqa_failure_all_users" : (failedList.size() != 0 ? "adssp.admin.policies.external_sources.sqa_failure_some_users" : "adssp.admin.policies.import_ans.auto_enroll_success"));
            reportLogger.log(Level.INFO, "StatusMessage : " + msg);
            reportLogger.log(Level.INFO, "FailureList : " + failedList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "SQAFetcher";
    }
}

