/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.scheduler.ScheduleReportsHandler;
import com.adventnet.sym.adsm.common.server.scheduler.SchedulerUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScheduleSSPReps
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        try {
            reportLogger.log(Level.INFO, "Scheduling the SSP Reports Starting............");
            Long scheduleId = taskContext.getScheduleID();
            Hashtable props = ScheduleReportsHandler.getSchedulerProps(scheduleId, null);
            props.put("EXPORT", Boolean.TRUE);
            Hashtable inputParams = (Hashtable)props.get("inputParams");
            Long categoryId = Long.parseLong((String)inputParams.get("REPORT_CATEGORY_ID"));
            if (categoryId.equals(ScheduleReportsHandler.AUDIT_REP)) {
                props.put("DIRECTORY_NAME", "Audit Reports");
                Hashtable periods = SchedulerUtil.getDurationPeriod((String)inputParams.get("AUDIT_DAYS"));
                props.put("FROM_TIME", (Long)periods.get("FROM_TIME"));
                props.put("TO_TIME", (Long)periods.get("TO_TIME"));
                ReportHandler.executeAuditReport(props);
            } else if (categoryId.equals(ScheduleReportsHandler.ENROLL_REP)) {
                props.put("DIRECTORY_NAME", "Enrollment Reports");
                props.putAll(inputParams);
                ReportHandler.executeEnrollReport(props);
            }
            reportLogger.log(Level.INFO, "Scheduling the SSP Report Ending............");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "ScheduleSSPReps";
    }
}

