/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.taskengine.Scheduler;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchedulerConfiguration {
    private static Logger logger = Logger.getLogger(SchedulerConfiguration.class.getName());
    private static String[] schedulerName = new String[]{"adssp.xml.schedule.name.adupdate", "adssp.xml.schedule.name.dashboard_lockedoutuser", "adssp.xml.schedule.name.dashboard_pwdexpireduser", "adssp.xml.schedule.name.dashboard_soontoexpireuser"};
    private static String[] taskNames = new String[]{"reports.name.update_ad_objects", "reports.name.locked_out_reports", "reports.name.pwd_expired_reports", "reports.name.soon_to_expire_reports"};

    public static void populateDashBoardScheduler(String domainName, Long loginId) {
        try {
            Scheduler scheduler = (Scheduler)BeanUtil.lookup((String)"Scheduler");
            for (int i = 0; i < taskNames.length; ++i) {
                Criteria cri;
                Iterator itr;
                Properties p = DomainHandler.getConfiguredValues(domainName, loginId);
                String dn = (String)p.get("DEFAULT_NAMING_CONTEXT");
                String scheduleName = schedulerName[i];
                Criteria crit = new Criteria(new Column("TaskEngine_Task", "TASK_NAME"), (Object)taskNames[i], 0);
                DataObject taskEngineDataObject = CommonUtil.getPersistence(new boolean[0]).get("TaskEngine_Task", crit);
                Criteria criter = new Criteria(new Column("Schedule", "SCHEDULE_NAME"), (Object)scheduleName, 0);
                DataObject schObj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", criter);
                if (schObj.isEmpty()) continue;
                Row sr = schObj.getFirstRow("Schedule");
                Long scheduleId = (Long)sr.get("SCHEDULE_ID");
                Criteria c = new Criteria(new Column("SSPSchedulerReportOUs", "SCHEDULE_ID"), (Object)scheduleId, 0);
                c = c.and(new Criteria(new Column("SSPSchedulerReportOUs", "DOMAIN_NAME"), (Object)"", 1));
                DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("SSPSchedulerReportOUs", c);
                if (dob.isEmpty()) {
                    SchedulerConfiguration.enableDashBoardScheduler(taskNames[i], scheduleName);
                }
                if ((itr = dob.getRows("SSPSchedulerReportOUs", cri = new Criteria(new Column("SSPSchedulerReportOUs", "DOMAIN_NAME"), (Object)domainName, 0))).hasNext()) continue;
                logger.log(Level.INFO, "Updating the SSPSchedulerReportOUs table for the scheduler :" + scheduleName);
                DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row ur = new Row("SSPSchedulerReportOUs");
                ur.set("SCHEDULE_ID", (Object)scheduleId);
                ur.set("DOMAIN_NAME", (Object)domainName);
                dObj.addRow(ur);
                Row r = new Row("SSPSchRepObjects");
                r.set("CONFIG_ID", ur.get("CONFIG_ID"));
                r.set("OBJECT_CLASS", (Object)"OU");
                r.set("OBJECT_VALUE", (Object)dn);
                dObj.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(dObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getScheduledContainers(Long scheduleId) {
        Hashtable<String, Cloneable> hash = new Hashtable<String, Cloneable>();
        Hashtable<String, String> dnDomainNameMap = new Hashtable<String, String>();
        try {
            Hashtable domains = DomainHandler.getConfiguredDomains();
            Criteria schCrit = new Criteria(new Column("SSPSchedulerReportOUs", "SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject sObj = CommonUtil.getPersistence(new boolean[0]).get(new ArrayList<String>(Arrays.asList("SSPSchedulerReportOUs", "SSPSchRepObjects")), schCrit);
            Enumeration enumer = domains.keys();
            while (enumer.hasMoreElements()) {
                String distinName = (String)enumer.nextElement();
                Properties p = (Properties)domains.get(distinName);
                String domainName = p.getProperty("DOMAIN_NAME");
                Row r = sObj.getRow("SSPSchedulerReportOUs", new Criteria(new Column("SSPSchedulerReportOUs", "DOMAIN_NAME"), (Object)domainName, 0));
                if (r == null) continue;
                ArrayList<String> conList = new ArrayList<String>();
                Iterator iter = sObj.getRows("SSPSchRepObjects", new Criteria(new Column("SSPSchRepObjects", "CONFIG_ID"), r.get("CONFIG_ID"), 0));
                while (iter.hasNext()) {
                    Row objRow = (Row)iter.next();
                    String dn = (String)objRow.get("OBJECT_VALUE");
                    conList.add(dn);
                    dnDomainNameMap.put(dn, domainName);
                }
                if (conList.isEmpty()) continue;
                hash.put("dnDomainNameMap", dnDomainNameMap);
                hash.put(domainName, conList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static void fillPolicyContainers(Long scheduleId, Hashtable props) {
        Hashtable domainOUMap = new Hashtable();
        Hashtable domainGroupMap = new Hashtable();
        try {
            ArrayList<String> ouList = new ArrayList<String>();
            ArrayList<String> groupList = new ArrayList<String>();
            String domainName = "";
            Long policyId = null;
            Criteria c = new Criteria(new Column("SchedulerConfiguration", "SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SchedulerConfiguration", c);
            Row r = obj.getRow("SchedulerConfiguration");
            policyId = (Long)r.get("POLICY_ID");
            c = new Criteria(new Column("PolicyCriteria", "POLICY_ID"), (Object)policyId, 0);
            obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyCriteria", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("PolicyCriteria");
                while (it.hasNext()) {
                    r = (Row)it.next();
                    domainName = (String)r.get("DOMAIN_NAME");
                    if ("OU".equalsIgnoreCase((String)r.get("OBJECT_CLASS"))) {
                        ouList.add((String)r.get("DISTINGUISHED_NAME"));
                        continue;
                    }
                    groupList.add((String)r.get("OBJECT_GUID"));
                }
                domainOUMap.put(domainName, ouList);
                domainGroupMap.put(domainName, groupList);
            }
            props.put("DOMAIN_VS_OUS", domainOUMap);
            props.put("DOMAIN_VS_GROUPS", domainGroupMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void enableDashBoardScheduler(String taskName, String scheduleName) {
        try {
            Scheduler scheduler = (Scheduler)BeanUtil.lookup((String)"Scheduler");
            int status = scheduler.getScheduledTaskAdminStatus(scheduleName, taskName);
            logger.log(Level.INFO, "Schedule Status :::" + status);
            if (status == 4) {
                Criteria c = new Criteria(new Column("Schedule", "SCHEDULE_NAME"), (Object)scheduleName, 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", c);
                if (!dataObj.isEmpty()) {
                    Row schRow = dataObj.getFirstRow("Schedule");
                    Long scheduleId = (Long)schRow.get("SCHEDULE_ID");
                    Criteria crit = new Criteria(new Column("Scheduled_Task", "SCHEDULE_ID"), (Object)scheduleId, 0);
                    DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", crit);
                    if (!dObj.isEmpty()) {
                        Row r = dObj.getFirstRow("Scheduled_Task");
                        r.set("ADMIN_STATUS", (Object)new Integer(3));
                        dObj.updateRow(r);
                        CommonUtil.getPersistence(new boolean[0]).update(dObj);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getDefaultSchedulerProps() {
        ArrayList<Properties> scheduleList = new ArrayList<Properties>();
        try {
            String[] tableNames = new String[]{"ADSMDomainConfiguration", "SSPSchedulerReportOUs"};
            List<String> tableList = Arrays.asList(tableNames);
            boolean[] isLeftJoins = new boolean[tableList.size()];
            Arrays.fill(isLeftJoins, true);
            DataObject dO = CommonUtil.getPersistence(new boolean[0]).get(QueryConstructor.get(tableList, (boolean[])isLeftJoins, (Criteria)DomainUtil.getCriteriaForLicensedDomains()));
            String domainName = "";
            ArrayList<String> domainList = new ArrayList<String>();
            ArrayList<String> domDisplayList = new ArrayList<String>();
            Iterator itr = dO.getRows("ADSMDomainConfiguration");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                String domDisplayName = (String)r.get("DOMAIN_DISPLAY_NAME");
                if (!domainName.equals("")) {
                    domainName = domainName + ", ";
                }
                domainName = domainName + domDisplayName;
                domDisplayList.add(domDisplayName);
                domainList.add((String)r.get("DOMAIN_NAME"));
            }
            String[] schTables = new String[]{"Schedule", "Calendar", "Periodic", "Scheduled_Task", "Task_Input", "Default_Task_Input"};
            List<String> schTableList = Arrays.asList(schTables);
            isLeftJoins = new boolean[schTableList.size()];
            Arrays.fill(isLeftJoins, true);
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)schedulerName, 8);
            SelectQuery sq = QueryConstructor.get(schTableList, (boolean[])isLeftJoins, (Criteria)crit);
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), true));
            DataObject schObj = CommonUtil.getPersistence(new boolean[0]).get(sq);
            Iterator itr2 = schObj.getRows("Schedule");
            while (itr2.hasNext()) {
                Properties p = new Properties();
                Row r = (Row)itr2.next();
                ArrayList statusList = new ArrayList();
                p.put("SCHEDULE_NAME", (String)r.get("SCHEDULE_NAME"));
                Long scheduleId = (Long)r.get("SCHEDULE_ID");
                p.put("SCHEDULE_ID", scheduleId);
                long scheduleTime = ((Date)schObj.getValue("Task_Input", "SCHEDULE_TIME", new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0))).getTime();
                p.put("SCHEDULE_TIME", (Object)scheduleTime);
                HashMap<String, Object> prop = new HashMap<String, Object>();
                Row calRow = schObj.getRow("Calendar", new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
                if (calRow != null) {
                    prop.put("TIME_OF_DAY", (Long)calRow.get("TIME_OF_DAY"));
                    prop.put("C_UNIT_OF_TIME", (String)calRow.get("UNIT_OF_TIME"));
                    prop.put("DAY_OF_WEEK", (Integer)calRow.get("DAY_OF_WEEK"));
                    prop.put("DATE_OF_MONTH", (Integer)calRow.get("DATE_OF_MONTH"));
                }
                Long timePeriod = (Long)schObj.getValue("Periodic", "TIME_PERIOD", new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
                prop.put("TIME_PERIOD", timePeriod);
                if (timePeriod != null && timePeriod != -1L) {
                    prop.put("SCHEDULE_TYPE", "Hourly");
                } else if (calRow != null) {
                    prop.put("SCHEDULE_TYPE", (String)calRow.get("REPEAT_FREQUENCY"));
                }
                prop.put("P_UNIT_OF_TIME", (String)schObj.getValue("Periodic", "UNIT_OF_TIME", new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)scheduleId, 0)));
                p.put("SCHEDULED_AT", prop);
                Long instanceId = (Long)schObj.getValue("Task_Input", "INSTANCE_ID", new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
                Hashtable<String, String> ht = new Hashtable<String, String>();
                Iterator ite = schObj.getRows("Default_Task_Input", new Criteria(Column.getColumn((String)"Default_Task_Input", (String)"INSTANCE_ID"), (Object)instanceId, 0));
                while (ite.hasNext()) {
                    Row defaultRow = (Row)ite.next();
                    String key = (String)defaultRow.get("VARIABLE_NAME");
                    String value = (String)defaultRow.get("VARIABLE_VALUE");
                    ht.put(key, value);
                }
                p.put("inputParams", ht);
                p.put("ADMIN_STATUS", (Integer)schObj.getValue("Scheduled_Task", "ADMIN_STATUS", new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)scheduleId, 0)));
                for (int i = 0; i < domainList.size(); ++i) {
                    Criteria schCrit = new Criteria(Column.getColumn((String)"SSPSchedulerReportOUs", (String)"DOMAIN_NAME"), domainList.get(i), 0);
                    schCrit = schCrit.and(new Criteria(Column.getColumn((String)"SSPSchedulerReportOUs", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
                    Row schRow = dO.getRow("SSPSchedulerReportOUs", schCrit);
                    String statusValue = "";
                    if (schRow != null && schRow.get("LAST_SCHEDULE_STATUS") != null) {
                        statusValue = (String)schRow.get("LAST_SCHEDULE_STATUS");
                    }
                    Hashtable errMap = new Hashtable();
                    errMap.put(domDisplayList.get(i), statusValue);
                    statusList.add(errMap);
                }
                p.put("LAST_STATUS", statusList);
                p.put("DOMAIN_NAME", domainName);
                scheduleList.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returning the schedule list ::: " + scheduleList);
        return scheduleList;
    }

    public static Properties updateScheduler(Map bean) {
        Properties resProp = new Properties();
        try {
            Long nextScheduleTime = -1L;
            Long scheduleId = -1L;
            Criteria crit = new Criteria(new Column("Schedule", "SCHEDULE_NAME"), (Object)((String)bean.get("SCHEDULE_NAME")), 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
            logger.log(Level.INFO, "DO : " + obj);
            if (!obj.isEmpty()) {
                Row schTaskRow;
                Integer adminStatus;
                Row scheduleRow = obj.getFirstRow("Schedule");
                scheduleId = (Long)scheduleRow.get("SCHEDULE_ID");
                Hashtable defaultInputParams = (Hashtable)bean.get("inputParams");
                Criteria calendarCriteria = new Criteria(new Column("Calendar", "SCHEDULE_ID"), (Object)scheduleId, 0);
                Criteria periodCriteria = new Criteria(new Column("Periodic", "SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject calendarObj = CommonUtil.getPersistence(new boolean[0]).get("Calendar", calendarCriteria);
                DataObject periodObj = CommonUtil.getPersistence(new boolean[0]).get("Periodic", periodCriteria);
                Row r = null;
                String scheduleType = (String)bean.get("SCHEDULE_TYPE");
                logger.log(Level.INFO, "SCH_TYPE : " + scheduleType + " :: MAP :: " + bean);
                if ("Hourly".equalsIgnoreCase(scheduleType)) {
                    CommonUtil.getPersistence(new boolean[0]).delete(calendarCriteria);
                    if (periodObj.isEmpty()) {
                        r = new Row("Periodic");
                        r.set("SCHEDULE_ID", (Object)scheduleId);
                        r.set("UNIT_OF_TIME", (Object)"Hours");
                        r.set("TIME_PERIOD", (Object)((Long)bean.get("TIME_PERIOD")));
                        periodObj.addRow(r);
                    } else {
                        r = periodObj.getFirstRow("Periodic");
                        r.set("TIME_PERIOD", (Object)((Long)bean.get("TIME_PERIOD")));
                        periodObj.updateRow(r);
                    }
                    nextScheduleTime = SchedulerConfiguration.updateTime(periodObj, scheduleId, defaultInputParams);
                    CommonUtil.getPersistence(new boolean[0]).update(periodObj);
                } else {
                    Integer dayOfWeek = (Integer)bean.get("DAY_OF_WEEK");
                    Integer dateOfMonth = (Integer)bean.get("DATE_OF_MONTH");
                    CommonUtil.getPersistence(new boolean[0]).delete(periodCriteria);
                    if (calendarObj.isEmpty()) {
                        r = new Row("Calendar");
                        r.set("SCHEDULE_ID", (Object)scheduleId);
                        r.set("UNIT_OF_TIME", (Object)"Hours");
                        r.set("REPEAT_FREQUENCY", (Object)scheduleType);
                        r.set("TIME_OF_DAY", (Object)((Long)bean.get("TIME_OF_DAY")));
                        SchedulerConfiguration.fillCalendarProperties(scheduleType, dayOfWeek, dateOfMonth, r);
                        calendarObj.addRow(r);
                    } else {
                        r = calendarObj.getFirstRow("Calendar");
                        r.set("REPEAT_FREQUENCY", (Object)scheduleType);
                        r.set("TIME_OF_DAY", (Object)((Long)bean.get("TIME_OF_DAY")));
                        SchedulerConfiguration.fillCalendarProperties(scheduleType, dayOfWeek, dateOfMonth, r);
                        calendarObj.updateRow(r);
                    }
                    nextScheduleTime = SchedulerConfiguration.updateTime(calendarObj, scheduleId, defaultInputParams);
                    CommonUtil.getPersistence(new boolean[0]).update(calendarObj);
                }
                Criteria c = new Criteria(new Column("Scheduled_Task", "SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject schTaskObj = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", c);
                if (!schTaskObj.isEmpty() && (adminStatus = (Integer)(schTaskRow = schTaskObj.getFirstRow("Scheduled_Task")).get("ADMIN_STATUS")) == 4) {
                    schTaskRow.set("ADMIN_STATUS", (Object)new Integer(3));
                    schTaskObj.updateRow(schTaskRow);
                    CommonUtil.getPersistence(new boolean[0]).update(schTaskObj);
                }
            }
            resProp.put("SCHEDULED_TIME", nextScheduleTime);
            resProp.put("SCHEDULE_ID", scheduleId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resProp;
    }

    public static Long updateTime(DataObject dObj, Long scheduleId, Hashtable defaultInputParams) {
        Long nextScheduleTime = -1L;
        try {
            DataObject taskInputObj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", new Criteria(new Column("Task_Input", "SCHEDULE_ID"), (Object)scheduleId, 0));
            if (!taskInputObj.isEmpty()) {
                Row taskInputRow = taskInputObj.getFirstRow("Task_Input");
                Long instanceId = (Long)taskInputRow.get("INSTANCE_ID");
                Date prevTime = (Date)taskInputRow.get("SCHEDULE_TIME");
                nextScheduleTime = ScheduleUtil.calculateNextScheduleTime((DataObject)dObj, (Long)new Long(-1L), (boolean)false);
                logger.log(Level.INFO, "New Time : " + new Timestamp(nextScheduleTime));
                taskInputRow.set("SCHEDULE_TIME", (Object)new Timestamp(nextScheduleTime));
                taskInputObj.updateRow(taskInputRow);
                CommonUtil.getPersistence(new boolean[0]).update(taskInputObj);
                Enumeration e = defaultInputParams.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = (String)defaultInputParams.get(key);
                    Criteria criter = new Criteria(new Column("Default_Task_Input", "INSTANCE_ID"), (Object)instanceId, 0);
                    criter = criter.and(new Criteria(new Column("Default_Task_Input", "VARIABLE_NAME"), (Object)key, 0));
                    DataObject defaultTIObj = CommonUtil.getPersistence(new boolean[0]).get("Default_Task_Input", criter);
                    Row defaultTIRow = defaultTIObj.getFirstRow("Default_Task_Input");
                    defaultTIRow.set("VARIABLE_VALUE", (Object)value);
                    defaultTIObj.updateRow(defaultTIRow);
                    CommonUtil.getPersistence(new boolean[0]).update(defaultTIObj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nextScheduleTime;
    }

    public static void fillCalendarProperties(String scheduleType, Integer dayOfWeek, Integer dateOfMonth, Row r) {
        try {
            if ("Daily".equalsIgnoreCase(scheduleType)) {
                r.set("DAY_OF_WEEK", (Object)-1);
                r.set("DATE_OF_MONTH", (Object)-1);
            } else if ("Weekly".equalsIgnoreCase(scheduleType)) {
                r.set("DAY_OF_WEEK", (Object)dayOfWeek);
                r.set("DATE_OF_MONTH", (Object)-1);
            } else if ("Monthly".equalsIgnoreCase(scheduleType)) {
                r.set("DAY_OF_WEEK", (Object)-1);
                r.set("DATE_OF_MONTH", (Object)dateOfMonth);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateScheduleStatus(String domName, Long scheduleId, String statusMsg) {
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("SSPSchedulerReportOUs");
            r.set("SCHEDULE_ID", (Object)scheduleId);
            r.set("DOMAIN_NAME", (Object)domName);
            r.set("LAST_SCHEDULE_STATUS", (Object)statusMsg);
            dObj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String changeAdminStatus(String scheduleId) {
        String image = "";
        try {
            Criteria c = new Criteria(new Column("Scheduled_Task", "SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", c);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("Scheduled_Task");
                Integer adminStatus = (Integer)r.get("ADMIN_STATUS");
                if (adminStatus == 3) {
                    r.set("ADMIN_STATUS", (Object)new Integer(4));
                    image = "disableIcon";
                } else if (adminStatus == 4) {
                    r.set("ADMIN_STATUS", (Object)new Integer(3));
                    image = "enableIcon";
                }
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }
}

