/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.admin.SoonToExpireHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SoonToExpTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        Long scheduleId = null;
        try {
            reportLogger.log(Level.INFO, "Scheduling the Soon-To-Expire Report Starting............");
            Integer reportId = 2;
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            scheduleId = taskContext.getScheduleID();
            if (scheduleId == null) {
                Iterator it = taskContext.getDefaultTaskInputs();
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    reportLogger.log(Level.INFO, "Row : " + r);
                    if (r == null || !r.get("VARIABLE_NAME").toString().equalsIgnoreCase("SCHEDULE_ID") || r.get("VARIABLE_VALUE") == null) continue;
                    scheduleId = Long.parseLong(r.get("VARIABLE_VALUE").toString());
                }
                if (scheduleId == null) {
                    throw new Exception("Schedule Id is null");
                }
            }
            props.put("SCHEDULE_ID", scheduleId);
            String poolName = taskContext.getPoolName();
            if (poolName == null || poolName == "") {
                poolName = "default";
            }
            props.put("POOL_NAME", poolName);
            props.put("GROUP_SELECTION", true);
            SchedulerHandler.getInstance();
            SchedulerHandler.getSchedulerProps(scheduleId, props);
            Long notifyTypeId = 1L;
            Hashtable inputs = (Hashtable)props.get("inputParams");
            if (inputs != null && !"true".equals(inputs.get("UpdateDashBoard"))) {
                SoonToExpireHandler.getInstance();
                SoonToExpireHandler.setNotifyMailProps(scheduleId, props);
                notifyTypeId = (Long)props.get("NOTIFY_TYPE_ID");
                if (notifyTypeId == 2L) {
                    reportId = 4;
                }
                Long mailSentTime = System.currentTimeMillis();
                props.put("MAIL_SENT_TIME", mailSentTime);
                props.put("NOTIFY_USERS", "true");
                inputs.put("noOfDays", Integer.parseInt(props.get("MAX_CONFIG_DAYS").toString()));
                props.put("CHECK_LICENSE", true);
            } else {
                SchedulerHandler.getInstance();
                SchedulerHandler.deleteScheduleDomainMapping(scheduleId);
            }
            ArrayList<Integer> repIds = new ArrayList<Integer>();
            repIds.add(reportId);
            if (props.containsKey("NOTIFY_PWD_EXPIRED_USERS") && props.get("NOTIFY_PWD_EXPIRED_USERS").toString().equalsIgnoreCase("true")) {
                if (notifyTypeId == 2L) {
                    reportLogger.log(Level.INFO, "NOTIFY_ACC_EXPIRED_USERS enabled");
                    repIds.add(new Integer(5));
                } else {
                    reportLogger.log(Level.INFO, "NOTIFY_PWD_EXPIRED_USERS enabled");
                    repIds.add(new Integer(3));
                }
            }
            props.put("SCHEDULED_REPORT_IDS", repIds);
            props.put("DIRECTORY_NAME", "Expiry Notification");
            ReportHandler.executeReport(props);
            reportLogger.log(Level.INFO, "Scheduling the Soon-To-Expire Report Ending............");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (scheduleId != null) {
                SchedulerHandler.getInstance().removeAsyncSchedulerEntry(scheduleId.toString());
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "SoonToExpTask";
    }
}

