/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.taskengine;

import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateADObjects
implements Task {
    private static Logger out = Logger.getLogger(UpdateADObjects.class.getName());

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        out.log(Level.INFO, "Scheduling UpdateADObjects Starts");
        try {
            Long scheduleId = taskContext.getScheduleID();
            SchedulerHandler.getInstance();
            SchedulerHandler.deleteScheduleDomainMapping(scheduleId);
            Hashtable domains = DomainHandler.getConfiguredDomains();
            Enumeration enumer = domains.keys();
            while (enumer.hasMoreElements()) {
                String distinName = (String)enumer.nextElement();
                Properties p = (Properties)domains.get(distinName);
                String domainName = p.getProperty("DOMAIN_NAME");
                while (DomainProcess.getInstance().isAnyDomainUpdateInProgress()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                DomainHandler.scheduleUpdate(domainName, scheduleId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        out.log(Level.INFO, "Scheduling UpdateADObjects Ends.");
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "UpdateADObjects";
    }
}

