/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.tfa;

import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.EnrollmentHandler;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticator;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.Authenticator;
import com.adventnet.sym.adsm.common.server.configuration.APCModuleHandler;
import com.adventnet.sym.adsm.common.server.notifications.PolicyNotifications;
import com.duosecurity.duoweb.DuoWeb;
import com.duosecurity.duoweb.DuoWebException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class DuoWebAuthenticator
extends Authenticator {
    public boolean authenticate() throws LoginException {
        String localLoginName = this.request.getParameter("LOGIN_NAME");
        String localDomainName = this.request.getParameter("DOMAIN_NAME");
        localLoginName = localLoginName == null ? this.loginName : localLoginName;
        localDomainName = localDomainName == null ? this.domainName : localDomainName;
        Long loginId = ADMPUserHandler.getLoginId(localLoginName, localDomainName);
        Long policyId = 0L;
        Boolean isEnrolPermitted = false;
        String userDN = (String)this.session.getAttribute("USER_DN");
        ArrayList userGroups = (ArrayList)this.session.getAttribute("userGroups");
        String messageType = "success";
        this.auditType = "adssp.reports.audit_report.user_attempts.type_duoweb_login_text";
        try {
            String akey;
            String skey;
            String signRequest = "";
            String authUser = "";
            if (this.authStatus == null || this.authStatus != null && !this.authStatus.has(this.authRule)) {
                this.needAudit = false;
                return false;
            }
            JSONObject tfaProviderProps = this.authStatus.getJSONObject(this.authRule);
            JSONArray tfaProviderModesNames = tfaProviderProps.getJSONArray("MODE_NAMES");
            String modeName = tfaProviderModesNames.getString(0);
            JSONObject tfaProviderMode = tfaProviderProps.getJSONObject("MODES").getJSONObject(modeName);
            JSONObject tfaProviderModeParams = tfaProviderMode.getJSONObject("PARAMS");
            String ikey = tfaProviderModeParams.getJSONObject("I_KEY").getString("PARAM_VALUE");
            authUser = DuoWebAuthenticator.verifyDuoResponse(this.request, ikey, skey = tfaProviderModeParams.getJSONObject("S_KEY").getString("PARAM_VALUE"), akey = tfaProviderModeParams.getJSONObject("A_KEY").getString("PARAM_VALUE"));
            if (authUser != null && authUser != "") {
                Hashtable polPermission = ADMPADAuthenticator.isValidDomainUser(this.loginName, this.domainName);
                policyId = (Long)polPermission.get("policyId");
                if (loginId != null && policyId != null) {
                    isEnrolPermitted = PolicyHandler.isEnrollAllowed(policyId);
                    Boolean isDuoEnrolledPreviously = EnrollmentHandler.isDuoEnrollmentRegistered(loginId);
                    JSONObject json = APCModuleHandler.getModuleFlagValues(policyId, "ID_VERIFICATIONS");
                    Boolean isDuoEnabled = "1".equals(json.getString("DUO_WEB"));
                    EnrollmentHandler.setEnrolledforDuo(loginId);
                    if (!EnrollmentHandler.getForceEnrollStatus(loginId, this.request) && isEnrolPermitted.booleanValue() && !isDuoEnrolledPreviously.booleanValue() && isDuoEnabled.booleanValue()) {
                        PolicyNotifications.sendEnrolledAcknowledgement(this.request, policyId, localDomainName, localLoginName);
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception le) {
            if (this.authStatus != null) {
                try {
                    this.authStatus.put("AUTH_STATE", 2);
                    if (this.authStatus.has(this.authRule)) {
                        this.authStatus.getJSONObject(this.authRule).put("AUTH_STATE", 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!"TWO_FACTOR".equals(le.getMessage())) {
                messageType = "error";
                this.request.setAttribute("message", (Object)le.getMessage());
                this.request.setAttribute("messageType", (Object)messageType);
                int status = 0;
                this.errMsg = le.getMessage();
                if (this.session.getAttribute("isWinLogTFA") != null) {
                    this.auditType = "adssp.reports.audit_report.user_attempts.type_windows_login_text";
                }
                AuditAPI.getInstance().addUserAttemptsAuditLog(this.request, localLoginName, localDomainName, this.auditType, this.errMsg, status);
            }
            this.needAudit = false;
            throw new LoginException("TWO_FACTOR");
        }
    }

    public static String verifyDuoResponse(HttpServletRequest request, String ikey, String skey, String akey) throws LoginException {
        String authUser = "";
        try {
            if (request.getParameter("sig_response") != null) {
                authUser = DuoWeb.verifyResponse((String)ikey, (String)skey, (String)akey, (String)request.getParameter("sig_response"));
            }
        }
        catch (DuoWebException dwe) {
            throw new LoginException(dwe.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new LoginException(nsae.getMessage());
        }
        catch (InvalidKeyException ike) {
            throw new LoginException(ike.getMessage());
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        return authUser;
    }
}

