/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.tfa;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.configuration.APCModuleHandler;
import com.adventnet.sym.adsm.common.server.configuration.EnrollmentNotifyHandler;
import com.adventnet.sym.adsm.common.server.configuration.IdentityVerifyHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mobile.MobileUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobileOneAuthHandler {
    public static final String SSPPCMOBILEONEAUTH = "SSPPolicyVsOneAuthModes";
    public static final String SSPMOBILEONEAUTH = "SSPMobileOneAuthEnrollment";
    public static final String SSPMOBILEONEAUTHMODES = "SSPMobileOneAuthModes";
    public static final String SSPMOBILEONEAUTHBUFFER = "SSPMobileOneAuthBuffer";
    public static final String SUCCESS = "success";
    public static final String ERROR = "error";
    public static final String FAIL = "fail";
    public static final String DENY = "deny";
    public static final String LATER = "later";
    public static final long PUSH_NOTIFICATION_ID = 64L;
    public static final long FINGERPRINT_ID = 128L;
    public static final long QR_CODE_ID = 256L;
    public static final long TOTP_ID = 512L;
    public static final String PUSH_NOTIFICATION_AUTH = "PUSH_NOTIFICATION_AUTH";
    public static final String FINGER_PRINT_AUTH = "FINGER_PRINT_AUTH";
    public static final String QR_CODE_AUTH = "QR_CODE_AUTH";
    public static final String TOTP_AUTH = "TOTP_AUTH";
    public static final int TOTP_CODE_LENTH = 6;
    public static Long[] modeIds = new Long[]{64L, 128L, 256L, 512L};
    public static String[] modeNames = new String[]{"PUSH_NOTIFICATION_AUTH", "FINGER_PRINT_AUTH", "QR_CODE_AUTH", "TOTP_AUTH"};

    public static JSONArray getOneAuthProps() {
        JSONArray oneAuthProps = new JSONArray();
        try {
            for (int i = 0; i < modeNames.length; ++i) {
                JSONObject mode = new JSONObject();
                mode.put("MODE_ID", (Object)modeIds[i]);
                mode.put("MODE_NAME", (Object)modeNames[i]);
                oneAuthProps.put((Object)mode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return oneAuthProps;
    }

    private static boolean isPowerOfTwo(long number) {
        return number == 0L || (number & -number) == number;
    }

    public static String getModeName(Long modeId) {
        try {
            JSONArray oneAuthProps = MobileOneAuthHandler.getOneAuthProps();
            for (int i = 0; i < oneAuthProps.length(); ++i) {
                JSONObject mode = oneAuthProps.getJSONObject(i);
                Long _modeId = mode.getLong("MODE_ID");
                if (!_modeId.equals(modeId)) continue;
                return mode.getString("MODE_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Long getModeId(String modeNameVal) {
        try {
            JSONArray oneAuthProps = MobileOneAuthHandler.getOneAuthProps();
            for (int i = 0; i < oneAuthProps.length(); ++i) {
                JSONObject mode = oneAuthProps.getJSONObject(i);
                String modeName = mode.getString("MODE_NAME");
                if (!modeName.equals(modeNameVal)) continue;
                return mode.getLong("MODE_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static long getModePos(Long modeIdValue) {
        if (MobileOneAuthHandler.isPowerOfTwo(modeIdValue)) {
            return Long.toBinaryString(modeIdValue).length() - 1;
        }
        return 0L;
    }

    public static String getBitValue(long flagPos, long bitValue) {
        if ((bitValue >> (int)flagPos & 1L) == 0L) {
            return "0";
        }
        return "1";
    }

    public static boolean isModeBitSet(Long enrolledValue, Long modeId) {
        return (enrolledValue & 1L << (int)MobileOneAuthHandler.getModePos(modeId)) != 0L;
    }

    public static String getUniqueToken() {
        try {
            String uniqueToken = UUID.randomUUID().toString();
            return uniqueToken.replaceAll("-", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject getMobileAppAuthRegValues(HttpServletRequest request, Long loginId, boolean checkNativeApp) {
        JSONObject mobileAppAuthReg = new JSONObject();
        try {
            Long enrolledValues = MobileOneAuthHandler.getOneAuthEnrolledModes(request, loginId, checkNativeApp);
            for (int i = 0; i < modeNames.length; ++i) {
                boolean isModeEnrolled = (enrolledValues & modeIds[i]) == modeIds[i];
                mobileAppAuthReg.put(modeNames[i], (Object)String.valueOf(isModeEnrolled));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mobileAppAuthReg;
    }

    public static JSONObject getMobileAppAuthRegValues(Long loginId) {
        return MobileOneAuthHandler.getMobileAppAuthRegValues(null, loginId, false);
    }

    public static JSONObject getMobileAppAuthRegValues(HttpServletRequest request, Long loginId) {
        return MobileOneAuthHandler.getMobileAppAuthRegValues(request, loginId, false);
    }

    public static long getOneAuthEnrolledModes(HttpServletRequest request, Long loginId) {
        return MobileOneAuthHandler.getOneAuthEnrolledModes(request, loginId, false);
    }

    public static long getOneAuthEnrolledModes(HttpServletRequest request, Long loginId, boolean checkNativeApp) {
        Long enrolledValue = 0L;
        try {
            DataObject dataObject;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "USER_LOGIN_ID"), (Object)loginId, 0);
            if (checkNativeApp && MobileUtil.isNativeApp(request)) {
                String oneAuthUniqueToken = request.getParameter("ONE_AUTH_UNIQUE_TOKEN");
                cri = cri.and(new Criteria(new Column(SSPMOBILEONEAUTH, "UNIQUE_TOKEN"), (Object)oneAuthUniqueToken, 0));
            }
            if (!(dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri)).isEmpty()) {
                Iterator it = dataObject.getRows(SSPMOBILEONEAUTH);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long bitValue = (Long)r.get("ENROLLED_MODES");
                    enrolledValue = enrolledValue | bitValue;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enrolledValue;
    }

    public static boolean isFingerprintSet(Long bitValue) {
        return (bitValue & 0x80L) == 128L;
    }

    public static boolean isPushNotificationSet(Long bitValue) {
        return (bitValue & 0x40L) == 64L;
    }

    public static boolean isQRCodeSet(Long bitValue) {
        return (bitValue & 0x100L) == 256L;
    }

    public static boolean isTOTPSet(Long bitValue) {
        return (bitValue & 0x200L) == 512L;
    }

    public static ArrayList getPushEnrolledDeviceList(Long loginId) {
        ArrayList<String> pushEnrolledDeviceList = new ArrayList<String>();
        try {
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(SSPMOBILEONEAUTH);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    String deviceId = (String)row.get("DEVICE_ID");
                    pushEnrolledDeviceList.add(deviceId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pushEnrolledDeviceList;
    }

    public static ArrayList getPushEnrolledDevice(String oneAuthToken) {
        ArrayList<String> pushEnrolledDeviceList = new ArrayList<String>();
        try {
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "UNIQUE_TOKEN"), (Object)oneAuthToken, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(SSPMOBILEONEAUTH);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    String deviceId = (String)row.get("DEVICE_ID");
                    pushEnrolledDeviceList.add(deviceId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pushEnrolledDeviceList;
    }

    public static void handleOneAuthResult(HttpServletRequest request) {
        try {
            Row row;
            String status;
            Iterator it;
            String requestID = request.getParameter("REQUEST_ID");
            String result = request.getParameter("RESULT");
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTHBUFFER, "REQUEST_ID"), (Object)requestID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER)).hasNext() && (status = (String)(row = (Row)it.next()).get("STATUS")) == null) {
                row.set("STATUS", (Object)result);
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean verifyTotpCode(String secretKey, String code, Long time, String crypto, int noDigits) {
        long timeUnit = time / 1000L / 30L;
        secretKey = secretKey.toUpperCase();
        byte[] secretBytes = secretKey.getBytes();
        long _code = Long.parseLong(code);
        for (int i = -5; i <= 5; ++i) {
            long gCode = MobileOneAuthHandler.getCode(secretBytes, timeUnit + (long)i, crypto, noDigits);
            if (gCode != _code) continue;
            return true;
        }
        return false;
    }

    private static long power(long a, long b) {
        if (b == 0L) {
            return 1L;
        }
        if (b == 1L) {
            return a;
        }
        if (b % 2L == 0L) {
            return MobileOneAuthHandler.power(a * a, b / 2L);
        }
        return a * MobileOneAuthHandler.power(a * a, b / 2L);
    }

    private static long getCode(byte[] secret, long timeUnit, String crypto, int noDigits) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8).putLong(timeUnit);
            byte[] timeBytes = buffer.array();
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(secret, "RAW");
            hmac.init(macKey);
            byte[] hash = hmac.doFinal(timeBytes);
            int offset = hash[hash.length - 1] & 0xF;
            long truncatedHash = hash[offset] & 0x7F;
            for (int i = 1; i < 4; ++i) {
                truncatedHash <<= 8;
                truncatedHash |= (long)(hash[offset + i] & 0xFF);
            }
            return truncatedHash %= MobileOneAuthHandler.power(10L, noDigits);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getStatusForRequest(String requestId) {
        String status = null;
        try {
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTHBUFFER, "REQUEST_ID"), (Object)requestId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER)).hasNext()) {
                Row row = (Row)it.next();
                status = (String)row.get("STATUS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static String getStatusFromBuffer(String requestId) {
        String status = null;
        try {
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTHBUFFER, "REQUEST_ID"), (Object)requestId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER)).hasNext()) {
                Row row = (Row)it.next();
                status = (String)row.get("STATUS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static void deleteQRImage(String imageName) {
        String imageDir = System.getProperty("server.home") + File.separator + "webapps" + File.separator + "adssp" + File.separator + "temp" + File.separator + "mfa" + File.separator;
        String imageNam = imageName + ".png";
        String imagePath = imageDir + imageNam;
        File file = new File(imagePath);
        if (file.isFile()) {
            file.delete();
        }
    }

    public static int getRequestCount(String oneAuthUniqueToken, Long loginId) {
        int requestCount = 0;
        try {
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTHBUFFER, "USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, cri);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    String oneAuthTokens = (String)row.get("UNIQUE_TOKEN");
                    String status = (String)row.get("STATUS");
                    Long expiryTime = (Long)row.get("EXPIRY_TIME");
                    Long modeId = (Long)row.get("MODE_ID");
                    String modeName = MobileOneAuthHandler.getModeName(modeId);
                    String pushStatus = (String)row.get("PUSH_STATUS");
                    boolean skipCount = false;
                    boolean isRequestExpired = MobileOneAuthHandler.isRequestExpired(expiryTime);
                    if (modeName.equals(PUSH_NOTIFICATION_AUTH) && (pushStatus == null || pushStatus.equals(FAIL))) {
                        skipCount = true;
                    }
                    if (skipCount || !oneAuthTokens.contains(oneAuthUniqueToken) || isRequestExpired || status != null) continue;
                    ++requestCount;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestCount;
    }

    public static void disenrollPushForUser(Long loginId) {
        try {
            boolean deleteUser = false;
            JSONObject mobileAppAuth = MobileOneAuthHandler.getMobileAppAuthRegValues(loginId);
            boolean isPushEnrolled = mobileAppAuth.getString(PUSH_NOTIFICATION_AUTH).equals("true");
            if (!isPushEnrolled) {
                Iterator it;
                Criteria c = new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPUserPropertyMap", c);
                if (!obj.isEmpty() && (it = obj.getRows("SSPUserPropertyMap")).hasNext()) {
                    Row row = (Row)it.next();
                    Long enrollmentType = (Long)row.get("ENROLLMENT_TYPE");
                    enrollmentType = enrollmentType - 256L;
                    row.set("ENROLLMENT_TYPE", (Object)enrollmentType);
                    if (enrollmentType.equals(0L)) {
                        deleteUser = true;
                    }
                    obj.updateRow(row);
                }
                if (deleteUser) {
                    Criteria cri = new Criteria(new Column("SSPUserPropertyMap", "USER_LOGIN_ID"), (Object)loginId, 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(cri);
                } else {
                    CommonUtil.getPersistenceLite().update(obj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void disenrollForPushNotification(String deviceId) {
        Long loginId = null;
        Long enrolledValue = null;
        String oneAuthUniqueToken = null;
        boolean deleteEnrollment = false;
        try {
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "DEVICE_ID"), (Object)deviceId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTH)).hasNext()) {
                Row row = (Row)it.next();
                loginId = (Long)row.get("USER_LOGIN_ID");
                oneAuthUniqueToken = (String)row.get("UNIQUE_TOKEN");
                enrolledValue = (Long)row.get("ENROLLED_MODES");
                enrolledValue = enrolledValue & (1L << (int)MobileOneAuthHandler.getModePos(64L) ^ 0xFFFFFFFFFFFFFFFFL);
                row.set("ENROLLED_MODES", (Object)enrolledValue);
                if (enrolledValue.equals(0L)) {
                    deleteEnrollment = true;
                }
                dataObject.updateRow(row);
            }
            if (deleteEnrollment) {
                MobileOneAuthHandler.removeOldEnrollment(deviceId);
            } else {
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
            MobileOneAuthHandler.disenrollPushForUser(loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long getRowNumber(String requestId) {
        Long rowNumber = 0L;
        try {
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTHBUFFER, "REQUEST_ID"), (Object)requestId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER)).hasNext()) {
                Row row = (Row)it.next();
                rowNumber = (Long)row.get("REQUEST_NUMBER");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowNumber;
    }

    public static Long getLoginIDForDeviceID(String deviceId) {
        Long loginId = 0L;
        try {
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "DEVICE_ID"), (Object)deviceId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTH)).hasNext()) {
                Row row = (Row)it.next();
                loginId = (Long)row.get("USER_LOGIN_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loginId;
    }

    public static Long getEnrolledValuesForDevice(String deviceId) {
        Long enrolledValues = 0L;
        try {
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "DEVICE_ID"), (Object)deviceId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTH)).hasNext()) {
                Row row = (Row)it.next();
                enrolledValues = (Long)row.get("ENROLLED_MODES");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enrolledValues;
    }

    public static Long getLoginIDForDevice(String oneAuthUniqueToken) {
        Long loginId = 0L;
        try {
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "UNIQUE_TOKEN"), (Object)oneAuthUniqueToken, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTH)).hasNext()) {
                Row row = (Row)it.next();
                loginId = (Long)row.get("USER_LOGIN_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loginId;
    }

    public static boolean isMobileAppAuthEnabled() {
        try {
            Criteria cri = new Criteria(Column.getColumn((String)"SSPPCPOLICYVSMODULES", (String)"PC_MODULE_ID"), (Object)APCModuleHandler.getModuleId("ID_VERIFICATIONS"), 0);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("SSPPCPOLICYVSMODULES", cri);
            if (!dataobject.isEmpty()) {
                Iterator it = dataobject.getRows("SSPPCPOLICYVSMODULES");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long enabledBitValues = (Long)r.get("FLAG_BIT_VALS");
                    if (!MobileOneAuthHandler.isPushNotificationSet(enabledBitValues) && !MobileOneAuthHandler.isFingerprintSet(enabledBitValues) && !MobileOneAuthHandler.isQRCodeSet(enabledBitValues) && !MobileOneAuthHandler.isTOTPSet(enabledBitValues)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isMobileAuthenticatorEnabled(Long loginId) {
        boolean isMobileAuthEnabled = false;
        try {
            Properties domainDetails = ADAuthHandler.getLoginUserDetails(loginId);
            if (!domainDetails.isEmpty()) {
                String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
                String logonName = domainDetails.getProperty("LOGIN_NAME");
                Hashtable policyHash = PolicyHandler.checkPermission(domainName, logonName);
                Long policyId = (Long)policyHash.get("policyId");
                JSONObject json = APCModuleHandler.getModuleFlagValues(policyId, "ID_VERIFICATIONS");
                boolean isPushEnabled = json.getString(PUSH_NOTIFICATION_AUTH).equals("1");
                boolean isFPEnabled = json.getString(FINGER_PRINT_AUTH).equals("1");
                boolean isQREnabled = json.getString(QR_CODE_AUTH).equals("1");
                boolean isTotpEnabled = json.getString(TOTP_AUTH).equals("1");
                isMobileAuthEnabled = isPushEnabled || isFPEnabled || isQREnabled || isTotpEnabled;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isMobileAuthEnabled;
    }

    public static List<String> getUniqueTokenList(Long modeId, Long loginId) {
        ArrayList<String> uniqueList = new ArrayList<String>();
        try {
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(SSPMOBILEONEAUTH);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Long enrolledModes = (Long)row.get("ENROLLED_MODES");
                    boolean isModeSet = MobileOneAuthHandler.isModeBitSet(enrolledModes, modeId);
                    if (!isModeSet) continue;
                    uniqueList.add((String)row.get("UNIQUE_TOKEN"));
                }
                return uniqueList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uniqueList;
    }

    public static void updateExpiryTime(String requestID, int sessionTime) {
        try {
            Iterator it;
            Long sessionTimeinMillis = sessionTime * 60 * 1000;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTHBUFFER, "REQUEST_ID"), (Object)requestID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER)).hasNext()) {
                Row row = (Row)it.next();
                Long expiryTime = System.currentTimeMillis() + sessionTimeinMillis;
                row.set("EXPIRY_TIME", (Object)expiryTime);
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String updateBuffer(String oneAuthToken, Long modeId, Long loginId, int sessionTime) {
        String uniqueId = null;
        try {
            String uniqueTokens = null;
            uniqueId = UUID.randomUUID().toString();
            List<String> tokenList = MobileOneAuthHandler.getUniqueTokenList(modeId, loginId);
            Long maxRefNum = MobileOneAuthHandler.getMaxReferenceNumber();
            uniqueTokens = oneAuthToken != null && !oneAuthToken.equals("") && tokenList.contains(oneAuthToken) ? oneAuthToken : tokenList.toString();
            Long sessionTimeinMillis = sessionTime * 60 * 1000;
            Long expiryTime = System.currentTimeMillis() + sessionTimeinMillis;
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row(SSPMOBILEONEAUTHBUFFER);
            row.set("REQUEST_ID", (Object)uniqueId);
            row.set("REQUEST_NUMBER", (Object)(maxRefNum + 1L));
            row.set("MODE_ID", (Object)modeId);
            row.set("UNIQUE_TOKEN", (Object)uniqueTokens);
            row.set("USER_LOGIN_ID", (Object)loginId);
            row.set("EXPIRY_TIME", (Object)expiryTime);
            row.set("PUSH_STATUS", (Object)FAIL);
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uniqueId;
    }

    public static int getTotalCount() {
        int totalCount = 0;
        try {
            String totalCountQuery = "select count(*) from SSPMobileOneAuthBuffer;";
            totalCount = QueryUtil.getRowsCount(totalCountQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalCount;
    }

    public static Long getMaxReferenceNumber() {
        Long maxReferenceNum = 0L;
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, (Criteria)null);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Long refNum = (Long)row.get("REQUEST_NUMBER");
                    if (refNum <= maxReferenceNum) continue;
                    maxReferenceNum = refNum;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxReferenceNum;
    }

    public static String updateBuffer(Long modeId, Long loginId, int sessionTime) {
        String uniqueId = null;
        try {
            Long maxRefNum = MobileOneAuthHandler.getMaxReferenceNumber();
            uniqueId = UUID.randomUUID().toString();
            String uniqueTokens = MobileOneAuthHandler.getUniqueTokenList(modeId, loginId).toString();
            Long sessionTimeinMillis = sessionTime * 60 * 1000;
            Long expiryTime = System.currentTimeMillis() + sessionTimeinMillis;
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row(SSPMOBILEONEAUTHBUFFER);
            row.set("REQUEST_ID", (Object)uniqueId);
            row.set("REQUEST_NUMBER", (Object)(maxRefNum + 1L));
            row.set("MODE_ID", (Object)modeId);
            row.set("UNIQUE_TOKEN", (Object)uniqueTokens);
            row.set("USER_LOGIN_ID", (Object)loginId);
            row.set("EXPIRY_TIME", (Object)expiryTime);
            row.set("PUSH_STATUS", (Object)FAIL);
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uniqueId;
    }

    public static boolean isRequestExpired(long expiryTime) {
        long currentTime = System.currentTimeMillis();
        return currentTime > expiryTime;
    }

    public static void deleteExpiredRequest(List<String> expiredReqList) {
        try {
            for (String id : expiredReqList) {
                MobileOneAuthHandler.deleteRequest(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getModeDetailsFromBuffer(String uniqueToken, Long mobileAppAuthId) {
        try {
            JSONObject response = new JSONObject();
            ArrayList<String> expiredReqIds = new ArrayList<String>();
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, (Criteria)null);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    String uniqueTokens = (String)row.get("UNIQUE_TOKEN");
                    Long expiryTime = (Long)row.get("EXPIRY_TIME");
                    boolean requestExpired = MobileOneAuthHandler.isRequestExpired(expiryTime);
                    if (requestExpired) {
                        String requestId = (String)row.get("REQUEST_ID");
                        expiredReqIds.add(requestId);
                    }
                    String status = (String)row.get("STATUS");
                    if (!uniqueTokens.contains(uniqueToken) || requestExpired || status != null) continue;
                    Long modeId = (Long)row.get("MODE_ID");
                    if (mobileAppAuthId != null && (mobileAppAuthId == null || !mobileAppAuthId.equals(modeId))) continue;
                    String requestID = (String)row.get("REQUEST_ID");
                    String modeName = MobileOneAuthHandler.getModeName(modeId);
                    String pushStatus = (String)row.get("PUSH_STATUS");
                    if (modeName.equals(PUSH_NOTIFICATION_AUTH) && (!modeName.equals(PUSH_NOTIFICATION_AUTH) || pushStatus == null || !pushStatus.equals(SUCCESS))) continue;
                    response.put("REQUEST_ROW_COUNT", row.get("REQUEST_NUMBER"));
                    response.put("REQUEST_ID", (Object)requestID);
                    response.put("MODE_NAME", (Object)modeName);
                    return response;
                }
            }
            if (expiredReqIds.size() > 0) {
                MobileOneAuthHandler.deleteExpiredRequest(expiredReqIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getPushStatusFromBuffer(String uniqueToken) {
        String pushStatus;
        block3: {
            pushStatus = null;
            try {
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, (Criteria)null);
                if (dataObject.isEmpty()) break block3;
                Iterator it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    String uniqueTokens = (String)row.get("UNIQUE_TOKEN");
                    Long expiryTime = (Long)row.get("EXPIRY_TIME");
                    String status = (String)row.get("STATUS");
                    boolean requestExpired = MobileOneAuthHandler.isRequestExpired(expiryTime);
                    if (!uniqueTokens.contains(uniqueToken) || requestExpired || status != null) continue;
                    pushStatus = (String)row.get("PUSH_STATUS");
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pushStatus;
    }

    public static JSONObject getModeFromBuffer(String uniqueToken, String modeName) {
        if (modeName == null || modeName.equals("")) {
            return MobileOneAuthHandler.getModeDetailsFromBuffer(uniqueToken, null);
        }
        if (modeName != null && modeName.equals(PUSH_NOTIFICATION_AUTH)) {
            String pushNotifStatus = MobileOneAuthHandler.getPushStatusFromBuffer(uniqueToken);
            while (pushNotifStatus != null && !pushNotifStatus.equals(SUCCESS)) {
                pushNotifStatus = MobileOneAuthHandler.getPushStatusFromBuffer(uniqueToken);
            }
        }
        return MobileOneAuthHandler.getModeDetailsFromBuffer(uniqueToken, MobileOneAuthHandler.getModeId(modeName));
    }

    public static JSONObject getModeFromBuffer(String uniqueToken) {
        return MobileOneAuthHandler.getModeDetailsFromBuffer(uniqueToken, null);
    }

    public static void setPushNotificationStatus(String requestId) {
        try {
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTHBUFFER, "REQUEST_ID"), (Object)requestId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER)).hasNext()) {
                Row row = (Row)it.next();
                row.set("PUSH_STATUS", (Object)SUCCESS);
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRequestAvailable(String requestId) {
        try {
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTHBUFFER, "REQUEST_ID"), (Object)requestId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, cri);
            if (!dataObject.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void deleteStatus(String requestId) {
        try {
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTHBUFFER, "REQUEST_ID"), (Object)requestId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTHBUFFER, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTHBUFFER)).hasNext()) {
                Row row = (Row)it.next();
                row.set("STATUS", null);
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteOneAuthRecord(String tableName, String columnName, String columnValue) {
        try {
            Criteria cri = new Criteria(new Column(tableName, columnName), (Object)columnValue, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(cri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteRequest(String requestId) {
        MobileOneAuthHandler.deleteOneAuthRecord(SSPMOBILEONEAUTHBUFFER, "REQUEST_ID", requestId);
        MobileOneAuthHandler.deleteQRImage(requestId);
    }

    public static void removeOldEnrollment(String deviceId) {
        MobileOneAuthHandler.deleteOneAuthRecord(SSPMOBILEONEAUTH, "DEVICE_ID", deviceId);
    }

    public static void checkOneAuthEnrollment(Long loginId, String devcieUniqueId) {
        try {
            Row row;
            Long _loginId;
            Iterator it;
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "DEVICE_ID"), (Object)devcieUniqueId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty() && (it = dataObject.getRows(SSPMOBILEONEAUTH)).hasNext() && !(_loginId = (Long)(row = (Row)it.next()).get("USER_LOGIN_ID")).equals(loginId)) {
                Long enrolledValues = (Long)row.get("ENROLLED_MODES");
                MobileOneAuthHandler.removeOldEnrollment(devcieUniqueId);
                MobileOneAuthHandler.removeOneAuthEnrollment(_loginId, enrolledValues);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void disenrollMobileOneAuth(ArrayList disEnrollmentList, Long loginId) {
        boolean deleteUser = false;
        try {
            JSONObject mobileAppAuth = MobileOneAuthHandler.getMobileAppAuthRegValues(loginId);
            Criteria c = new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPUserPropertyMap", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPUserPropertyMap");
                if (it.hasNext()) {
                    Row row = (Row)it.next();
                    Long enrollmentType = (Long)row.get("ENROLLMENT_TYPE");
                    if (disEnrollmentList.contains(PUSH_NOTIFICATION_AUTH) && mobileAppAuth.getString(PUSH_NOTIFICATION_AUTH).equals("false")) {
                        enrollmentType = enrollmentType - 256L;
                    }
                    if (disEnrollmentList.contains(FINGER_PRINT_AUTH) && mobileAppAuth.getString(FINGER_PRINT_AUTH).equals("false")) {
                        enrollmentType = enrollmentType - 512L;
                    }
                    if (disEnrollmentList.contains(QR_CODE_AUTH) && mobileAppAuth.getString(QR_CODE_AUTH).equals("false")) {
                        enrollmentType = enrollmentType - 1024L;
                    }
                    if (disEnrollmentList.contains(TOTP_AUTH) && mobileAppAuth.getString(TOTP_AUTH).equals("false")) {
                        enrollmentType = enrollmentType - 2048L;
                    }
                    row.set("ENROLLMENT_TYPE", (Object)enrollmentType);
                    if (enrollmentType.equals(0L)) {
                        deleteUser = true;
                    }
                    obj.updateRow(row);
                }
                if (deleteUser) {
                    Criteria cri = new Criteria(new Column("SSPUserPropertyMap", "USER_LOGIN_ID"), (Object)loginId, 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(cri);
                } else {
                    CommonUtil.getPersistenceLite().update(obj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeOneAuthEnrollment(Long loginId, Long enrolledValueInDevice) {
        try {
            boolean deleteUser = false;
            JSONObject mobileAppAuth = MobileOneAuthHandler.getMobileAppAuthRegValues(loginId);
            Criteria c = new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPUserPropertyMap", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPUserPropertyMap");
                if (it.hasNext()) {
                    Row row = (Row)it.next();
                    Long enrollmentType = (Long)row.get("ENROLLMENT_TYPE");
                    if (MobileOneAuthHandler.isPushNotificationSet(enrolledValueInDevice) && mobileAppAuth.getString(PUSH_NOTIFICATION_AUTH).equals("false")) {
                        enrollmentType = enrollmentType - 256L;
                    }
                    if (MobileOneAuthHandler.isFingerprintSet(enrolledValueInDevice) && mobileAppAuth.getString(FINGER_PRINT_AUTH).equals("false")) {
                        enrollmentType = enrollmentType - 512L;
                    }
                    if (MobileOneAuthHandler.isQRCodeSet(enrolledValueInDevice) && mobileAppAuth.getString(QR_CODE_AUTH).equals("false")) {
                        enrollmentType = enrollmentType - 1024L;
                    }
                    if (MobileOneAuthHandler.isTOTPSet(enrolledValueInDevice) && mobileAppAuth.getString(TOTP_AUTH).equals("false")) {
                        enrollmentType = enrollmentType - 2048L;
                    }
                    row.set("ENROLLMENT_TYPE", (Object)enrollmentType);
                    if (enrollmentType.equals(0L)) {
                        deleteUser = true;
                    }
                    obj.updateRow(row);
                }
                if (deleteUser) {
                    Criteria cri = new Criteria(new Column("SSPUserPropertyMap", "USER_LOGIN_ID"), (Object)loginId, 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(cri);
                } else {
                    CommonUtil.getPersistenceLite().update(obj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkOneAuthTokenExist(String oneAuthToken) {
        boolean isOneAuthTokenExist = false;
        try {
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "UNIQUE_TOKEN"), (Object)oneAuthToken, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty()) {
                isOneAuthTokenExist = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isOneAuthTokenExist;
    }

    public static ArrayList convertList(ArrayList idList) {
        ArrayList finalList = idList;
        boolean isPush = idList.indexOf(IdentityVerifyHandler.PN_VERIFICATION_ID) != -1;
        boolean isFP = idList.indexOf(IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID) != -1;
        boolean isQR = idList.indexOf(IdentityVerifyHandler.QR_CODE_VERIFICATION_ID) != -1;
        boolean isTotp = idList.indexOf(IdentityVerifyHandler.TOTP_VERIFICATION_ID) != -1;
        boolean isOneAuth = isPush || isFP || isQR || isTotp;
        finalList.remove(IdentityVerifyHandler.PN_VERIFICATION_ID);
        finalList.remove(IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID);
        finalList.remove(IdentityVerifyHandler.QR_CODE_VERIFICATION_ID);
        finalList.remove(IdentityVerifyHandler.TOTP_VERIFICATION_ID);
        if (isOneAuth) {
            finalList.add(IdentityVerifyHandler.PN_VERIFICATION_ID);
        }
        return finalList;
    }

    public static boolean isOneAuthTokenValid(String oneAuthToken, String deviceId) {
        try {
            Criteria cri = new Criteria(new Column(SSPMOBILEONEAUTH, "UNIQUE_TOKEN"), (Object)oneAuthToken, 0);
            cri = cri.and(new Criteria(new Column(SSPMOBILEONEAUTH, "DEVICE_ID"), (Object)deviceId, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SSPMOBILEONEAUTH, cri);
            if (!dataObject.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void convertIdentityDetails(JSONObject identityDetails, HttpServletRequest request) {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long pushId = IdentityVerifyHandler.PN_VERIFICATION_ID;
            Long fpId = IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID;
            Long qrId = IdentityVerifyHandler.QR_CODE_VERIFICATION_ID;
            Long totpId = IdentityVerifyHandler.TOTP_VERIFICATION_ID;
            String mobileAppAuth = rb.getString("adssp.enrollment.mobile_one_auth.heading");
            Long priority = 11L;
            Long verifId = 7L;
            Long pushP = 0L;
            Long fpP = 0L;
            Long qrP = 0L;
            Long totpP = 0L;
            boolean isMandatory = false;
            boolean pushM = false;
            boolean fpM = false;
            boolean qrM = false;
            boolean totpM = false;
            Iterator iterator = identityDetails.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                JSONObject jsonProp = (JSONObject)identityDetails.get(key);
                Long identityID = (Long)jsonProp.get("VERIFICATION_ID");
                if (identityID.equals(pushId)) {
                    if (jsonProp.has("PRIORITY")) {
                        pushP = (Long)jsonProp.get("PRIORITY");
                        priority = Math.min(priority, pushP);
                    }
                    pushM = jsonProp.has("IS_MANDATORY") && (Boolean)jsonProp.get("IS_MANDATORY") != false;
                    continue;
                }
                if (identityID.equals(fpId)) {
                    if (jsonProp.has("PRIORITY")) {
                        fpP = (Long)jsonProp.get("PRIORITY");
                        priority = Math.min(priority, fpP);
                    }
                    fpM = jsonProp.has("IS_MANDATORY") && (Boolean)jsonProp.get("IS_MANDATORY") != false;
                    continue;
                }
                if (identityID.equals(qrId)) {
                    if (jsonProp.has("PRIORITY")) {
                        qrP = (Long)jsonProp.get("PRIORITY");
                        priority = Math.min(priority, qrP);
                    }
                    qrM = jsonProp.has("IS_MANDATORY") && (Boolean)jsonProp.get("IS_MANDATORY") != false;
                    continue;
                }
                if (!identityID.equals(totpId)) continue;
                if (jsonProp.has("PRIORITY")) {
                    totpP = (Long)jsonProp.get("PRIORITY");
                    priority = Math.min(priority, totpP);
                }
                totpM = jsonProp.has("IS_MANDATORY") && (Boolean)jsonProp.get("IS_MANDATORY") != false;
            }
            isMandatory = pushM || fpM || qrM || totpM;
            JSONObject oneAuth = new JSONObject();
            oneAuth.put("VERIFICATION_DISPLAY_NAME", (Object)mobileAppAuth);
            oneAuth.put("PRIORITY", (Object)priority);
            oneAuth.put("IS_MANDATORY", isMandatory);
            oneAuth.put("VERIFICATION_ID", (Object)verifId);
            if (!pushP.equals(0L)) {
                identityDetails.remove(String.valueOf(pushP));
            }
            if (!fpP.equals(0L)) {
                identityDetails.remove(String.valueOf(fpP));
            }
            if (!qrP.equals(0L)) {
                identityDetails.remove(String.valueOf(qrP));
            }
            if (!totpP.equals(0L)) {
                identityDetails.remove(String.valueOf(totpP));
            }
            identityDetails.put(Long.toString(priority), (Object)oneAuth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList convertEnrollList(ArrayList enrollList, ArrayList mandatoryList) {
        ArrayList finalList = enrollList;
        boolean isPushE = enrollList.indexOf(IdentityVerifyHandler.PN_VERIFICATION_ID) != -1;
        boolean isFPE = enrollList.indexOf(IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID) != -1;
        boolean isQRE = enrollList.indexOf(IdentityVerifyHandler.QR_CODE_VERIFICATION_ID) != -1;
        boolean isTotpE = enrollList.indexOf(IdentityVerifyHandler.TOTP_VERIFICATION_ID) != -1;
        boolean isPushM = mandatoryList.indexOf(IdentityVerifyHandler.PN_VERIFICATION_ID) != -1;
        boolean isFPM = mandatoryList.indexOf(IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID) != -1;
        boolean isQRM = mandatoryList.indexOf(IdentityVerifyHandler.QR_CODE_VERIFICATION_ID) != -1;
        boolean isTOTPM = mandatoryList.indexOf(IdentityVerifyHandler.TOTP_VERIFICATION_ID) != -1;
        finalList.remove(IdentityVerifyHandler.PN_VERIFICATION_ID);
        finalList.remove(IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID);
        finalList.remove(IdentityVerifyHandler.QR_CODE_VERIFICATION_ID);
        finalList.remove(IdentityVerifyHandler.TOTP_VERIFICATION_ID);
        boolean isOneAuth = false;
        if (!(isPushM || isFPM || isQRM || isTOTPM)) {
            isOneAuth = isPushE || isFPE || isQRE || isTotpE;
        } else {
            boolean bl = isOneAuth = !(isPushM && !isPushE || isFPM && !isFPE || isQRM && !isQRE || isTOTPM && !isTotpE);
        }
        if (isOneAuth) {
            finalList.add(IdentityVerifyHandler.PN_VERIFICATION_ID);
        }
        return finalList;
    }

    public static void addPushNotificationAudit(JSONObject pushJSON) {
        try {
            if (pushJSON != null) {
                Hashtable<String, String> notificationProps = new Hashtable<String, String>();
                notificationProps.put("ACTION_NAME", "adssp.reports.audit_report.notification_delivery_report.mfa_notificaiton");
                notificationProps.put("NOTIFICATION_FROM", "MFA_NOTIFICATION");
                String returnValue = pushJSON.get("STATUS") + "";
                if (returnValue.equals(SUCCESS)) {
                    JSONArray notifiedUserList = pushJSON.getJSONArray("DELIVERY_DETAILS");
                    EnrollmentNotifyHandler.auditProcess(notifiedUserList, notificationProps);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getTOTPCodeLength() {
        int totpLength = 8;
        try {
            totpLength = IdentityVerifyHandler.getVerificationCodeLength();
            if (totpLength <= 0 || totpLength > 10) {
                totpLength = 8;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return totpLength;
    }
}

