/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.tfa;

import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.authentication.Authenticator;
import com.theorem.radius3.Attribute;
import com.theorem.radius3.AttributeList;
import com.theorem.radius3.ClientReceiveException;
import com.theorem.radius3.ClientSendException;
import com.theorem.radius3.RADIUSClient;
import com.theorem.radius3.RADIUSEncrypt;
import com.theorem.radius3.RADIUSException;
import com.theorem.radius3.dictionary.DefaultDictionary;
import com.theorem.radius3.dictionary.RADIUSDictionary;
import com.theorem.radius3.radutil.Util;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class RADIUSAuthenticator
extends Authenticator {
    public static final int SEND_FAILED = -1;
    public static final int RECEIVE_FAILED = -2;
    public static final int UNKNOWN_RADIUS_HOST = -3;
    public static final int UNKNOWN_EXCEPTION = -4;

    public boolean authenticate() throws LoginException {
        String messageType = "success";
        this.auditType = "adssp.reports.audit_report.user_attempts.type_radius_login_text";
        try {
            if (this.authStatus == null || this.authStatus != null && !this.authStatus.has(this.authRule)) {
                this.needAudit = false;
                return false;
            }
            String radiusPassword = this.request.getParameter("radiusPassword");
            Boolean isAuthenticated = this.radiusAuthenticate(this.loginName, this.domainName, radiusPassword);
            if (isAuthenticated.booleanValue()) {
                return true;
            }
            this.needAudit = false;
            throw new Exception("TWO_FACTOR");
        }
        catch (Exception le) {
            messageType = "error";
            if (this.authStatus != null) {
                try {
                    this.authStatus.put("AUTH_STATE", 2);
                    if (this.authStatus.has(this.authRule)) {
                        this.authStatus.getJSONObject(this.authRule).put("AUTH_STATE", 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!"TWO_FACTOR".equals(le.getMessage())) {
                this.request.setAttribute("message", (Object)le.getMessage());
                this.request.setAttribute("messageType", (Object)messageType);
                int status = 0;
                if ("success".equalsIgnoreCase(messageType)) {
                    status = 1;
                }
                this.errMsg = le.getMessage();
                if (this.session.getAttribute("isWinLogTFA") != null) {
                    this.auditType = "adssp.reports.audit_report.user_attempts.type_windows_login_text";
                }
                AuditAPI.getInstance().addUserAttemptsAuditLog(this.request, this.loginName, this.domainName, this.auditType, this.errMsg, status);
            }
            this.needAudit = false;
            throw new LoginException("TWO_FACTOR");
        }
    }

    public boolean radiusAuthenticate(String loginName, String domainName, String password) throws Exception {
        return this.radiusAuthenticate(loginName, domainName, password, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean radiusAuthenticate(String loginName, String domainName, String password, HttpSession mfaSession) throws Exception {
        String errorMsg = null;
        String radiusServer = null;
        String radiusSecret = "";
        String radiusPort = "";
        String retries = "";
        String authType = "";
        boolean status = false;
        String timeOut = "";
        String radiusUserName = loginName;
        Properties serverProps = new Properties();
        JSONObject mfaAuthstatus = null;
        try {
            if (mfaSession != null) {
                mfaAuthstatus = (JSONObject)mfaSession.getAttribute("MFA_AUTH_STATUS");
                radiusUserName = (String)mfaSession.getAttribute("radiusUserName");
            } else {
                radiusUserName = (String)this.session.getAttribute("radiusUserName");
            }
            JSONObject tfaProviderProps = mfaAuthstatus != null ? mfaAuthstatus.getJSONObject("RADIUSAuthenticator") : this.authStatus.getJSONObject(this.authRule);
            JSONArray tfaProviderModesNames = tfaProviderProps.getJSONArray("MODE_NAMES");
            String modeName = tfaProviderModesNames.getString(0);
            JSONObject tfaProviderMode = tfaProviderProps.getJSONObject("MODES").getJSONObject(modeName);
            JSONObject tfaProviderModeParams = tfaProviderMode.getJSONObject("PARAMS");
            String radiusUserPattern = tfaProviderModeParams.getJSONObject("RADIUS_USER_NAME").getString("PARAM_VALUE");
            radiusServer = tfaProviderModeParams.getJSONObject("SERVER_NAME").getString("PARAM_VALUE");
            radiusPort = tfaProviderModeParams.getJSONObject("SERVER_PORT").optString("PARAM_VALUE", "1812");
            radiusSecret = tfaProviderModeParams.getJSONObject("SERVER_SECRET").optString("PARAM_VALUE", "testing123");
            authType = tfaProviderModeParams.getJSONObject("SERVER_PROTOCOL").optString("PARAM_VALUE", "PAP");
            retries = tfaProviderModeParams.getJSONObject("AUTH_RETRIES").optString("PARAM_VALUE", "3");
            timeOut = tfaProviderModeParams.getJSONObject("TIME_OUT").optString("PARAM_VALUE", "5");
            serverProps.put("PORT", radiusPort);
            serverProps.put("SERVERSECRET", radiusSecret);
            serverProps.put("PROTOCOL", authType);
            serverProps.put("SERVERNAME", radiusServer);
            serverProps.put("RETRIES", retries);
            serverProps.put("TIMEOUT", timeOut);
            int result = RADIUSAuthenticator.radiusAuthenticate(radiusUserName, password, serverProps);
            switch (result) {
                case -1: {
                    logger.log(Level.SEVERE, "RADIUS Authentication Failed");
                    errorMsg = "adssp.login.radius.error.authentication_submit_failed";
                    break;
                }
                case -2: {
                    logger.log(Level.SEVERE, "RADIUS Authentication Failed");
                    errorMsg = "adssp.login.radius.error.authentication_failed_no_respone";
                    break;
                }
                case -3: {
                    logger.log(Level.SEVERE, "Unknown RADIUS Host Server");
                    errorMsg = "adssp.login.radius.error.unknown_host";
                    break;
                }
                case -4: {
                    logger.log(Level.SEVERE, "RADIUS Authentication Failed");
                    errorMsg = "adssp.login.radius.error.authentication_failed";
                    break;
                }
                case 3: {
                    logger.log(Level.SEVERE, "Invalid RADIUS Password");
                    errorMsg = "adssp.login.radius.error.invalid_pwd";
                    break;
                }
                case 0: {
                    logger.log(Level.SEVERE, "Received bad packet");
                    errorMsg = "adssp.login.radius.error.bad_packet";
                    break;
                }
                case 11: {
                    logger.log(Level.SEVERE, "Access was challenged. Can't handle this yet.");
                    errorMsg = "adssp.login.radius.error.access_challenged";
                    break;
                }
                case 2: {
                    logger.log(Level.SEVERE, "Authenticated");
                    status = true;
                }
            }
            if (errorMsg == null) return status;
        }
        catch (Exception e) {
            try {
                logger.log(Level.INFO, "Radius failed: ", e);
                throw new LoginException(e.getMessage());
            }
            catch (Throwable throwable) {
                if (errorMsg == null) throw throwable;
                throw new LoginException(errorMsg);
            }
        }
        throw new LoginException(errorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int radiusAuthenticate(String name, String password, Properties serverProps) {
        boolean flg = false;
        RADIUSClient r = null;
        int result = 3;
        String radiusServer = serverProps.getProperty("SERVERNAME");
        String radiusSecret = serverProps.getProperty("SERVERSECRET");
        int port = Integer.parseInt(serverProps.getProperty("PORT"));
        int retries = Integer.parseInt(serverProps.getProperty("RETRIES", "1"));
        String authType = serverProps.getProperty("PROTOCOL");
        String timeout = serverProps.getProperty("TIMEOUT");
        for (int l = 0; l < retries && !flg; ++l) {
            try {
                r = timeout == null ? new RADIUSClient(radiusServer, port, radiusSecret) : new RADIUSClient(radiusServer, port, radiusSecret, Integer.parseInt(timeout) * 1000);
                r.addDictionary((RADIUSDictionary)new DefaultDictionary());
                r.setDebug(false);
                logger.log(Level.FINEST, "\n---------------------------- Authentication (" + authType + ")----------------------------");
                logger.log(Level.INFO, "Authenticating: " + name);
                AttributeList aList = new AttributeList();
                try {
                    InetAddress ourIP = null;
                    String clientId = "localhost";
                    InetAddress clientAddress = null;
                    clientAddress = InetAddress.getLocalHost();
                    if (clientAddress != null) {
                        clientId = clientAddress.getCanonicalHostName();
                        aList.addAttribute(32, clientId);
                        ourIP = InetAddress.getByName(clientId);
                        aList.addAttribute(4, ourIP);
                    }
                    aList.addAttribute(5, 1);
                    logger.log(Level.INFO, "NAS_IP_Address  enabled ");
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception while adding NAS_IP_Address ", ex);
                }
                aList.addAttribute(80);
                logger.log(Level.INFO, "Mesage Authenticator enabled ");
                if (authType.equals("PAP")) {
                    byte[] arrByte = name.getBytes();
                    Attribute attribute = new Attribute(1, arrByte);
                    aList.addAttribute(attribute);
                    arrByte = password.getBytes();
                    byte[] encryptedByte = RADIUSEncrypt.encrypt((byte[])arrByte, (byte[])r.getSecret(), (byte[])r.getRequestAuthenticator());
                    attribute = new Attribute(2, encryptedByte);
                    aList.addAttribute(attribute);
                    logger.log(Level.FINEST, "User name is=" + name + " alist is=" + aList);
                    result = r.authenticate(aList);
                    AttributeList responseList = r.getAttributes();
                    logger.log(Level.FINEST, "User name is=" + responseList);
                } else if (authType.equals("CHAP")) {
                    aList.addAttribute(1, name.getBytes());
                    result = r.authenticate(password.getBytes(), aList);
                } else if (authType.equals("MSCHAP")) {
                    aList.addAttribute(1, Util.toUTF8((String)name));
                    try {
                        r.createMSCHAP(Util.toUTF8((String)new String(password.getBytes(), "ISO-8859-1")), aList);
                    }
                    catch (RADIUSException re) {
                        logger.log(Level.INFO, "Can't access the DES encoding algorithm -:", re);
                    }
                    result = r.authenticate(aList);
                } else if (authType.equals("MSCHAP2")) {
                    aList.addAttribute(1, Util.toUTF8((String)name));
                    try {
                        r.createMSCHAP2(RADIUSClient.getBytes((String)name), Util.toUTF8((String)new String(password.getBytes(), "ISO-8859-1")), aList);
                    }
                    catch (RADIUSException re) {
                        logger.log(Level.INFO, "Can't access the DES encoding algorithm -:", re);
                    }
                    result = r.authenticate(aList);
                } else {
                    logger.log(Level.INFO, "Unknown authentication type: " + authType);
                }
                if (result != 2 && result != 3) continue;
                flg = true;
                continue;
            }
            catch (UnknownHostException ex) {
                logger.log(Level.INFO, "Unknown RADIUS Host Server", ex);
                result = -3;
                flg = true;
                continue;
            }
            catch (ClientReceiveException ex) {
                logger.log(Level.INFO, "Radius authentication failed (ClientReceiveException) : ", ex);
                result = -2;
                continue;
            }
            catch (ClientSendException ex) {
                logger.log(Level.INFO, "Radius authentication failed (ClientSendException) : ", ex);
                result = -1;
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Radius authentication failed (Unknown Exception): ", ex);
                result = -4;
                continue;
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        return result;
    }
}

