/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.tfa;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.admin.AdvancedPolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.SecondaryAttributesHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.configuration.APCModuleHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.tfa.RADIUSAuthenticator;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.duosecurity.duoweb.Base64;
import com.duosecurity.duoweb.DuoWeb;
import com.zoho.framework.utils.crypto.CryptoUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class TFAHandler {
    public static final String TFAPROVIDERS_TABLE = "SSPTFAProviderModes";
    public static final String TFAPROVIDERPARAMS_TABLE = "SSPTFAModeParams";
    public static final String TFATRUST_TABLE = "SSPTFATrust";
    public static final String TFAMODEVSPOLICY_TABLE = "SSPTFAModesVsPolicies";
    public static final String TFA_COOKIE_VALIDITY = "TFA_COOKIE_VALIDITY";
    public static final String TFA_STRICT_MODE_DISABLED = "TFA_STRICT_MODE_DISABLED";
    public static final String TFA_VC_CODE_LENGTH = "TFA_VC_CODE_LENGTH";
    public static final String TFA_ENABLE_TRUST_BY_DEFAULT = "TFA_ENABLE_TRUST_BY_DEFAULT";
    public static final String EXCLUDE_TFA_FOR_SAML = "EXCLUDE_TFA_FOR_SAML";
    public static final int TFA_DUOWEB_AKEY_LEN = 40;
    public static final String TFA_DUOWEB_ERR_USER = "adssp.login.tfa.tfa_not_configured";
    public static final String TFA_DUOWEB_ERR_IKEY = "adssp.login.tfa.duoweb_ikey_error";
    public static final String TFA_DUOWEB_ERR_SKEY = "adssp.login.tfa.duoweb_skey_error";
    public static final String TFA_DUOWEB_ERR_AKEY = "adssp.login.tfa.duoweb_akey_error";
    public static final String TFA_DUOWEB_ERR_UNKNOWN = "adssp.login.tfa.duoweb_unknown_error";
    public static final String SUPPORTED_SERVER_PROTOCOL = "[\"PAP\",\"CHAP\",\"MSCHAP\",\"MSCHAP2\"]";
    public static final String SUPPORTED_AUTH_RETRIES = "[\"1\",\"2\",\"5\"]";
    public static final String SUPPORTED_TIME_OUT = "[\"5\",\"10\",\"15\",\"20\"]";
    public static final String SUPPORTED_RADIUS_USER_PREFIX_SUFIX = "[\"%domainDNSName%\",\"%domainFlatName%\",\"%userName%\",\"%capsDomainDNSName%\",\"%capsDomainFlatName%\",\"%capsUserName%\",\"%%\"]";
    public static final String SUPPORTED_RADIUS_USER_PREFIX_SUFIX_LABEL = "[\"domain_dns_name\",\"domain_flat_name\",\"user_name\",\"DOMAIN_DNS_NAME\",\"DOMAIN_FLAT_NAME\",\"USER_NAME\",\"EMPTY\"]";
    public static final String SUPPORTED_RADIUS_USER_INFIX = "[\"%\\\\%\",\"%@%\",\"%%\"]";
    public static final String SUPPORTED_RADIUS_USER_INFIX_LABEL = "[\"\\\\\",\"@\",\"EMPTY\"]";

    public static JSONObject getTFAProps() {
        return TFAHandler.getTFAProps(true, null);
    }

    public static JSONObject getTFAProps(Long policyId) {
        return TFAHandler.getTFAProps(true, policyId);
    }

    public static JSONObject getTFAProps(Boolean adminConfigMode, Long policyId) {
        return TFAHandler.getTFAProps(adminConfigMode, policyId, "");
    }

    public static JSONObject getTFAProps(Boolean adminConfigMode, Long policyId, String providerName) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONObject tfaProps = new JSONObject();
        JSONObject tfaProviders = new JSONObject();
        JSONArray providerNames = new JSONArray();
        try {
            tfaProps.put("ENABLED", false);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaPamModule"));
            sq.addJoin(new Join("AaaPamModule", TFAPROVIDERS_TABLE, new String[]{"PAMMODULE_ID"}, new String[]{"PROVIDER_ID"}, 2));
            sq.addSelectColumn(Column.getColumn((String)"AaaPamModule", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)TFAPROVIDERS_TABLE, (String)"*"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"AaaPamModule", (String)"PAMMODULE_ID"), true));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)TFAPROVIDERS_TABLE, (String)"MODE_ID"), true));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            SelectQueryImpl paramQuery = new SelectQueryImpl(Table.getTable((String)TFAPROVIDERPARAMS_TABLE));
            paramQuery.addSelectColumn(Column.getColumn((String)TFAPROVIDERPARAMS_TABLE, (String)"*"));
            paramQuery.addSortColumn(new SortColumn(Column.getColumn((String)TFAPROVIDERPARAMS_TABLE, (String)"PARAM_ID"), true));
            DataObject paramObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)paramQuery);
            SelectQueryImpl modePolicyQuery = new SelectQueryImpl(Table.getTable((String)TFAMODEVSPOLICY_TABLE));
            modePolicyQuery.addSelectColumn(Column.getColumn((String)TFAMODEVSPOLICY_TABLE, (String)"*"));
            DataObject modePolicyObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)modePolicyQuery);
            SelectQueryImpl polNotifQuery = new SelectQueryImpl(Table.getTable((String)"PolicyNotifications"));
            polNotifQuery.addSelectColumn(Column.getColumn((String)"PolicyNotifications", (String)"*"));
            DataObject polNotifObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)polNotifQuery);
            Criteria providerCriteria = "".equals(providerName) ? (Criteria)null : new Criteria(Column.getColumn((String)"AaaPamModule", (String)"NAME"), (Object)providerName, 0, false);
            Iterator pamIterator = obj.getRows("AaaPamModule", providerCriteria);
            while (pamIterator.hasNext()) {
                Row pamRow = (Row)pamIterator.next();
                JSONObject tfaProviderProps = new JSONObject();
                tfaProviderProps.put("PROVIDER_ID", pamRow.get("PAMMODULE_ID"));
                Boolean isProviderEnabled = false;
                JSONObject tfaProviderModes = new JSONObject();
                JSONArray modeNames = new JSONArray();
                Iterator it = obj.getRows(TFAPROVIDERS_TABLE, new Criteria(Column.getColumn((String)TFAPROVIDERS_TABLE, (String)"PROVIDER_ID"), pamRow.get("PAMMODULE_ID"), 0, false));
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    if (r == null) continue;
                    Boolean isEnabled = false;
                    JSONObject tfaProviderMode = new JSONObject();
                    tfaProviderMode.put("MODE_ID", r.get("MODE_ID"));
                    tfaProviderMode.put("MODE_NAME", r.get("MODE_NAME"));
                    Long notifyId = 23L;
                    if ("EMAIL_VERIFICATION_CODE".equalsIgnoreCase((String)r.get("MODE_NAME"))) {
                        notifyId = 22L;
                    }
                    tfaProviderMode.put("MODE_DISPLAY_NAME", r.get("MODE_DISPLAY_NAME"));
                    tfaProviderMode.put("CONFIG_URL", r.get("CONFIG_URL"));
                    tfaProviderMode.put("AUDIT_TYPE", r.get("AUDIT_TYPE"));
                    if (!tfaProviderProps.has("PROVIDER_NAME")) {
                        tfaProviderProps.put("PROVIDER_NAME", (Object)((String)pamRow.get("NAME")));
                        tfaProviderProps.put("PROVIDER_DISPLAY_NAME", r.get("PROVIDER_DISPLAY_NAME"));
                    }
                    if (adminConfigMode.booleanValue()) {
                        tfaProviderMode.put("CONFIG_STATUS", (Object)TFAHandler.getModeConfigurationStatus((String)r.get("MODE_NAME")));
                    }
                    Criteria crit = new Criteria(Column.getColumn((String)TFAMODEVSPOLICY_TABLE, (String)"MODE_ID"), r.get("MODE_ID"), 0);
                    if (policyId != null) {
                        crit = crit.and(new Criteria(Column.getColumn((String)TFAMODEVSPOLICY_TABLE, (String)"POLICY_ID"), (Object)policyId, 0));
                    }
                    Iterator modePolicyIterator = modePolicyObj.getRows(TFAMODEVSPOLICY_TABLE, crit);
                    while (modePolicyIterator.hasNext()) {
                        Row rw = (Row)modePolicyIterator.next();
                        isEnabled = (Boolean)rw.get("ENABLED");
                    }
                    tfaProviderMode.put("ENABLED", (Object)isEnabled);
                    isProviderEnabled = isProviderEnabled != false || isEnabled != false;
                    JSONObject tfaProviderParams = new JSONObject();
                    JSONArray paramNameArray = new JSONArray();
                    Iterator paramIterator = paramObj.getRows(TFAPROVIDERPARAMS_TABLE, new Criteria(Column.getColumn((String)TFAPROVIDERPARAMS_TABLE, (String)"MODE_ID"), r.get("MODE_ID"), 0, false));
                    while (paramIterator.hasNext()) {
                        Row paramRow = (Row)paramIterator.next();
                        if (paramRow == null) continue;
                        JSONObject tfaProviderParam = new JSONObject();
                        String paramName = (String)paramRow.get("PARAM_NAME");
                        tfaProviderParam.put("PARAM_NAME", paramRow.get("PARAM_NAME"));
                        tfaProviderParam.put("PARAM_DISPLAY_NAME", paramRow.get("PARAM_DISPLAY_NAME"));
                        String paramValue = (String)paramRow.get("PARAM_VALUE");
                        if ("DuoWebAuthenticator".equals(tfaProviderProps.getString("PROVIDER_NAME")) && "S_KEY".equals((String)paramRow.get("PARAM_NAME"))) {
                            paramValue = CryptoUtil.decrypt((String)paramValue);
                        } else if ("VCAuthenticator".equals(tfaProviderProps.getString("PROVIDER_NAME")) && ("SUBJECT".equals(paramName) || "MESSAGE".equals(paramName))) {
                            Criteria criteria = new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"NOTIFICATION_ID"), (Object)notifyId, 0);
                            if (policyId != null) {
                                criteria = criteria.and(new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"POLICY_ID"), (Object)policyId, 0));
                                Iterator polNotifIterator = polNotifObj.getRows("PolicyNotifications", criteria);
                                while (polNotifIterator.hasNext()) {
                                    Row rw = (Row)polNotifIterator.next();
                                    String columnName = "SUBJECT".equals(paramName) ? "SUBJECT" : "MAIL_CONTENT";
                                    paramValue = (String)rw.get(columnName);
                                }
                                paramValue = paramValue != null ? rb.getString(paramValue) : "";
                            }
                        }
                        tfaProviderParam.put("CONFIG_URL", paramRow.get("CONFIG_URL"));
                        tfaProviderParam.put("PARAM_VALUE", (Object)paramValue);
                        tfaProviderParams.put(tfaProviderParam.getString("PARAM_NAME"), (Object)tfaProviderParam);
                        paramNameArray.put((Object)tfaProviderParam.getString("PARAM_NAME"));
                    }
                    if ("RADIUSAuthenticator".equals(tfaProviderProps.getString("PROVIDER_NAME"))) {
                        tfaProviderMode.put("SUPPORTED_SERVER_PROTOCOL", (Object)new JSONArray(SUPPORTED_SERVER_PROTOCOL));
                        tfaProviderMode.put("SUPPORTED_AUTH_RETRIES", (Object)new JSONArray(SUPPORTED_AUTH_RETRIES));
                        tfaProviderMode.put("SUPPORTED_TIME_OUT", (Object)new JSONArray(SUPPORTED_TIME_OUT));
                        tfaProviderMode.put("SUPPORTED_RADIUS_USER_PREFIX_SUFIX", (Object)new JSONArray(SUPPORTED_RADIUS_USER_PREFIX_SUFIX));
                        tfaProviderMode.put("SUPPORTED_RADIUS_USER_PREFIX_SUFIX_LABEL", (Object)new JSONArray(SUPPORTED_RADIUS_USER_PREFIX_SUFIX_LABEL));
                        tfaProviderMode.put("SUPPORTED_RADIUS_USER_INFIX", (Object)new JSONArray(SUPPORTED_RADIUS_USER_INFIX));
                        tfaProviderMode.put("SUPPORTED_RADIUS_USER_INFIX_LABEL", (Object)new JSONArray(SUPPORTED_RADIUS_USER_INFIX_LABEL));
                    }
                    tfaProviderMode.put("PARAMS", (Object)tfaProviderParams);
                    tfaProviderMode.put("PARAM_NAMES", (Object)paramNameArray);
                    tfaProviderModes.put(tfaProviderMode.getString("MODE_NAME"), (Object)tfaProviderMode);
                    modeNames.put((Object)tfaProviderMode.getString("MODE_NAME"));
                }
                tfaProviderProps.put("ENABLED", (Object)isProviderEnabled);
                tfaProviderProps.put("MODES", (Object)tfaProviderModes);
                tfaProviderProps.put("MODE_NAMES", (Object)modeNames);
                tfaProviders.put(tfaProviderProps.getString("PROVIDER_NAME"), (Object)tfaProviderProps);
                providerNames.put((Object)tfaProviderProps.getString("PROVIDER_NAME"));
                tfaProps.put("ENABLED", tfaProps.getBoolean("ENABLED") || isProviderEnabled != false);
            }
            tfaProps.put("PROVIDERS", (Object)tfaProviders);
            tfaProps.put("PROVIDER_NAMES", (Object)providerNames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tfaProps;
    }

    public static Boolean saveTFASettings(HttpServletRequest request) {
        Boolean result = false;
        try {
            Long policyId = Long.parseLong(request.getParameter("policyId"));
            ArrayList<Long> enabledModes = new ArrayList<Long>();
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(new ArrayList<String>(Arrays.asList("AaaPamModule", TFAPROVIDERS_TABLE)), (Criteria)null);
            Iterator iterator = obj.getRows(TFAPROVIDERS_TABLE);
            DataObject modeVsPolObj = CommonUtil.getPersistence(new boolean[0]).get(TFAMODEVSPOLICY_TABLE, (Criteria)null);
            while (iterator.hasNext()) {
                Row r = (Row)iterator.next();
                Long providerId = (Long)r.get("PROVIDER_ID");
                Long modeId = (Long)r.get("MODE_ID");
                String modeName = (String)r.get("MODE_NAME");
                String tempModeName = modeName.equalsIgnoreCase("DUOWEB") ? "DuoWebAuthenticator" : (modeName.equalsIgnoreCase("RSA") ? "RSAAuthenticator" : (modeName.equalsIgnoreCase("RADIUS") ? "RADIUSAuthenticator" : modeName));
                Boolean modeEnabled = true;
                if (request.getParameter("TFA") == null) {
                    modeEnabled = false;
                } else {
                    modeEnabled = false;
                    if (providerId.toString().equals(request.getParameter("TFA_MODE"))) {
                        Iterator moduleItr = obj.getRows(TFAPROVIDERS_TABLE, new Criteria(Column.getColumn((String)TFAPROVIDERS_TABLE, (String)"PROVIDER_ID"), (Object)providerId, 0));
                        int noOfModes = 0;
                        while (moduleItr.hasNext()) {
                            ++noOfModes;
                            moduleItr.next();
                        }
                        if (noOfModes == 1 || "true".equalsIgnoreCase(request.getParameter(tempModeName.toString()))) {
                            modeEnabled = true;
                        }
                    }
                }
                if (modeEnabled.booleanValue()) {
                    String configStatus = TFAHandler.getModeConfigurationStatus((String)r.get("MODE_NAME"));
                    if (!"".equals(configStatus)) {
                        request.setAttribute("message", (Object)configStatus);
                        return false;
                    }
                    enabledModes.add(modeId);
                    String subject = request.getParameter(modeId + "_SUBJECT") != null ? request.getParameter(modeId + "_SUBJECT") : "";
                    String message = request.getParameter(modeId + "_MESSAGE") != null ? request.getParameter(modeId + "_MESSAGE") : "";
                    message = message.replaceAll("&lt;", "<");
                    message = message.replaceAll("&gt;", ">");
                    message = message.replaceAll("&quot;", "\"");
                    message = message.replaceAll("&#39;", "'");
                    message = message.replaceAll("&amp;", "&");
                    subject = subject.replaceAll("&lt;", "<");
                    subject = subject.replaceAll("&gt;", ">");
                    subject = subject.replaceAll("&quot;", "\"");
                    subject = subject.replaceAll("&#39;", "'");
                    subject = subject.replaceAll("&amp;", "&");
                    if (modeName.contains("VERIFICATION_CODE")) {
                        Row row;
                        String sendVia = "SMS";
                        String notifyType = "TWO_FACTOR_AUTHENTICATION_MOBILE";
                        Long notifyId = 23L;
                        if ("EMAIL_VERIFICATION_CODE".equalsIgnoreCase(modeName)) {
                            sendVia = "MAIL";
                            notifyType = "TWO_FACTOR_AUTHENTICATION_MAIL";
                            notifyId = 22L;
                        }
                        Criteria notifCriteria = new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"NOTIFICATION_ID"), (Object)notifyId, 0);
                        notifCriteria = notifCriteria.and(new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"POLICY_ID"), (Object)policyId, 0));
                        DataObject notifObj = CommonUtil.getPersistence(new boolean[0]).get("PolicyNotifications", notifCriteria);
                        if (notifObj.isEmpty()) {
                            row = new Row("PolicyNotifications");
                            row.set("POLICY_ID", (Object)policyId);
                            row.set("NOTIFICATION_ID", (Object)notifyId);
                            row.set("NOTIFICATION_TYPE", (Object)notifyType);
                            row.set("SUBJECT", (Object)subject);
                            row.set("MAIL_CONTENT", (Object)message);
                            row.set("SEND_VIA", (Object)sendVia);
                            row.set("MAIL_ID", (Object)"");
                            row.set("ENABLED", (Object)true);
                            notifObj.addRow(row);
                        } else {
                            row = notifObj.getFirstRow("PolicyNotifications");
                            row.set("SUBJECT", (Object)subject);
                            row.set("MAIL_CONTENT", (Object)message);
                            notifObj.updateRow(row);
                        }
                        CommonUtil.getPersistence(new boolean[0]).update(notifObj);
                    } else {
                        boolean updateInDB = false;
                        if ("DUOWEB".equals(modeName) && "true".equals(request.getParameter("isDuoConfigEdited"))) {
                            try {
                                updateInDB = true;
                                TFAHandler.isValidDuoWebKey(request.getParameter(modeId + "_I_KEY"), request.getParameter(modeId + "_S_KEY"), request.getParameter(modeId + "_API_HOST_NAME"));
                            }
                            catch (Exception e) {
                                request.setAttribute("message", (Object)e.getMessage());
                                return false;
                            }
                        }
                        if ("RADIUS".equals(modeName) && "true".equals(request.getParameter("isRadiusConfigEdited"))) {
                            try {
                                updateInDB = true;
                                if (!TFAHandler.isValidRadiusServer(request.getParameter(modeId + "_SERVER_NAME"), request.getParameter(modeId + "_SERVER_PORT"), request.getParameter(modeId + "_SERVER_SECRET"), request.getParameter(modeId + "_SERVER_PROTOCOL"), request.getParameter(modeId + "_TIME_OUT"))) {
                                    request.setAttribute("message", (Object)"adssp.admin.tfa.radius_server_invalid");
                                    return false;
                                }
                            }
                            catch (Exception e) {
                                request.setAttribute("message", (Object)e.getMessage());
                                return false;
                            }
                        }
                        if (!"DUOWEB".equals(modeName) && !"RADIUS".equals(modeName) || updateInDB) {
                            Criteria c = new Criteria(Column.getColumn((String)TFAPROVIDERPARAMS_TABLE, (String)"MODE_ID"), (Object)modeId, 0);
                            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(TFAPROVIDERPARAMS_TABLE, c);
                            if (!dObj.isEmpty()) {
                                Iterator it = dObj.getRows(TFAPROVIDERPARAMS_TABLE, c);
                                while (it.hasNext()) {
                                    Row paramRow = (Row)it.next();
                                    String paramName = modeId + "_" + paramRow.get("PARAM_NAME");
                                    String paramValue = request.getParameter(paramName);
                                    if (paramValue == null) continue;
                                    if ("S_KEY".equals(paramRow.get("PARAM_NAME"))) {
                                        paramValue = CryptoUtil.encrypt((String)paramValue);
                                    }
                                    paramRow.set("PARAM_VALUE", (Object)paramValue);
                                    dObj.updateRow(paramRow);
                                }
                                CommonUtil.getPersistence(new boolean[0]).update(dObj);
                            }
                        }
                    }
                }
                Criteria modeCriteria = new Criteria(Column.getColumn((String)TFAMODEVSPOLICY_TABLE, (String)"MODE_ID"), (Object)modeId, 0);
                Row row = modeVsPolObj.getRow(TFAMODEVSPOLICY_TABLE, modeCriteria = modeCriteria.and(new Criteria(Column.getColumn((String)TFAMODEVSPOLICY_TABLE, (String)"POLICY_ID"), (Object)policyId, 0)));
                if (row == null) {
                    Row newRow = new Row(TFAMODEVSPOLICY_TABLE);
                    newRow.set("MODE_ID", (Object)modeId);
                    newRow.set("POLICY_ID", (Object)policyId);
                    newRow.set("ENABLED", (Object)modeEnabled);
                    modeVsPolObj.addRow(newRow);
                    continue;
                }
                row.set("ENABLED", (Object)modeEnabled);
                modeVsPolObj.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(modeVsPolObj);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getUserTFAProps(String loginName, String domainName, Long policyId) {
        JSONObject userTFAProps = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            Boolean isStrictModeDisabled = "true".equalsIgnoreCase(ADSMPersUtil.getSyMParameter(TFA_STRICT_MODE_DISABLED));
            String tfaTrustFlag = ADSMPersUtil.getSyMParameter(TFA_ENABLE_TRUST_BY_DEFAULT);
            String trustCheckedValue = tfaTrustFlag == null || "false".equals(tfaTrustFlag) ? "" : "checked";
            userTFAProps.put("ENABLED", false);
            JSONObject tfaProps = TFAHandler.getTFAProps(false, policyId);
            JSONObject tfaProviders = tfaProps.getJSONObject("PROVIDERS");
            JSONArray providerNames = tfaProps.getJSONArray("PROVIDER_NAMES");
            JSONObject userTFAProviders = new JSONObject();
            JSONArray userTFAProviderNames = new JSONArray();
            for (int j = 0; j < providerNames.length(); ++j) {
                String providerName = providerNames.getString(j);
                if (!tfaProviders.getJSONObject(providerName).getBoolean("ENABLED")) continue;
                Long enSecMailMobile = 0L;
                Row usersPersonalRow = null;
                JSONObject secondaryAttributes = null;
                String showPartially = "0";
                String isDefValEnabled = "0";
                if ("VCAuthenticator".equals(providerName)) {
                    secondaryAttributes = SecondaryAttributesHandler.getAttributeDetails(domainName);
                    showPartially = AdvancedPolicyHandler.getRequiredPCValue(policyId, "SHOW_IDENTITY_PARTIALLY", "SSPSecurity");
                    isDefValEnabled = AdvancedPolicyHandler.getRequiredPCValue(policyId, "SHOW_SELECT_MAIL_MOB", "SSPSecurity");
                    JSONObject jsonObj = APCModuleHandler.getModuleFlagValues(policyId, "VERIFICATION_CODE");
                    if (jsonObj.has("ENABLE_SEC_MAIL_MOBILE")) {
                        enSecMailMobile = new Long((String)jsonObj.get("ENABLE_SEC_MAIL_MOBILE"));
                    }
                    Criteria c = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)loginName, 0, false);
                    c = c.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false));
                    DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(new ArrayList<String>(Arrays.asList("AaaLogin", "ADMPUsersPersonal")), c);
                    if (!obj.isEmpty()) {
                        usersPersonalRow = obj.getRow("ADMPUsersPersonal");
                    }
                }
                tfaProviders.getJSONObject(providerName).put("ENABLED", false);
                JSONObject tfaProviderModes = tfaProviders.getJSONObject(providerName).getJSONObject("MODES");
                JSONArray modeNames = tfaProviders.getJSONObject(providerName).getJSONArray("MODE_NAMES");
                JSONObject userTFAProviderModes = new JSONObject();
                JSONArray userTFAProviderModeNames = new JSONArray();
                Boolean continueCheckingModes = true;
                for (int m = 0; m < modeNames.length() && continueCheckingModes.booleanValue(); ++m) {
                    String modeName = modeNames.getString(m);
                    if (!tfaProviderModes.getJSONObject(modeName).getBoolean("ENABLED")) continue;
                    JSONObject tfaProviderModeParams = tfaProviderModes.getJSONObject(modeName).getJSONObject("PARAMS");
                    JSONArray tfaProviderModeParamNames = tfaProviderModes.getJSONObject(modeName).getJSONArray("PARAM_NAMES");
                    JSONObject userTFAProviderModeParams = new JSONObject();
                    JSONArray userTFAProviderModeParamNames = new JSONArray();
                    tfaProviderModes.getJSONObject(modeName).put("IS_VERIFY_MODE", false);
                    if (tfaProviderModeParams.length() == 0) {
                        tfaProviderModes.getJSONObject(modeName).put("IS_VERIFY_MODE", true);
                    }
                    Boolean continueCheckingParams = true;
                    for (int p = 0; p < tfaProviderModeParamNames.length() && continueCheckingParams.booleanValue(); ++p) {
                        String paramName = tfaProviderModeParamNames.getString(p);
                        if ("VCAuthenticator".equals(providerName) && paramName.equals("AD_ATTRIBUTES")) {
                            Properties attrProps;
                            String paramValue = tfaProviderModeParams.getJSONObject(paramName).getString("PARAM_VALUE");
                            ArrayList<String> attrList = new ArrayList<String>();
                            String usersPersonalColName = "EMAIL_ADDRESSES";
                            String keyName = "mail";
                            if ("SMS_VERIFICATION_CODE".equals(modeName)) {
                                usersPersonalColName = "MOBILE_NUMBERS";
                                keyName = "mobile";
                            }
                            if (secondaryAttributes != null && secondaryAttributes.has(keyName)) {
                                JSONArray attrArr = secondaryAttributes.getJSONArray(keyName);
                                for (int i = 0; i < attrArr.length(); ++i) {
                                    String attrName;
                                    String isEnabled = attrArr.getJSONObject(i).getString("IS_ENABLED");
                                    if (!"true".equalsIgnoreCase(isEnabled) || attrList.contains((attrName = attrArr.getJSONObject(i).getString("ATTRIBUTE_NAME")).trim())) continue;
                                    attrList.add(attrName.trim());
                                }
                            }
                            if (!(attrProps = UserUtil.getObjValList(loginName, DomainHandler.getConfiguredValues(domainName, new Long(1L)), attrList)).isEmpty() || usersPersonalRow != null && usersPersonalRow.get(usersPersonalColName) != null) {
                                ArrayList<String> valList = new ArrayList<String>();
                                ArrayList tempList = new ArrayList();
                                for (int i = 0; i < attrList.size() && !attrProps.isEmpty(); ++i) {
                                    if (attrProps.get(attrList.get(i)) == null) continue;
                                    tempList.addAll((ArrayList)attrProps.get(attrList.get(i)));
                                }
                                if ((enSecMailMobile == 1L || tempList.isEmpty()) && usersPersonalRow != null && usersPersonalRow.get(usersPersonalColName) != null) {
                                    String[] dBValArr = ((String)usersPersonalRow.get(usersPersonalColName)).split(",");
                                    for (int i = 0; i < dBValArr.length && !"".equals(dBValArr[i].trim()); ++i) {
                                        valList.add(dBValArr[i].trim());
                                    }
                                }
                                valList.addAll(tempList);
                                if (valList.size() > 0) {
                                    int mailMobIndex = "1".equals(isDefValEnabled) ? 1 : 0;
                                    String clientKey = "EMAIL_VERIFICATION_CODE".equals(modeName) ? "adssp.reset_unlock.accounts.ver_code.select_mail" : "adssp.reset_unlock.accounts.ver_code.select_mob";
                                    JSONObject valJson = new JSONObject();
                                    for (int i = 0; i < valList.size(); ++i) {
                                        String val = (String)valList.get(i);
                                        JSONObject json = new JSONObject();
                                        if (val == null || val.equals("") || "EMAIL_VERIFICATION_CODE".equals(modeName) && !StrUtil.isValidEmailID(val)) continue;
                                        json.put("SERVER_VALUE", (Object)val);
                                        json.put("CLIENT_VALUE", (Object)("1".equals(showPartially) ? ("EMAIL_VERIFICATION_CODE".equals(modeName) ? StrUtil.getPartialMailID(val) : StrUtil.getPartialMobNo(val)) : val));
                                        valJson.put(Integer.toString(mailMobIndex++), (Object)json);
                                    }
                                    if (valJson.length() > 0) {
                                        if ("1".equals(isDefValEnabled)) {
                                            JSONObject init = new JSONObject();
                                            init.put("SERVER_VALUE", (Object)"-1");
                                            init.put("CLIENT_VALUE", (Object)rb.getString(clientKey));
                                            valJson.put(Integer.toString(0), (Object)init);
                                        }
                                        tfaProviderModeParams.getJSONObject(paramName).put("PARAM_DISPLAY_VALUE", (Object)valJson);
                                    }
                                }
                            }
                            if (!tfaProviderModeParams.getJSONObject(paramName).has("PARAM_DISPLAY_VALUE")) {
                                tfaProviderModes.getJSONObject(modeName).put("ENABLED", false);
                                continue;
                            }
                        }
                        userTFAProviderModeParams.put(paramName, (Object)tfaProviderModeParams.getJSONObject(paramName));
                        userTFAProviderModeParamNames.put((Object)paramName);
                    }
                    if ("DuoWebAuthenticator".equals(providerName)) {
                        JSONObject aKeyJSON = new JSONObject();
                        String pName = "A_KEY";
                        aKeyJSON.put("PARAM_NAME", (Object)pName);
                        aKeyJSON.put("PARAM_VALUE", (Object)StrUtil.generateUniqueCode(40, ResourceBundleMgr.getInstance().getBundle()));
                        userTFAProviderModeParams.put(pName, (Object)aKeyJSON);
                        userTFAProviderModeParamNames.put((Object)pName);
                    }
                    tfaProviderModes.getJSONObject(modeName).put("PARAMS", (Object)userTFAProviderModeParams);
                    tfaProviderModes.getJSONObject(modeName).put("PARAM_NAMES", (Object)userTFAProviderModeParamNames);
                    if (isStrictModeDisabled.booleanValue() && (!isStrictModeDisabled.booleanValue() || !tfaProviderModes.getJSONObject(modeName).getBoolean("ENABLED"))) continue;
                    userTFAProviderModes.put(modeName, (Object)tfaProviderModes.getJSONObject(modeName));
                    userTFAProviderModeNames.put((Object)modeName);
                    tfaProviders.getJSONObject(providerName).put("ENABLED", tfaProviders.getJSONObject(providerName).getBoolean("ENABLED") || tfaProviderModes.getJSONObject(modeName).getBoolean("ENABLED"));
                }
                tfaProviders.getJSONObject(providerName).put("MODES", (Object)userTFAProviderModes);
                tfaProviders.getJSONObject(providerName).put("MODE_NAMES", (Object)userTFAProviderModeNames);
                tfaProviders.getJSONObject(providerName).put("TRUST", (Object)trustCheckedValue);
                if (isStrictModeDisabled.booleanValue() && (!isStrictModeDisabled.booleanValue() || !tfaProviders.getJSONObject(providerName).getBoolean("ENABLED") || userTFAProviderModes.length() <= 0)) continue;
                userTFAProviders.put(providerName, (Object)tfaProviders.getJSONObject(providerName));
                userTFAProviderNames.put((Object)providerName);
            }
            if (userTFAProviders.length() > 0) {
                userTFAProps.put("PROVIDERS", (Object)userTFAProviders);
                userTFAProps.put("PROVIDER_NAMES", (Object)userTFAProviderNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (userTFAProps.has("PROVIDERS") && userTFAProps.getJSONObject("PROVIDERS").length() > 0) {
                    userTFAProps.put("ENABLED", true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return userTFAProps;
    }

    public static int getTFACookieValidity() {
        int days = 180;
        try {
            String daysString = ADSMPersUtil.getSyMParameter(TFA_COOKIE_VALIDITY);
            days = Integer.parseInt(daysString);
        }
        catch (NumberFormatException nfe) {
            ADSMPersUtil.updateSyMParameter(TFA_COOKIE_VALIDITY, "180");
        }
        return days;
    }

    public static String getModeConfigurationStatus(String modeName) {
        String configStatus = "";
        try {
            if ("RSA".equalsIgnoreCase(modeName)) {
                if (!new File(System.getProperty("server.home") + File.separator + "bin" + File.separator + "sdconf.rec").exists()) {
                    configStatus = "adssp_login_tfa_rsa_not_configured_copy_config_file";
                }
            } else if ("EMAIL_VERIFICATION_CODE".equalsIgnoreCase(modeName)) {
                Properties mailProp = ADSMPersUtil.getMailServerSettings();
                String mailServer = (String)mailProp.get("MAIL_SERVER");
                if ("".equals(mailServer)) {
                    configStatus = "adssp_login_tfa_alert_confiure_mail_server";
                }
            } else if ("SMS_VERIFICATION_CODE".equalsIgnoreCase(modeName)) {
                JSONObject smsProp = ServerUtil.getSMSSettings();
                String smsProvider = "";
                if (!smsProp.isNull("SELECTED_PROVIDER")) {
                    smsProvider = smsProp.getString("SELECTED_PROVIDER");
                }
                if ("".equals(smsProvider)) {
                    configStatus = "adssp_login_tfa_alert_confiure_sms_server";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidRadiusServer(String radiusServer, String port, String radiusSecret, String protocal, String timeout) throws Exception {
        boolean result;
        block5: {
            result = false;
            int intResult = 0;
            String tempUserName = "tespADSSP";
            String tempPassword = System.currentTimeMillis() + "pass";
            try {
                Properties serverProps = new Properties();
                serverProps.setProperty("SERVERNAME", radiusServer);
                serverProps.setProperty("PORT", port);
                serverProps.setProperty("SERVERSECRET", radiusSecret);
                serverProps.setProperty("RETRIES", "2");
                serverProps.setProperty("PROTOCOL", protocal);
                serverProps.setProperty("TIMEOUT", timeout);
                intResult = RADIUSAuthenticator.radiusAuthenticate(tempUserName, tempPassword, serverProps);
                result = intResult >= 0;
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
            finally {
                if (intResult != -3) break block5;
                throw new Exception("adssp.login.radius.error.unknown_host");
            }
        }
        return result;
    }

    public static boolean isValidDuoWebKey(String ikey, String skey, String apiHostName) throws Exception {
        String akey = StrUtil.generateUniqueCode(40, ResourceBundleMgr.getInstance().getBundle());
        TFAHandler.getDuoWebSignedRequest(ikey, skey, akey, "abcd", "abcd");
        boolean result = false;
        int responseCode = 0;
        try {
            String inputLine;
            String uri = "/auth/v2/check";
            String url = "https://" + apiHostName + uri;
            URL obj = new URL(url);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Host", apiHostName);
            SimpleDateFormat RFC_2822_DATE_FORMAT = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
            String date = RFC_2822_DATE_FORMAT.format(new Date());
            con.setRequestProperty("Date", date);
            String canonRequest = date + "\nGET\n" + apiHostName.toLowerCase() + "\n" + uri + "\n";
            String sig = TFAHandler.signHMAC(skey, canonRequest);
            String auth = ikey + ":" + sig;
            String header = "Basic " + Base64.encodeBytes((byte[])auth.getBytes());
            con.setRequestProperty("Authorization", header);
            con.setRequestProperty("Content-Length", "35");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            responseCode = con.getResponseCode();
            if (responseCode == 0) {
                result = true;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (ConnectException ce) {
            ce.printStackTrace();
            throw new Exception("adssp.login.tfa.duoweb_connection_timed_out");
        }
        catch (UnknownHostException ue) {
            ue.printStackTrace();
            throw new Exception("adssp.login.tfa.duoweb_unknown_host_exception");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (responseCode == 401) {
                throw new Exception("adssp.login.tfa.duoweb_invalid_key");
            }
            throw e;
        }
        return result;
    }

    public static String getDuoWebSignedRequest(String ikey, String skey, String akey, String loginName, String domainName) throws Exception {
        String signRequest;
        String signErr = "";
        String domainDNSName = domainName;
        if (!"abcd".equals(domainDNSName)) {
            DomainUtil.getDomainData(domainName, "DOMAIN_DNS_NAME");
        }
        if ("ERR|The username passed to sign_request() is invalid.".equals(signRequest = DuoWeb.signRequest((String)ikey, (String)skey, (String)akey, (String)(domainDNSName + "\\" + loginName)))) {
            signErr = TFA_DUOWEB_ERR_USER;
        } else if ("ERR|The Duo integration key passed to sign_request() is invalid.".equals(signRequest)) {
            signErr = TFA_DUOWEB_ERR_IKEY;
        } else if ("ERR|The Duo secret key passed to sign_request() is invalid.".equals(signRequest)) {
            signErr = TFA_DUOWEB_ERR_SKEY;
        } else if ("ERR|The application secret key passed to sign_request() must be at least 40 characters.".equals(signRequest)) {
            signErr = TFA_DUOWEB_ERR_AKEY;
        } else if ("ERR|An unknown error has occurred.".equals(signRequest)) {
            signErr = TFA_DUOWEB_ERR_UNKNOWN;
        }
        if (!"".equals(signErr)) {
            throw new Exception(signErr);
        }
        return signRequest;
    }

    public static String signHMAC(String skey, String msg) {
        try {
            byte[] sig_bytes = TFAHandler.hmacSha1(skey.getBytes(), msg.getBytes());
            String sig = TFAHandler.bytes_to_hex(sig_bytes);
            return sig;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] hmacSha1(byte[] key_bytes, byte[] text_bytes) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmacSha1;
        try {
            hmacSha1 = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            hmacSha1 = Mac.getInstance("HMAC-SHA-1");
        }
        SecretKeySpec macKey = new SecretKeySpec(key_bytes, "RAW");
        hmacSha1.init(macKey);
        return hmacSha1.doFinal(text_bytes);
    }

    public static String bytes_to_hex(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static Cookie createADSSPTFACookie(HttpServletRequest request, String loginName, String domainName) {
        try {
            String authRule = request.getParameter("AUTHRULE_NAME");
            JSONObject tfaProviderProps = ((JSONObject)request.getSession().getAttribute("AUTH_STATUS")).getJSONObject(authRule);
            Long modeId = 0L;
            if (tfaProviderProps.has("SELECTED_MODE")) {
                modeId = tfaProviderProps.getLong("SELECTED_MODE");
            } else {
                String modeName = tfaProviderProps.getJSONArray("MODE_NAMES").getString(0);
                modeId = tfaProviderProps.getJSONObject("MODES").getJSONObject(modeName).getLong("MODE_ID");
            }
            String ip = request.getRemoteAddr();
            String userAgent = request.getHeader("user-agent");
            Long time = System.currentTimeMillis();
            Criteria crit = new Criteria(Column.getColumn((String)TFATRUST_TABLE, (String)"LOGIN_NAME"), (Object)loginName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)TFATRUST_TABLE, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)TFATRUST_TABLE, (String)"IP"), (Object)ip, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)TFATRUST_TABLE, (String)"USER_AGENT"), (Object)userAgent, 0));
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row(TFATRUST_TABLE);
            r.set("MODE_ID", (Object)modeId);
            r.set("LOGIN_NAME", (Object)loginName);
            r.set("DOMAIN_NAME", (Object)domainName);
            r.set("IP", (Object)ip);
            r.set("USER_AGENT", (Object)userAgent);
            r.set("TIME", (Object)time);
            obj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
            JSONObject cookieParams = new JSONObject();
            cookieParams.put("MODE_ID", (Object)modeId);
            cookieParams.put("LOGIN_NAME", (Object)loginName);
            cookieParams.put("DOMAIN_NAME", (Object)domainName);
            cookieParams.put("IP", (Object)ip);
            cookieParams.put("USER_AGENT", (Object)userAgent);
            Cookie cookie = new Cookie("ADSSPTFA", AuthUtil.getEncryptedPassword((String)cookieParams.toString(), (String)String.valueOf(time), (String)"MD5"));
            cookie.setPath("/");
            if (request.isSecure()) {
                cookie.setSecure(true);
            }
            cookie.setMaxAge(86400 * TFAHandler.getTFACookieValidity());
            return cookie;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean isValidCookiePresent(HttpServletRequest request, String loginName, String domainName, Long policyId) {
        try {
            String tfaCookie = UserUtil.getCookieValue(request, "ADSSPTFA");
            if (tfaCookie != null && !tfaCookie.equals("")) {
                String ip = request.getRemoteAddr();
                String userAgent = request.getHeader("user-agent");
                Criteria crit = new Criteria(Column.getColumn((String)TFATRUST_TABLE, (String)"LOGIN_NAME"), (Object)loginName, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)TFATRUST_TABLE, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                crit = crit.and(new Criteria(Column.getColumn((String)TFATRUST_TABLE, (String)"IP"), (Object)ip, 0));
                crit = crit.and(new Criteria(Column.getColumn((String)TFATRUST_TABLE, (String)"USER_AGENT"), (Object)userAgent, 0));
                DataObject trustDO = CommonUtil.getPersistence(new boolean[0]).get(TFATRUST_TABLE, crit);
                if (!trustDO.isEmpty()) {
                    Row r = trustDO.getRow(TFATRUST_TABLE);
                    String time = String.valueOf(r.get("TIME"));
                    Criteria criteria = new Criteria(Column.getColumn((String)TFAMODEVSPOLICY_TABLE, (String)"ENABLED"), (Object)true, 0);
                    criteria = criteria.and(new Criteria(Column.getColumn((String)TFAMODEVSPOLICY_TABLE, (String)"POLICY_ID"), (Object)policyId, 0));
                    DataObject providerModesDO = CommonUtil.getPersistence(new boolean[0]).get(TFAMODEVSPOLICY_TABLE, criteria);
                    if (!providerModesDO.isEmpty()) {
                        Iterator it = providerModesDO.getRows(TFAMODEVSPOLICY_TABLE);
                        while (it.hasNext()) {
                            Row providerModeRow = (Row)it.next();
                            JSONObject cookieParams = new JSONObject();
                            cookieParams.put("MODE_ID", (Object)((Long)providerModeRow.get("MODE_ID")));
                            cookieParams.put("LOGIN_NAME", (Object)loginName);
                            cookieParams.put("DOMAIN_NAME", (Object)domainName);
                            cookieParams.put("IP", (Object)ip);
                            cookieParams.put("USER_AGENT", (Object)userAgent);
                            if (!tfaCookie.equals(AuthUtil.getEncryptedPassword((String)cookieParams.toString(), (String)time, (String)"MD5"))) continue;
                            return true;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static JSONObject generateAKEYforDuo() {
        JSONObject aKeyJSON = new JSONObject();
        try {
            String pName = "A_KEY";
            aKeyJSON.put("PARAM_NAME", (Object)pName);
            aKeyJSON.put("PARAM_VALUE", (Object)StrUtil.generateUniqueCode(40, ResourceBundleMgr.getInstance().getBundle()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aKeyJSON;
    }

    private static String getRadiusUserName(HttpServletRequest request, JSONObject response) {
        try {
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("LoginBean");
            String loginName = (String)bean.get("USERNAME");
            String domainName = (String)bean.get("DOMAIN_NAME");
            String radiusUserName = loginName;
            JSONObject tfaProviderProps = response.getJSONObject("MFA_AUTH_STATUS").getJSONObject("RADIUSAuthenticator");
            JSONArray tfaProviderModesNames = tfaProviderProps.getJSONArray("MODE_NAMES");
            String modeName = tfaProviderModesNames.getString(0);
            JSONObject tfaProviderMode = tfaProviderProps.getJSONObject("MODES").getJSONObject(modeName);
            JSONObject tfaProviderModeParams = tfaProviderMode.getJSONObject("PARAMS");
            String radiusUserPattern = tfaProviderModeParams.getJSONObject("RADIUS_USER_NAME").getString("PARAM_VALUE");
            if (radiusUserPattern.toLowerCase().indexOf("domainDNSName%".toLowerCase()) != -1) {
                domainName = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "DOMAIN_DNS_NAME");
                radiusUserName = radiusUserPattern.indexOf("%domainDNSName%") != -1 ? radiusUserPattern.replace("%domainDNSName%", domainName.toLowerCase()) : radiusUserPattern.replace("%capsDomainDNSName%", domainName.toUpperCase());
            } else if (radiusUserPattern.toLowerCase().indexOf("domainFlatName%".toLowerCase()) != -1) {
                domainName = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "DOMAIN_FLAT_NAME");
                radiusUserName = radiusUserPattern.indexOf("%domainFlatName%") != -1 ? radiusUserPattern.replace("%domainFlatName%", domainName.toLowerCase()) : radiusUserPattern.replace("%capsDomainFlatName%", domainName.toUpperCase());
            } else {
                radiusUserName = radiusUserPattern;
            }
            if (radiusUserName.toLowerCase().indexOf("userName%".toLowerCase()) != -1) {
                radiusUserName = radiusUserName.replace("%userName%", loginName.toLowerCase());
                radiusUserName = radiusUserName.replace("%capsUserName%", loginName.toUpperCase());
            }
            radiusUserName = radiusUserName.replace("%\\%", "\\");
            radiusUserName = radiusUserName.replace("%@%", "@");
            radiusUserName = radiusUserName.replace("%%", "");
            session.setAttribute("radiusUserName", (Object)radiusUserName);
            return radiusUserName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setPropsinRequest(HttpServletRequest request, Long policyId, String providerName, String modeName, JSONObject response) {
        try {
            TFAHandler.setPropsinRequest(request, policyId, providerName, modeName);
            HttpSession session = request.getSession();
            response.put("MFA_AUTH_STATUS", (Object)((JSONObject)session.getAttribute("MFA_AUTH_STATUS")));
            if (providerName.equals("RADIUSAuthenticator")) {
                String radiusUserName = TFAHandler.getRadiusUserName(request, response);
                response.getJSONObject("MFA_AUTH_STATUS").getJSONObject("RADIUSAuthenticator").put("RADIUS_USER_NAME", (Object)radiusUserName);
            }
            if (providerName.equals("DuoWebAuthenticator")) {
                String ikey = ((JSONObject)session.getAttribute("MFA_AUTH_STATUS")).getJSONObject("DuoWebAuthenticator").getJSONObject("MODES").getJSONObject("DUOWEB").getJSONObject("PARAMS").getJSONObject("I_KEY").getString("PARAM_VALUE");
                String skey = ((JSONObject)session.getAttribute("MFA_AUTH_STATUS")).getJSONObject("DuoWebAuthenticator").getJSONObject("MODES").getJSONObject("DUOWEB").getJSONObject("PARAMS").getJSONObject("S_KEY").getString("PARAM_VALUE");
                String akey = ((JSONObject)session.getAttribute("MFA_AUTH_STATUS")).getJSONObject("DuoWebAuthenticator").getJSONObject("MODES").getJSONObject("DUOWEB").getJSONObject("PARAMS").getJSONObject("A_KEY").getString("PARAM_VALUE");
                String apiHostName = ((JSONObject)session.getAttribute("MFA_AUTH_STATUS")).getJSONObject("DuoWebAuthenticator").getJSONObject("MODES").getJSONObject("DUOWEB").getJSONObject("PARAMS").getJSONObject("API_HOST_NAME").getString("PARAM_VALUE");
                TFAHandler.isValidDuoWebKey(ikey, skey, apiHostName);
                Long loginId = response.getLong("LOGIN_ID");
                Properties prop = ADAuthHandler.getLoginUserDetails(loginId);
                String loginName = prop.getProperty("LOGIN_NAME");
                String domainName = prop.getProperty("LOGIN_DOMAIN_NAME");
                String signRequest = TFAHandler.getDuoWebSignedRequest(ikey, skey, akey, loginName, domainName);
                response.getJSONObject("MFA_AUTH_STATUS").getJSONObject("DuoWebAuthenticator").put("SIGN_REQUEST", (Object)signRequest);
            }
        }
        catch (Exception e) {
            try {
                if (providerName.equals("DuoWebAuthenticator")) {
                    String signErr = e.getMessage();
                    response.getJSONObject("MFA_AUTH_STATUS").getJSONObject("DuoWebAuthenticator").put("SIGN_ERROR", (Object)signErr);
                }
            }
            catch (Exception e1) {
                e1.getMessage();
            }
            e.printStackTrace();
        }
    }

    public static void setPropsinRequest(HttpServletRequest request, Long policyId, String providerName, String modeName) {
        try {
            JSONObject tfaProviderProps;
            HttpSession session = request.getSession();
            JSONObject authStatus = new JSONObject();
            JSONArray authenticators = new JSONArray();
            JSONObject prevAuthStatus = (JSONObject)session.getAttribute("MFA_AUTH_STATUS");
            JSONObject jSONObject = prevAuthStatus != null ? (prevAuthStatus.has(providerName) ? prevAuthStatus.getJSONObject(providerName) : null) : (tfaProviderProps = null);
            if (tfaProviderProps == null) {
                JSONObject tFAProps = TFAHandler.getTFAProps(false, policyId, providerName);
                JSONObject tfaProviders = tFAProps.getJSONObject("PROVIDERS");
                JSONObject providerProps = tfaProviders.getJSONObject(providerName);
                providerProps.put("AUTH_STATE", 1);
                JSONObject modeProps = providerProps.getJSONObject("MODES").getJSONObject(modeName);
                if ("DuoWebAuthenticator".equals(providerName)) {
                    JSONObject aKeyJSON = TFAHandler.generateAKEYforDuo();
                    modeProps.getJSONObject("PARAMS").put((String)aKeyJSON.get("PARAM_NAME"), (Object)aKeyJSON);
                    modeProps.getJSONArray("PARAM_NAMES").put((Object)((String)aKeyJSON.get("PARAM_NAME")));
                }
                providerProps.getJSONObject("MODES").put(modeName, (Object)modeProps);
                authStatus.put(providerName, (Object)providerProps);
                authenticators.put((Object)providerName);
                authStatus.put("AUTHENTICATORS", (Object)authenticators);
                session.setAttribute("MFA_AUTH_STATUS", (Object)authStatus);
            } else {
                session.setAttribute("MFA_AUTH_STATUS", (Object)prevAuthStatus);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Boolean isTFAExcludedForSAML(Long policyId) {
        if (AdvancedPolicyHandler.getRequiredPCValue(policyId, EXCLUDE_TFA_FOR_SAML, "SSPSecurity").equals("1")) {
            return true;
        }
        return false;
    }

    public static Boolean isLoginTFAEnabled() {
        try {
            Criteria c = new Criteria(Column.getColumn((String)TFAMODEVSPOLICY_TABLE, (String)"ENABLED"), (Object)true, 0);
            int count = 0;
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(TFAMODEVSPOLICY_TABLE, c);
            count = dataobject.size(TFAMODEVSPOLICY_TABLE);
            if (count > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

