/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.tfa;

import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.authentication.Authenticator;
import com.adventnet.sym.adsm.common.server.configuration.IdentityVerifyHandler;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.sms.SMSAction;
import com.adventnet.sym.adsm.common.server.util.FormatUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.json.JSONArray;
import org.json.JSONObject;

public class VCAuthenticator
extends Authenticator {
    public boolean authenticate() throws LoginException {
        String messageType = "success";
        try {
            Properties auditProps;
            if (this.authStatus == null || this.authStatus != null && !this.authStatus.has(this.authRule)) {
                this.needAudit = false;
                return false;
            }
            JSONObject tfaProviderProps = this.authStatus.getJSONObject(this.authRule);
            Boolean isVerifyMode = tfaProviderProps.has("IS_VERIFY_MODE") ? tfaProviderProps.getBoolean("IS_VERIFY_MODE") : false;
            Long providerId = tfaProviderProps.getLong("PROVIDER_ID");
            String providerName = tfaProviderProps.getString("PROVIDER_NAME");
            String confirmationCode = this.request.getParameter("passCode");
            if (isVerifyMode.booleanValue() && confirmationCode != null && !confirmationCode.equals("")) {
                String verificationCode = tfaProviderProps.getString("VERIFICATION_CODE");
                Boolean isValidCode = verificationCode.equals(confirmationCode);
                if (!isValidCode.booleanValue()) {
                    messageType = "error";
                    throw new LoginException("adssp.login.tfa.invalid_verification_code");
                }
                return isValidCode;
            }
            JSONObject tfaProviderModes = tfaProviderProps.getJSONObject("MODES");
            JSONArray modeNames = tfaProviderProps.getJSONArray("MODE_NAMES");
            String modeName = modeNames.getString(0);
            Long modeId = tfaProviderModes.getJSONObject(modeName).getLong("MODE_ID");
            JSONObject tfaProviderModeParams = tfaProviderModes.getJSONObject(modeName).getJSONObject("PARAMS");
            if (tfaProviderModes.length() > 1) {
                modeId = Long.parseLong(this.request.getParameter(tfaProviderProps.getString("PROVIDER_ID") + "_MODE"));
                for (int m = 0; m < modeNames.length(); ++m) {
                    String mName = modeNames.getString(m);
                    if (tfaProviderModes.getJSONObject(mName).getLong("MODE_ID") != modeId.longValue()) continue;
                    modeName = mName;
                    tfaProviderModeParams = tfaProviderModes.getJSONObject(mName).getJSONObject("PARAMS");
                    break;
                }
            }
            tfaProviderProps.put("SELECTED_MODE", (Object)modeId);
            String msg = tfaProviderModeParams.getJSONObject("MESSAGE").getString("PARAM_VALUE");
            String address = tfaProviderModeParams.getJSONObject("AD_ATTRIBUTES").getJSONObject("PARAM_DISPLAY_VALUE").getJSONObject(this.request.getParameter(modeId + "_AD_ATTRIBUTES")).getString("SERVER_VALUE");
            String sendVia = "EMAIL_VERIFICATION_CODE".equals(modeName) ? "MAIL" : "SMS";
            int verificationCodeLength = IdentityVerifyHandler.getVerificationCodeLength();
            String confirmCode = IdentityVerifyHandler.generateVerificationCode(this.request);
            Hashtable<String, String> keyPairValue = new Hashtable<String, String>();
            keyPairValue.put("confirmCode", confirmCode);
            keyPairValue.put("sAMAccountName", this.loginName);
            keyPairValue.put("userName", this.loginName);
            msg = FormatUtil.getNameFormats(this.domainName, msg, this.loginName, "sAMAccountName", keyPairValue);
            Properties userProps = UserUtil.getUserObjectDetails(this.loginName, this.domainName, new String[]{"objectGUID"});
            String objGUID = userProps.getProperty("objectGUID", "");
            String status = "adssp.common.text.success";
            Properties mailConfig = ADSMPersUtil.getMailServerSettings();
            if (sendVia.equals("MAIL")) {
                String sub = tfaProviderModeParams.getJSONObject("SUBJECT").getString("PARAM_VALUE");
                sub = FormatUtil.getNameFormats(this.domainName, sub, this.loginName, "sAMAccountName", keyPairValue);
                auditProps = new Hashtable();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("MAIL_IDS", new String[]{address});
                map.put("MAIL_SERVER", (String)mailConfig.get("MAIL_SERVER"));
                map.put("FROM_ADDRESS", (String)mailConfig.get("FROM_ADDRESS"));
                map.put("MAIL_SUBJECT", sub);
                map.put("MAIL_CONTENT", msg);
                map.put("SMTP_PORT", (String)mailConfig.get("SMTP_PORT"));
                map.put("MAIL_SERVER_USER", (String)mailConfig.get("MAIL_SERVER_USER"));
                map.put("MAIL_SERVER_PWD", (String)mailConfig.get("MAIL_SERVER_PWD"));
                map.put("DOMAIN_NAME", this.domainName);
                map.put("OBJECT_GUID", objGUID);
                map.put("NAME", this.loginName);
                map.put("MAIL_SENT_TIME", System.currentTimeMillis());
                map.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
                map.put("ACTION_NAME", "adssp.reports.audit_report.notification_delivery_report.vc_login");
                status = SendMailAPI.getInstance().sendMail(map, auditProps, mailConfig);
                status = status.equals("adssp.common.text.mail_sent_success") ? "adssp.common.text.success" : "adssp.reset_unlock.accounts.status.unable_send_code";
                AuditAPI.getInstance();
                AuditAPI.addAuditLogs(auditProps);
            } else if (sendVia.equals("SMS")) {
                status = SMSAction.sendSMS(address, msg, true);
                status = status.equals("adssp.common.text.smssent") ? "adssp.common.text.success" : "adssp.reset_unlock.accounts.status.unable_send_code";
                Hashtable<String, Properties> auditLogs = new Hashtable<String, Properties>();
                auditProps = new Properties();
                auditProps.put("ACTION_NAME", "adssp.reports.audit_report.notification_delivery_report.vc_login");
                auditProps.put("DOMAIN_NAME", this.domainName);
                auditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.sms");
                auditProps.put("MAIL_SENT_TIME", (Object)System.currentTimeMillis());
                auditProps.put("STATUS", status);
                auditProps.put("NAME", this.loginName);
                auditLogs.put(objGUID, auditProps);
                AuditAPI.getInstance();
                AuditAPI.addAuditLogs(auditLogs);
            }
            if (!status.equalsIgnoreCase("adssp.common.text.success")) {
                messageType = "error";
                throw new LoginException(status);
            }
            tfaProviderProps.put("VERIFICATION_CODE", (Object)confirmCode);
            tfaProviderProps.put("IS_VERIFY_MODE", true);
            JSONObject passCodePolicy = new JSONObject();
            passCodePolicy.put("MIN_LEN", verificationCodeLength);
            passCodePolicy.put("MAX_LEN", verificationCodeLength);
            Boolean isAlphanumeric = false;
            try {
                Long l = Long.parseLong(confirmCode);
                isAlphanumeric = false;
            }
            catch (NumberFormatException nfe) {
                isAlphanumeric = true;
            }
            passCodePolicy.put("IS_ALPHA_NUMERIC", (Object)isAlphanumeric);
            tfaProviderProps.put("PASS_CODE_POLICY", (Object)passCodePolicy);
            this.authStatus.put(this.authRule, (Object)tfaProviderProps);
            this.needAudit = false;
            throw new Exception("TWO_FACTOR");
        }
        catch (Exception le) {
            if (this.authStatus != null) {
                try {
                    this.authStatus.put("AUTH_STATE", 2);
                    if (this.authStatus.has(this.authRule)) {
                        this.authStatus.getJSONObject(this.authRule).put("AUTH_STATE", 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!"TWO_FACTOR".equals(le.getMessage())) {
                this.request.setAttribute("message", (Object)le.getMessage());
                this.request.setAttribute("messageType", (Object)messageType);
                int status = 0;
                if ("success".equalsIgnoreCase(messageType)) {
                    status = 1;
                }
                this.errMsg = le.getMessage();
                if (this.session.getAttribute("isWinLogTFA") != null) {
                    this.auditType = "adssp.reports.audit_report.user_attempts.type_windows_login_text";
                }
                AuditAPI.getInstance().addUserAttemptsAuditLog(this.request, this.loginName, this.domainName, this.auditType, this.errMsg, status);
            }
            this.needAudit = false;
            throw new LoginException("TWO_FACTOR");
        }
    }
}

