/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.usermanagement;

import com.adventnet.sym.adsm.common.server.NativeError;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class AddUserErrorHandler {
    private static String USER_CREATION_TABLE = "ADSMAUUserCreation";
    private static String USER_CREATION_ID = "USER_CREATION_ID";

    public static Properties getSingleUserErrorMessage(String domainName, String userName, String samAccountName, String containerName, ArrayList groupList, NativeError errHdlr, String statusMessage) {
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList<Object> errorList = new ArrayList();
        String errorSeverity = null;
        if (!errHdlr.getErrorMessage(domainName).isEmpty()) {
            errorList = errHdlr.getErrorList(domainName);
            errorSeverity = errHdlr.getSeverityLevel(domainName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (!errHdlr.getErrorMessage(containerName).isEmpty()) {
            errorList = errHdlr.getErrorList(containerName);
            errorSeverity = errHdlr.getSeverityLevel(containerName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (!errHdlr.getErrorMessage(userName).isEmpty()) {
            errorList = errHdlr.getErrorList(userName);
            errorSeverity = errHdlr.getSeverityLevel(userName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        if (!userName.equals(samAccountName) && !errHdlr.getErrorMessage(samAccountName).isEmpty()) {
            errorList = errHdlr.getErrorList(samAccountName);
            errorSeverity = errHdlr.getSeverityLevel(samAccountName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        for (Object e : groupList) {
            if (errHdlr.getErrorMessage(e).isEmpty()) continue;
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
            errorList = errHdlr.getErrorList(e);
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    public static void setSingleUserHFError(String domainName, Properties statusProps, NativeError errHdlr, String type) {
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList<Object> errorList = new ArrayList();
        if (!errHdlr.getErrorMessage(domainName).isEmpty()) {
            messageList = (ArrayList<Hashtable>)statusProps.get("CREATION_MESSAGE");
            if (messageList == null) {
                messageList = new ArrayList<Hashtable>();
            }
            errorList = errHdlr.getErrorList(domainName);
            for (Hashtable hashtable : errorList) {
                String message = (String)hashtable.get("ERROR_MESSAGE");
                StringBuilder strBuilder = new StringBuilder();
                if (type.equalsIgnoreCase("mailBoxRights")) {
                    strBuilder.append("adssp.error.java.single_user_mailbox_rights");
                } else if (type.equalsIgnoreCase("homeDir")) {
                    strBuilder.append("adssp.error.java.single_user_homedir");
                } else if (type.equalsIgnoreCase("homeDirShare")) {
                    strBuilder.append("adssp.error.java.single_user_homedir_share");
                } else if (type.equalsIgnoreCase("tsHomeDir")) {
                    strBuilder.append("adssp.error.java.single_user_tshomedir");
                } else if (type.equalsIgnoreCase("tsHomeDirShare")) {
                    strBuilder.append("adssp.error.java.single_user_tshomedir_share");
                } else if (type.equalsIgnoreCase("profilePath")) {
                    strBuilder.append("adssp.error.java.single_user_profilepath");
                } else if (type.equalsIgnoreCase("tsProfilePath")) {
                    strBuilder.append("adssp.error.java.single_user_tsprofilepath");
                }
                strBuilder.append("||");
                strBuilder.append(message);
                hashtable.put("ERROR_MESSAGE", message);
                messageList.add(hashtable);
            }
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        }
    }

    public static void setSingleUserCustomAttributesError(Properties statusProps, NativeError errHdlr, String searchString) {
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList<Object> errorList = new ArrayList();
        if (!errHdlr.getErrorMessage(searchString).isEmpty()) {
            messageList = (ArrayList<Hashtable>)statusProps.get("CREATION_MESSAGE");
            if (messageList == null) {
                messageList = new ArrayList<Hashtable>();
            }
            errorList = errHdlr.getErrorList(searchString);
            for (Hashtable hashtable : errorList) {
                String message = (String)hashtable.get("ERROR_MESSAGE");
                message = "Setting Values for Custom Attributes : " + message;
                hashtable.put("ERROR_MESSAGE", message);
                messageList.add(hashtable);
            }
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        }
    }
}

