/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class AddUserHandler {
    private static AddUserHandler handler = null;
    protected ArrayList<Hashtable> attributeDetailsMap = this.getAttributeDetailsFromDB();
    protected static String ATTRIB_TABLE = "ADSMAttributeDetails";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AddUserHandler getInstance() {
        if (handler != null) return handler;
        Class<AddUserHandler> clazz = AddUserHandler.class;
        synchronized (AddUserHandler.class) {
            handler = new AddUserHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    protected AddUserHandler() {
    }

    public ArrayList<Hashtable> getAttributeList() {
        return this.attributeDetailsMap;
    }

    public ArrayList<Hashtable> getAttributeDetailsFromDB() {
        ArrayList<Hashtable> arrayList = new ArrayList<Hashtable>();
        try {
            Criteria criteria = new Criteria(new Column(ATTRIB_TABLE, "ATTRIB_ID"), (Object)2000, 7);
            criteria = criteria.and(new Criteria(new Column(ATTRIB_TABLE, "AU_TABLE_NAME"), null, 1));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(ATTRIB_TABLE, criteria);
            Iterator iterator = dataObject.getRows(ATTRIB_TABLE);
            while (iterator.hasNext()) {
                Hashtable<String, Object> attributesdetailsTable = new Hashtable<String, Object>();
                Row row = (Row)iterator.next();
                for (String string : UserMgmtUtil.attributeProp) {
                    Object object = row.get(string);
                    if (object == null) continue;
                    attributesdetailsTable.put(string, object);
                }
                arrayList.add(attributesdetailsTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    public Hashtable getAttributeDetails(Hashtable hash) {
        return this.getAttributeDetailsFromMap(hash);
    }

    public Hashtable getAttributeDetailsFromMap(Hashtable colValHash) {
        for (Hashtable hashtable : this.attributeDetailsMap) {
            boolean isMatched = true;
            Enumeration e = colValHash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = colValHash.get(key).toString();
                if (val.equalsIgnoreCase(hashtable.get(key).toString())) continue;
                isMatched = false;
                break;
            }
            if (!isMatched) continue;
            return (Hashtable)hashtable.clone();
        }
        return new Hashtable();
    }

    public Hashtable getAttributeDetails(String columnName, Object value) {
        return this.getAttributeDetailsFromMap(columnName, value);
    }

    public Hashtable getAttributeDetailsFromMap(String columnName, Object value) {
        String string = value.toString();
        for (Hashtable hashtable : this.attributeDetailsMap) {
            if (!string.equalsIgnoreCase((String)hashtable.get(columnName))) continue;
            return (Hashtable)hashtable.clone();
        }
        return new Hashtable();
    }

    public void resetAttributes() {
        this.attributeDetailsMap = this.getAttributeDetailsFromDB();
    }

    public ArrayList<Hashtable> getAttributeDetailsForActionIds(ArrayList<Long> actionList) {
        ArrayList<Hashtable> attrList = new ArrayList<Hashtable>();
        try {
            for (Long actionId : actionList) {
                Criteria criteria = new Criteria(new Column(ATTRIB_TABLE, "MODIFY_ID"), (Object)actionId, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(ATTRIB_TABLE, criteria);
                Iterator iterator = dataObject.getRows(ATTRIB_TABLE, criteria);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Hashtable<String, Object> attributesdetailsTable = new Hashtable<String, Object>();
                    for (String string : UserMgmtUtil.attributeProp) {
                        Object object = row.get(string);
                        if (object == null) continue;
                        attributesdetailsTable.put(string, object);
                    }
                    attrList.add(attributesdetailsTable);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attrList;
    }
}

