/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserMgmtUtil {
    public static final int ADS_GROUP_TYPE_GLOBAL_GROUP = 2;
    public static final int ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP = 4;
    public static final int ADS_GROUP_TYPE_LOCAL_GROUP = 4;
    public static final int ADS_GROUP_TYPE_UNIVERSAL_GROUP = 8;
    public static final int ADS_GROUP_TYPE_SECURITY_ENABLED = Integer.MIN_VALUE;
    public static final int ADS_UF_SCRIPT = 1;
    public static final int ADS_UF_ACCOUNTDISABLE = 2;
    public static final int ADS_UF_HOMEDIR_REQUIRED = 8;
    public static final int ADS_UF_LOCKOUT = 16;
    public static final int ADS_UF_PASSWD_NOTREQD = 32;
    public static final int ADS_UF_PASSWD_CANT_CHANGE = 64;
    public static final int ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED = 128;
    public static final int ADS_UF_TEMP_DUPLICATE_ACCOUNT = 256;
    public static final int ADS_UF_NORMAL_ACCOUNT = 512;
    public static final int ADS_UF_INTERDOMAIN_TRUST_ACCOUNT = 2048;
    public static final int ADS_UF_WORKSTATION_TRUST_ACCOUNT = 4096;
    public static final int ADS_UF_SERVER_TRUST_ACCOUNT = 8192;
    public static final int ADS_UF_DONT_EXPIRE_PASSWD = 65536;
    public static final int ADS_UF_MNS_LOGON_ACCOUNT = 131072;
    public static final int ADS_UF_SMARTCARD_REQUIRED = 262144;
    public static final int ADS_UF_TRUSTED_FOR_DELEGATION = 524288;
    public static final int ADS_UF_NOT_DELEGATED = 0x100000;
    public static final int ADS_UF_USE_DES_KEY_ONLY = 0x200000;
    public static final int ADS_UF_DONT_REQUIRE_PREAUTH = 0x400000;
    public static final int ADS_UF_PASSWORD_EXPIRED = 0x800000;
    public static final int ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION = 0x1000000;
    public static final String MS_EXCH_POLICIES_EXCLUDED = "{26491CFC-9E50-4857-861B-0CB8DF22B5D7}";
    private static String USER_ATTRIBUTE_TABLE = "ADSMAUNamingAttributes";
    private static Hashtable idVsLdapName = null;
    public static final String ATTRIBUTE_DETAILS = "ADSMAttributeDetails";
    public static final String ATTRIB_MODIFY_ID = "MODIFY_ID";
    public static final String ATTRIB_COL_NAME = "ATTRIB_COLUMN_NAME";
    public static final String COUNTRIES_LIST_TABLE = "ADSMCountriesList";
    public static final String NUMERIC_COUNTRY_CODE = "countryCode";
    public static final String COUNTRY_NAME = "co";
    public static final String TWO_LETTER_COUNTRY_CODE = "c";
    public static final int COUNTRY_CODE_ATTRIB_ID = 1072;
    public static final int COUNRTY_TWO_DIGIT_CODE_ATTRIB_ID = 1071;
    public static final int COUNTRY_ATTRIB_ID = 1055;
    private static String encoding = null;
    private static String special;
    public static String HTTP_ENABLE;
    public static String HTTP_DISABLE;
    public static String IMAP4_ENABLE;
    public static String IMAP4_DISABLE;
    public static String POP3_ENABLE;
    public static String POP3_DISABLE;
    public static final String[] USERNAME_ESCAPE_CHARECTERS;
    public static final String[] DN_ESCAPE_CHARECTERS;
    public static final String[] SAMNAME_SPL_CHARECTERS;
    public static String[] userNamingProp;
    public static String[] securityPropCheckEmpty;
    public static String[] securityPropCheckDefault;
    public static Object[] securityPropDefaultValues;
    public static String[] userContactProp;
    public static String[] terminalPropCheckEmpty;
    public static String[] terminalPropCheckDefault;
    public static Object[] terminalPropDefaultValues;
    public static String[] exchangePropCheckEmpty;
    public static String[] exchangePropCheckDefault;
    public static Object[] exchangePropDefaultValues;
    public static String[] exchangePropNoCheck;
    public static String[] exchangeServerAttributes;
    public static String[] mailEnablePropCheckEmpty;
    public static String[] mailEnablePropCheckDefault;
    public static String[] mailEnablePropNoCheck;
    public static String[] mailEnablePropNoCheckValues;
    public static Object[] mailEnablePropDefaultValues;
    public static String[] multiValuAttribs;
    public static String[] multiValuAttribsTables;
    public static String[][] attribsCheckEmpty;
    public static String[][] attribsCheckDefault;
    public static Object[][] attribsDefaultValues;
    public static String[] drives;
    public static Long[] sessionValues;
    public static String[] sessionLabel;
    public static String[] userListProps;
    public static String[] attributeTableProps;
    public static String[] attributeProp;
    public static String[] attributeNativeProp;
    public static String[] statusProp;
    public static String[] customAttributeProps;
    public static String[] passwordAttribs;
    public static String[] generalProp;
    public static Long[] unMatchAccountColumn;
    public static Long[] unMatchExchangeColumn;
    public static Long[][] unMatchColumn;
    public static ArrayList<String> homeDriveList;
    public static ArrayList<Long> sessionValuesList;
    public static ArrayList<String> sessionLabelList;
    public static String[] groupAttributesArray;
    public static final String[] profCheckboxes;
    public static final String[] hfCheckboxes;
    public static final String[] tsProfCheckboxes;
    public static final String[] tsHfCheckboxes;
    public static final String[][] permsCheckBoxes;
    public static final String[] permTypes;

    public static Long getActionId(String columnName, String mgmtType) {
        Long id = 0L;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)ATTRIBUTE_DETAILS, (String)ATTRIB_COL_NAME), (Object)columnName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)ATTRIBUTE_DETAILS, (String)"ATTRIB_ID"), (Object)new Integer(2000), 7));
            crit = crit.and(new Criteria(Column.getColumn((String)ATTRIBUTE_DETAILS, (String)"ATTRIB_ID"), (Object)new Integer(1500), 5));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(ATTRIBUTE_DETAILS, crit);
            if (!dataObject.isEmpty() && !mgmtType.equalsIgnoreCase("")) {
                Iterator it = dataObject.getRows(ATTRIBUTE_DETAILS);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String column = "";
                    if (mgmtType.equalsIgnoreCase("userCreation") || mgmtType.equalsIgnoreCase("template")) {
                        column = "ACTION_ID";
                    } else if (mgmtType.equalsIgnoreCase("userModify")) {
                        column = ATTRIB_MODIFY_ID;
                    }
                    id = (Long)r.get(column);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static Properties getPropertiesfromRID(String rid, ArrayList groupList) {
        for (Object object : groupList) {
            Properties properties = (Properties)object;
            String objectRID = properties.getProperty("objectSID");
            if (!(objectRID = objectRID.substring(objectRID.lastIndexOf("-") + 1, objectRID.length())).equalsIgnoreCase(rid)) continue;
            Properties properties2 = new Properties();
            properties2.setProperty("Display_Name", properties.getProperty("name"));
            properties2.setProperty("Distinguished_Name", properties.getProperty("distinguishedName"));
            properties2.setProperty("objectRID", objectRID);
            properties2.setProperty("groupType", properties.getProperty("groupType"));
            return properties2;
        }
        return null;
    }

    public static Properties getPropertiesfromDN(String dn, ArrayList groupList) {
        for (Object object : groupList) {
            Properties properties = (Properties)object;
            String dnString = properties.getProperty("distinguishedName");
            String displayName = properties.getProperty("name");
            Properties properties2 = new Properties();
            String objectRID = properties.getProperty("objectSID");
            objectRID = objectRID.substring(objectRID.lastIndexOf("-") + 1, objectRID.length());
            properties2.setProperty("objectRID", objectRID);
            properties2.setProperty("groupType", properties.getProperty("groupType"));
            if (dnString.equalsIgnoreCase(dn)) {
                properties2.setProperty("Display_Name", displayName);
                properties2.setProperty("Distinguished_Name", dn);
                return properties2;
            }
            if (!displayName.equalsIgnoreCase(dn)) continue;
            properties2.setProperty("Display_Name", dn);
            properties2.setProperty("Distinguished_Name", dnString);
            return properties2;
        }
        return null;
    }

    public static String getGroupDNfromRID(String domainName, String groupRID) {
        String groupDN = null;
        String tableName = CommonUtil.getDomainGroupTableName(domainName);
        try {
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)"SID_STRING"), (Object)("*-" + groupRID), 2));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"SID_STRING"));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DN_STRING"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (dataObject != null && !dataObject.isEmpty()) {
                Row row = dataObject.getRow(tableName);
                groupDN = (String)row.get("DN_STRING");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return groupDN;
    }

    public static String getGroupSIDfromRID(String rid, ArrayList groupList) {
        for (Object object : groupList) {
            Properties properties = (Properties)object;
            String objectSID = properties.getProperty("objectSID");
            if (!objectSID.endsWith("-" + rid)) continue;
            return objectSID;
        }
        return null;
    }

    public static String getDisplayName(String domainName, String critCol, String critVal) {
        String displayName = null;
        try {
            String tableName = CommonUtil.getDomainUserTableName(domainName);
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)critCol), (Object)StrUtil.queryEscape(critVal), 0);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DISPLAY_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow(tableName);
                displayName = (String)row.get("DISPLAY_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return displayName;
    }

    public static ArrayList getCountriesList() {
        ArrayList<Properties> coList = new ArrayList<Properties>();
        try {
            Criteria crit = null;
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(COUNTRIES_LIST_TABLE, crit);
            Iterator it = obj.getRows(COUNTRIES_LIST_TABLE);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                p.put(NUMERIC_COUNTRY_CODE, r.get(NUMERIC_COUNTRY_CODE));
                p.put(COUNTRY_NAME, r.get(COUNTRY_NAME));
                p.put(TWO_LETTER_COUNTRY_CODE, r.get(TWO_LETTER_COUNTRY_CODE));
                coList.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return coList;
    }

    public static Integer getAttributeId(String ldapName) {
        Integer id = null;
        try {
            ldapName = ldapName.toLowerCase();
            if (idVsLdapName == null) {
                idVsLdapName = new Hashtable();
                Criteria crit = new Criteria(Column.getColumn((String)ATTRIBUTE_DETAILS, (String)"ATTRIB_ID"), (Object)new Integer(2000), 7);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(ATTRIBUTE_DETAILS, crit);
                Iterator it = obj.getRows(ATTRIBUTE_DETAILS);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String ldap = ((String)r.get("ATTRIB_LDAP_NAME")).toLowerCase();
                    Integer d = (Integer)r.get("ATTRIB_ID");
                    idVsLdapName.put(ldap, d);
                }
            }
            id = (Integer)idVsLdapName.get(ldapName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static String getMOBDisplayNameFromDN(String domainName, String dn) {
        String displayName = null;
        String tableName = CommonUtil.getDomainUserTableName(domainName);
        try {
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DN_STRING"), (Object)StrUtil.queryEscape(dn.trim()), 0);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DN_STRING"));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (dataObject != null && !dataObject.isEmpty()) {
                Row row = dataObject.getRow(tableName);
                displayName = (String)row.get("NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return displayName;
    }

    public static String getMailRecipientObjectClass(String dn) {
        String objectClass = "user";
        String tableName = "ADSMMailBoxObjects";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DISTINGUISHED_NAME"), (Object)StrUtil.queryEscape(dn), 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow(tableName);
                objectClass = (String)row.get("OBJECT_CLASS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectClass;
    }

    public static DataObject getFormats() {
        DataObject obj = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMFormats", (String)"FORMAT_DISPLAY_NAME"), (Object)"", 1);
            obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMFormats", crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static ByteArrayOutputStream getFormattedNamesXML(Properties properties) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Element element = document.createElement("attribute");
                element.setAttribute("name", key);
                element.setAttribute("value", properties.getProperty(key));
                data.appendChild(element);
            }
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    public static void getMailBoxXMLElement(HttpServletResponse response, ArrayList mailBoxStoreDNs, ArrayList mailBoxStores) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            for (Object object : mailBoxStoreDNs) {
                Element mailBoxStoreElement = document.createElement("Store");
                mailBoxStoreElement.setAttribute("dn", object.toString());
                mailBoxStoreElement.setAttribute("name", mailBoxStores.get(mailBoxStoreDNs.indexOf(object)).toString());
                data.appendChild(mailBoxStoreElement);
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateNewDO(DataObject baseDO, DataObject[] dataObjects, Long userCreationID) {
        try {
            DataObject newDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Iterator it = baseDO.getRows(USER_ATTRIBUTE_TABLE);
            while (it.hasNext()) {
                int i;
                Row r = (Row)it.next();
                Row newRow = new Row(USER_ATTRIBUTE_TABLE);
                newRow.set("USER_CREATION_ID", (Object)userCreationID);
                UniqueValueHolder uniqueValueHolder = (UniqueValueHolder)newRow.get("USER_INDEX");
                Object oldUniqueValueHolder = r.get("USER_INDEX");
                List columnNames = r.getColumns();
                for (i = 0; i < columnNames.size(); ++i) {
                    String columnName = (String)columnNames.get(i);
                    if (columnName.equalsIgnoreCase("USER_INDEX") || columnName.equalsIgnoreCase("USER_CREATION_ID") || columnName.equalsIgnoreCase("CREATION_STATUS") || columnName.equalsIgnoreCase("CREATION_MESSAGE")) continue;
                    newRow.set(columnName, r.get(columnName));
                }
                newDO.addRow(newRow);
                for (i = 0; i < multiValuAttribsTables.length; ++i) {
                    if (dataObjects[i].isEmpty()) continue;
                    Criteria c = new Criteria(Column.getColumn((String)multiValuAttribsTables[i], (String)"USER_INDEX"), oldUniqueValueHolder, 0);
                    Iterator it1 = dataObjects[i].getRows(multiValuAttribsTables[i], c);
                    while (it1.hasNext()) {
                        Row r1 = (Row)it1.next();
                        if (r1 == null) continue;
                        Row newRow1 = new Row(multiValuAttribsTables[i]);
                        newRow1.set("USER_CREATION_ID", (Object)userCreationID);
                        newRow1.set("USER_INDEX", (Object)uniqueValueHolder);
                        List columnNames1 = r1.getColumns();
                        for (int j = 0; j < columnNames1.size(); ++j) {
                            String columnName1 = (String)columnNames1.get(j);
                            if (columnName1.equalsIgnoreCase("USER_INDEX") || columnName1.equalsIgnoreCase("USER_CREATION_ID")) continue;
                            newRow1.set(columnName1, r1.get(columnName1));
                        }
                        newDO.addRow(newRow1);
                    }
                }
            }
            CommonUtil.getPersistenceLite().add(newDO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getGroupList(Long loginId, String defaultNamingContext) {
        ArrayList<String> grpAttribList = new ArrayList<String>();
        for (String string : groupAttributesArray) {
            grpAttribList.add(string);
        }
        ArrayList<Properties> groupList = new ArrayList<Properties>();
        try {
            int groupCount = GroupHandler.getGroupsCount(defaultNamingContext, null, null, null, loginId);
            DataObject groupsDO = GroupHandler.getGroups(defaultNamingContext, null, null, null, 1, groupCount, loginId);
            Iterator iterator = groupsDO.getRows("ADSMGroupGeneralDetails");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Properties properties = new Properties();
                properties.setProperty("distinguishedName", (String)row.get("DISTINGUISHED_NAME"));
                properties.setProperty("name", (String)row.get("GROUP_NAME"));
                properties.setProperty("objectSID", (String)row.get("SID_STRING"));
                String groupType = (String)row.get("GROUP_TYPE");
                String groupScope = (String)row.get("GROUP_SCOPE");
                properties.setProperty("groupScope", groupScope);
                properties.setProperty("groupType1", groupType);
                if (groupType.equalsIgnoreCase("Security") && (groupScope.equalsIgnoreCase("Global") || groupScope.equalsIgnoreCase("Universal"))) {
                    properties.setProperty("groupType", "2");
                } else {
                    properties.setProperty("groupType", "4");
                }
                groupList.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return groupList;
    }

    public static Hashtable getColValueForModifyId(Long[] ids, String retColumn) {
        Hashtable<String, String> valueHash = new Hashtable<String, String>();
        try {
            if (ids != null && ids.length > 0) {
                Criteria crit = new Criteria(Column.getColumn((String)ATTRIBUTE_DETAILS, (String)ATTRIB_MODIFY_ID), (Object)ids, 8);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(ATTRIBUTE_DETAILS, crit);
                if (!dataObject.isEmpty()) {
                    Iterator it = dataObject.getRows(ATTRIBUTE_DETAILS);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        valueHash.put(r.get(ATTRIB_MODIFY_ID).toString(), (String)r.get(retColumn));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return valueHash;
    }

    public static JSONObject getGroupData(String domainName, String columnName, ArrayList columnValues, ArrayList requiredColumns) {
        return UserMgmtUtil.getGroupData(domainName, columnName, columnValues.toArray(new String[columnValues.size()]), requiredColumns);
    }

    public static JSONObject getGroupData(String domainName, String columnName, String[] columnValues, ArrayList requiredColumns) {
        JSONObject retJson = new JSONObject();
        try {
            String tableName = CommonUtil.getDomainGroupTableName(domainName);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)columnValues, 8, false);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(tableName);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    JSONObject tempJsonObj = new JSONObject();
                    for (int i = 0; i < requiredColumns.size(); ++i) {
                        tempJsonObj.put(requiredColumns.get(i).toString(), (Object)r.get(requiredColumns.get(i).toString()).toString());
                    }
                    retJson.put(r.get(columnName).toString(), (Object)tempJsonObj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retJson;
    }

    public static DataObject getAttributeDetailsDataObject() {
        DataObject obj = null;
        try {
            obj = CommonUtil.getPersistence(new boolean[0]).get(ATTRIBUTE_DETAILS, (Criteria)null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    static {
        encoding = "ISO-8859-1";
        special = "\u00a7";
        HTTP_ENABLE = "HTTP" + special + "1" + special + "1" + special + special + special + special + special + special;
        HTTP_DISABLE = "HTTP" + special + "0" + special + "1" + special + special + special + special + special + special;
        IMAP4_ENABLE = "IMAP4" + special + "1" + special + "1" + special + "4" + special + encoding + special + "0" + special + "1" + special + "0" + special + "0";
        IMAP4_DISABLE = "IMAP4" + special + "0" + special + "1" + special + "4" + special + encoding + special + "0" + special + "1" + special + "0" + special + "0";
        POP3_ENABLE = "POP3" + special + "1" + special + "1" + special + "4" + special + encoding + special + "0" + special + special + special;
        POP3_DISABLE = "POP3" + special + "0" + special + "1" + special + "4" + special + encoding + special + "0" + special + special + special;
        USERNAME_ESCAPE_CHARECTERS = new String[]{"<", ">", "=", ",", ";", "#", "\"", "\\\\"};
        DN_ESCAPE_CHARECTERS = new String[]{"/"};
        SAMNAME_SPL_CHARECTERS = new String[]{"/", "\\", "[", "]", ":", ";", "|", "=", ",", "+", "*", "?", "<", ">", "@", "'", "#"};
        userNamingProp = new String[]{"FIRST_NAME", "LAST_NAME", "INITIAL", "LOGON_NAME", "SAM_ACCOUNT_NAME", "DISPLAY_NAME", "FULL_NAME", "DESCRIPTION", "EMPLOYEE_ID", "EMPLOYEE_NUMBER"};
        securityPropCheckEmpty = new String[]{"SCRIPT_PATH", "PROFILE_PATH", "HOME_DIRECTORY", "LOGON_TO"};
        securityPropCheckDefault = new String[]{"PASSWORD_LAST_SET", "ACCOUNT_EXPIRY_DATE", "PRIMARY_GROUP_ID", "USER_FLAGS", "ACCOUNT_STATUS", "HOME_DRIVE"};
        securityPropDefaultValues = new Object[]{0L, 0L, "513", 0, 512, ""};
        userContactProp = new String[]{"STREET_ADDRESS", "P_O_BOX", "CITY", "STATE_PROVINCE", "ZIP_POSTAL_CODE", "TELEPHONE_NUMBER", "HOME_PHONE", "PAGER", "MOBILE", "FAX", "IP_PHONE", "WEB_PAGE", "TITLE", "DEPARTMENT", "COMPANY", "OFFICE", "MANAGER", "NOTES"};
        terminalPropCheckEmpty = new String[]{"TS_PROFILE_PATH", "TS_HOME_DIRECTORY", "TS_INITIAL_PROGRAM", "TS_WORKING_DIRECTORY"};
        terminalPropCheckDefault = new String[]{"TS_ALLOW_LOGON", "TS_DC_DRIVES", "TS_DC_PRINTERS", "TS_DC_DEFAULT_PRINTER", "TS_END_DISCONNECTION", "TS_ACTIVE_SESSION", "TS_IDLE_SESSION", "TS_BROKEN_TIMEOUT", "TS_RECONNECT", "TS_SHADOWING", "TS_INHERIT_INITIAL_PROGRAM", "TS_HOME_DRIVE"};
        terminalPropDefaultValues = new Object[]{"1", "1", "1", "1", 0L, 0L, 0L, "0", "0", "1", "1", "Z:"};
        exchangePropCheckEmpty = new String[]{"OUT_MESSAGE_SIZE", "IN_MESSAGE_SIZE", "RECIPIENT_LIMITS", "WARN_AT", "PROHIBIT_SEND_MESSAGES_AT", "PROHIBIT_SEND_REC_MESSAGES_AT", "SIMPLE_DISPLAY_NAME", "FORWARD_TO", "EMAIL_ADDRESS", "MAIL_ALIAS", "MS_EXCH_EXCLUDE_POLICIES"};
        exchangePropCheckDefault = new String[]{"REQUIRE_AUTH", "PERMANENT_DELETION", "KEEP_DELETED_ITEMS", "HIDDEN_TO_ADDRESSLISTS", "OMA", "DELIVER_AND_REDIRECT"};
        exchangePropDefaultValues = new Object[]{false, "0", 0L, false, "0", false};
        exchangePropNoCheck = new String[]{"USE_DEFAULT_STORAGE"};
        exchangeServerAttributes = new String[]{"MAIL_SERVER", "MAIL_BOX_STORE"};
        mailEnablePropCheckEmpty = new String[]{"ME_IN_MESSAGE_SIZE", "ME_SIMPLE_DISPLAY_NAME", "EMAIL_ADDRESS", "ME_MAIL_ALIAS", "TARGET_ADDRESS", "MS_EXCH_EXCLUDE_POLICIES"};
        mailEnablePropCheckDefault = new String[]{"ME_REQUIRE_AUTH", "ME_HIDDEN_TO_ADDRESSLISTS"};
        mailEnablePropNoCheck = new String[]{"INTERNET_ENCODING", "MAPI_RECIPIENT"};
        mailEnablePropNoCheckValues = new String[]{"1310720", "FALSE"};
        mailEnablePropDefaultValues = new Object[]{false, false};
        multiValuAttribs = new String[]{"MEMBER_OF", "REJECT_MESSAGES_FROM", "ACCEPT_MESSAGES_FROM", "SEND_ON_BEHALF", "PROTOCOL_SETTINGS", "EMAIL_PROXY_ADDRESSES"};
        multiValuAttribsTables = new String[]{"ADSMAUMemberOf", "ADSMAUExchUnAuth", "ADSMAUExchAuth", "ADSMAUExchPublicDelegates", "ADSMAUProtocolSettings", "ADSMAUProxyAddresses"};
        attribsCheckEmpty = new String[][]{userNamingProp, securityPropCheckEmpty, userContactProp, terminalPropCheckEmpty};
        attribsCheckDefault = new String[][]{securityPropCheckDefault, terminalPropCheckDefault};
        attribsDefaultValues = new Object[][]{securityPropDefaultValues, terminalPropDefaultValues};
        drives = new String[]{"D:", "E:", "F:", "G:", "H:", "I:", "J:", "K:", "L:", "M:", "N:", "O:", "P:", "Q:", "R:", "S:", "T:", "U:", "V:", "W:", "X:", "Y:", "Z:"};
        sessionValues = new Long[]{0L, 60000L, 300000L, 600000L, 900000L, 1800000L, 3600000L, 0x6DDD00L, 10800000L, 14400000L, 18000000L, 36000000L, 86400000L, 172800000L};
        sessionLabel = new String[]{"Never", "1 min", "5 min", "10 min", "15 min", "30 min", "1 hr", "2 hr", "3 hr", "4 hr", "5 hr", "10 hr", "1 day", "2 days"};
        userListProps = new String[]{"SESSION_ID", "DOMAIN_NAME", "CONTAINER_NAME", "TEMPLATE_ID"};
        attributeTableProps = new String[]{"ATTRIB_ID", ATTRIB_COL_NAME, "AU_TABLE_NAME"};
        attributeProp = new String[]{"ATTRIB_ID", "ATTRIB_LDAP_NAME", ATTRIB_COL_NAME, "ATTRIB_DISP_NAME", "ATTRIB_DATA_TYPE", "AU_TABLE_NAME", "DATA_HANDLER_TYPE", "RELATIONAL_TYPE", "BULK_EDIT", "AJAX_SUPPORT", "ON_MOUSE_HELP", "ATTRIB_VALUE_COUNT", "HELP_TEXT", "ACTION_ID", ATTRIB_MODIFY_ID};
        attributeNativeProp = new String[]{"ATTRIB_LDAP_NAME", "DATA_HANDLER_TYPE", "ATTRIB_VALUE_COUNT"};
        statusProp = new String[]{"USER_INDEX", "FULL_NAME", "SAM_ACCOUNT_NAME", "PASSWORD", "CREATION_STATUS", "CREATION_MESSAGE"};
        customAttributeProps = new String[]{"CUSTOM_ATTRIB_NAME", "CUSTOM_ATTRIB_VALUE"};
        passwordAttribs = new String[]{"PASSWORD_TYPE", "PASSWORD"};
        generalProp = new String[]{"COUNTRY_CODE", "COUNTRY", "COUNRTY_TWO_DIGIT_CODE"};
        unMatchAccountColumn = new Long[]{1201L, 1202L, 1203L, 1208L, 1301L, 1302L, 1303L, 1304L, 1305L, 1306L};
        unMatchExchangeColumn = new Long[]{1252L, 1253L, 1254L};
        unMatchColumn = new Long[][]{unMatchAccountColumn, unMatchExchangeColumn};
        homeDriveList = null;
        sessionValuesList = null;
        sessionLabelList = null;
        homeDriveList = new ArrayList();
        for (String string : drives) {
            homeDriveList.add(string);
        }
        sessionValuesList = new ArrayList();
        for (Long l : sessionValues) {
            sessionValuesList.add(l);
        }
        sessionLabelList = new ArrayList();
        for (String string : sessionLabel) {
            sessionLabelList.add(string);
        }
        groupAttributesArray = new String[]{"distinguishedName", "name", "groupType", "objectSID"};
        profCheckboxes = new String[]{"CREATE_PROFILE", "PROF_INHERIT_PERMISSIONS"};
        hfCheckboxes = new String[]{"HD_INHERIT_PERMISSIONS", "IS_HOME_DIR_SHARED"};
        tsProfCheckboxes = new String[]{"TS_CREATE_PROFILE", "TS_PROF_INHERIT_PERMISSIONS"};
        tsHfCheckboxes = new String[]{"TS_IS_HOME_DIR_SHARED", "TS_HD_INHERIT_PERMISSIONS"};
        permsCheckBoxes = new String[][]{profCheckboxes, hfCheckboxes, tsProfCheckboxes, tsHfCheckboxes};
        permTypes = new String[]{"profilePath", "homeFolder", "tsProfilePath", "tsHomeFolder"};
    }
}

