/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.SecondaryAttributesHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.util.BlockUserUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.FormatUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class APCUtil {
    public static Hashtable getRequiredPCValues(Long policyId, ArrayList columnNames, String tableName) {
        Hashtable ret = new Hashtable();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow(tableName);
                for (int i = 0; i < columnNames.size(); ++i) {
                    if (r.get((String)columnNames.get(i)) == null) continue;
                    ret.put(columnNames.get(i), r.get((String)columnNames.get(i)).toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void setRequestedPCValues(Long policyId, String tableName, Hashtable kv) {
        try {
            HashMap kvM = new HashMap();
            Enumeration e = kv.keys();
            while (e.hasMoreElements()) {
                String col = (String)e.nextElement();
                kvM.put(col, kv.get(col));
            }
            APCUtil.setRequestedPCValues(policyId, tableName, kvM);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setRequestedPCValues(Long policyId, String tableName, HashMap kv) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow(tableName);
                for (String col : kv.keySet()) {
                    r.set(col, kv.get(col));
                }
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList isUserBlocked(Long policyId, Long loginId) {
        return BlockUserUtil.isUserBlocked(policyId, loginId);
    }

    public static Hashtable getPolNotVals(Long policyId, String[] notIds) {
        Hashtable ret = new Hashtable();
        try {
            Criteria c = new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"POLICY_ID"), (Object)policyId, 0);
            c = c.and(new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"NOTIFICATION_ID"), (Object)notIds, 8));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyNotifications", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("PolicyNotifications");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Hashtable<String, Object> kv = new Hashtable<String, Object>();
                    kv.put("NOTIFICATION_ID", (Long)row.get("NOTIFICATION_ID"));
                    kv.put("NOTIFICATION_TYPE", (String)row.get("NOTIFICATION_TYPE"));
                    kv.put("SUBJECT", (String)row.get("SUBJECT"));
                    kv.put("MAIL_CONTENT", (String)row.get("MAIL_CONTENT"));
                    kv.put("ENABLED", (Long)row.get("ENABLED"));
                    ret.put((Long)row.get("NOTIFICATION_ID"), kv);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void setPolNotVals(Long policyId, Hashtable kv) {
        try {
            String[] notIds = (String[])kv.get("NOTIFICATION_IDS");
            Criteria c = new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"POLICY_ID"), (Object)policyId, 0);
            c = c.and(new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"NOTIFICATION_ID"), (Object)notIds, 8));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyNotifications", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("PolicyNotifications");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Hashtable det = (Hashtable)kv.get((Long)row.get("NOTIFICATION_ID"));
                    Enumeration e = det.keys();
                    while (e.hasMoreElements()) {
                        String col = (String)e.nextElement();
                        row.set(col, det.get(col));
                    }
                    obj.updateRow(row);
                }
                CommonUtil.getPersistenceLite().update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDomainName(Long policyId) {
        Connection connection = null;
        DataSet dataSet = null;
        String domainName = "";
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"PolicyConfiguration"));
            sq.addJoin(new Join(Table.getTable((String)"PolicyConfiguration"), Table.getTable((String)"ADSMDomainConfiguration"), new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 2));
            sq.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"));
            sq.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_FLAT_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_DNS_NAME"));
            sq.setCriteria(new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0));
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            if (dataSet.next()) {
                domainName = "{'DOMAIN_NAME':'" + (String)dataSet.getValue("DOMAIN_NAME") + "', 'DOMAIN_FLAT_NAME':'" + (String)dataSet.getValue("DOMAIN_FLAT_NAME") + "', 'POLICY_ID':'" + (Long)dataSet.getValue("POLICY_ID") + "', 'DOMAIN_DNS_NAME':'" + (String)dataSet.getValue("DOMAIN_DNS_NAME") + "'}";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return domainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getEnrolledUsersCount(Long policyId) {
        Connection connection = null;
        DataSet dataSet = null;
        Long count = 0L;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SSPSecretQues"));
            sq.addJoin(new Join(Table.getTable((String)"SSPSecretQues"), Table.getTable((String)"SSPBuildInQAMap"), new String[]{"QUESTION_ID"}, new String[]{"QUESTION_ID"}, 2));
            sq.addJoin(new Join(Table.getTable((String)"SSPBuildInQAMap"), Table.getTable((String)"SSPUserPropertyMap"), new String[]{"USER_LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 2));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"));
            sq.setCriteria(new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"POLICY_ID"), (Object)policyId, 0));
            sq.setDistinct(true);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return count;
    }

    public static Properties getPCNotifyProps(String samAccountName, String domainName, String mailText, String subject, Hashtable keyPairValue) {
        Properties retProps = new Properties();
        try {
            String value;
            int j;
            ArrayList attributeValue;
            String attributeKey;
            int i;
            ArrayList mailAttributes = SecondaryAttributesHandler.getAttributes(domainName, "MAIL");
            ArrayList mobileAttributes = SecondaryAttributesHandler.getAttributes(domainName, "MOBILE");
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.addAll(mailAttributes);
            attributes.removeAll(mobileAttributes);
            attributes.addAll(mobileAttributes);
            attributes.add("name");
            attributes.add("objectGUID");
            ArrayList<String> mailids = new ArrayList<String>();
            ArrayList<String> mobileNos = new ArrayList<String>();
            Properties props = UserUtil.getObjValList(samAccountName, DomainHandler.getConfiguredValues(domainName, new Long(1L)), attributes);
            ArrayList getName = (ArrayList)props.get("name");
            ArrayList getGuid = (ArrayList)props.get("objectGUID");
            String name = (String)getName.get(0);
            String guid = (String)getGuid.get(0);
            for (i = 0; i < mailAttributes.size(); ++i) {
                attributeKey = (String)mailAttributes.get(i);
                attributeValue = (ArrayList)props.get(attributeKey);
                if (attributeValue == null) continue;
                for (j = 0; j < attributeValue.size(); ++j) {
                    value = (String)attributeValue.get(j);
                    if (!StrUtil.isValidEmailID(value) || mailids.contains(value)) continue;
                    mailids.add(value);
                }
            }
            for (i = 0; i < mobileAttributes.size(); ++i) {
                attributeKey = (String)mobileAttributes.get(i);
                attributeValue = (ArrayList)props.get(attributeKey);
                if (attributeValue == null) continue;
                for (j = 0; j < attributeValue.size(); ++j) {
                    value = (String)attributeValue.get(j);
                    mobileNos.add(value);
                }
            }
            ArrayList<Properties> conAtt = new ArrayList<Properties>();
            Properties p = new Properties();
            String email = (String)keyPairValue.get("emailAddress");
            String mobile = (String)keyPairValue.get("mobileNumber");
            p.put("primMailIds", mailids);
            if (email == null && mailids != null && mailids.size() != 0) {
                p.put("mail", mailids);
            } else if (email != null) {
                ArrayList<String> mailList = new ArrayList<String>();
                if (email.contains(",")) {
                    String[] mails = email.split(",");
                    for (int j2 = 0; j2 < mails.length; ++j2) {
                        mailList.add(mails[j2]);
                    }
                } else {
                    mailList = new ArrayList<String>(Arrays.asList(email));
                }
                p.put("mail", mailList);
            }
            if ((mobile == null || mobile.equalsIgnoreCase("null")) && mobileNos != null && mobileNos.size() != 0) {
                p.put("mobNumber", mobileNos);
            } else if (mobile != null) {
                p.put("mobNumber", new ArrayList<String>(Arrays.asList(mobile)));
            }
            p.put("secMailIds", UserUtil.getUserSecondaryMailIds(samAccountName, domainName));
            p.put("name", name);
            p.put("objectGUID", guid);
            conAtt.add(p);
            keyPairValue.put("userName", name);
            retProps.put("contactAtt", conAtt);
            retProps.put("mailText", FormatUtil.getNameFormats(domainName, mailText, guid, "objectGUID", keyPairValue));
            retProps.put("subject", FormatUtil.getNameFormats(domainName, subject, guid, "objectGUID", keyPairValue));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retProps;
    }

    public static Properties enrollBlocking(Long loginId, Long policyId, Boolean valAns, String type, HttpServletRequest request) {
        return BlockUserUtil.enrollBlocking(loginId, policyId, valAns, type, request);
    }

    public static Row getAppliedPwdPolicy(Long policyId) {
        try {
            String tableName = "SSPPasswordPolicy";
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"POLICY_ID"), (Object)policyId, 0);
            Criteria appliedCrit = new Criteria(Column.getColumn((String)tableName, (String)"FORCE_LEVEL"), (Object)"0", 1);
            appliedCrit = appliedCrit.or(new Criteria(Column.getColumn((String)tableName, (String)"LEVEL_NAME"), (Object)"Strong", 0));
            crit = crit.and(appliedCrit);
            selQuery.setCriteria(crit);
            selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            selQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"FORCE_LEVEL"), false));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            if (!obj.isEmpty()) {
                return obj.getFirstRow(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getAlgorithm(Long policyId) {
        String tableName = "SSPQASettings";
        Criteria c = null;
        String algorithm = "";
        try {
            c = new Criteria(Column.getColumn((String)tableName, (String)"POLICY_ID"), (Object)policyId, 0, false);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
            if (!dataobject.isEmpty()) {
                Row r = dataobject.getFirstRow(tableName);
                algorithm = r.get("ALGORITHM").toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return algorithm;
    }

    public static JSONArray getEncryptionAlgorithms() {
        JSONArray algorithmArray = new JSONArray();
        String tableName = "SSPEncryptionAlgorithms";
        Criteria c = null;
        try {
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
            if (!dataobject.isEmpty()) {
                Iterator it = dataobject.getRows(tableName);
                while (it.hasNext()) {
                    JSONObject algorithm = new JSONObject();
                    Row r = (Row)it.next();
                    algorithm.put("ALGORITHM_ID", r.get("ALGORITHM_ID"));
                    algorithm.put("ALGORITHM_DISPLAY_NAME", r.get("ALGORITHM_DISPLAY_NAME"));
                    algorithm.put("ALGORITHM", r.get("ALGORITHM"));
                    algorithmArray.put((Object)algorithm);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return algorithmArray;
    }

    public static ArrayList getAllDomainPolicyIds() {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            DataObject dataobject;
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnLoginId = cred.getLoginId();
            Criteria c = null;
            if (!ADMPRoleHandler.isADSSPUser(loggedOnLoginId)) {
                String domainName = DomainHandler.getDomainName(loggedOnLoginId);
                c = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            }
            if (!(dataobject = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", c)).isEmpty()) {
                Iterator it = dataobject.getRows("PolicyConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long policyId = (Long)r.get("POLICY_ID");
                    list.add(policyId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

