/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DCConfiguration.DCConfigUtil;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DNSIPCache;
import com.adventnet.sym.adsm.common.server.util.GinaUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.VpnUtil;
import com.adventnet.sym.adsm.start.util.SDInstallUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.struts.validator.DynaValidatorForm;

public class AgentSchedulerUtil {
    public static final String LOGON_SCRIPT = "ADSelfService_Enroll.hta";
    private static final String TABLE_NAME = new String("AgentComputerDetails");
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String PORT_NO = "PORT_NO";
    public static final String GINA_INSTALL_SCHEDULE = "adssp.configuration.admin_tools.gina_install_scheduler_title";
    public static final String GINA_CUSTOM_SCHEDULE = "adssp.configuration.admin_tools.gina_custom_scheduler_title";
    public static final String ENROLL_REMIND_SCHEDULE = "adssp.config.management.agent_scheduler.enroll_remind_scheduler";
    private static Logger logger = CommonUtil.getDefaultLogger();

    public static void addToPendingTable(Long agentId, Hashtable domainOUSelected) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPASPendingComputers", (String)"AGENT_ID"), (Object)agentId, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(c);
            Enumeration domainSelectedName = domainOUSelected.keys();
            while (domainSelectedName.hasMoreElements()) {
                DataObject pendTblDObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                String domainName = (String)domainSelectedName.nextElement();
                String tableName = CommonUtil.getDomainComputerTableName(domainName);
                SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)tableName));
                selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
                selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DN_STRING"));
                ArrayList ouList = (ArrayList)domainOUSelected.get(domainName);
                ouList = OUUtil.getParentOUs(ouList);
                Criteria successCrit = new Criteria(Column.getColumn((String)TABLE_NAME, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 0);
                successCrit = successCrit.or(new Criteria(Column.getColumn((String)TABLE_NAME, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_reinstall_success", 0));
                Criteria crit = null;
                for (int ouCount = 0; ouCount < ouList.size(); ++ouCount) {
                    Criteria ouCrit = new Criteria(Column.getColumn((String)tableName, (String)"DN_STRING"), (Object)("*" + ouList.get(ouCount)), 2, false);
                    crit = crit != null ? crit.or(ouCrit) : ouCrit;
                }
                Join join = new Join(tableName, "AgentComputerDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                selQuery.addJoin(join);
                Criteria finalCrit = crit.and(successCrit);
                selQuery.setCriteria(finalCrit);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Row pendingRow = new Row("SSPASPendingComputers");
                    Row r = (Row)iterator.next();
                    pendingRow.set("AGENT_ID", (Object)agentId);
                    pendingRow.set("COMPUTER_DN", (Object)((String)r.get("DN_STRING")));
                    pendingRow.set("OBJECT_GUID", (Object)((String)r.get("OBJECT_GUID")));
                    pendTblDObj.addRow(pendingRow);
                }
                CommonUtil.getPersistenceLite().add(pendTblDObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getComputerList(String domainName, ArrayList ouList) {
        ArrayList<Properties> compList = new ArrayList<Properties>();
        try {
            String domComptable = CommonUtil.getDomainComputerTableName(domainName);
            Table domainTable = Table.getTable((String)domComptable);
            SelectQueryImpl selQuery = new SelectQueryImpl(domainTable);
            Join join = new Join(domComptable, TABLE_NAME, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            selQuery.addJoin(join);
            ouList = OUUtil.getParentOUs(ouList);
            Criteria filterCrit = null;
            for (int x = 0; x < ouList.size(); ++x) {
                filterCrit = filterCrit == null ? new Criteria(Column.getColumn((String)domComptable, (String)"DN_STRING"), (Object)("*" + ouList.get(x)), 2, false) : filterCrit.or(new Criteria(Column.getColumn((String)domComptable, (String)"DN_STRING"), (Object)("*" + ouList.get(x)), 2, false));
            }
            Criteria statusCrit = new Criteria(Column.getColumn((String)TABLE_NAME, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 1);
            statusCrit = statusCrit.and(new Criteria(Column.getColumn((String)TABLE_NAME, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_reinstall_success", 1));
            Criteria nullCrit = new Criteria(Column.getColumn((String)TABLE_NAME, (String)"INSTALL_STATUS"), null, 0);
            Criteria finalCrit = nullCrit.or(statusCrit);
            finalCrit = filterCrit.and(finalCrit);
            selQuery.setCriteria(finalCrit);
            selQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            String dnsName = new String();
            String ipaddress = new String();
            DNSIPCache dnsipcache = DNSIPCache.getInstance();
            Iterator iter = dataObject.getRows(domComptable);
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                Properties compProps = new Properties();
                compProps.put("sAMAccountName", (String)row.get("NAME"));
                compProps.put("objectGUID", (String)row.get("OBJECT_GUID"));
                dnsName = (String)row.get("DNS_NAME");
                if (dnsName == null) {
                    dnsName = "--";
                }
                compProps.put("dNSHostName", dnsName);
                compProps.put("ouName", (String)row.get("OU_NAME"));
                compProps.put("distinguishedName", (String)row.get("DN_STRING"));
                compProps.put("domainName", domainName);
                ipaddress = dnsipcache.getIP(compProps.getProperty("sAMAccountName"));
                compProps.put("computerIP", ipaddress);
                compProps.put("installAction", "Install");
                compList.add(compProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return compList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getCustomProps(Long agentId) {
        Row r;
        Properties customProps = new Properties();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        String[] customOpts = new String[]{"AGENT_ID", "FRAME_TEXT", "BUTTON_TEXT", "ICON", "SHOW_ADSSP_TILE", "SHOW_ADSSP_LINK", "WINDOWS_LOGON_TFA", "BYPASS_ADSSPSERVER_UNREACH"};
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPASCustomValues", (String)"AGENT_ID"), (Object)agentId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPASCustomValues", crit);
            if (!obj.isEmpty()) {
                r = obj.getFirstRow("SSPASCustomValues");
                for (String customOpt : customOpts) {
                    if (customOpt.equals("ICON")) {
                        String iconName = (String)r.get("ICON");
                        if (iconName == null) continue;
                        String srcPath = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adssp" + File.separator + iconName;
                        customProps.put("ICON", srcPath);
                        continue;
                    }
                    Object val = r.get(customOpt);
                    if (val == null) continue;
                    String objValue = rb.getString(String.valueOf(val));
                    customProps.put(customOpt, objValue);
                }
            }
            AgentSchedulerUtil.getAccessURLProperties(customProps);
            AgentSchedulerUtil.getVPNProperties(customProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String prodTitle = rb.getString("adssp.common.text.product_title");
        try {
            DataObject dObj = CommonUtil.getCachedPersistence().get("SystemUtility", (Criteria)null);
            if (!dObj.isEmpty()) {
                r = dObj.getFirstRow("SystemUtility");
                prodTitle = rb.getString((String)r.get("TITLE"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            customProps.put("PROD_TITLE", prodTitle);
        }
        String serverUnreach = rb.getString("adssp.config.management.gina.winlogtfa.server_unreach");
        customProps.put("SERVER_UNREACH", serverUnreach);
        return customProps;
    }

    public static Properties getDetails(String objGuid) {
        String compTableName = new String();
        Properties machineProp = new Properties();
        try {
            Properties domainProp = new Properties();
            ArrayList domainList = DomainHandler.getDomainList();
            for (int x = 0; x < domainList.size(); ++x) {
                domainProp = (Properties)domainList.get(x);
                String domainName = (String)domainProp.get("DOMAIN_NAME");
                compTableName = CommonUtil.getDomainComputerTableName(domainName);
                Criteria crit = new Criteria(Column.getColumn((String)compTableName, (String)"OBJECT_GUID"), (Object)objGuid, 0);
                DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(compTableName, crit);
                if (dObj.isEmpty()) continue;
                Row r = dObj.getFirstRow(compTableName);
                machineProp.setProperty("sAMAccountName", (String)r.get("NAME"));
                machineProp.setProperty("distinguishedName", (String)r.get("DN_STRING"));
                machineProp.setProperty("objectGUID", objGuid);
                machineProp.setProperty("dNSHostName", (String)r.get("DNS_NAME"));
                machineProp.setProperty("domainName", domainName);
                if ((String)r.get("OS") != null) {
                    machineProp.setProperty("os", (String)r.get("OS"));
                } else {
                    machineProp.setProperty("os", "");
                }
                if ((String)r.get("OS_VERSION") != null) {
                    machineProp.setProperty("osVersion", (String)r.get("OS_VERSION"));
                } else {
                    machineProp.setProperty("osVersion", "");
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return machineProp;
    }

    public static void removePendingComp(String objGuid) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPASPendingComputers", (String)"OBJECT_GUID"), (Object)objGuid, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addToAuditActionResult(String objGuid, Long actionId, String status) {
        try {
            DataObject o = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("AgentAuditActionResult");
            r.set("AGENT_ACTION_ID", (Object)actionId);
            r.set("OBJECT_GUID", (Object)objGuid);
            r.set("STATUS", (Object)status);
            o.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mapAgentAuditAction(Long agentId, Long scheduleAuditId, Long agentAuditId) {
        try {
            DataObject o = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("ScheduleAgentAuditMapping");
            r.set("AGENT_ID", (Object)agentId);
            r.set("SCHEDULE_AUDIT_ID", (Object)scheduleAuditId);
            r.set("AGENT_ACTION_ID", (Object)agentAuditId);
            o.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getADSSPServerName(String webServerPortFile) {
        String hostName = SDInstallUtil.getAliasName((String)webServerPortFile);
        if (hostName == null) {
            logger.log(Level.INFO, "Alias Name not given. Using the web server name");
            hostName = SDInstallUtil.getWebServerAddr((String)webServerPortFile);
        }
        if (hostName.equalsIgnoreCase("localhost")) {
            try {
                InetAddress i = InetAddress.getLocalHost();
                hostName = i.getHostName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeScriptFile() {
        FileOutputStream pwdFilestream = null;
        OutputStreamWriter osr = null;
        BufferedWriter out = null;
        BufferedReader in = null;
        try {
            String fileName = System.getProperty("server.home") + File.separator + "bin" + File.separator + LOGON_SCRIPT;
            String enrollURL = AdminHandler.getAccessURL();
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF8"));
            String s = "";
            StringBuffer bufferStr = new StringBuffer();
            while ((s = in.readLine()) != null) {
                if (s.startsWith("serverURL=")) {
                    bufferStr.append("serverURL=\"" + enrollURL + "\"");
                } else {
                    bufferStr.append(s);
                }
                bufferStr.append("\n");
            }
            in.close();
            pwdFilestream = new FileOutputStream(fileName);
            osr = new OutputStreamWriter((OutputStream)pwdFilestream, "UTF-8");
            out = new BufferedWriter(osr);
            out.write(bufferStr.toString());
            out.close();
            osr.close();
            pwdFilestream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (pwdFilestream != null) {
                    pwdFilestream.close();
                }
                if (out != null) {
                    out.close();
                }
                if (osr != null) {
                    osr.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Properties getScriptDetails(Long policyId, Boolean skipPolicySelection, Boolean forceEnroll) {
        Properties scriptDetails = new Properties();
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPEnrollmentLogonScript", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPEnrollmentLogonScript", c);
            if (!dObj.isEmpty() && !skipPolicySelection.booleanValue()) {
                Row r = dObj.getFirstRow("SSPEnrollmentLogonScript");
                scriptDetails.put("ENROLL_UI_TEXT", (String)r.get("ENROLL_UI_TEXT"));
                scriptDetails.put("ENFORCE", (Boolean)r.get("ENFORCE"));
            }
            if (skipPolicySelection.booleanValue()) {
                if (forceEnroll.booleanValue()) {
                    scriptDetails.put("ENFORCE", (Object)true);
                } else {
                    scriptDetails.put("ENFORCE", (Object)false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scriptDetails;
    }

    public static Properties copyScriptFile(Long policyId) throws Exception {
        Properties prop = new Properties();
        String msg = "adssp.config.management.agent_scheduler.file_copy_success";
        String sourceFile = System.getProperty("server.home") + File.separator + "bin" + File.separator + LOGON_SCRIPT;
        String dnsName = "";
        String domainName = "";
        if (policyId != null && policyId != 0L) {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("PolicyConfiguration");
                domainName = (String)r.get("DOMAIN_NAME");
                dnsName = DomainHandler.getDomainDNSName(domainName);
                String sysvolPath = "\\\\" + dnsName + File.separator + "SYSVOL" + File.separator + dnsName + File.separator + "scripts";
                String destFile = sysvolPath + File.separator + LOGON_SCRIPT;
                try {
                    msg = ADHandler.CopyFileToClient(sourceFile, destFile, null, domainName);
                }
                catch (NativeException ee) {
                    msg = ee.getExceptionMsg();
                    logger.log(Level.INFO, "NativeException Thrown : " + msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!"adssp.config.management.agent_scheduler.file_copy_success".equals(msg)) {
                    String machineName = DCConfigUtil.getFirstDC(domainName);
                    String netlogonPath = "\\\\" + machineName + File.separator + "NETLOGON";
                    destFile = netlogonPath + File.separator + LOGON_SCRIPT;
                    try {
                        msg = ADHandler.CopyFileToClient(sourceFile, destFile, machineName, domainName);
                    }
                    catch (NativeException ee) {
                        msg = ee.getExceptionMsg();
                        logger.log(Level.INFO, "NativeException Thrown : " + msg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!"adssp.config.management.agent_scheduler.file_copy_success".equals(msg)) {
                        prop.put("MSG_STATUS", "error");
                    }
                }
            }
        }
        prop.put("MESSAGE", msg);
        prop.put("DOMAIN_NAME", domainName);
        return prop;
    }

    public static void populateTaskSchedulers(String domainName) {
        try {
            String[] schedulerNames;
            Criteria crit = new Criteria(Column.getColumn((String)"SSPASConfiguration", (String)"AGENT_ID"), null, 1);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPASConfiguration", crit);
            if (!dObj.isEmpty()) {
                return;
            }
            logger.log(Level.INFO, "Populating the values for TaskScheduler");
            for (String schedulerName : schedulerNames = new String[]{GINA_INSTALL_SCHEDULE, GINA_CUSTOM_SCHEDULE}) {
                Criteria criter = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)schedulerName, 0);
                DataObject schObj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", criter);
                if (schObj.isEmpty()) continue;
                Row sr = schObj.getFirstRow("Schedule");
                Row cR = new Row("SSPASConfiguration");
                cR.set("SCHEDULE_ID", (Object)((Long)sr.get("SCHEDULE_ID")));
                dObj.addRow(cR);
            }
            AgentSchedulerUtil.populateASCustomValues();
            CommonUtil.getPersistence(new boolean[0]).add(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void populateASCustomValues() {
        try {
            Long agentId = -1L;
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPASCustomValues", new Criteria(Column.getColumn((String)"SSPASCustomValues", (String)"AGENT_ID"), (Object)agentId, 0));
            if (dObj.isEmpty()) {
                logger.log(Level.INFO, "Adding the Default server name, port name, protocol, Frame text, custom text etc., to the table SSPASCustomValues");
                Row customRow = new Row("SSPASCustomValues");
                customRow.set("AGENT_ID", (Object)agentId);
                customRow.set("FRAME_TEXT", (Object)"adssp.config.management.gina_custom.def_frame_text");
                customRow.set("BUTTON_TEXT", (Object)"adssp.config.management.gina_custom.def_button_text");
                customRow.set("SHOW_ADSSP_TILE", (Object)"true");
                customRow.set("SHOW_ADSSP_LINK", (Object)"true");
                customRow.set("WINDOWS_LOGON_TFA", (Object)"false");
                customRow.set("BYPASS_ADSSPSERVER_UNREACH", (Object)"false");
                dObj.addRow(customRow);
                CommonUtil.getPersistence(new boolean[0]).add(dObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeScriptPath(String domainName, String samAccName) {
        try {
            Long agentAuditId = GinaUtil.addToAgentAuditActions(new Long(-1L), "RSP_MANUAL_ENROLL");
            String domUserTableName = CommonUtil.getDomainUserTableName(domainName);
            SelectQueryImpl userSelQuery = new SelectQueryImpl(Table.getTable((String)domUserTableName));
            Criteria sidCrit = new Criteria(Column.getColumn((String)domUserTableName, (String)"SAM_ACCOUNT_NAME"), (Object)samAccName, 0);
            userSelQuery.setCriteria(sidCrit);
            userSelQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)userSelQuery);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getFirstRow(domUserTableName);
                String sidString = (String)row.get("SID_STRING");
                String status = ADHandler.removeScriptPath(domainName, sidString, LOGON_SCRIPT);
                AgentSchedulerUtil.addToAuditActionResult(sidString, agentAuditId, status);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDefaultProps(DynaValidatorForm bean, Long loginId) {
        try {
            Hashtable domains = DomainHandler.getDomainsAndOUs(loginId);
            bean.set("dnDomainNameMap", domains.get("dnDomainNameMap"));
            ArrayList domainList = (ArrayList)bean.get("domainList");
            if (domainList == null || domainList.size() == 0) {
                bean.set("domains", (Object)new String[0]);
            }
            bean.set("domainList", domains.get("domainList"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getAccessURLProperties(Properties customProps) {
        String context;
        Properties prop = AdminHandler.getAddOnRow(com.manageengine.ads.fw.util.CommonUtil.getProductName());
        if (prop == null) {
            prop = AgentSchedulerUtil.populateServerDetails();
        }
        String string = context = prop.get("CONTEXT") != null ? (String)prop.get("CONTEXT") : "";
        if (context.equals("")) {
            String productInstallPath = System.getProperty("server.home");
            String webServerPortFile = productInstallPath + "\\conf\\server.xml";
            context = SDInstallUtil.getContextPathName((String)webServerPortFile);
        }
        customProps.put(SERVER_NAME, prop.get("HOST"));
        customProps.put(PORT_NO, prop.get("PORT"));
        customProps.put("PROTOCOL", prop.get("PROTOCOL"));
        customProps.put("CONTEXT", context);
    }

    public static void getVPNProperties(Properties customProps) {
        Properties vpnParams = VpnUtil.getVPNProviderSettings();
        customProps.put("IS_VPN_ENABLED", "");
        customProps.put("IS_TP_VPN_ENABLED", "");
        customProps.put("VPN_SERVER_NAME", "");
        customProps.put("VPN_PORT_NO", "");
        customProps.put("PRE_SHARED_KEY", "");
        customProps.put("VPN_GROUP_NAME", "");
        customProps.put("VPN_DOMAIN_NAME", "");
        customProps.put("VPN_TYPE", "");
        customProps.put("VPN_CLIENT_LOCATION", "");
        customProps.put("VPN_CLIENT_LOCATION_64", "");
        customProps.put("VPN_CONNECT_CMD", "");
        customProps.put("VPN_DISCONNECT_CMD", "");
        if (vpnParams.containsKey("IS_VPN_ENABLED") && ((Boolean)vpnParams.get("IS_VPN_ENABLED")).booleanValue()) {
            Properties vpnSettingsParams = (Properties)vpnParams.get("VPN_SETTINGS_PARAMS");
            Long vpnProviderId = (Long)vpnParams.get("VPN_PROVIDER_ID");
            customProps.put("VPN_SERVER_NAME", vpnParams.get("VPN_SERVER_NAME"));
            customProps.put("VPN_PORT_NO", vpnParams.get("VPN_PORT_NO"));
            if (vpnProviderId == 2L) {
                customProps.put("PRE_SHARED_KEY", vpnSettingsParams.get("PRE_SHARED_KEY"));
                customProps.put("IS_TP_VPN_ENABLED", "f");
            } else {
                customProps.put("VPN_CLIENT_LOCATION", vpnSettingsParams.get("VPN_CLIENT_LOCATION"));
                customProps.put("VPN_CLIENT_LOCATION_64", vpnSettingsParams.get("VPN_CLIENT_LOCATION_64"));
                customProps.put("VPN_CONNECT_CMD", " " + vpnSettingsParams.get("CONNECT_CMD"));
                customProps.put("VPN_DISCONNECT_CMD", " " + vpnSettingsParams.get("DISCONNECT_CMD"));
                if (vpnSettingsParams.containsKey("VPN_GROUP_NAME")) {
                    customProps.put("VPN_GROUP_NAME", " " + vpnSettingsParams.get("VPN_GROUP_NAME"));
                }
                if (vpnSettingsParams.containsKey("VPN_DOMAIN_NAME")) {
                    customProps.put("VPN_DOMAIN_NAME", " " + vpnSettingsParams.get("VPN_DOMAIN_NAME"));
                }
                customProps.put("IS_TP_VPN_ENABLED", "t");
            }
            customProps.put("IS_VPN_ENABLED", "t");
            customProps.put("VPN_TYPE", vpnParams.get("VPN_TYPE"));
        }
    }

    public static Properties populateServerDetails() {
        Properties prop = new Properties();
        try {
            String productInstallPath = System.getProperty("server.home");
            String webServerPortFile = productInstallPath + "\\conf\\server.xml";
            int portNo = SDInstallUtil.getSSLPort();
            String protocol = "https";
            if (portNo == -1) {
                portNo = SDInstallUtil.getWebServerPort((String)webServerPortFile);
                protocol = "http";
            }
            String adsspServer = AgentSchedulerUtil.getADSSPServerName(webServerPortFile);
            prop.put("HOST", adsspServer);
            prop.put("PORT", (Object)portNo);
            prop.put("PROTOCOL", protocol);
            prop.put("CONTEXT", "");
            AdminHandler.addProductDetails(com.manageengine.ads.fw.util.CommonUtil.getProductName(), prop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }
}

