/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.adapter.BackupDBParams;
import com.adventnet.db.adapter.BackupRestoreConfigurations;
import com.adventnet.db.adapter.BackupRestoreException;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.taskengine.TaskContext;
import com.manageengine.ads.fw.ha.HAConstants;
import com.manageengine.ads.fw.ha.HAHandler;
import com.manageengine.ads.startup.util.StartupUtil;
import java.io.File;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.struts.validator.DynaValidatorForm;

public class BackupSchedulerUtil {
    private static Logger out = Logger.getLogger(BackupSchedulerUtil.class.getName());
    private static String defaultBackupDIR = new File(System.getProperty("server.home")).getAbsolutePath();

    public static void setScheduledProps(DynaValidatorForm bean) {
        ArrayList scheduleConfigList = BackupSchedulerUtil.getTaskSchedulers();
        Properties pro = (Properties)scheduleConfigList.get(0);
        HashMap hashMap = (HashMap)pro.get("SCHEDULED_AT");
        bean.set("SCHEDULE_TYPE", (Object)((String)hashMap.get("SCHEDULE_TYPE")));
        bean.set("TIME_PERIOD", (Object)((Long)hashMap.get("TIME_PERIOD")));
        bean.set("DATE_OF_MONTH", (Object)((Integer)hashMap.get("DATE_OF_MONTH")));
        bean.set("DAY_OF_WEEK", (Object)((Integer)hashMap.get("DAY_OF_WEEK")));
        bean.set("TIME_OF_DAY", (Object)((Long)hashMap.get("TIME_OF_DAY")));
        bean.set("SCHEDULE_ID", (Object)((Long)pro.get("SCHEDULE_ID")));
        bean.set("SCHEDULE_NAME", (Object)((String)pro.get("SCHEDULE_NAME")));
        bean.set("DESCRIPTION", (Object)((String)pro.get("DESCRIPTION")));
        bean.set("TASK_ID", (Object)((Long)pro.get("TASK_ID")));
        bean.set("BACKUP_LOCATION", (Object)((String)pro.get("BACKUP_LOCATION")));
        bean.set("HOURLY_MINS_OF_HOUR", (Object)((Long)hashMap.get("HOURLY_MINS_OF_HOUR")));
        bean.set("MINS_OF_HOUR", (Object)((Long)hashMap.get("MINS_OF_HOUR")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTaskSchedulers() {
        ArrayList<Properties> scheduleConfigList = new ArrayList<Properties>();
        DataSet dataSet = null;
        Connection connection = null;
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(new Table("Schedule"));
            Join taskInputJoin = new Join("Schedule", "Task_Input", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join calendarJoin = new Join("Schedule", "Calendar", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join periodicJoin = new Join("Schedule", "Periodic", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join schTaskJoin = new Join("Schedule", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join taskJoin = new Join("Scheduled_Task", "TaskEngine_Task", new String[]{"TASK_ID"}, new String[]{"TASK_ID"}, 1);
            Join defTask = new Join("Task_Input", "Default_Task_Input", new String[]{"INSTANCE_ID"}, new String[]{"INSTANCE_ID"}, 1);
            selQuery.addJoin(taskInputJoin);
            selQuery.addJoin(calendarJoin);
            selQuery.addJoin(periodicJoin);
            selQuery.addJoin(schTaskJoin);
            selQuery.addJoin(taskJoin);
            selQuery.addJoin(defTask);
            selQuery.addSelectColumn(new Column("Schedule", "SCHEDULE_ID"));
            selQuery.addSelectColumn(new Column("Schedule", "SCHEDULE_NAME"));
            selQuery.addSelectColumn(new Column("Schedule", "DESCRIPTION"));
            selQuery.addSelectColumn(new Column("Calendar", "TIME_OF_DAY"));
            selQuery.addSelectColumn(new Column("Calendar", "DAY_OF_WEEK"));
            selQuery.addSelectColumn(new Column("Calendar", "DATE_OF_MONTH"));
            selQuery.addSelectColumn(new Column("Calendar", "REPEAT_FREQUENCY"));
            selQuery.addSelectColumn(new Column("Periodic", "TIME_PERIOD"));
            selQuery.addSelectColumn(new Column("Scheduled_Task", "ADMIN_STATUS"));
            selQuery.addSelectColumn(new Column("Scheduled_Task", "TASK_ID"));
            selQuery.addSelectColumn(new Column("TaskEngine_Task", "TASK_NAME"));
            selQuery.addSelectColumn(new Column("Default_Task_Input", "VARIABLE_VALUE"));
            selQuery.addSelectColumn(new Column("Periodic", "UNIT_OF_TIME"));
            selQuery.addSelectColumn(new Column("Calendar", "UNIT_OF_TIME"));
            Criteria crit = new Criteria(new Column("Default_Task_Input", "VARIABLE_NAME"), (Object)"adssp.admin.customization.dbbackup_scheduler", 0);
            Criteria criteria = crit.and(new Criteria(new Column("TaskEngine_Task", "TASK_NAME"), (Object)"adssp.xml.taskflow.dbbackup_scheduler", 0));
            selQuery.setCriteria(criteria);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selQuery, connection);
            while (dataSet.next()) {
                Properties taskProps = new Properties();
                taskProps.put("SCHEDULE_ID", (Long)dataSet.getValue("SCHEDULE_ID"));
                taskProps.put("SCHEDULE_NAME", (String)dataSet.getValue("SCHEDULE_NAME"));
                taskProps.put("DESCRIPTION", (String)dataSet.getValue("DESCRIPTION"));
                taskProps.put("TASK_ID", (Long)dataSet.getValue("TASK_ID"));
                HashMap<String, Object> prop = new HashMap<String, Object>();
                prop.put("DAY_OF_WEEK", (Integer)dataSet.getValue("DAY_OF_WEEK"));
                prop.put("DATE_OF_MONTH", (Integer)dataSet.getValue("DATE_OF_MONTH"));
                Long timePeriod = (Long)dataSet.getValue("TIME_PERIOD");
                prop.put("TIME_PERIOD", timePeriod);
                if (timePeriod != null && timePeriod != -1L) {
                    prop.put("SCHEDULE_TYPE", "Hourly");
                    if ("Minutes".equalsIgnoreCase((String)dataSet.getValue(13))) {
                        prop.put("TIME_PERIOD", (Long)dataSet.getValue("TIME_PERIOD") / 60L);
                        prop.put("HOURLY_MINS_OF_HOUR", (Long)dataSet.getValue("TIME_PERIOD") % 60L);
                    } else {
                        prop.put("TIME_PERIOD", (Long)dataSet.getValue("TIME_PERIOD"));
                    }
                } else {
                    prop.put("SCHEDULE_TYPE", (String)dataSet.getValue("REPEAT_FREQUENCY"));
                    if ("Minutes".equalsIgnoreCase((String)dataSet.getValue(14))) {
                        prop.put("TIME_OF_DAY", (Long)dataSet.getValue("TIME_OF_DAY") / 60L);
                        prop.put("MINS_OF_HOUR", (Long)dataSet.getValue("TIME_OF_DAY") % 60L);
                    } else {
                        prop.put("TIME_OF_DAY", (Long)dataSet.getValue("TIME_OF_DAY"));
                    }
                }
                taskProps.put("SCHEDULED_AT", prop);
                taskProps.put("SCHEDULE_STATUS", (Integer)dataSet.getValue("ADMIN_STATUS"));
                String backupLocation = (String)dataSet.getValue("VARIABLE_VALUE");
                if (backupLocation == null) {
                    backupLocation = new File(System.getProperty("server.home")).getAbsolutePath();
                    backupLocation = BackupSchedulerUtil.replaceFirstStr(backupLocation, "\\\\bin\\\\..", "\\\\Backup");
                }
                taskProps.put("BACKUP_LOCATION", backupLocation);
                scheduleConfigList.add(taskProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (dataSet != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scheduleConfigList;
    }

    public static String getBackupLocation(TaskContext taskContext) {
        String bkLocation = null;
        Iterator ite = taskContext.getDefaultTaskInputs();
        while (ite.hasNext()) {
            Row inputRow = (Row)ite.next();
            String key = (String)inputRow.get("VARIABLE_NAME");
            if (!"adssp.admin.customization.dbbackup_scheduler".equalsIgnoreCase(key)) continue;
            bkLocation = (String)inputRow.get("VARIABLE_VALUE");
            if (bkLocation != null) break;
            bkLocation = BackupSchedulerUtil.replaceFirstStr(defaultBackupDIR, "\\\\bin\\\\..", "\\\\Backup");
            break;
        }
        return bkLocation;
    }

    public static String replaceFirstStr(String source, String firstStr, String toBeReplace) {
        return source.replaceFirst(firstStr, toBeReplace);
    }

    public static int executeDBBackupOperation(String backupDir) {
        int backUpStatus = BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_PROCESS_FAILED.getValue();
        out.log(Level.INFO, "The database backup operation : {0}", backupDir);
        try {
            if (DomainHandler.getConfiguredDomains().size() > 0) {
                File file = new File(backupDir);
                File check = new File(backupDir + "\\check");
                check.mkdirs();
                if (!check.exists() && file.isDirectory() || !file.exists() && !file.isDirectory() && !file.mkdirs()) {
                    backupDir = BackupSchedulerUtil.replaceFirstStr(defaultBackupDIR, "\\\\bin\\\\..", "\\\\Backup");
                }
                if (check.exists()) {
                    check.delete();
                }
                BackupDBParams params = new BackupDBParams();
                params.incrementalBackupEnabled = false;
                params.backupStartTime = System.currentTimeMillis();
                params.backupContentType = BackupRestoreConfigurations.BACKUP_CONTENT_TYPE.DUMP;
                params.backupType = BackupRestoreConfigurations.BACKUP_TYPE.FULL_BACKUP;
                params.backupFolder = new File(backupDir);
                params.backupLabelWaitDuration = 20;
                params.backupMode = BackupRestoreConfigurations.BACKUP_MODE.OFFLINE_BACKUP;
                params.zipFileName = new SimpleDateFormat("yyMMdd-HHmmss").format(Calendar.getInstance().getTime()) + ".zip";
                backUpStatus = RelationalAPI.getInstance().getDBAdapter().getBackupHandler().doBackup(params).getBackupStatus().getValue();
            } else {
                backUpStatus = 0;
                out.log(Level.INFO, "No Domains configured. Hence skipping DB backup operation.");
            }
            out.log(Level.INFO, "BackupStatus............. {0} ", backUpStatus);
        }
        catch (BackupRestoreException bre) {
            if ("Already a backup DB process is running.".equalsIgnoreCase(bre.getMessage())) {
                out.log(Level.WARNING, bre.getMessage());
                backUpStatus = BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_PROCESS_IN_PROGRESS.getValue();
            } else {
                bre.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return backUpStatus;
    }

    public static Boolean isBuiltInDB() {
        Boolean isBuiltInDB = true;
        try {
            Properties props;
            String dbDriver;
            String startDB = PersistenceInitializer.getConfigurationValue((String)"StartDBServer");
            if (startDB.equalsIgnoreCase("false") && "org.postgresql.Driver".equalsIgnoreCase(dbDriver = (props = StartupUtil.getProperties((String)HAHandler.getFilePath((String)HAConstants.HA_DB_PARAMS))).getProperty("drivername"))) {
                return true;
            }
            isBuiltInDB = startDB != null && startDB.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isBuiltInDB;
    }
}

