/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mobile.MobileUtil;
import com.adventnet.sym.adsm.common.server.notifications.PolicyNotifications;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class BlockUserUtil {
    private static Logger logger = Logger.getLogger(BlockUserUtil.class.getName());

    public static ArrayList isUserBlocked(Long policyId, Long loginId) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        Boolean blockStatus = false;
        try {
            Criteria crit = new Criteria(new Column("SSPBlocking", "POLICY_ID"), (Object)policyId, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("SSPBlocking", crit);
            Row blockingRow = null;
            Long blockDur = null;
            if (!o.isEmpty()) {
                blockingRow = o.getFirstRow("SSPBlocking");
                blockDur = (Long)blockingRow.get("BLOCKING_DURATION");
            }
            Criteria c = new Criteria(new Column("SSPUserPropertyMap", "USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPUserPropertyMap", c);
            Row userProRow = null;
            if (!obj.isEmpty()) {
                userProRow = obj.getFirstRow("SSPUserPropertyMap");
                Long bStatus = new Long(userProRow.get("BLOCKING_STATUS").toString());
                Long bTime = (Long)userProRow.get("INVALID_ANS_TIME");
                Long cT = System.currentTimeMillis();
                blockDur = bTime + blockDur * 60L * 1000L;
                if (bStatus == 1L) {
                    blockStatus = true;
                    if (cT > blockDur) {
                        userProRow.set("BLOCKING_STATUS", (Object)new Long(0L));
                        obj.updateRow(userProRow);
                        CommonUtil.getPersistenceLite().update(obj);
                        blockStatus = false;
                    }
                }
            }
            list.add(blockStatus);
            list.add((Boolean)blockingRow);
            list.add((Boolean)obj);
            list.add((Boolean)userProRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Properties enrollBlocking(Long loginId, Long policyId, Boolean valAns, String type, HttpServletRequest request) {
        Properties ret = new Properties();
        String statusMsg = "";
        Boolean status = false;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            ArrayList list = BlockUserUtil.isUserBlocked(policyId, loginId);
            Row blockingRow = (Row)list.get(1);
            Long maxAtt = (Long)blockingRow.get("MAX_ATTEMPTS");
            Long resetAtt = (Long)blockingRow.get("RESET_ATTEMPTS");
            Long blockDur = (Long)blockingRow.get("BLOCKING_DURATION");
            DataObject obj = (DataObject)list.get(2);
            Row userProRow = (Row)list.get(3);
            Long bStatus = new Long(userProRow.get("BLOCKING_STATUS").toString());
            Long bCount = (Long)userProRow.get("INVALID_ANS_COUNT");
            Long bTime = (Long)userProRow.get("INVALID_ANS_TIME");
            Long cT = System.currentTimeMillis();
            blockDur = bTime + blockDur * 60L * 1000L;
            resetAtt = bTime + resetAtt * 60L * 1000L;
            logger.log(Level.INFO, "Current Time ::: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(cT));
            logger.log(Level.INFO, "DB Time ::: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(bTime));
            logger.log(Level.INFO, "blockDur ::: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(blockDur));
            logger.log(Level.INFO, "resetAtt ::: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(resetAtt));
            if (bStatus == 1L) {
                if (cT > blockDur) {
                    if (!valAns.booleanValue()) {
                        if (maxAtt == 1L) {
                            userProRow.set("INVALID_ANS_COUNT", (Object)new Long(0L));
                            userProRow.set("INVALID_ANS_TIME", (Object)cT);
                            userProRow.set("BLOCKING_STATUS", (Object)new Long(1L));
                            BlockUserUtil.sendBlockedUserNotification(policyId, loginId, request);
                            statusMsg = "adssp.security.que.rp.ua.page.account.blocked";
                        } else {
                            userProRow.set("INVALID_ANS_COUNT", (Object)new Long(1L));
                            userProRow.set("INVALID_ANS_TIME", (Object)cT);
                            userProRow.set("BLOCKING_STATUS", (Object)new Long(0L));
                            statusMsg = type.equals("audit.action.security_ques") ? "adssp.security.que.rp.ua.page.invalid.answer" : "adssp.reset_unlock.accounts.status_msg.enter_valid_ver_code";
                        }
                    } else {
                        userProRow.set("INVALID_ANS_COUNT", (Object)new Long(0L));
                        userProRow.set("INVALID_ANS_TIME", (Object)new Long(0L));
                        userProRow.set("BLOCKING_STATUS", (Object)new Long(0L));
                        status = true;
                    }
                    obj.updateRow(userProRow);
                } else {
                    statusMsg = "adssp.security.que.rp.ua.page.account.blocked";
                }
            } else if (!valAns.booleanValue()) {
                if (cT < resetAtt) {
                    if (bCount + 1L < maxAtt) {
                        userProRow.set("INVALID_ANS_COUNT", (Object)(bCount + 1L));
                        userProRow.set("BLOCKING_STATUS", (Object)new Long(0L));
                        if (bTime == 0L) {
                            userProRow.set("INVALID_ANS_TIME", (Object)cT);
                        }
                        obj.updateRow(userProRow);
                        statusMsg = type.equals("audit.action.security_ques") ? "adssp.security.que.rp.ua.page.invalid.answer" : "adssp.reset_unlock.accounts.status_msg.enter_valid_ver_code";
                    } else {
                        userProRow.set("INVALID_ANS_COUNT", (Object)new Long(0L));
                        userProRow.set("INVALID_ANS_TIME", (Object)cT);
                        userProRow.set("BLOCKING_STATUS", (Object)new Long(1L));
                        obj.updateRow(userProRow);
                        BlockUserUtil.sendBlockedUserNotification(policyId, loginId, request);
                        statusMsg = "adssp.security.que.rp.ua.page.account.blocked";
                    }
                } else if (maxAtt == 1L) {
                    userProRow.set("INVALID_ANS_COUNT", (Object)new Long(0L));
                    userProRow.set("INVALID_ANS_TIME", (Object)cT);
                    userProRow.set("BLOCKING_STATUS", (Object)new Long(1L));
                    obj.updateRow(userProRow);
                    BlockUserUtil.sendBlockedUserNotification(policyId, loginId, request);
                    statusMsg = "adssp.security.que.rp.ua.page.account.blocked";
                } else {
                    userProRow.set("INVALID_ANS_COUNT", (Object)new Long(1L));
                    userProRow.set("INVALID_ANS_TIME", (Object)cT);
                    userProRow.set("BLOCKING_STATUS", (Object)new Long(0L));
                    obj.updateRow(userProRow);
                    statusMsg = type.equals("audit.action.security_ques") ? "adssp.security.que.rp.ua.page.invalid.answer" : "adssp.reset_unlock.accounts.status_msg.enter_valid_ver_code";
                }
            } else {
                status = true;
            }
            CommonUtil.getPersistenceLite().update(obj);
            ret.put("STATUS", status);
            ret.put("statusMsg", statusMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void resetBlockCount(long policyId, long loginId) {
        try {
            ArrayList list = BlockUserUtil.isUserBlocked(policyId, loginId);
            DataObject obj = (DataObject)list.get(2);
            Row userProRow = (Row)list.get(3);
            userProRow.set("INVALID_ANS_COUNT", (Object)new Long(0L));
            userProRow.set("INVALID_ANS_TIME", (Object)new Long(0L));
            userProRow.set("BLOCKING_STATUS", (Object)new Long(0L));
            obj.updateRow(userProRow);
            CommonUtil.getPersistenceLite().update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendBlockedUserNotification(Long policyId, Long loginId, HttpServletRequest request) {
        try {
            Hashtable<String, String> keyPairValue = new Hashtable<String, String>();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            keyPairValue.put("dateTime", TimeZoneUtil.getPresentDateTime(request, null));
            String ipAddress = CommonUtil.getIPAddress(request);
            HashMap result = (HashMap)CommonUtil.getHostDetails(request, ipAddress);
            keyPairValue.put("hostName", (String)result.get("host"));
            keyPairValue.put("ipAddress", (String)result.get("ip"));
            String domainName = DomainHandler.getDomainName(loginId);
            Properties domainDetails = ADAuthHandler.getLoginUserDetails(loginId);
            String loginName = domainDetails.getProperty("LOGIN_NAME");
            ArrayList<Long> nIds = new ArrayList<Long>();
            nIds.add(new Long(17L));
            nIds.add(new Long(18L));
            nIds.add(new Long(20L));
            if (MobileUtil.isNativeApp(request) && request.getParameterMap().containsKey("DEVICE_ID")) {
                keyPairValue.put("EXEMPTED_DEVICE", request.getParameter("DEVICE_ID"));
            }
            PolicyNotifications.sendNotification(domainName, loginName, policyId, nIds, keyPairValue);
            AdventNetResourceBundle adminRb = ResourceBundleMgr.getInstance().getBundle();
            keyPairValue.put("action", adminRb.getString("adssp.notification.actio.block_user_action"));
            keyPairValue.put("actionPhrase", adminRb.getString("adssp.notification.actio.block_user"));
            keyPairValue.put("dateTime", TimeZoneUtil.getPresentDateTime(request, 1L));
            JSONObject jsonLog = AuditAPI.getInstance().setAuditProps(loginName, domainName, System.currentTimeMillis(), "adssp.notification.actio.block_user", (String)result.get("ip"), (String)result.get("host"), "", "adssp.reports.audit_report.user_attempts.error.user_blocked");
            logger.log(Level.INFO, "calling LogForwarderAPI : " + jsonLog.toString());
            LogForwarderAPI.getInstance().sendMessage(jsonLog);
            PolicyNotifications.sendMailToAdmin(domainName, loginName, policyId, keyPairValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

