/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.sql.Timestamp;
import java.util.Date;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;

public class CaptchaUtil {
    public static void verifyCaptchaOnLogin(String loginName, String domainName, HttpServletRequest request) throws LoginException {
        JSONObject LogonCaptchaSettings = CaptchaUtil.getLogonCaptchaSettings();
        String showCap = ADSMPersUtil.getSyMParameter("SHOW_CAPTCHA_LOGIN_PAGE");
        HttpSession session = request.getSession();
        String showCaptcha = (String)session.getAttribute("showCaptcha");
        showCaptcha = showCaptcha != null && showCaptcha.equals("true") ? "true" : "false";
        showCap = showCap != null && showCap.equals("true") ? "true" : "false";
        String excludeCaptcha = request.getParameter("EXCLUDE_CAPTCHA");
        boolean chkCaptcha = !"true".equalsIgnoreCase(excludeCaptcha);
        String queryStr = request.getQueryString();
        if (queryStr != null && queryStr.indexOf("EXCLUDE_CAPTCHA") != -1) {
            chkCaptcha = true;
        }
        if (!chkCaptcha) {
            return;
        }
        try {
            JSONObject UserBadLoginStatus;
            if (showCap.equals("true") && !LogonCaptchaSettings.getBoolean("IS_ENABLED") || showCaptcha.equals("true")) {
                if (!CaptchaUtil.validateCaptcha(request)) {
                    throw new LoginException("adssp.reset_unlock.accounts.captcha.enter_img_text");
                }
                return;
            }
            if (domainName == null) {
                return;
            }
            if (showCap.equals("true") && LogonCaptchaSettings.getBoolean("IS_ENABLED") && (UserBadLoginStatus = CaptchaUtil.getUserBadLoginStatus(loginName, domainName)).length() != 0) {
                boolean resetTimeCheck;
                long curTime = System.currentTimeMillis();
                boolean badLoginAtmptsCheck = UserBadLoginStatus.getInt("NUM_OF_BAD_LOGIN") >= LogonCaptchaSettings.getInt("MAX_INVALID_LOGIN");
                boolean bl = resetTimeCheck = curTime < ((Timestamp)UserBadLoginStatus.get("LAST_BAD_LOGIN_TIME")).getTime() + (long)(LogonCaptchaSettings.getInt("TIME_TO_RESET") * 60 * 1000);
                if (badLoginAtmptsCheck && resetTimeCheck) {
                    session.setAttribute("showCaptcha", (Object)"true");
                    throw new LoginException("adssp.account.login.captcha.enter_img_text");
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static boolean validateCaptcha(HttpServletRequest request) {
        String hipId = request.getParameter("DIGEST");
        String hip = (String)request.getSession().getAttribute("SIMPLE_CAPCHA_SESSION_KEY");
        request.getSession().removeAttribute("SIMPLE_CAPCHA_SESSION_KEY");
        return hipId != null && hip != null && hip.equalsIgnoreCase(hipId);
    }

    private static JSONObject getUserBadLoginStatus(String loginName, String domainName) {
        JSONObject info = new JSONObject();
        String tableName = "SSPUsersBadLoginStatus";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"LOGIN_NAME"), (Object)loginName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DataObject object = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            if (!object.isEmpty()) {
                Row r = object.getRow(tableName);
                info.put("NUM_OF_BAD_LOGIN", r.get("NUM_OF_BAD_LOGIN"));
                info.put("LAST_BAD_LOGIN_TIME", r.get("LAST_BAD_LOGIN_TIME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    private static void updateUserBadLoginStatus(String loginName, String domainName, int attempts, Timestamp time) {
        String tableName = "SSPUsersBadLoginStatus";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"LOGIN_NAME"), (Object)loginName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DataObject object = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            if (object.isEmpty()) {
                Row r = new Row(tableName);
                r.set("LOGIN_NAME", (Object)loginName);
                r.set("DOMAIN_NAME", (Object)domainName);
                r.set("NUM_OF_BAD_LOGIN", (Object)attempts);
                r.set("LAST_BAD_LOGIN_TIME", (Object)time);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                dataObject.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            } else {
                Row r = object.getFirstRow(tableName);
                r.set("NUM_OF_BAD_LOGIN", (Object)attempts);
                r.set("LAST_BAD_LOGIN_TIME", (Object)time);
                object.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(object);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getLogonCaptchaSettings() {
        JSONObject captchaSettings = new JSONObject();
        String tableName = "SSPLogonCaptchaSettings";
        try {
            Criteria criteria = null;
            DataObject object = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Row r = object.getRow(tableName);
            captchaSettings.put("IS_ENABLED", r.get("IS_ENABLED"));
            captchaSettings.put("MAX_INVALID_LOGIN", r.get("MAX_INVALID_LOGIN"));
            captchaSettings.put("TIME_TO_RESET", r.get("TIME_TO_RESET"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return captchaSettings;
    }

    public static void updateLogonCaptchaSettings(boolean isEnabled, int maxAttempts, int timeToReset) {
        String tableName = "SSPLogonCaptchaSettings";
        try {
            Criteria criteria = null;
            DataObject object = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Row r = object.getRow(tableName);
            r.set("IS_ENABLED", (Object)isEnabled);
            r.set("MAX_INVALID_LOGIN", (Object)maxAttempts);
            r.set("TIME_TO_RESET", (Object)timeToReset);
            object.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isCaptchaEnabled(HttpSession session) {
        String tableName = "SSPLogonCaptchaSettings";
        String showCap = ADSMPersUtil.getSyMParameter("SHOW_CAPTCHA_LOGIN_PAGE");
        String showCaptcha = (String)session.getAttribute("showCaptcha");
        boolean customCaptcha = false;
        try {
            Criteria criteria = null;
            DataObject object = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Row r = object.getRow(tableName);
            customCaptcha = (Boolean)r.get("IS_ENABLED");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        customCaptcha = showCap != null && showCap.equals("true") && (!customCaptcha || showCaptcha != null && showCaptcha.equals("true"));
        return customCaptcha;
    }

    public static void updateLoginStatus(String loginName, String domainName, HttpServletRequest request, String loginStatus) {
        HttpSession session = request.getSession();
        JSONObject LogonCaptchaSettings = CaptchaUtil.getLogonCaptchaSettings();
        String showCap = ADSMPersUtil.getSyMParameter("SHOW_CAPTCHA_LOGIN_PAGE");
        try {
            String queryStr = request.getQueryString();
            if ("true".equalsIgnoreCase(request.getParameter("EXCLUDE_CAPTCHA")) && (queryStr == null || queryStr.indexOf("EXCLUDE_CAPTCHA") == -1)) {
                return;
            }
            if (showCap == null || showCap.equals("false") || !LogonCaptchaSettings.getBoolean("IS_ENABLED")) {
                if (session.getAttribute("showCaptcha") != null) {
                    session.removeAttribute("showCaptcha");
                }
                return;
            }
            JSONObject UserBadLoginStatus = CaptchaUtil.getUserBadLoginStatus(loginName, domainName);
            if (loginStatus.equals("success")) {
                if (UserBadLoginStatus.length() != 0) {
                    CaptchaUtil.updateUserBadLoginStatus(loginName, domainName, 0, (Timestamp)UserBadLoginStatus.get("LAST_BAD_LOGIN_TIME"));
                }
                session.setAttribute("showCaptcha", (Object)"false");
            } else {
                int attempts = 1;
                String showCaptcha = (String)session.getAttribute("showCaptcha");
                Date date = new Date();
                Timestamp timeStamp = new Timestamp(date.getTime());
                if (UserBadLoginStatus.length() != 0 && timeStamp.getTime() < ((Timestamp)UserBadLoginStatus.get("LAST_BAD_LOGIN_TIME")).getTime() + (long)(LogonCaptchaSettings.getInt("TIME_TO_RESET") * 60 * 1000)) {
                    attempts = UserBadLoginStatus.getInt("NUM_OF_BAD_LOGIN") + 1;
                }
                CaptchaUtil.updateUserBadLoginStatus(loginName, domainName, attempts, timeStamp);
                if (attempts >= LogonCaptchaSettings.getInt("MAX_INVALID_LOGIN") || showCaptcha != null && showCaptcha.equals("true")) {
                    session.setAttribute("showCaptcha", (Object)"true");
                } else {
                    session.setAttribute("showCaptcha", (Object)"false");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

