/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.taskengine.TaskContext;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Transaction;

public class CleanUpUtil {
    private static Logger logger = Logger.getLogger(CleanUpUtil.class.getName());
    private static CleanUpUtil cleanupUtil = null;
    private static final Integer OBJ_GEN_DETAILS_DELETE_LIMIT = 20;
    private static final Integer DELETE_LIMIT = 50;
    private static final String MINIMUM_ID = "MINIMUM_ID";
    private static final String MAXIMUM_ID = "MAXIMUM_ID";
    public static final String AGENT_AUDIT_ACTIONS_TABLE = "AgentAuditActions";
    public static final String AGENT_AUDIT_ACTIONS_ID = "AGENT_ACTION_ID";
    public static final String AGENT_AUDIT_ACTIONS_TIME = "TIME";
    public static final String OBJ_GEN_DETAILS_TABLE = "ADSMObjectGenerationDetails";
    public static final String OBJ_GEN_DETAILS_ID = "REPORT_GENERATION_ID";
    public static final String OBJ_GEN_DETAILS_TIME = "CREATION_TIME";
    public static final String SCHEDULE_AUDIT_TABLE = "Schedule_Audit";
    public static final String SCHEDULE_AUDIT_ID = "AUDIT_ID";
    public static final String SCHEDULE_AUDIT_TIME = "SCHEDULE_FINISH_TIME";
    public static final String SSP_META_TABLE = "SSPMETATABLE";
    public static final String SSP_META_TABLE_COLUMN = "LOOKUP_TABLENAME";
    public static final String SSP_META_TABLE_TIME = "END_TIME";
    public static final String AD_DATA_CLEANUP_PERIOD = "AD_DATA_CLEANUP_PERIOD";
    public static final String ADSSP_DATA_CLEANUP_PERIOD = "ADSSP_DATA_CLEANUP_PERIOD";

    public static synchronized CleanUpUtil getInstance() throws Exception {
        if (cleanupUtil == null) {
            cleanupUtil = new CleanUpUtil();
        }
        return cleanupUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCleanUpTasks(TaskContext taskContext) {
        Transaction txn = null;
        try {
            txn = DataAccess.getTransactionManager().suspend();
            Integer daysToBePertained = this.getCleanupPeriod(taskContext, AD_DATA_CLEANUP_PERIOD);
            Long cleanUpTimeStamp = this.getCleanUptimeStamp(daysToBePertained);
            this.cleanUpScheduleHistory(cleanUpTimeStamp);
            this.cleanUpObjectDetails(cleanUpTimeStamp);
            this.cleanUpAgentAuditLogs(cleanUpTimeStamp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                DataAccess.getTransactionManager().resume(txn);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            logger.log(Level.INFO, "TaskEngine's Default Transaction resumes.");
        }
        try {
            this.cleanUpMetaTable(this.getCleanupPeriod(taskContext, ADSSP_DATA_CLEANUP_PERIOD));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanUpObjectDetails(Long cleanUpTimeStamp) throws Exception {
        logger.log(Level.INFO, "Going to delete ADSMObjectGenerationDetails");
        Criteria crit = this.getCritForObjDetails(cleanUpTimeStamp);
        this.deleteRecords(OBJ_GEN_DETAILS_TABLE, OBJ_GEN_DETAILS_ID, OBJ_GEN_DETAILS_DELETE_LIMIT, crit);
        logger.log(Level.INFO, "Schedule Audit Logs has been cleaned up successfully");
    }

    public Criteria getCritForObjDetails(Long cleanUpTimeStamp) {
        ArrayList genIds = this.getGenIdsForDashboard();
        Criteria crit = null;
        try {
            crit = this.getCritForCleanUp(OBJ_GEN_DETAILS_TABLE, OBJ_GEN_DETAILS_TIME, cleanUpTimeStamp);
            if (genIds != null) {
                String[] genIdsArr = genIds.toArray(new String[genIds.size()]);
                crit = crit.and(new Criteria(Column.getColumn((String)OBJ_GEN_DETAILS_TABLE, (String)OBJ_GEN_DETAILS_ID), (Object)genIdsArr, 9));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public ArrayList getGenIdsForDashboard() {
        ArrayList<String> genIds = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)OBJ_GEN_DETAILS_ID), null, 1);
            DataAccess.getTransactionManager().begin();
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMHomeProps", criteria);
            DataAccess.getTransactionManager().commit();
            if (!dataObj.isEmpty()) {
                genIds = new ArrayList<String>();
                Iterator iter = dataObj.getRows("ADSMHomeProps");
                while (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    String genIdStr = ((Long)r.get(OBJ_GEN_DETAILS_ID)).toString();
                    genIds.add(genIdStr);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                DataAccess.getTransactionManager().rollback();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return genIds;
    }

    public void cleanUpScheduleHistory(Long cleanUpTimeStamp) throws Exception {
        logger.log(Level.INFO, "Schedule Audit Logs started");
        Criteria crit = this.getCritForCleanUp(SCHEDULE_AUDIT_TABLE, SCHEDULE_AUDIT_TIME, cleanUpTimeStamp);
        this.deleteRecords(SCHEDULE_AUDIT_TABLE, SCHEDULE_AUDIT_ID, DELETE_LIMIT, crit);
        logger.log(Level.INFO, "Schedule Audit Logs has been cleaned up successfully");
    }

    public void cleanUpMetaTable(Integer cleanUpPeriod) throws Exception {
        logger.log(Level.INFO, "cleanMetaTable method called");
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)SSP_META_TABLE));
        sq.addSelectColumn(Column.getColumn((String)SSP_META_TABLE, (String)SSP_META_TABLE_COLUMN));
        Criteria crit = this.getCritForCleanUp(SSP_META_TABLE, SSP_META_TABLE_TIME, this.getCleanUptimeStamp(cleanUpPeriod));
        sq.setCriteria(crit);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        Iterator it = dataObject.getRows(SSP_META_TABLE);
        while (it.hasNext()) {
            Row row = (Row)it.next();
            String tableName = (String)row.get(SSP_META_TABLE_COLUMN);
            CommonUtil.getPersistence(new boolean[0]).dropTable(tableName);
            logger.log(Level.INFO, "Deleted table " + tableName);
            crit = new Criteria(Column.getColumn((String)SSP_META_TABLE, (String)SSP_META_TABLE_COLUMN), (Object)tableName, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
        }
        logger.log(Level.INFO, "MetaTable has been cleaned up successfully");
    }

    public void cleanUpAgentAuditLogs(Long cleanUpTimeStamp) throws Exception {
        logger.log(Level.INFO, "Going to delete Agent Audit Logs");
        try {
            Criteria crit = this.getCritForCleanUp(AGENT_AUDIT_ACTIONS_TABLE, AGENT_AUDIT_ACTIONS_TIME, cleanUpTimeStamp);
            this.deleteRecords(AGENT_AUDIT_ACTIONS_TABLE, AGENT_AUDIT_ACTIONS_ID, DELETE_LIMIT, crit);
            logger.log(Level.INFO, "Agent Audit Logs has been cleaned up successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Criteria getCritForCleanUp(String tableName, String columnName, Long columnValue) {
        Criteria crit = null;
        try {
            Comparable<Long> colValue = columnValue;
            if (tableName.equals(SCHEDULE_AUDIT_TABLE) && columnName.equals(SCHEDULE_AUDIT_TIME)) {
                colValue = new Timestamp(columnValue);
            }
            crit = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)colValue, 7);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.FINE, "CleanUp Criteria :: " + crit);
        return crit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getCleanUpDataStats(String tableName, String columnName, Criteria agentAuditCrit) {
        HashMap<String, Long> dataStat = new HashMap<String, Long>();
        DataSet dataSet = null;
        Connection connection = null;
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            Column maxAuditIdColumn = Column.getColumn((String)tableName, (String)columnName).maximum();
            maxAuditIdColumn.setColumnAlias(MAXIMUM_ID);
            Column minAuditIdColumn = Column.getColumn((String)tableName, (String)columnName).minimum();
            minAuditIdColumn.setColumnAlias(MINIMUM_ID);
            selQuery.addSelectColumn(maxAuditIdColumn);
            selQuery.addSelectColumn(minAuditIdColumn);
            selQuery.setCriteria(agentAuditCrit);
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)selQuery, connection);
            while (dataSet.next()) {
                dataStat.put(MAXIMUM_ID, (Long)dataSet.getValue(MAXIMUM_ID));
                dataStat.put(MINIMUM_ID, (Long)dataSet.getValue(MINIMUM_ID));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dataStat;
    }

    public void deleteRecords(String tableName, String columnName, Integer deleteRange, Criteria crit) throws Exception {
        long auditMinId = 0L;
        long auditMaxId = 0L;
        HashMap dataStat = this.getCleanUpDataStats(tableName, columnName, crit);
        if (dataStat.containsKey(MINIMUM_ID)) {
            if (dataStat.get(MINIMUM_ID) == null) {
                return;
            }
            auditMinId = (Long)dataStat.get(MINIMUM_ID);
        }
        if (dataStat.containsKey(MAXIMUM_ID)) {
            auditMaxId = (Long)dataStat.get(MAXIMUM_ID);
        }
        for (long minId = auditMinId; minId <= auditMaxId; minId += (long)deleteRange.intValue()) {
            Criteria rangeCrit = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)minId, 4);
            rangeCrit = rangeCrit.and(new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)(minId + (long)deleteRange.intValue()), 7));
            rangeCrit = rangeCrit.and(crit);
            try {
                DataAccess.getTransactionManager().begin();
                CommonUtil.getPersistence(new boolean[0]).delete(rangeCrit);
                DataAccess.getTransactionManager().commit();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    DataAccess.getTransactionManager().rollback();
                    continue;
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        }
    }

    public Long getCleanUptimeStamp(int cleanUpLimit) throws Exception {
        GregorianCalendar gCal = new GregorianCalendar();
        int year = gCal.get(1);
        int month = gCal.get(2);
        int date = gCal.get(5);
        gCal = new GregorianCalendar(year, month, date -= cleanUpLimit);
        Long timeInMillis = gCal.getTimeInMillis();
        return timeInMillis;
    }

    public Integer getCleanupPeriod(TaskContext taskContext, String paramName) {
        int daysToReturn = paramName.equals(AD_DATA_CLEANUP_PERIOD) ? 30 : 365;
        try {
            Iterator it = taskContext.getDefaultTaskInputs();
            Long instanceId = taskContext.getID();
            while (it.hasNext()) {
                Row r = (Row)it.next();
                if (!((String)r.get("VARIABLE_NAME")).equals(paramName)) continue;
                String value = (String)r.get("VARIABLE_VALUE");
                daysToReturn = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return daysToReturn;
    }
}

