/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.ReadOnlyPersistence;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainDatas;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.UrlClicksHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.GinaReportUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.TechnicianUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseManager;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.sym.adsm.start.util.PortCheckerUtil;
import com.adventnet.sym.adsm.start.util.SDInstallUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.ByteMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommonUtil {
    private static Logger logger = Logger.getLogger("CommonUtil");
    private static Persistence persistence = null;
    private static Persistence persistenceLite = null;
    private static String isDemo = null;
    private static Persistence dbSyncPersistence = null;
    public static final String[] PURCHASE_TIME = new String[]{"adssp.common.layout.demo_quote.estimated_time.option1", "adssp.common.layout.demo_quote.estimated_time.option2", "adssp.common.layout.demo_quote.estimated_time.option3", "adssp.common.layout.demo_quote.estimated_time.option4", "adssp.common.layout.demo_quote.estimated_time.option5"};
    public static final String[] PRIMARY_OPTIONS = new String[]{"adssp.common.text.yes", "adssp.common.text.no"};
    public static final String[] NO_DOMAIN_USERS_OPTIONS = new String[]{"500", "1000", "1500", "2000", "3000", "5000"};
    private static final String DEMO_QUOTE_STATUS = "DEMO_QUOTE_STATUS";
    private static final String DEMO_QUOTE_TIME = "DEMO_QUOTE_TIME";

    public static Logger getDefaultLogger() {
        return Logger.getLogger("SSPLogger");
    }

    public static Persistence getPersistence(boolean ... flags) {
        if (flags.length > 0 && flags[0]) {
            if (dbSyncPersistence != null) {
                return dbSyncPersistence;
            }
            try {
                dbSyncPersistence = (Persistence)BeanUtil.lookup((String)"DBSyncPersistence");
                return dbSyncPersistence;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (persistence != null) {
            return persistence;
        }
        try {
            persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
            return persistence;
        }
        catch (Exception me) {
            me.printStackTrace();
            return null;
        }
    }

    public static ReadOnlyPersistence getCachedPersistence() throws Exception {
        try {
            return (ReadOnlyPersistence)BeanUtil.lookup((String)"PureCachedPersistence");
        }
        catch (Exception me) {
            me.printStackTrace();
            return null;
        }
    }

    public static Persistence getPersistenceLite() {
        if (persistenceLite != null) {
            return persistenceLite;
        }
        try {
            persistenceLite = (Persistence)BeanUtil.lookup((String)"PersistenceLite");
            return persistenceLite;
        }
        catch (Exception me) {
            me.printStackTrace();
            return null;
        }
    }

    public static Row getRowObject(Hashtable prop, String[] propArray, String tableName) {
        Row row = new Row(tableName);
        return CommonUtil.updateRow(row, prop, propArray);
    }

    public static Row updateRow(Row row, Hashtable prop, String[] propArray) {
        for (int i = 0; i < propArray.length; ++i) {
            if (prop.get(propArray[i]) != null) {
                row.set(propArray[i], prop.get(propArray[i]));
                continue;
            }
            row.set(propArray[i], (Object)"Not Set");
        }
        return row;
    }

    public static String getURL(String user) {
        return CommonUtil.getURL(user, true);
    }

    public static String getURL(String user, boolean clicks) {
        String url = "";
        String usageStatistics = ADSMPersUtil.getSyMParameter("USAGE_STATISTICS");
        if (clicks && !user.equals("R") && (usageStatistics == null || usageStatistics.equals("true"))) {
            url = url + "clicks=" + UrlClicksHandler.getInstance().getString() + "&";
        }
        String fileHome = System.getProperty("server.home") + File.separator + "conf";
        String installTime = "000000";
        try {
            File installFile = new File(fileHome + File.separator + "customerInfo.txt");
            if (installFile.exists()) {
                Properties installProp = new Properties();
                installProp.load(new FileInputStream(installFile));
                installTime = installProp.getProperty("InstallationTime");
            }
        }
        catch (Exception ex) {
            System.err.println("Problem in getting install time");
        }
        if (user.equals("R")) {
            if (usageStatistics == null || usageStatistics.equals("true")) {
                url = url + "ry=a&fi=96&pi=51&it=" + installTime;
            }
        } else if (user.equals("T")) {
            url = url + "ry=b&fi=96&pi=51&it=" + installTime;
        } else if (user.equals("F")) {
            url = url + "ry=c&fi=96&pi=51&it=" + installTime;
        }
        Properties pdtDetails = LicenseUtil.getProductDetails();
        url = url + "&bn=" + pdtDetails.getProperty("product.build_number");
        return url;
    }

    public static Row updateRow(Row row, Hashtable prop) {
        Enumeration e = prop.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            row.set(key, prop.get(key));
        }
        return row;
    }

    public static Row updateRow(Row row, Properties prop) {
        return CommonUtil.updateRow(row, (Hashtable)prop);
    }

    public static ArrayList getList(DataObject obj, String[] propArray, String tableName) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            Iterator it = obj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                for (String s : propArray) {
                    if (r.get(s) == null) continue;
                    p.put(s, r.get(s));
                }
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getList(DataObject obj, String tableName) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            Iterator it = obj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                List columnNames = r.getColumns();
                for (int i = 0; i < columnNames.size(); ++i) {
                    String columnName = (String)columnNames.get(i);
                    if (r.get(columnName) == null) continue;
                    p.put(columnName, r.get(columnName).toString());
                }
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Properties getProperties(DataObject obj, String tableName) {
        Properties p = new Properties();
        try {
            Row r = obj.getRow(tableName);
            if (r != null) {
                List columnNames = r.getColumns();
                for (int i = 0; i < columnNames.size(); ++i) {
                    String columnName = (String)columnNames.get(i);
                    if (r.get(columnName) == null) continue;
                    p.put(columnName, r.get(columnName));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static String getDomainTableName(String domainName) {
        String str = (String)DomainDatas.getInstance().getValue(domainName, "domainTableName");
        if (str == null) {
            String sidTableName = domainName.toUpperCase();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < sidTableName.length(); ++i) {
                if (sidTableName.charAt(i) == '-' || sidTableName.charAt(i) == '.') {
                    buf.append("_");
                    continue;
                }
                buf.append(sidTableName.charAt(i));
            }
            str = CommonUtil.getValidName(buf.toString());
            DomainDatas.getInstance().setValue(domainName, "domainTableName", str);
        }
        return str;
    }

    public static String getDomainUserTableName(String domainName) {
        String str = (String)DomainDatas.getInstance().getValue(domainName, "domainUserTableName");
        if (str == null) {
            str = CommonUtil.getDomainTableName(domainName) + "_Users";
            DomainDatas.getInstance().setValue(domainName, "domainUserTableName", str);
        }
        return str;
    }

    public static String getDomainComputerTableName(String domainName) {
        String str = (String)DomainDatas.getInstance().getValue(domainName, "domainComputerTableName");
        if (str == null) {
            str = CommonUtil.getDomainTableName(domainName) + "_Computers";
            DomainDatas.getInstance().setValue(domainName, "domainComputerTableName", str);
        }
        return str;
    }

    public static String getDomainGroupTableName(String domainName) {
        String str = (String)DomainDatas.getInstance().getValue(domainName, "domainGroupTableName");
        if (str == null) {
            str = CommonUtil.getDomainTableName(domainName) + "_Groups";
            DomainDatas.getInstance().setValue(domainName, "domainGroupTableName", str);
        }
        return str;
    }

    public static Long getFileTimeFromSystemTime(Long systemTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1600, 11, 31, 0, 0, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Long millis = calendar.getTimeInMillis();
        Long fileTime = (systemTime - millis) * 10000L;
        return fileTime;
    }

    public static Long getSystemTimeFromFileTime(Long fileTime) {
        Long systemTime = fileTime / 10000L;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1600, 11, 31, 24, 0, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Long millis = calendar.getTimeInMillis();
        systemTime = systemTime + millis;
        return systemTime;
    }

    public static Long getDateFromFileTime(Long fileTime) {
        Long systemTime = fileTime / 10000L;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1601, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Long millis = calendar.getTimeInMillis();
        systemTime = systemTime + millis;
        return systemTime;
    }

    public static Long getTimeForPwdProp(Long fileTime) {
        Long systemTime = fileTime / 10000L;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1601, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Long millis = calendar.getTimeInMillis();
        systemTime = systemTime + millis;
        return systemTime;
    }

    public static String getLicenseProperty(String module, String property) {
        return LicenseManager.getInstance().getLicenseProperty(module, property);
    }

    public static Hashtable getPackageDetails(String serverPath) {
        Hashtable<String, String> pkgDetails = new Hashtable<String, String>();
        try {
            String fileHome = serverPath + File.separator + "conf";
            Properties installProp = new Properties();
            File installFile = new File(fileHome + File.separator + "AgentPackage.conf");
            if (installFile.exists()) {
                installProp.load(new FileInputStream(installFile));
                String packageVersion = installProp.getProperty("package.version");
                pkgDetails.put("AgentVersion", packageVersion);
                String installDir = installProp.getProperty("package.installDir");
                pkgDetails.put("AgentDirectory", installDir);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pkgDetails;
    }

    public static String getServerURL(String serverInstallPath) {
        String webServerPortFile = serverInstallPath + "\\conf\\server.xml";
        String hostName = SDInstallUtil.getWebServerAddr((String)webServerPortFile);
        PortCheckerUtil pchutil = new PortCheckerUtil(webServerPortFile);
        String contextPathName = pchutil.getContextPathName(webServerPortFile);
        int portNo = SDInstallUtil.getWebServerPort((String)webServerPortFile);
        if (hostName.equalsIgnoreCase("localhost")) {
            try {
                InetAddress i = InetAddress.getLocalHost();
                hostName = i.getHostName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String serverURL = "http://" + hostName + ":" + portNo;
        serverURL = contextPathName != null && !contextPathName.equals("") ? serverURL + contextPathName : serverURL + "/";
        return serverURL;
    }

    public static boolean isDemo() {
        if (isDemo == null) {
            try {
                String fileHome = System.getProperty("server.home") + File.separator + "conf";
                Properties installProp = new Properties();
                File installFile = new File(fileHome + File.separator + "demo.conf");
                if (installFile.exists()) {
                    installProp.load(new FileInputStream(installFile));
                    isDemo = installProp.getProperty("demo.isDemo");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return isDemo.equals("true");
    }

    public static String getFormattedString(String string) {
        byte[] bs = string.getBytes();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bs.length; ++i) {
            byte b = bs[i];
            if (b == 92) {
                builder.append("\\\\");
                continue;
            }
            if (b == 9) {
                builder.append("\\t");
                continue;
            }
            if (b == 10) {
                builder.append("\\n");
                continue;
            }
            if (b == 13) {
                builder.append("\\r");
                continue;
            }
            if (b == 12) {
                builder.append("\\f");
                continue;
            }
            if (b == 8) {
                builder.append("\\b");
                continue;
            }
            builder.append((char)b);
        }
        return builder.toString();
    }

    public static void resetValues() {
        LicenseManager.getInstance().resetValues();
    }

    public static long getNoOfDays(Long longObj) {
        longObj = CommonUtil.getTimeForPwdProp(longObj);
        Calendar currDate = Calendar.getInstance();
        currDate.setTimeInMillis(System.currentTimeMillis());
        GregorianCalendar laterDate = new GregorianCalendar();
        laterDate.set(currDate.get(1), currDate.get(2), currDate.get(5), 0, 0, 0);
        Calendar setDate = Calendar.getInstance();
        setDate.setTimeInMillis(longObj);
        GregorianCalendar earlierDate = new GregorianCalendar();
        earlierDate.set(setDate.get(1), setDate.get(2), setDate.get(5), 0, 0, 0);
        long duration = laterDate.getTimeInMillis() - earlierDate.getTimeInMillis();
        long nDays = (duration + 3600000L) / 86400000L;
        return nDays;
    }

    public static Criteria getActionCriteria(String tableName, Long[] actionIds) {
        Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"ACTION_ID"), (Object)actionIds, 8);
        crit = crit.or(new Criteria(Column.getColumn((String)tableName, (String)"ACTION_ID"), null, 0));
        return crit;
    }

    public static String escapeDN(String string) {
        String[] DN_ESCAPE_CHARECTERS = new String[]{"/"};
        if (string == null) {
            return null;
        }
        return CommonUtil.escapeString(string, DN_ESCAPE_CHARECTERS);
    }

    public static String escapeString(String string, String[] escapeChars) {
        String escapedString = string;
        for (String s : escapeChars) {
            if (!escapedString.contains(s)) continue;
            escapedString = s.equalsIgnoreCase("\\") ? escapedString.replaceAll("\\\\", "\\\\\\\\") : escapedString.replaceAll(s, "\\\\" + s);
        }
        return escapedString;
    }

    public static String escapeSpecialCharacters(String string) {
        return StrUtil.ldapEscape(string);
    }

    public static String deEscapeString(String string, String[] escapeChars) {
        String escapedString = string;
        for (int i = 0; i < escapedString.length(); ++i) {
            Character sp = Character.valueOf(escapedString.charAt(i));
            if (!sp.equals(Character.valueOf('\\'))) continue;
            escapedString = escapedString.replace("\\", "");
        }
        System.out.println("De Escaped String : " + escapedString);
        return escapedString;
    }

    public static ArrayList getDomainUserDetails(String domain) {
        ArrayList<String> aL = new ArrayList<String>();
        try {
            String DOMAIN_CONFIG_TBL_NAME = "ADSMDomainConfiguration";
            Criteria criteria = new Criteria(Column.getColumn((String)DOMAIN_CONFIG_TBL_NAME, (String)"DOMAIN_NAME"), (Object)domain, 0, false);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(DOMAIN_CONFIG_TBL_NAME, criteria);
            Iterator iterator = dataObject.getRows(DOMAIN_CONFIG_TBL_NAME);
            Row row = (Row)iterator.next();
            String user = (String)row.get("USER_NAME");
            aL.add(user);
            String sPassword = (String)row.get("PASSWORD");
            aL.add(sPassword);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in getDomainUserDetails ");
            e.printStackTrace();
        }
        return aL;
    }

    public static String getSystemTimeFormat(Long systemTime) {
        String timeFormat = "-NA-";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
            if (systemTime != 0L) {
                timeFormat = sdf.format(new Date(systemTime));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timeFormat;
    }

    public static int getInstalledMachineCount() {
        return GinaReportUtil.getTotalSuccessInstallCount();
    }

    public static String getDomainNameFromDNS(String dnsName) {
        String tableName = "ADSMDomainConfiguration";
        try {
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl sq = new SelectQueryImpl(table);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_DNS_NAME"), (Object)dnsName, 0, false);
            sq.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Row row = dataObject.getFirstRow(tableName);
            return (String)row.get("DOMAIN_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String();
        }
    }

    public static String getDomainFunctionalLevel(String domainName, Long loginId) {
        try {
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, loginId, null);
            return domainDetails.getProperty("DOMAIN_FUNCTIONAL_LEVEL");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Long getAccountId(String loginName, String serviceName) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)loginName, 0, false);
        criteria = criteria.and(Column.getColumn((String)"AaaService", (String)"NAME"), (Object)serviceName, 0, false);
        DataObject dobj = null;
        try {
            dobj = DataAccess.get((String)"AaaAccount", (Criteria)criteria);
        }
        catch (Exception re) {
            throw new DataAccessException("Exception occured while fetching dataobject", (Throwable)re);
        }
        Row accRow = dobj.getFirstRow("AaaAccount");
        return (Long)accRow.get("ACCOUNT_ID");
    }

    public static void deleteFiles(String path) {
        try {
            File direc = new File(path);
            File[] files = direc.listFiles();
            for (int i = 0; i < files.length; ++i) {
                boolean deleted;
                if (!files[i].isFile() || (deleted = files[i].delete())) continue;
                logger.log(Level.INFO, "Error occurred while deleting the file :: " + files[i].getName());
            }
            direc.delete();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error occurred while deleting :: " + e);
        }
    }

    public static void executeCommand(String[] dumpcmd) throws Exception {
        boolean flag = false;
        Process p = Runtime.getRuntime().exec(dumpcmd);
        p.waitFor();
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String line = in.readLine();
        while (line != null) {
            logger.log(Level.INFO, line);
            line = in.readLine();
            flag = true;
        }
        if (flag) {
            throw new Exception("Unable to execute " + dumpcmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String path) {
        int BUFFER = 2048;
        BufferedInputStream origin = null;
        FileOutputStream dest = null;
        ZipOutputStream output = null;
        FileInputStream fi = null;
        try {
            String zipfile = path + ".zip";
            dest = new FileOutputStream(zipfile);
            output = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            File f = new File(path);
            String[] files = f.list();
            File[] f1 = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                int count;
                if (!f1[i].isFile()) continue;
                logger.log(Level.INFO, "Adding to Zip: " + files[i]);
                fi = new FileInputStream(f1[i]);
                origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(files[i]);
                output.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    output.write(data, 0, count);
                }
                fi.close();
                origin.close();
            }
            output.close();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error occurred while zipping:" + e);
            e.printStackTrace();
        }
        finally {
            try {
                output.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                origin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                dest.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                fi.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void unZip(String src, String dst) throws Exception {
        int BUFFER = 2048;
        FilterOutputStream dest = null;
        FileInputStream fis = null;
        ZipInputStream zis = null;
        FileOutputStream fos = null;
        try {
            ZipEntry entry;
            dest = null;
            fis = new FileInputStream(src);
            zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                logger.log(Level.INFO, "Extracting: " + entry);
                byte[] data = new byte[2048];
                String destname = dst + File.separator + entry.getName();
                fos = new FileOutputStream(destname);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    ((BufferedOutputStream)dest).write(data, 0, count);
                }
                ((BufferedOutputStream)dest).flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                fos.close();
                dest.close();
                zis.close();
                fis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isMSSQL() {
        String dbName = PersistenceInitializer.getConfigurationValue((String)"DBName");
        return dbName.equalsIgnoreCase("MSSQL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMySQL4() {
        Connection connection = null;
        boolean isMySQL4 = false;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            DatabaseMetaData dbm = connection.getMetaData();
            int dbVersion = dbm.getDatabaseMajorVersion();
            String dbName = dbm.getDatabaseProductName();
            logger.log(Level.INFO, "DB NAME : VERSION :::::::::::::::: " + dbName + ":" + dbVersion);
            if ("MySQL".equalsIgnoreCase(dbName) && dbVersion < 5) {
                isMySQL4 = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isMySQL4;
    }

    public static String getValidName(String name) {
        try {
            String dbServerName;
            if (Character.isDigit(name.charAt(0)) && !(dbServerName = PersistenceInitializer.getConfigurationValue((String)"DBName")).equalsIgnoreCase("mysql")) {
                name = new StringBuffer("_").append(name).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static void writeToFile(String fileName, String key, String value, boolean overWrite) {
        Properties props = new Properties();
        props.setProperty(key, value);
        CommonUtil.writePropsToFile(fileName, props, overWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePropsToFile(String fileName, Properties props, boolean overWrite) {
        logger.log(Level.INFO, "fileName : " + fileName + "\t Props : " + props);
        OutputStream out = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                logger.log(Level.INFO, "File not found : " + fileName);
                return;
            }
            out = new FileOutputStream(fileName, !overWrite);
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String configLine = "\n" + key + "=" + props.getProperty(key);
                out.write(configLine.getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void generateQrForSettingsConfiguration() {
        Boolean isMobileAccessHidden = Boolean.parseBoolean(ADSMPersUtil.getSyMParameter("HIDE_MACCESS_BUTTON"));
        if (!isMobileAccessHidden.booleanValue()) {
            String contextPath;
            Properties prop = new Properties();
            AgentSchedulerUtil.getAccessURLProperties(prop);
            String serverName = prop.get("SERVER_NAME").toString();
            String context = "";
            String string = contextPath = prop.get("CONTEXT") != null ? (String)prop.get("CONTEXT") : null;
            if (contextPath != null && !contextPath.equals("")) {
                serverName = serverName + contextPath;
            }
            String serverAccessURL = "adsspsettings://settings?serverName=" + serverName + "&serverPort=" + prop.get("PORT_NO") + "&serverProtocol=" + prop.getProperty("PROTOCOL");
            String imageDir = System.getProperty("server.home") + File.separator + "webapps" + File.separator + "adssp" + File.separator + "temp" + File.separator;
            String qrName = "adssp-settings-qr.png";
            int size = 140;
            CommonUtil.generateQRCode(serverAccessURL, qrName, imageDir, size);
        }
    }

    public static void generateQRCodeForMFA(String qrContent, String imageName) {
        String imageDir = System.getProperty("server.home") + File.separator + "webapps" + File.separator + "adssp" + File.separator + "temp" + File.separator + "mfa" + File.separator;
        String _qrContent = "adssponeauthcode=" + qrContent;
        CommonUtil.generateQRCode(_qrContent, imageName + ".png", imageDir, 110);
    }

    private static void createFolder(String dir) {
        File folder = new File(dir);
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    private static void generateQRCode(String qrContent, String imageName, String imgLocation, int qrSize) {
        String filePath = imgLocation + imageName;
        String fileType = "png";
        String data = "";
        try {
            CommonUtil.createFolder(imgLocation);
            File myFile = new File(filePath);
            data = new String(qrContent.getBytes(), "UTF8");
            Hashtable<EncodeHintType, String> hintMap = new Hashtable<EncodeHintType, String>();
            hintMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hintMap.put(EncodeHintType.ERROR_CORRECTION, (String)ErrorCorrectionLevel.L);
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix matrix = CommonUtil.encode(data, BarcodeFormat.QR_CODE, qrSize, qrSize, hintMap);
            int width = matrix.getWidth();
            BufferedImage image = new BufferedImage(width, width, 1);
            image.createGraphics();
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, width, width);
            graphics.setColor(Color.BLACK);
            for (int y = 0; y < width; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (!matrix.get(y, x)) continue;
                    graphics.fillRect(y, x, 1, 1);
                }
            }
            ImageIO.write((RenderedImage)image, "png", myFile);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        ErrorCorrectionLevel requestedECLevel;
        if (contents.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (format != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + format);
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + width + 'x' + height);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        int quietZone = 1;
        if (hints != null && (requestedECLevel = (ErrorCorrectionLevel)hints.get(EncodeHintType.ERROR_CORRECTION)) != null) {
            errorCorrectionLevel = requestedECLevel;
        }
        QRCode code = new QRCode();
        Encoder.encode((String)contents, (ErrorCorrectionLevel)errorCorrectionLevel, (Hashtable)hints, (QRCode)code);
        return CommonUtil.renderResult(code, width, height, quietZone);
    }

    private static BitMatrix renderResult(QRCode code, int width, int height, int quietZone) {
        ByteMatrix input = code.getMatrix();
        if (input == null) {
            throw new IllegalStateException();
        }
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + quietZone * 2;
        int qrHeight = inputHeight + quietZone * 2;
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        BitMatrix output = new BitMatrix(outputWidth, outputHeight);
        int inputY = 0;
        int outputY = topPadding;
        while (inputY < inputHeight) {
            int inputX = 0;
            int outputX = leftPadding;
            while (inputX < inputWidth) {
                if (input.get(inputX, inputY) == 1) {
                    output.setRegion(outputX, outputY, multiple, multiple);
                }
                ++inputX;
                outputX += multiple;
            }
            ++inputY;
            outputY += multiple;
        }
        return output;
    }

    public static ArrayList jsonArrayToArrayList(JSONArray arr) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (int i = 0; i < arr.length(); ++i) {
                list.add(arr.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String getFileContent(String filePath, String delimiter) {
        String ret = null;
        try {
            StringBuffer outBuf = new StringBuffer();
            File file = new File(filePath);
            FileReader fReader = new FileReader(file);
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8");
            BufferedReader bufRead = new BufferedReader(is);
            boolean startWrite = false;
            String line = bufRead.readLine();
            while (line != null) {
                if (delimiter != null && !delimiter.equals("")) {
                    if (line.contains(delimiter)) {
                        startWrite = true;
                    }
                    if (startWrite) {
                        outBuf.append(line);
                    }
                    if (line.contains("/" + delimiter)) {
                        startWrite = false;
                    }
                } else {
                    outBuf.append(line);
                }
                line = bufRead.readLine();
            }
            bufRead.close();
            ret = outBuf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map getHostDetails(HttpServletRequest request, String input) {
        String host = input;
        String ip = input;
        HashMap<String, String> result = new HashMap<String, String>();
        HttpSession session = request.getSession();
        String hostName = (String)session.getAttribute("HOST_NAME");
        String ipAddress = (String)session.getAttribute("IP_ADDRESS");
        if (hostName != null && !hostName.equals("") && ipAddress != null && !ipAddress.equals("")) {
            result.put("ip", ipAddress);
            result.put("host", hostName);
            return result;
        }
        try {
            InetAddress addr;
            block10: {
                block9: {
                    addr = InetAddress.getByName(input);
                    if (addr.isAnyLocalAddress()) break block9;
                    if (!addr.isLoopbackAddress()) break block10;
                }
                addr = addr.getLocalHost();
                host = addr.getCanonicalHostName();
                ip = "127.0.0.1";
                return result;
            }
            host = addr.getCanonicalHostName();
            ip = addr.getHostAddress();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        finally {
            result.put("ip", ip);
            result.put("host", host);
            session.setAttribute("HOST_NAME", (Object)host);
            session.setAttribute("IP_ADDRESS", (Object)ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map getHostDetails(String input) {
        String host = input;
        String ip = input;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            InetAddress addr;
            block8: {
                block7: {
                    addr = InetAddress.getByName(input);
                    if (addr.isAnyLocalAddress()) break block7;
                    if (!addr.isLoopbackAddress()) break block8;
                }
                host = addr.getLocalHost().getCanonicalHostName();
                ip = "127.0.0.1";
                return result;
            }
            host = addr.getCanonicalHostName();
            ip = addr.getHostAddress();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        finally {
            result.put("ip", ip);
            result.put("host", host);
        }
    }

    public static String getIPAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-FORWARDED-FOR") != null ? request.getHeader("X-FORWARDED-FOR") : request.getRemoteAddr();
        try {
            InetAddress inetAddr;
            if (ipAddress.contains(",")) {
                Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
                String[] remoteIpHeaderValue = commaSeparatedValuesPattern.split(ipAddress);
                ipAddress = remoteIpHeaderValue[0];
            }
            String ipv4Pattern = "((([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])):(\\d+)\\s*";
            Pattern VALID_IPV4_PATTERN = null;
            VALID_IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
            Matcher mp = VALID_IPV4_PATTERN.matcher(ipAddress);
            if (mp.matches()) {
                ipAddress = mp.group(1);
            }
            if ((inetAddr = InetAddress.getByName(ipAddress)).isLoopbackAddress()) {
                ipAddress = request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            ipAddress = request.getRemoteAddr();
            e.printStackTrace();
        }
        return ipAddress;
    }

    public static List getAllCountries() {
        String[] countries = Locale.getISOCountries();
        ArrayList<String> countryList = new ArrayList<String>();
        for (int i = 0; i < countries.length; ++i) {
            Locale locale = new Locale("en", countries[i]);
            countryList.add(locale.getDisplayCountry());
        }
        Collections.sort(countryList);
        return countryList;
    }

    public static void updateDemoQuoteStatus(int status) {
        try {
            ADSMPersUtil.updateSyMParameter(DEMO_QUOTE_STATUS, String.valueOf(status));
            ADSMPersUtil.updateSyMParameter(DEMO_QUOTE_TIME, String.valueOf(System.currentTimeMillis()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getDemoQuoteProperties(Long loginID, HttpServletRequest request) {
        JSONObject demoQuoteProps = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            String demoQuoteStatus = ADSMPersUtil.getSyMParameter(DEMO_QUOTE_STATUS);
            String installTimeStr = ADSMPersUtil.getSyMParameter("INSTALL_TIME");
            if (demoQuoteStatus == null) {
                CommonUtil.updateDemoQuoteStatus(DEMO_QUOTE_STATE.DEMO_QUOTE_NONE.ordinal());
                demoQuoteStatus = ADSMPersUtil.getSyMParameter(DEMO_QUOTE_STATUS);
            }
            int status = Integer.valueOf(demoQuoteStatus);
            Long demoQuoteTime = Long.valueOf(ADSMPersUtil.getSyMParameter(DEMO_QUOTE_TIME));
            Long installTime = System.currentTimeMillis();
            if (installTimeStr != null) {
                installTime = Long.valueOf(installTimeStr);
            }
            Long currentTime = System.currentTimeMillis();
            Long dateDiff = currentTime - installTime;
            float fDays = dateDiff / 86400000L;
            long noOfDays = (long)fDays;
            boolean showPriceQuote = false;
            boolean showForm = true;
            boolean showExtendTrial = false;
            if (noOfDays > 15L) {
                showPriceQuote = true;
            }
            String licenseMsg = LicenseUtil.getLicenseStatus(request);
            ArrayList sspRoles = TechnicianUtil.getRolesForId(loginID);
            if (!sspRoles.contains("Operator") && LicenseManager.getInstance().isTrial()) {
                if (status != DEMO_QUOTE_STATE.DEMO_QUOTE_NONE.ordinal()) {
                    dateDiff = currentTime - demoQuoteTime;
                    fDays = dateDiff / 86400000L;
                    long noDays = (long)fDays;
                    showForm = false;
                    if (noDays >= 2L && (status == DEMO_QUOTE_STATE.DEMO_REJECTED.ordinal() || status == DEMO_QUOTE_STATE.QUOTE_REJECTED.ordinal() || status == DEMO_QUOTE_STATE.DEMO_ACCEPT.ordinal())) {
                        showPriceQuote = true;
                        showForm = true;
                        if (status == DEMO_QUOTE_STATE.DEMO_REJECTED.ordinal() && noOfDays <= 15L) {
                            showPriceQuote = false;
                        }
                    }
                }
            } else if (!sspRoles.contains("Operator") && noOfDays > 30L && noOfDays <= 45L && LicenseUtil.isTrialExpired()) {
                if (status != DEMO_QUOTE_STATE.EXTEND_TRIAL_REJECTED.ordinal() && status != DEMO_QUOTE_STATE.EXTEND_TRIAL_ACCEPT.ordinal()) {
                    showExtendTrial = true;
                    showForm = true;
                }
            } else {
                showForm = false;
            }
            demoQuoteProps.put("ShowForm", showForm);
            demoQuoteProps.put("ShowPriceQuote", showPriceQuote);
            demoQuoteProps.put("ShowExtendTrial", showExtendTrial);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return demoQuoteProps;
    }

    public static boolean isNetworkAvailable(String serverURL) {
        boolean networkAvailable = false;
        try {
            URL urlObj = new URL(serverURL);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                networkAvailable = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, " Exception while checking for Network Availability ");
        }
        logger.log(Level.INFO, " Network Availability :: " + networkAvailable);
        return networkAvailable;
    }

    public static void setHttpOnly(HttpServletResponse response, String cookieName) {
        if (!"true".equalsIgnoreCase(ADSMPersUtil.getSyMParameter("ENABLE_HTTPONLY"))) {
            return;
        }
        Collection head = response.getHeaders("Set-Cookie");
        Object[] headers = head.toArray();
        for (int i = 0; i < headers.length; ++i) {
            String cookieObject = String.valueOf(headers[i]);
            if (!cookieObject.contains(cookieName)) continue;
            String cookieValue = cookieObject.substring(cookieObject.indexOf(cookieName + "=") + (cookieName + "=").length(), cookieObject.indexOf(";"));
            response.addHeader("SET-COOKIE", cookieObject + "; HttpOnly");
        }
    }

    public static enum DEMO_QUOTE_STATE {
        DEMO_QUOTE_NONE,
        DEMO_ACCEPT,
        DEMO_REJECTED,
        QUOTE_ACCEPT,
        QUOTE_REJECTED,
        EXTEND_TRIAL_ACCEPT,
        EXTEND_TRIAL_REJECTED;

    }
}

