/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class CreateProcess
extends Thread {
    public boolean finished = false;
    private String[] cmdsArray;
    private long timeOut = 120000L;
    private StringBuffer outputStrBuffer = new StringBuffer();
    private StringBuffer errorStrBuffer = new StringBuffer();

    public CreateProcess(String[] commands) {
        super(commands[0] + commands[1]);
        this.cmdsArray = commands;
    }

    @Override
    public void run() {
        this.createAndRunProcess();
        this.finished = true;
    }

    private void createAndRunProcess() {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            int counter = 0;
            String[] modArr = new String[this.cmdsArray.length + 2];
            modArr[0] = "cmd";
            modArr[1] = "/C";
            modArr[2] = this.cmdsArray[0];
            for (String command : this.cmdsArray) {
                if (counter != 0) {
                    String envName = "ADSSP_" + counter;
                    env.put(envName, command);
                    modArr[counter + 2] = "%" + envName + "%";
                }
                ++counter;
            }
            ProcessBuilder pb = new ProcessBuilder(modArr);
            Map<String, String> pbEnv = pb.environment();
            pbEnv.putAll(env);
            Process proc = pb.start();
            this.getStream("OutputStream", proc);
            this.getStream("ErrorStream", proc);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setBuffer("ErrorStream", "The specified command could not be executed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getStream(String bufferName, Process proc) {
        String bufferValue = null;
        long initialTime = System.currentTimeMillis();
        InputStream inpStr = bufferName.equals("OutputStream") ? proc.getInputStream() : proc.getErrorStream();
        BufferedReader tst = new BufferedReader(new InputStreamReader(inpStr));
        block15: while (true) {
            while (true) {
                if (!tst.ready()) {
                    try {
                        proc.exitValue();
                        return;
                    }
                    catch (IllegalThreadStateException itse) {
                        try {
                            Thread.sleep(100L);
                            if (!this.stopProcess(proc, initialTime)) continue block15;
                            return;
                        }
                        catch (InterruptedException ex) {
                            continue;
                        }
                    }
                }
                bufferValue = tst.readLine();
                this.setBuffer(bufferName, bufferValue);
                if (this.stopProcess(proc, initialTime)) return;
            }
            break;
        }
        catch (IOException e) {
            this.setBuffer(bufferName, "Error running command: " + e);
            return;
        }
        finally {
            if (tst != null) {
                try {
                    tst.close();
                }
                catch (IOException iee) {
                    iee.printStackTrace();
                }
            }
        }
    }

    private void setBuffer(String bufferName, String bufferValue) {
        if (bufferName.equals("OutputStream")) {
            this.outputStrBuffer = this.outputStrBuffer.append(bufferValue).append(".");
        } else {
            this.errorStrBuffer = this.errorStrBuffer.append(bufferValue).append(".");
        }
    }

    private String getBuffer(String bufferName) {
        return bufferName.equals("OutputStream") ? this.outputStrBuffer.toString() : this.errorStrBuffer.toString();
    }

    public String getOutputStream() {
        return this.getBuffer("OutputStream");
    }

    public String getErrorStream() {
        return this.getBuffer("ErrorStream");
    }

    private boolean stopProcess(Process proc, long initialTime) {
        if (System.currentTimeMillis() - initialTime > this.timeOut) {
            this.setBuffer("ErrorStream", "adssp.configuration.gina.install_fail_time_exceeds");
            proc.destroy();
            this.stop();
            return true;
        }
        return false;
    }
}

