/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;

public class CustomPolicyUtil {
    public static void writePwdPolicy(String domainName, Properties pwdProps) {
        try {
            String productHomeDir = System.getProperty("server.home");
            Object localeId = null;
            String fileName = CommonUtil.getDomainTableName(domainName) + "_PasswordPolicy.html";
            File pwdFile = new File(productHomeDir + File.separator + "webapps" + File.separator + "adssp" + File.separator + "html" + File.separator + fileName);
            String editPolicy = ADSMPersUtil.getSyMParameter("editPwdPolicy");
            boolean allowFileWrite = false;
            if (!pwdFile.exists()) {
                pwdFile.createNewFile();
                allowFileWrite = true;
            } else if ("false".equalsIgnoreCase(editPolicy)) {
                allowFileWrite = true;
            }
            if (allowFileWrite) {
                FileOutputStream pwdFilestream = new FileOutputStream(productHomeDir + File.separator + "webapps" + File.separator + "adssp" + File.separator + "html" + File.separator + fileName);
                OutputStreamWriter osr = new OutputStreamWriter((OutputStream)pwdFilestream, "UTF-8");
                BufferedWriter out = new BufferedWriter(osr);
                out.write(CustomPolicyUtil.getPwdPolicy(pwdProps));
                out.close();
                osr.close();
                pwdFilestream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long getMaxPwdAge(ArrayList psoList, String domainName) {
        long maxPwdAge = 0L;
        if (psoList != null) {
            String resultantPSO = (String)psoList.get(0);
            long maxPwdAgeTime = DomainHandler.getPSOProp(domainName, resultantPSO, "MAX_PWD_AGE");
            if ((maxPwdAgeTime = -1L * maxPwdAgeTime) != Long.MIN_VALUE) {
                maxPwdAge = maxPwdAgeTime / 10000L;
            }
        } else {
            Properties policy = DomainHandler.getPolicies(domainName, 1L);
            maxPwdAge = Long.parseLong(policy.getProperty("maxPwdAge"));
            maxPwdAge = maxPwdAge * 24L * 60L * 60L * 1000L;
        }
        return maxPwdAge;
    }

    private static String getPwdPolicy(Properties pwdProps) {
        StringBuffer sb = new StringBuffer("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"5\" class=\"normalFont fntSize fntFamily\">");
        String[] policyMsg = new String[]{"${adssp.domain_user.change_pwd.policy_req.min_pwd_age}", "${adssp.domain_user.change_pwd.policy_req.maxi_pwd_age}", "${adssp.domain_user.change_pwd.policy_req.min_pwd_length}", "${adssp.domain_user.change_pwd.policy_req.pwd_history}", "${adssp.domain_user.change_pwd.policy_req.pwd_complex_info}"};
        for (int i = 0; i < policyMsg.length; ++i) {
            if (i == 0) {
                sb.append("<tr>");
                sb.append("<td colspan=\"2\" class=\"normalBoldFont alignLeft\">${adssp.custom.password.policy.policy_requirements}</td></tr>");
            }
            String policyName = DomainHandler.policyNames[i];
            String policyValue = (String)pwdProps.get(policyName);
            if ("pwdProperties".equals(policyName)) {
                policyValue = policyValue.equals("0") ? "${adssp.admin.common.text.disabled}" : "${adssp.admin.common.text.enabled}";
            }
            if (policyValue == null || policyValue.length() == 0) continue;
            sb.append("<tr>");
            sb.append("<td width=\"5\"><div class=\"common-bgcolor dotBg\" ><span class=\"dot blockElement\"></span></div></td>");
            sb.append("<td class=\"alignLeft\">");
            sb.append(policyMsg[i] + " " + policyValue);
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    public static String getPwdPolicy(String domainName, String psoName) {
        return CustomPolicyUtil.getPwdPolicy(DomainHandler.getPSOProp(domainName, psoName));
    }
}

