/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.reports.ReportQueue;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;

public class DBObjectUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdate(String baseTableName, String keyColumnName, ArrayList guidList, Hashtable tableRowMap, Hashtable relationalMap) {
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            String[] guids = new String[guidList.size()];
            for (int i = 0; i < guidList.size(); ++i) {
                guids[i] = (String)guidList.get(i);
            }
            Column col = new Column(baseTableName, keyColumnName);
            Criteria crit = new Criteria(col, (Object)guids, 8);
            ReportQueue.reportLogger.log(Level.INFO, "Checking the old Values for the table to the SIDs Count " + guidList.size());
            DataObject baseDataObj = CommonUtil.getPersistence(new boolean[0]).get(baseTableName, crit);
            DBObjectUtil.add(baseDataObj, baseTableName, tableRowMap);
            DBObjectUtil.processTables(baseTableName, keyColumnName, guids, tableRowMap);
            DBObjectUtil.processRTTables(keyColumnName, guids, relationalMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void processTables(String baseTableName, String keyColumnName, String[] guids, Hashtable h) {
        try {
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String tableName = (String)e.nextElement();
                if (tableName.equalsIgnoreCase(baseTableName)) continue;
                Criteria crit = new Criteria(new Column(tableName, keyColumnName), (Object)guids, 8);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                DBObjectUtil.add(dataObj, tableName, h);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processRTTables(String keyColumnName, String[] guids, Hashtable h) {
        try {
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String tableName = (String)e.nextElement();
                Criteria crit = new Criteria(new Column(tableName, keyColumnName), (Object)guids, 8);
                CommonUtil.getPersistence(new boolean[0]).delete(crit);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                ArrayList list = (ArrayList)h.get(tableName);
                for (int i = 0; i < list.size(); ++i) {
                    Row r = (Row)list.get(i);
                    Row row = obj.getRow(tableName, r);
                    if (row != null) continue;
                    obj.addRow(r);
                }
                ReportQueue.reportLogger.log(Level.INFO, "Adding the new Values to the table " + tableName);
                CommonUtil.getPersistence(new boolean[0]).add(obj);
                ReportQueue.reportLogger.log(Level.INFO, "After adding the new Values to the table" + tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void add(DataObject obj, String tableName, Hashtable h) {
        try {
            ArrayList list = (ArrayList)h.get(tableName);
            for (int i = 0; i < list.size(); ++i) {
                Row r = (Row)list.get(i);
                Row oldRow = obj.getRow(tableName, r);
                if (oldRow == null) {
                    DBObjectUtil.updateLLT(r, tableName);
                    obj.addRow(r);
                    continue;
                }
                DBObjectUtil.updateRowValues(oldRow, r, tableName);
                obj.updateRow(oldRow);
            }
            ReportQueue.reportLogger.log(Level.INFO, "Adding the new Values to the table " + tableName);
            CommonUtil.getPersistenceLite().update(obj);
            ReportQueue.reportLogger.log(Level.INFO, "After adding the new Values to the table" + tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateLLT(Row newRow, String tableName) {
        block4: {
            try {
                int[] changedColumns = newRow.getChangedColumnIndex();
                int lastLogonIndex = MetaDataUtil.getTableDefinitionByName((String)tableName).getColumnIndex("LAST_LOGON_TIME");
                int lastLogonTimestampIndex = MetaDataUtil.getTableDefinitionByName((String)tableName).getColumnIndex("LAST_LOGON_TIMESTAMP");
                int domainControllerIndex = MetaDataUtil.getTableDefinitionByName((String)tableName).getColumnIndex("DOMAIN_CONTROLLER_NAME");
                if (changedColumns == null) break block4;
                for (int i = 0; i < changedColumns.length; ++i) {
                    if (changedColumns[i] != lastLogonIndex && changedColumns[i] != lastLogonTimestampIndex) continue;
                    long newLLT = (Long)newRow.get(lastLogonIndex);
                    long newLLTS = (Long)newRow.get(lastLogonTimestampIndex);
                    String dcLatest = (String)newRow.get("DOMAIN_CONTROLLER_NAME");
                    if (newLLT < newLLTS) {
                        newLLT = newLLTS;
                    }
                    newRow.set(lastLogonIndex, (Object)new Long(newLLT));
                    newRow.set(lastLogonTimestampIndex, (Object)new Long(newLLT));
                    newRow.set("DOMAIN_CONTROLLER_NAME", (Object)dcLatest);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateRowValues(Row oldRow, Row newRow, String tableName) {
        try {
            int[] changedColumns = newRow.getChangedColumnIndex();
            int lastLogonIndex = MetaDataUtil.getTableDefinitionByName((String)tableName).getColumnIndex("LAST_LOGON_TIME");
            int lastLogonTimestampIndex = MetaDataUtil.getTableDefinitionByName((String)tableName).getColumnIndex("LAST_LOGON_TIMESTAMP");
            int domainControllerIndex = MetaDataUtil.getTableDefinitionByName((String)tableName).getColumnIndex("DOMAIN_CONTROLLER_NAME");
            for (int i = 0; i < changedColumns.length; ++i) {
                if (changedColumns[i] == lastLogonIndex || changedColumns[i] == lastLogonTimestampIndex) {
                    DBObjectUtil.checkNewValues(oldRow, newRow, lastLogonIndex, lastLogonTimestampIndex);
                    continue;
                }
                if (changedColumns[i] == domainControllerIndex) continue;
                Object obj = newRow.get(changedColumns[i]);
                oldRow.set(changedColumns[i], obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkNewValues(Row oldRow, Row newRow, int lastLogonIndex, int lastLogonTimestampIndex) {
        long oldVal = (Long)oldRow.get(lastLogonIndex);
        long newLLT = (Long)newRow.get(lastLogonIndex);
        long newLLTS = (Long)newRow.get(lastLogonTimestampIndex);
        String dcLatest = (String)newRow.get("DOMAIN_CONTROLLER_NAME");
        String dcOldest = (String)oldRow.get("DOMAIN_CONTROLLER_NAME");
        if (newLLT < newLLTS) {
            newLLT = newLLTS;
        }
        if (newLLT < oldVal) {
            newLLT = oldVal;
        } else {
            oldRow.set("DOMAIN_CONTROLLER_NAME", (Object)dcLatest);
        }
        oldRow.set(lastLogonIndex, (Object)new Long(newLLT));
        oldRow.set(lastLogonTimestampIndex, (Object)new Long(newLLT));
    }
}

