/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.customview.CustomViewManager;
import com.adventnet.customview.CustomViewRequest;
import com.adventnet.customview.ViewData;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.model.table.CVTableModel;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBUtil {
    private static Logger logger = Logger.getLogger(DBUtil.class.getName());
    private static CustomViewManager cvMgr = null;
    private static String[] noBackupTables = new String[]{"ADSMUserReportResult"};

    public static CustomViewManager getCVManager() {
        if (cvMgr != null) {
            return cvMgr;
        }
        try {
            cvMgr = (CustomViewManager)BeanUtil.lookup((String)"TableViewManager");
            return cvMgr;
        }
        catch (Exception me) {
            me.printStackTrace();
            return null;
        }
    }

    public static CVTableModel getTableModel(SelectQuery sqImpl) throws Exception {
        CVTableModel model = null;
        CustomViewManager cvMgr = DBUtil.getCVManager();
        ViewData viewData = cvMgr.getData(new CustomViewRequest(sqImpl));
        logger.log(Level.FINEST, "View Data : {0}", viewData);
        model = (CVTableModel)viewData.getModel();
        return model;
    }

    public static void closeQuietly(Connection conn, DataSet dataSet) {
        if (dataSet != null) {
            try {
                dataSet.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Object convert(String value, int type) {
        if (type == 4 || type == -6) {
            return Integer.parseInt(value);
        }
        if (type == -5) {
            return Long.parseLong(value);
        }
        if (type == 16) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }

    public static Object convert(String value, String type) throws Exception {
        if (type.equals("BOOLEAN") && value.equals("1")) {
            return Boolean.TRUE;
        }
        return MetaDataUtil.convert((String)value, (String)type);
    }

    public static ArrayList<String> getExcludedTableList() {
        ArrayList<String> excludeList = new ArrayList<String>();
        for (String table : noBackupTables) {
            excludeList.add(table);
        }
        return excludeList;
    }
}

