/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import java.net.InetAddress;
import java.util.Hashtable;

public class DNSIPCache {
    private static DNSIPCache handler = null;
    private Hashtable<String, String> cache = new Hashtable();

    private DNSIPCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DNSIPCache getInstance() {
        if (handler != null) return handler;
        Class<DNSIPCache> clazz = DNSIPCache.class;
        synchronized (DNSIPCache.class) {
            handler = new DNSIPCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public String getIP(String dns) {
        if (this.cache.get(dns) != null) {
            return this.cache.get(dns);
        }
        GetIP ip = new GetIP(dns);
        ip.start();
        long t = System.currentTimeMillis();
        try {
            while (this.cache.get(dns) == null) {
                Thread.sleep(5L);
                if (System.currentTimeMillis() - t <= 1000L) continue;
                this.cache.put(dns, "-");
                ip.stop();
                break;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return this.cache.get(dns);
    }

    public String getIPFromCache(String machineName) {
        return this.cache.get(machineName);
    }

    class GetIP
    extends Thread {
        public String ip = null;
        public String dns = null;

        public GetIP() {
        }

        public GetIP(String dns) {
            this.dns = dns;
        }

        @Override
        public void run() {
            try {
                InetAddress inet = InetAddress.getByName(this.dns);
                this.ip = inet.getHostAddress();
                DNSIPCache.this.cache.put(this.dns, this.ip);
            }
            catch (Exception e) {
                DNSIPCache.this.cache.put(this.dns, "-");
            }
        }
    }
}

