/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.manageengine.ads.fw.tree.DirectoryObjectTreeModel;
import com.manageengine.ads.fw.tree.DirectoryObjectTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DirectoryObjectUtil {
    public static DirectoryObject getDirectoryObject(String nodeClicked, HttpServletRequest request, String attrib) {
        HttpSession session = request.getSession();
        DirectoryObjectTreeModel model = (DirectoryObjectTreeModel)session.getAttribute(attrib);
        DirectoryObject object = (DirectoryObject)((DirectoryObjectTreeNode)model.getRoot()).getUserObject();
        DirectoryObject obj = DirectoryObjectUtil.getDirectoryObject(nodeClicked, object);
        return obj;
    }

    public static DirectoryObject getDirectoryObject(String nodeClicked, DirectoryObject object) {
        if (object.getID().equals(nodeClicked)) {
            return object;
        }
        ArrayList childList = object.getChildObjectList();
        if (childList.size() > 0) {
            for (int i = 0; i < childList.size(); ++i) {
                DirectoryObject childObject = (DirectoryObject)childList.get(i);
                DirectoryObject obj = DirectoryObjectUtil.getDirectoryObject(nodeClicked, childObject);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    public static ArrayList getParentOUs(ArrayList l) {
        ArrayList list = (ArrayList)l.clone();
        block0: for (int i = 0; i < list.size(); ++i) {
            String s1 = ((String)list.get(i)).toLowerCase();
            for (int j = i + 1; j < list.size(); ++j) {
                String s2 = ((String)list.get(j)).toLowerCase();
                if (s1.endsWith(s2)) {
                    list.remove(i);
                    --i;
                    continue block0;
                }
                if (!s2.endsWith(s1)) continue;
                list.remove(j);
                --i;
                continue block0;
            }
        }
        return list;
    }

    public static DirectoryObject getDirectoryObject(String domainName, Long loginId, String rootPath, ArrayList ouList) throws Exception {
        return DirectoryObjectUtil.getDirectoryObject(domainName, loginId, rootPath, ouList, "false");
    }

    public static DirectoryObject getDirectoryObject(String domainName, Long loginId, String rootPath, ArrayList ouList, String isGuidPassed) throws Exception {
        DirectoryObject object = null;
        try {
            if (ouList == null || ouList.size() == 0) {
                object = (DirectoryObject)ADHandler.getDomainObject(domainName, loginId, rootPath, isGuidPassed);
            } else {
                object = new DirectoryObject();
                ArrayList ous = DirectoryObjectUtil.getParentOUs(ouList);
                ArrayList ouProps = OUUtil.getOUProps(domainName, ous);
                Properties childs = new Properties();
                for (int i = 0; i < ouProps.size(); ++i) {
                    Properties p = (Properties)ouProps.get(i);
                    DirectoryObject child = new DirectoryObject();
                    child.setName(p.getProperty("OU_NAME"));
                    child.setRelativeName(p.getProperty("DISTINGUISHED_NAME"));
                    child.setGuid(p.getProperty("OBJECT_GUID"));
                    child.setObjectClass("organizationalUnit");
                    child.setIsLeaf(false);
                    child.setIsContainer(true);
                    String key = isGuidPassed.equalsIgnoreCase("true") ? p.getProperty("OBJECT_GUID") : p.getProperty("DISTINGUISHED_NAME");
                    childs.put(key, child);
                }
                object.setName(domainName);
                object.setRelativeName(rootPath);
                object.setObjectClass("domainDNS");
                object.setChildObjects(childs);
                object.setIsLeaf(false);
                object.setIsContainer(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return object;
    }

    public static DirectoryObject getObject(DirectoryObject object, String dn) {
        Properties childObjects = object.getChildObjects();
        DirectoryObject ret = null;
        if (childObjects != null) {
            Enumeration<Object> e = childObjects.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                DirectoryObject obj = (DirectoryObject)childObjects.get(key);
                if (key.equalsIgnoreCase(dn)) {
                    return obj;
                }
                ret = DirectoryObjectUtil.getObject(obj, dn);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    public static void getDirectoryObject(DirectoryObject object, String dn, Properties selectedDomain, Long loginId, String isGuidPassed) {
        try {
            DirectoryObject directoryObject = DirectoryObjectUtil.getObject(object, dn);
            if (directoryObject != null && directoryObject.getChildObjects() == null) {
                DirectoryObject childObject = (DirectoryObject)ADHandler.getDomainObject(selectedDomain.getProperty("DOMAIN_NAME"), loginId, dn, isGuidPassed);
                directoryObject.setChildObjects(childObject.getChildObjects());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getOpenNodes(ArrayList selOUs) {
        ArrayList<String> openNode = new ArrayList<String>();
        try {
            if (selOUs == null) {
                return openNode;
            }
            for (int i = 0; i < selOUs.size(); ++i) {
                String dN = (String)selOUs.get(i);
                String[] dNArr = dN.split("OU=");
                if (dNArr.length <= 2) continue;
                int cI = dN.length();
                for (int j = 2; j < dNArr.length; ++j) {
                    int ouIndex = dN.lastIndexOf("OU=", cI);
                    String dNStr = dN.substring(ouIndex, dN.length());
                    if (!openNode.contains(dNStr)) {
                        openNode.add(dNStr);
                    }
                    cI = ouIndex - 1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return openNode;
    }
}

