/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.iam.security.SecurityRequestWrapper;
import com.adventnet.iam.security.UploadedFileItem;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.json.JSONObject;

public class DirectoryUtil {
    private static String fileDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adssp" + File.separator;
    private static Logger logger = Logger.getLogger("DirectoryUtil");

    public static String setAttachments(JSONObject fileSettings, HttpServletRequest request) {
        String prodHome = "-NA-";
        try {
            String tableName = fileSettings.getString("TABLE_NAME");
            Column col = Column.getColumn((String)tableName, (String)"SCHEDULE_ID");
            Criteria criteria = new Criteria(col, (Object)new Long(fileSettings.getString("SCHEDULE_ID")), 0);
            String path = "mail_attachments/scheduler/";
            String folderName = "-";
            String dirExistence = fileSettings.getString("DIR_EXIST");
            String FileNames = fileSettings.getString("STORE_FILES");
            String[] fileList = FileNames.split(";;;");
            if ("false".equalsIgnoreCase(dirExistence)) {
                folderName = Long.toString(System.nanoTime());
                prodHome = new File(System.getProperty("server.home")).getAbsolutePath();
                prodHome = prodHome.replaceFirst("\\\\bin\\\\..", "\\\\webapps\\\\adssp\\\\mail_attachments\\\\scheduler\\\\" + folderName);
                logger.log(Level.INFO, "Destination Folder: " + prodHome);
                if (prodHome != null && !prodHome.equals("")) {
                    File f = new File(prodHome);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    prodHome = "mail_attachments\\\\scheduler\\\\" + folderName;
                }
            } else {
                folderName = fileSettings.getString("FOLDER_NAME");
            }
            path = path + folderName + "/";
            DirectoryUtil.moveFiles(fileList, path, request, "MAIL_ATTACHMENTS_IN");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in Folder Creation::" + e);
            e.printStackTrace();
        }
        return prodHome;
    }

    public static void moveFiles(String[] fileNames, String dirPath, HttpServletRequest request, String parameter) {
        try {
            request = (HttpServletRequest)((MultipartRequestWrapper)request).getRequest();
            ArrayList<Object> fileName = new ArrayList();
            ArrayList<File> formFile = DirectoryUtil.getFilesFromRequest(request, parameter);
            if (formFile.get(0) != null) {
                fileName = DirectoryUtil.getUploadedFileNames(request, parameter);
            }
            block2: for (int k = 0; k < fileNames.length; ++k) {
                for (int i = 0; i < formFile.size(); ++i) {
                    if (formFile.get(i) == null || formFile.get(i).getName() == null || formFile.get(i).getName().length() <= 0) continue;
                    logger.log(Level.FINE, "Filelist: " + fileNames[k] + " FileName Fetched:" + (String)fileName.get(i));
                    if (!StrUtil.decodeURIComponent(fileNames[k]).equals(fileName.get(i))) continue;
                    String filestore = DirectoryUtil.storeFile(formFile.get(i), (String)fileName.get(i), dirPath);
                    logger.log(Level.FINE, "Storage Path: " + filestore);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String storeFile(File formFile, String ... args) throws Exception {
        FileOutputStream fout = null;
        FileInputStream fileInput = null;
        try {
            File saveDir;
            fileInput = new FileInputStream(formFile);
            byte[] file = new byte[((InputStream)fileInput).available()];
            ((InputStream)fileInput).read(file);
            String fileLocation = fileDir;
            if (!"".equals(args[1])) {
                fileLocation = fileDir + args[1];
            }
            if (!(saveDir = new File(fileLocation)).exists()) {
                saveDir.mkdirs();
            }
            logger.log(Level.INFO, "Stored location :: " + fileLocation + " :: " + args[0]);
            File writeFile = new File(fileLocation + args[0]);
            fout = new FileOutputStream(writeFile);
            fout.write(file);
            String string = args[1] + args[0];
            return string;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fileInput != null) {
                try {
                    ((InputStream)fileInput).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ArrayList<String> getUploadedFileNames(HttpServletRequest request, String paramName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            SecurityRequestWrapper secrequest = (SecurityRequestWrapper)request;
            List item = secrequest.getMultipartParameters(paramName);
            for (int i = 0; i < item.size(); ++i) {
                if (item.get(i) == null) continue;
                fileNames.add(((UploadedFileItem)item.get(i)).getFileName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileNames;
    }

    public static ArrayList<File> getFilesFromRequest(HttpServletRequest request, String paramName) {
        ArrayList<File> file = new ArrayList<File>();
        try {
            SecurityRequestWrapper secrequest = (SecurityRequestWrapper)request;
            List item = secrequest.getMultipartParameters(paramName);
            for (int i = 0; i < item.size(); ++i) {
                if (item.get(i) == null) continue;
                file.add(((UploadedFileItem)item.get(i)).getUploadedFile());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }
}

