/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.reports.enrollment.EnrollHandler;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.GroupUtil;
import com.adventnet.taskengine.Scheduler;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnrollmentReminderUtil {
    private static Logger logger = Logger.getLogger(EnrollmentReminderUtil.class.toString());

    public static String setOUsForPolicy(Long policyId, ArrayList<String> ouList) {
        String domainName = null;
        Criteria crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"POLICY_ID"), (Object)policyId, 0);
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("PolicyCriteria", crit);
            if (!dataObj.isEmpty()) {
                Iterator iter = dataObj.getRows("PolicyCriteria");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    ouList.add((String)row.get("DISTINGUISHED_NAME"));
                    if (domainName != null) continue;
                    domainName = (String)row.get("DOMAIN_NAME");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    public static void updateCalendarTable(Long schedId) {
        try {
            logger.log(Level.INFO, "updateCalendarTable method invoked");
            Criteria criteria = new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)schedId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("Calendar", criteria);
            if (!dataObject.isEmpty()) {
                Row calendarRow = dataObject.getRow("Calendar");
                Calendar currentTime = Calendar.getInstance();
                Long tempScheduleTime = new Long(currentTime.get(11) * 60 * 60 + currentTime.get(12) * 60 + currentTime.get(13) + 5);
                logger.log(Level.INFO, "Current Time :: " + currentTime + " and tempScheduleTime :: " + tempScheduleTime + " :: MONTH : " + currentTime.get(2));
                calendarRow.set("DATE_OF_MONTH", (Object)currentTime.get(5));
                calendarRow.set("MONTH_OF_YEAR", (Object)currentTime.get(2));
                calendarRow.set("YEAR_OF_DECADE", (Object)currentTime.get(1));
                calendarRow.set("REPEAT_FREQUENCY", (Object)"None");
                calendarRow.set("DAY_OF_WEEK", (Object)-1);
                calendarRow.set("SKIP_FREQUENCY", (Object)0);
                calendarRow.set("UNIT_OF_TIME", (Object)"Seconds");
                calendarRow.set("TIME_OF_DAY", (Object)tempScheduleTime);
                calendarRow.set("TZ", (Object)TimeZone.getDefault().getID());
                dataObject.updateRow(calendarRow);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "updateCalendarTable method Ends");
    }

    public static ArrayList getPolicyWithEnrollRem() {
        ArrayList<Long> policies = new ArrayList<Long>();
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(new Table("SSPEnrollmentLogonScript"));
            Join scheduleJoin = new Join("SSPEnrollmentLogonScript", "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            Join taskIDJoin = new Join("Schedule", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            selQuery.addJoin(scheduleJoin);
            selQuery.addJoin(taskIDJoin);
            selQuery.addSelectColumn(new Column(null, "*"));
            RelationalAPI relApi = RelationalAPI.getInstance();
            Criteria crit = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"ADMIN_STATUS"), (Object)3, 0);
            selQuery.setCriteria(crit);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            Iterator it = dObj.get("SSPEnrollmentLogonScript", "POLICY_ID");
            while (it.hasNext()) {
                policies.add((Long)it.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUsersSIDInDO(List<Long> policyIds, String domainName, DataObject inputDO, Object instanceId) {
        logger.log(Level.INFO, "addUsersSIDInDO method invoked");
        Connection conn = null;
        DataSet dataSet = null;
        String[] selectColumns = new String[]{"SID_STRING", "OBJECT_GUID", "DN_STRING", "PRIMARY_GROUP_ID"};
        try {
            conn = RelationalAPI.getInstance().getConnection();
            dataSet = EnrollHandler.getDSForNonEnrolled(conn, domainName, null, true, selectColumns);
            while (dataSet.next()) {
                ArrayList groupsDN = GroupUtil.getAllGroupsOfUser(domainName, dataSet.getString("OBJECT_GUID"), dataSet.getString("PRIMARY_GROUP_ID"));
                Hashtable hash = PolicyHandler.checkUserPermission(domainName, dataSet.getString("DN_STRING").toLowerCase(), groupsDN);
                if (!((Boolean)hash.get("status")).booleanValue() || !policyIds.contains((Long)hash.get("policyId"))) continue;
                Row defInputRow = new Row("Default_Task_Input");
                defInputRow.set("INSTANCE_ID", instanceId);
                defInputRow.set("VARIABLE_NAME", dataSet.getValue("SID_STRING"));
                defInputRow.set("VARIABLE_VALUE", (Object)domainName);
                try {
                    inputDO.addRow(defInputRow);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "User has already added for this scheduler");
                    e.printStackTrace();
                }
            }
            DBUtil.closeQuietly(conn, dataSet);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(conn, dataSet);
        }
        logger.log(Level.INFO, "addUsersSIDInDO method ends");
    }

    public static synchronized void callScheduleTask(DataObject inputDO, Long scheduleId) {
        try {
            EnrollmentReminderUtil.updateCalendarTable(scheduleId);
            Scheduler scheduler = (Scheduler)BeanUtil.lookup((String)"Scheduler");
            scheduler.scheduleTask("adssp.admin.customization.remove_script_path", "adssp.xml.taskflow.remove_script_path", inputDO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addScriptPath(String domainName, Hashtable policyMap, Long agentAuditId) {
        DataSet dataSet = null;
        Connection conn = null;
        String[] selectColumns = new String[]{"SID_STRING", "OBJECT_GUID", "DN_STRING", "PRIMARY_GROUP_ID"};
        try {
            conn = RelationalAPI.getInstance().getConnection();
            dataSet = EnrollHandler.getDSForNonEnrolled(conn, domainName, null, true, selectColumns);
            while (dataSet.next()) {
                ArrayList groupsDN = GroupUtil.getAllGroupsOfUser(domainName, dataSet.getString("OBJECT_GUID"), dataSet.getString("PRIMARY_GROUP_ID"));
                Hashtable hash = PolicyHandler.checkUserPermission(domainName, dataSet.getString("DN_STRING").toLowerCase(), groupsDN);
                Enumeration e = policyMap.keys();
                while (e.hasMoreElements()) {
                    Long policyId = (Long)e.nextElement();
                    if (!((Boolean)hash.get("status")).booleanValue() || !((Long)hash.get("policyId")).equals(policyId)) continue;
                    String updateStatus = ADHandler.setScriptPath(domainName, dataSet.getString("SID_STRING"), "ADSelfService_Enroll.hta");
                    logger.log(Level.INFO, "Set script path for " + dataSet.getString("DN_STRING") + " Status : " + updateStatus);
                    AgentSchedulerUtil.addToAuditActionResult(dataSet.getString("OBJECT_GUID"), agentAuditId, updateStatus);
                }
            }
            DBUtil.closeQuietly(conn, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(conn, dataSet);
        }
    }
}

