/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class ExchangeUtil {
    private static String exchangeServerTable = "ADSMExchangeServers";
    private static String mailBoxStoreTable = "ADSMMailBoxStores";
    private static String adminGroupTable = "ADSMExchAdminGroups";
    public static String[] mailBoxColumns = new String[]{"NAME", "MAIL_NICK_NAME", "DN_STRING", "OBJECT_GUID", "E_MAIL", "DISPLAY_NAME"};

    public static ArrayList getExchangeAdminGroups(String domainName) {
        ArrayList list = new ArrayList();
        try {
            Table table = new Table(adminGroupTable);
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(new Column(adminGroupTable, "DOMAIN_NAME"), (Object)domainName, 0);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(new Column(adminGroupTable, "*"));
            selectQuery.addSortColumn(new SortColumn(new Column(adminGroupTable, "ADMIN_GROUP_NAME"), true));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator it = dataObj.getRows(adminGroupTable);
            ArrayList<String> groupNameList = new ArrayList<String>();
            ArrayList<String> groupDNList = new ArrayList<String>();
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String serverName = (String)r.get("ADMIN_GROUP_NAME");
                String legacyDN = (String)r.get("ADMIN_GRP_LEGACYDN");
                groupNameList.add(serverName);
                groupDNList.add(legacyDN);
            }
            list.add(groupNameList);
            list.add(groupDNList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getExchangeServers(String domainName) {
        ArrayList list = new ArrayList();
        try {
            Table table = new Table(exchangeServerTable);
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(new Column(exchangeServerTable, "DOMAIN_NAME"), (Object)domainName, 0);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumn(new Column(exchangeServerTable, "*"));
            selectQuery.addSortColumn(new SortColumn(new Column(exchangeServerTable, "SERVER_NAME"), true));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator it = dataObj.getRows(exchangeServerTable);
            ArrayList<String> serverNameList = new ArrayList<String>();
            ArrayList<String> serverDNList = new ArrayList<String>();
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String serverName = (String)r.get("SERVER_NAME");
                String distinguishedName = (String)r.get("LEGACY_EXCHANGE_DN");
                serverNameList.add(serverName);
                serverDNList.add(distinguishedName);
            }
            list.add(serverNameList);
            list.add(serverDNList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getMailBoxStores(String domainName, String serverDistinguishedName) {
        ArrayList list = new ArrayList();
        try {
            Table baseTable = new Table(mailBoxStoreTable);
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, new Table(exchangeServerTable), new String[]{"DOMAIN_EXCHANGE_SERVER_ID"}, new String[]{"DOMAIN_EXCHANGE_SERVER_ID"}, 2);
            sq.addJoin(join);
            sq.addSelectColumn(new Column(null, "*"));
            sq.addSortColumn(new SortColumn(new Column(mailBoxStoreTable, "STORE_NAME"), true));
            Criteria crit = new Criteria(new Column(exchangeServerTable, "DOMAIN_NAME"), (Object)domainName, 0);
            crit = crit.and(new Criteria(new Column(exchangeServerTable, "LEGACY_EXCHANGE_DN"), (Object)serverDistinguishedName, 0));
            sq.setCriteria(crit);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator it = dataObj.getRows(mailBoxStoreTable);
            ArrayList<String> storeNameList = new ArrayList<String>();
            ArrayList<String> storeDNList = new ArrayList<String>();
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String storeName = (String)r.get("STORE_NAME");
                String distinguishedName = (String)r.get("STORE_DISTINGUISHED_NAME");
                storeNameList.add(storeName);
                storeDNList.add(distinguishedName);
            }
            list.add(storeNameList);
            list.add(storeDNList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getMailBoxObjects(String searchPattern, String domainName, int startIndex, int numOfObjects) {
        String tableName = CommonUtil.getDomainUserTableName(domainName);
        ArrayList list = null;
        try {
            DataObject dataObject;
            Table table = new Table(tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(new Column(tableName, "MAIL_NICK_NAME"), (Object)"", 1);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(new Column(tableName, "NAME"), (Object)searchPattern, 2, false));
            }
            query.setCriteria(criteria);
            for (String str : mailBoxColumns) {
                query.addSelectColumn(new Column(tableName, str));
            }
            query.addSortColumn(new SortColumn(tableName, "NAME", true));
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (!(dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query)).isEmpty()) {
                list = CommonUtil.getList(dataObject, mailBoxColumns, tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getMailBoxObjectsCount(String searchPattern, String domainName) {
        String tableName = CommonUtil.getDomainUserTableName(domainName);
        Connection connection = null;
        Integer ret = null;
        try {
            Table table = new Table(tableName);
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Column countColumn = new Column(null, "*");
            sq.addSelectColumn(countColumn.count());
            Criteria criteria = new Criteria(new Column(tableName, "MAIL_NICK_NAME"), (Object)"", 1);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(new Column(tableName, "NAME"), (Object)searchPattern, 2, false));
            }
            sq.setCriteria(criteria);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            DataSet dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                ret = (Integer)dataSet.getValue(1);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return ret;
    }
}

