/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.admin.LayoutHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class FormatUtil {
    private static Logger logger = Logger.getLogger(FormatUtil.class.getName());
    public static String[] ldapNames = new String[]{"givenName", "sn", "initials", "displayName", "userPrincipalName", "sAMAccountName", "userName", "logonName", "mail", "distinguishedName"};
    public static String[] customNames = new String[]{"noOfDays", "password", "userName", "confirmCode", "dateTime", "ipAddress", "hostName", "reportName", "secureLink", "accessURL", "action", "domainName", "scheduleTime", "actionPhrase", "accounts", "updatedAttributes", "linkExpireTime"};

    public static String getNameFormats(String domainName, String message, Hashtable customValues) {
        message = FormatUtil.getNameFormats(domainName, message, "", "", customValues);
        return message;
    }

    public static String getNameFormats(String domainName, String message, String matchValue, String matchWith, Hashtable customValues) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        return FormatUtil.getNameFormats(domainName, message, matchValue, matchWith, customValues, rb);
    }

    public static String getNameFormats(String domainName, String message, String matchValue, String matchWith, Hashtable customValues, String samAccName) {
        Long loginId = ADMPUserHandler.getLoginId(samAccName, domainName);
        Long localeId = ResourceBundleMgr.getInstance().getUserLocaleId(loginId);
        if (localeId == -1L) {
            return FormatUtil.getNameFormats(domainName, message, matchValue, matchWith, customValues);
        }
        Locale locale = ResourceBundleMgr.getInstance().getLocale(localeId);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        return FormatUtil.getNameFormats(domainName, message, matchValue, matchWith, customValues, rb);
    }

    public static String getNameFormats(String domainName, String message, String matchValue, String matchWith, Hashtable customValues, AdventNetResourceBundle rb) {
        try {
            if (rb == null) {
                rb = ResourceBundleMgr.getInstance().getBundle();
            }
            String key = "";
            if (!customValues.isEmpty()) {
                for (String customName : customNames) {
                    Object customValue;
                    if (message.toLowerCase().indexOf(customName.toLowerCase()) == -1) continue;
                    key = "(?i)%" + customName + "%";
                    if (customName.equals("updatedAttributes")) {
                        customValue = (JSONArray)customValues.get(customName);
                        if (customValue != null && customValue.length() > 0) {
                            JSONObject json = (JSONObject)customValue.get(0);
                            String attributeNames = "";
                            String displayName = "";
                            String string = "";
                            int sNo = 0;
                            attributeNames = "<br><table border='1'><tr><td><b>S.No</b></td><td><b>Attribute Name</b></td><td><b>Updated Value</b></td></tr>";
                            for (int i = 0; i < customValue.length(); ++i) {
                                json = (JSONObject)customValue.get(i);
                                displayName = "";
                                if (json.has("isWorkFlow") && json.getBoolean("isWorkFlow")) {
                                    if ("<br><table border='1'><tr><td><b>S.No</b></td><td><b>Attribute Name</b></td><td><b>Updated Value</b></td></tr>".equals(attributeNames)) {
                                        attributeNames = "<br><table border='1'><tr><td><b>S.No</b></td><td><b>LDAP Name</b></td><td><b>Updated Value</b></td></tr>";
                                    }
                                } else {
                                    displayName = rb.getString((String)json.get("DISP_NAME"));
                                    String string2 = rb.getString((String)json.get("LDAP_NAME"));
                                    Long modifyId = (Long)json.get("MODIFY_ID");
                                    Long layoutId = (Long)json.get("LAYOUT_ID");
                                    if (modifyId < 1350L && (string2.equalsIgnoreCase("c") || string2.equalsIgnoreCase("countryCode"))) continue;
                                    if (modifyId != 0L && layoutId != 0L) {
                                        String displayNameFromLayout = rb.getString(LayoutHandler.getAttributeDisplayText(modifyId, layoutId));
                                        displayName = "".equals(displayNameFromLayout) ? displayName : displayNameFromLayout;
                                    }
                                }
                                displayName = "".equals(displayName) ? rb.getString((String)json.get("LDAP_NAME")) : displayName;
                                String value = rb.getString((String)json.get("VALUE"));
                                attributeNames = attributeNames + "<tr><td>" + ++sNo + ".</td><td>" + displayName + "</td><td>" + value + "</td></tr>";
                            }
                            if ((attributeNames = attributeNames + "</table>") == null || attributeNames.equals("")) continue;
                            message = message.replaceAll(key, StrUtil.escapeSplChars(attributeNames));
                            continue;
                        }
                        message = message.replaceAll(key, "");
                        continue;
                    }
                    if (customName.equals("domainName")) {
                        if (domainName == null || domainName.equals("")) continue;
                        String domainDispName = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "DOMAIN_DISPLAY_NAME");
                        message = message.replaceAll(key, StrUtil.escapeSplChars(domainDispName));
                        continue;
                    }
                    customValue = (String)customValues.get(customName);
                    if (customValue == null || ((String)customValue).equals("")) continue;
                    message = message.replaceAll(key, StrUtil.escapeSplChars((String)customValue));
                }
            }
            if (matchValue != null && !matchValue.equals("")) {
                ArrayList<String> tempLDAP = new ArrayList<String>(Arrays.asList(ldapNames));
                Hashtable customAttribDataTypeMap = ReportAttributeHandler.getCustomAttributesDataType();
                ArrayList CustomFieldList = new ArrayList(customAttribDataTypeMap.keySet());
                for (int i = 0; i < CustomFieldList.size(); ++i) {
                    tempLDAP.add((String)CustomFieldList.get(i));
                }
                ArrayList<String> LDAPList = new ArrayList<String>();
                for (String ldapName : tempLDAP) {
                    if (message.toLowerCase().indexOf(ldapName.toLowerCase()) == -1) continue;
                    if (ldapName.equalsIgnoreCase("userName") || ldapName.equalsIgnoreCase("logonName")) {
                        message = message.replaceAll("(?i)%" + ldapName + "%", "%name%");
                        ldapName = "name";
                    } else if (ldapName.equalsIgnoreCase("memberof")) {
                        ldapName = "memberOf";
                    }
                    LDAPList.add(ldapName);
                }
                if (LDAPList.size() > 0) {
                    Properties properties = new Properties();
                    if (domainName != null && !domainName.equals("")) {
                        properties = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_NAME");
                    }
                    Properties userDetails = FormatUtil.getObjectString(matchWith, matchValue, properties, LDAPList);
                    ArrayList<Object> userDetailsKey = new ArrayList<Object>(userDetails.keySet());
                    for (String string : userDetailsKey) {
                        key = "(?i)%" + string + "%";
                        String ldapValue = "";
                        ArrayList disList = (ArrayList)userDetails.get(string);
                        if (disList != null && !disList.isEmpty()) {
                            String strLDAP = disList.toString();
                            ldapValue = strLDAP.substring(1, strLDAP.length() - 1);
                            if ("DATETIME".equals((String)customAttribDataTypeMap.get(string.toLowerCase())) && (ldapValue = ReportAttributeHandler.getCustomAttribDate(string, ldapValue, null, rb)) == null) {
                                ldapValue = "";
                            }
                        }
                        message = message.replaceAll(key, StrUtil.escapeSplChars(ldapValue));
                    }
                    for (String string : LDAPList) {
                        message = message.replaceAll("(?i)%" + string + "%", "");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    public static Properties getObjectString(String matchLDAP, String matchValue, Properties properties, ArrayList attrList) {
        Properties prop = new Properties();
        try {
            String searchString = "(&(objectClass=user)(objectCategory=person)(" + matchLDAP + "=" + matchValue + "))";
            logger.log(Level.INFO, "The search string :" + searchString);
            if ("objectGUID".equals(matchLDAP)) {
                matchValue = matchValue.substring(matchValue.indexOf("{") + 1, matchValue.lastIndexOf("}"));
                Properties userDetails = ADHandler.getObjectFromGUID(properties, matchValue, attrList);
                logger.log(Level.INFO, "The userDetails are ::: " + userDetails);
                return userDetails;
            }
            ArrayList list = new ArrayList();
            try {
                list = ADHandler.getObjectsWithOutListener(properties, properties.getProperty("DEFAULT_NAMING_CONTEXT"), attrList, searchString);
            }
            catch (NativeException ne) {
                ne.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!list.isEmpty()) {
                prop = (Properties)list.get(0);
                logger.log(Level.INFO, "The userDetails are ::: " + prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }
}

