/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class GinaReportUtil {
    private static Logger reportLogger = Logger.getLogger(GinaReportUtil.class.getName());
    public static final String AGENT_TABLE = "AgentComputerDetails";
    public static List<String> agentList = Arrays.asList("COMPUTER_IP", "OBJECT_GUID", "INSTALL_STATUS", "AGENT_VERSION");
    public static final Long MAC_OS_TYPE = 3L;
    public static final String MAC_OS_X = "Mac OS X";

    public static int getNewInstallationCount(String domainName, Properties filter) {
        String tableName = CommonUtil.getDomainComputerTableName(domainName);
        SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)tableName));
        selQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        DataObject dataObject = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"OBJECT_GUID"), null, 0);
            if (filter != null && !filter.isEmpty()) {
                c = c.and(GinaReportUtil.getSearchCriteria(filter, tableName));
            }
            selQuery.setCriteria(c);
            Join join = new Join(tableName, AGENT_TABLE, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            selQuery.addJoin(join);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reportLogger.log(Level.INFO, " Size : " + dataObject.size(tableName));
        return dataObject.size(tableName);
    }

    private static void appendSelectColumn(SelectQuery selQuery, String tableName) {
        selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
        selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"NAME"));
        selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DN_STRING"));
        selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DNS_NAME"));
        selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"OS"));
        selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"OS_VERSION"));
        selQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"LOCATION"));
    }

    public static ArrayList getNewInstallationList(Properties filter, String domainName, int startIndex, int numOfObjects, String dNContext) {
        String tableName = CommonUtil.getDomainComputerTableName(domainName);
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            GinaReportUtil.appendSelectColumn((SelectQuery)selQuery, tableName);
            Criteria c = new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"OBJECT_GUID"), null, 0, false);
            if (filter != null && !filter.isEmpty()) {
                c = c.and(GinaReportUtil.getSearchCriteria(filter, tableName));
            }
            selQuery.setCriteria(c);
            Join join = new Join(tableName, AGENT_TABLE, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            selQuery.addJoin(join);
            if (startIndex != -1 || numOfObjects != -1) {
                selQuery.setRange(new Range(startIndex, numOfObjects));
            }
            selQuery.addSortColumn(GinaReportUtil.getSortColumn(filter, tableName));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            reportLogger.log(Level.INFO, " Size : " + dataObject.size(tableName));
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                String dnsName;
                Row row = (Row)iterator.next();
                String dn = (String)row.get("DN_STRING");
                String fqdn = (String)row.get("LOCATION");
                if (fqdn == null) {
                    fqdn = "--";
                }
                if ((dnsName = (String)row.get("DNS_NAME")) == null) {
                    dnsName = "--";
                }
                Properties properties = new Properties();
                properties.setProperty("NAME", (String)row.get("NAME"));
                properties.setProperty("GUID", (String)row.get("OBJECT_GUID"));
                properties.setProperty("DISTINGUISHED_NAME", dn);
                properties.setProperty("FQDN", fqdn);
                properties.setProperty("DNS_NAME", dnsName);
                properties.setProperty("OS", row.get("OS") != null ? (String)row.get("OS") : "--");
                if (row.get("OS_VERSION") != null) {
                    String osVersion = (String)row.get("OS_VERSION");
                    properties.setProperty("OS_VERSION", osVersion);
                    String os = properties.getProperty("OS");
                    if (MAC_OS_X.equals(os) && !"".equals(osVersion)) {
                        os = os + " - " + osVersion;
                        properties.setProperty("OS", os);
                    }
                }
                arrayList.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    public static int getInstalledComputerCount(Properties filter, String domainName, String defaultNamingContext) {
        try {
            String tableName = CommonUtil.getDomainComputerTableName(domainName);
            Table table = Table.getTable((String)AGENT_TABLE);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Join join = new Join(AGENT_TABLE, tableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            Criteria criteria = GinaReportUtil.getInstalledCriteria();
            if (filter != null && !filter.isEmpty()) {
                criteria = criteria.and(GinaReportUtil.getSearchCriteria(filter, tableName));
            }
            query.setCriteria(criteria);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            int count = dataObject.size(AGENT_TABLE);
            if (count != -1) {
                return count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static Criteria getSearchCriteria(Properties filter, String tableName) {
        Criteria c = null;
        if (filter.containsKey("searchPattern")) {
            c = new Criteria(Column.getColumn((String)tableName, (String)"NAME"), (Object)('*' + filter.getProperty("searchPattern") + '*'), 2, false);
        }
        if (filter.containsKey("os") && !filter.getProperty("os").equals("")) {
            String osIDStr = filter.getProperty("os");
            Long osID = Long.parseLong(osIDStr);
            Long typeID = GinaReportUtil.getOSTypeID(osID);
            String colName = MAC_OS_TYPE.equals(typeID) ? "OS_VERSION" : "OS";
            String searchStr = GinaReportUtil.getOSName(osID);
            c = c != null ? c.and(new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)('*' + searchStr + '*'), 2, false)) : new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)('*' + searchStr + '*'), 2, false);
        }
        return c;
    }

    private static Criteria getInstalledCriteria() {
        Criteria criteria = new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 0, false);
        criteria = criteria.or(new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_reinstall_success", 0, false));
        return criteria;
    }

    private static Criteria getErrorMachineCrit() {
        Criteria criteria = new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 1, false);
        criteria = criteria.and(new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_reinstall_success", 1, false));
        return criteria;
    }

    private static void appendAgentColumn(SelectQuery query) {
        query.addSelectColumn(Column.getColumn((String)AGENT_TABLE, (String)"COMPUTER_IP"));
        query.addSelectColumn(Column.getColumn((String)AGENT_TABLE, (String)"OBJECT_GUID", (String)"GUID"));
        query.addSelectColumn(Column.getColumn((String)AGENT_TABLE, (String)"INSTALL_STATUS"));
        query.addSelectColumn(Column.getColumn((String)AGENT_TABLE, (String)"AGENT_VERSION"));
    }

    public static ArrayList getInstalledMachineList(Properties filter, String domainName, int startIndex, int numOfObjects, String defaultnamingcontext) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            String tableName = CommonUtil.getDomainComputerTableName(domainName);
            Join join = new Join(AGENT_TABLE, tableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            Table table = Table.getTable((String)AGENT_TABLE);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = GinaReportUtil.getInstalledCriteria();
            if (filter != null && !filter.isEmpty()) {
                criteria = criteria.and(GinaReportUtil.getSearchCriteria(filter, tableName));
            }
            query.setCriteria(criteria);
            GinaReportUtil.appendAgentColumn((SelectQuery)query);
            GinaReportUtil.appendSelectColumn((SelectQuery)query, tableName);
            query.addJoin(join);
            query.addSortColumn(GinaReportUtil.getSortColumn(filter, tableName));
            if (startIndex != -1 || numOfObjects != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(AGENT_TABLE);
            while (iterator.hasNext()) {
                Properties properties = new Properties();
                Row row = (Row)iterator.next();
                boolean x = false;
                properties.setProperty("IPNAME", (String)row.get("COMPUTER_IP"));
                properties.setProperty("GUID", (String)row.get("OBJECT_GUID"));
                properties.setProperty("INSTALL_STATUS", (String)row.get("INSTALL_STATUS"));
                properties.setProperty("AGENT_VERSION", (String)row.get("AGENT_VERSION"));
                Row name = dataObject.getRow(tableName, new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)((String)row.get("OBJECT_GUID")), 0, false));
                properties.setProperty("NAME", (String)name.get("NAME"));
                properties.setProperty("DISTINGUISHED_NAME", (String)name.get("DN_STRING"));
                String fqdn = (String)name.get("LOCATION");
                if (fqdn == null) {
                    fqdn = "--";
                }
                properties.setProperty("FQDN", fqdn);
                String dnsName = (String)name.get("DNS_NAME");
                if (dnsName == null) {
                    dnsName = "--";
                }
                properties.setProperty("DNS_NAME", dnsName);
                properties.setProperty("OS", name.get("OS") != null ? (String)name.get("OS") : "--");
                if (name.get("OS_VERSION") != null) {
                    String osVersion = (String)name.get("OS_VERSION");
                    properties.setProperty("OS_VERSION", osVersion);
                    String os = properties.getProperty("OS");
                    if (MAC_OS_X.equals(os) && !"".equals(osVersion)) {
                        os = os + " - " + osVersion;
                        properties.setProperty("OS", os);
                    }
                }
                arrayList.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reportLogger.log(Level.INFO, "Total Installed computers in " + domainName + " are " + arrayList.size());
        return arrayList;
    }

    public static int getErrorComputerCount(Properties filter, String domainName, String defaultNamingContext) {
        try {
            String tableName = CommonUtil.getDomainComputerTableName(domainName);
            Table table = Table.getTable((String)AGENT_TABLE);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Join join = new Join(AGENT_TABLE, tableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            Criteria criteria = GinaReportUtil.getErrorMachineCrit();
            if (filter != null && !filter.isEmpty()) {
                criteria = criteria.and(GinaReportUtil.getSearchCriteria(filter, tableName));
            }
            query.setCriteria(criteria);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            int count = dataObject.size(AGENT_TABLE);
            if (count != -1) {
                return count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static ArrayList getErrorMachineList(Properties filter, String domainName, int startIndex, int numOfObjects, String defaultnamingcontext) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            String tableName = CommonUtil.getDomainComputerTableName(domainName);
            Join join = new Join(AGENT_TABLE, tableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            Table table = Table.getTable((String)AGENT_TABLE);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = GinaReportUtil.getErrorMachineCrit();
            if (filter != null && !filter.isEmpty()) {
                criteria = criteria.and(GinaReportUtil.getSearchCriteria(filter, tableName));
            }
            GinaReportUtil.appendAgentColumn((SelectQuery)query);
            GinaReportUtil.appendSelectColumn((SelectQuery)query, tableName);
            query.setCriteria(criteria);
            query.addJoin(join);
            query.addSortColumn(GinaReportUtil.getSortColumn(filter, tableName));
            if (startIndex != -1 || numOfObjects != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(AGENT_TABLE);
            while (iterator.hasNext()) {
                String dnsName;
                Properties properties = new Properties();
                Row row = (Row)iterator.next();
                properties.setProperty("IPNAME", (String)row.get("COMPUTER_IP"));
                properties.setProperty("GUID", (String)row.get("OBJECT_GUID"));
                properties.setProperty("REASON", (String)row.get("INSTALL_STATUS"));
                properties.setProperty("TROUBLESHOOT", (String)row.get("INSTALL_STATUS"));
                Row name = dataObject.getRow(tableName, new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)((String)row.get("OBJECT_GUID")), 0, false));
                properties.setProperty("NAME", (String)name.get("NAME"));
                properties.setProperty("DISTINGUISHED_NAME", (String)name.get("DN_STRING"));
                String fqdn = (String)name.get("LOCATION");
                if (fqdn == null) {
                    fqdn = "--";
                }
                properties.setProperty("FQDN", fqdn);
                properties.setProperty("OS", name.get("OS") != null ? (String)name.get("OS") : "--");
                if (name.get("OS_VERSION") != null) {
                    String osVersion = (String)name.get("OS_VERSION");
                    properties.setProperty("OS_VERSION", osVersion);
                    String os = properties.getProperty("OS");
                    if (MAC_OS_X.equals(os) && !"".equals(osVersion)) {
                        os = os + " - " + osVersion;
                        properties.setProperty("OS", os);
                    }
                }
                if ((dnsName = (String)name.get("DNS_NAME")) == null) {
                    dnsName = "--";
                }
                properties.setProperty("DNS_NAME", dnsName);
                arrayList.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reportLogger.log(Level.INFO, "Total Error Installation computers in " + domainName + " are " + arrayList.size());
        return arrayList;
    }

    public static Hashtable getUpdateList(Long generationid) {
        Hashtable<String, String> ginaInstallStatus = new Hashtable<String, String>();
        String tableName = "AgentAuditActionResult";
        Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"AGENT_ACTION_ID"), (Object)generationid, 0, false);
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"STATUS"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"AGENT_ACTION_ID"));
        query.setCriteria(criteria);
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                ginaInstallStatus.put((String)row.get("OBJECT_GUID"), (String)row.get("STATUS"));
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ginaInstallStatus;
    }

    private static Criteria getOUCriteria(String tableName, ArrayList selectedOUs) {
        Criteria ouCrit = null;
        for (int i = 0; i < selectedOUs.size(); ++i) {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DN_STRING"), (Object)("*" + QueryUtil.mickeyCriteriaEscape((String)selectedOUs.get(i))), 2);
            ouCrit = i == 0 ? crit : ouCrit.or(crit);
        }
        return ouCrit;
    }

    public static int getOUComputerCount(Properties filter, String domainName, ArrayList selectedOUs, String defaultnamingcontext) {
        String tableName = CommonUtil.getDomainComputerTableName(domainName);
        DataObject dataObject = null;
        try {
            Criteria ouCrit;
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            selQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
            Criteria c = new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"OBJECT_GUID"), null, 0, false);
            if (filter != null && !filter.isEmpty()) {
                c = c.and(GinaReportUtil.getSearchCriteria(filter, tableName));
            }
            Criteria criteria = ouCrit = (selectedOUs = OUUtil.getParentOUs(selectedOUs)).isEmpty() ? null : GinaReportUtil.getOUCriteria(tableName, selectedOUs);
            if (ouCrit != null) {
                c = c.and(ouCrit);
            }
            selQuery.setCriteria(c);
            selQuery.addSortColumn(GinaReportUtil.getSortColumn(filter, tableName));
            Join join = new Join(tableName, AGENT_TABLE, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            selQuery.addJoin(join);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int count = dataObject.size(tableName);
        reportLogger.log(Level.INFO, "Total number of OUs in " + domainName + " is " + count);
        return count;
    }

    public static ArrayList getOUListComputer(Properties filter, String domainName, int startIndex, int numOfObjects, ArrayList selectedOUs, String defaultnamingcontext) {
        String tableName = CommonUtil.getDomainComputerTableName(domainName);
        SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)tableName));
        GinaReportUtil.appendSelectColumn((SelectQuery)selQuery, tableName);
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            Criteria ouCrit;
            Criteria c = new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"OBJECT_GUID"), null, 0, false);
            if (filter != null && !filter.isEmpty()) {
                c = c.and(GinaReportUtil.getSearchCriteria(filter, tableName));
            }
            Criteria criteria = ouCrit = (selectedOUs = OUUtil.getParentOUs(selectedOUs)).isEmpty() ? null : GinaReportUtil.getOUCriteria(tableName, selectedOUs);
            if (ouCrit != null) {
                c = c.and(ouCrit);
            }
            selQuery.setCriteria(c);
            if (startIndex != -1 || numOfObjects != -1) {
                selQuery.setRange(new Range(startIndex, numOfObjects));
            }
            selQuery.addSortColumn(GinaReportUtil.getSortColumn(filter, tableName));
            Join join = new Join(tableName, AGENT_TABLE, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            selQuery.addJoin(join);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            reportLogger.log(Level.INFO, " OU Computer List Size : " + dataObject.size(tableName));
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                String dnsName;
                Row row = (Row)iterator.next();
                String dn = (String)row.get("DN_STRING");
                String fqdn = (String)row.get("LOCATION");
                if (fqdn == null) {
                    fqdn = "--";
                }
                if ((dnsName = (String)row.get("DNS_NAME")) == null) {
                    dnsName = "--";
                }
                Properties properties = new Properties();
                properties.setProperty("NAME", (String)row.get("NAME"));
                properties.setProperty("GUID", (String)row.get("OBJECT_GUID"));
                properties.setProperty("DISTINGUISHED_NAME", dn);
                properties.setProperty("FQDN", fqdn);
                properties.setProperty("DNS_NAME", dnsName);
                properties.setProperty("OS", row.get("OS") != null ? (String)row.get("OS") : "--");
                if (row.get("OS_VERSION") != null) {
                    String osVersion = (String)row.get("OS_VERSION");
                    properties.setProperty("OS_VERSION", osVersion);
                    String os = properties.getProperty("OS");
                    if (MAC_OS_X.equals(os) && !"".equals(osVersion)) {
                        os = os + " - " + osVersion;
                        properties.setProperty("OS", os);
                    }
                }
                arrayList.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    public static int getTotalSuccessInstallCount() {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 0, false);
            crit = crit.or(new Criteria(Column.getColumn((String)AGENT_TABLE, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_reinstall_success", 0, false));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AGENT_TABLE, crit);
            int nCount = dataObject.size(AGENT_TABLE);
            reportLogger.log(Level.INFO, "Get Installed Computer count " + nCount);
            if (nCount == -1) {
                nCount = 0;
            }
            return nCount;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static ArrayList getOSList() {
        ArrayList<JSONObject> osList = new ArrayList<JSONObject>();
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)"SSPGinaOsTypes"));
            Join join = new Join("SSPGinaOsTypes", "SSPGinaOsList", new String[]{"OS_TYPE_ID"}, new String[]{"OS_TYPE_ID"}, 1);
            selQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
            selQuery.addJoin(join);
            selQuery.addSortColumn(new SortColumn(Column.getColumn((String)"SSPGinaOsList", (String)"OS_ID"), false));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            obj.sortRows("SSPGinaOsTypes", new SortColumn[]{new SortColumn(Column.getColumn((String)"SSPGinaOsTypes", (String)"OS_TYPE_ID"), true)});
            if (!obj.isEmpty()) {
                Iterator itr = obj.getRows("SSPGinaOsTypes");
                while (itr.hasNext()) {
                    JSONObject osTypeDetails = new JSONObject();
                    Row r = (Row)itr.next();
                    Long osTypeId = (Long)r.get("OS_TYPE_ID");
                    String osTypeName = (String)r.get("OS_TYPE");
                    osTypeDetails.put("OS_TYPE_ID", (Object)osTypeId);
                    osTypeDetails.put("OS_TYPE", (Object)osTypeName);
                    Criteria crit = new Criteria(Column.getColumn((String)"SSPGinaOsList", (String)"OS_TYPE_ID"), (Object)osTypeId, 0, false);
                    JSONArray list = new JSONArray();
                    Iterator it = obj.getRows("SSPGinaOsList", crit);
                    while (it.hasNext()) {
                        JSONObject osDetails = new JSONObject();
                        Row row = (Row)it.next();
                        Long osId = (Long)row.get("OS_ID");
                        String osName = (String)row.get("OS_NAME");
                        osDetails.put("OS_ID", (Object)osId);
                        osDetails.put("OS_NAME", (Object)osName);
                        list.put((Object)osDetails);
                    }
                    osTypeDetails.put("OS_LIST", (Object)list);
                    osList.add(osTypeDetails);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return osList;
    }

    public static SortColumn getSortColumn(Properties filter, String tableName) {
        try {
            if (filter != null) {
                String sortColumn = filter.getProperty("SORT_COLUMN");
                Boolean sortType = Boolean.parseBoolean(filter.getProperty("IS_ASC"));
                if (sortColumn == null || "".equals(sortColumn)) {
                    sortColumn = "NAME";
                    sortType = true;
                }
                if (agentList.contains(sortColumn)) {
                    return new SortColumn(Column.getColumn((String)AGENT_TABLE, (String)sortColumn), sortType.booleanValue());
                }
                Column col = Column.getColumn((String)tableName, (String)sortColumn);
                if ("OS".equals(sortColumn)) {
                    if (CommonUtil.isMSSQL() && sortType.booleanValue()) {
                        sortType = false;
                    }
                    col = Column.createFunction((String)"CONCAT", (Object[])new Object[]{Column.getColumn((String)tableName, (String)"OS"), Column.getColumn((String)tableName, (String)"OS_VERSION")});
                    col.setType(1);
                }
                return new SortColumn(col, sortType.booleanValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SortColumn(Column.getColumn((String)tableName, (String)"NAME"), true);
    }

    public static String getOSName(Long osTypeId, String osVersion) {
        String osName = "";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPGinaOsList", (String)"OS_TYPE_ID"), (Object)osTypeId, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"SSPGinaOsList", (String)"OS_VERSION"), (Object)osVersion, 0, false));
            DataObject obj = CommonUtil.getCachedPersistence().get("SSPGinaOsList", crit);
            if (!obj.isEmpty()) {
                Row row = obj.getFirstRow("SSPGinaOsList");
                osName = (String)row.get("OS_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return osName;
    }

    public static Long getOSTypeID(Long osID) {
        Long osTypeID = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPGinaOsList", (String)"OS_ID"), (Object)osID, 0, false);
            DataObject obj = CommonUtil.getCachedPersistence().get("SSPGinaOsList", crit);
            if (!obj.isEmpty()) {
                Row row = obj.getFirstRow("SSPGinaOsList");
                osTypeID = (Long)row.get("OS_TYPE_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return osTypeID;
    }

    public static String getOSName(Long osID) {
        String osName = "";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPGinaOsList", (String)"OS_ID"), (Object)osID, 0, false);
            DataObject obj = CommonUtil.getCachedPersistence().get("SSPGinaOsList", crit);
            if (!obj.isEmpty()) {
                Row row = obj.getFirstRow("SSPGinaOsList");
                osName = (String)row.get("OS_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return osName;
    }
}

