/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ssh.SSHUtil;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.CreateProcess;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.VpnUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GinaUtil {
    private static Logger logger = Logger.getLogger("ReportLogger");
    public static String[] strLdap = new String[]{"objectGUID", "sAMAccountName", "computerIP", "dNSHostName", "domainName", "distinguishedName", "installedTime", "installedDir", "version", "installStatus"};
    public static String[] strColumn = new String[]{"OBJECT_GUID", "COMPUTER_NAME", "COMPUTER_IP", "DNS_NAME", "DOMAIN_NAME", "COMPUTER_DN", "AGENT_INSTALLED_ON", "AGENT_INSTALLED_DIR", "AGENT_VERSION", "INSTALL_STATUS"};

    public static Long addToAgentAuditActions(Long loginId, String installType) {
        Long ret = null;
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("AgentAuditActions");
            r.set("TYPE", (Object)installType);
            r.set("TIME", (Object)new Long(System.currentTimeMillis()));
            r.set("LOGIN_ID", (Object)loginId);
            dataObj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            ret = (Long)r.get("AGENT_ACTION_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Long getRecentGenerationId() {
        Long ret = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AgentComputerReports"));
            sq.addSelectColumn(Column.getColumn((String)"AgentComputerReports", (String)"REPORT_GENERATION_ID"));
            Column column = Column.getColumn((String)"AgentComputerReports", (String)"REPORT_GENERATION_TIME");
            SortColumn sortCol = new SortColumn(column, false);
            sq.addSortColumn(sortCol);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getRow("AgentComputerReports");
                ret = (Long)r.get("REPORT_GENERATION_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void addOrUpdateComputer(Properties prop) {
        String tableName = "AgentComputerDetails";
        try {
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)((String)prop.get("objectGUID")), 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
            if (obj.isEmpty()) {
                GinaUtil.addComputer(prop, obj);
            } else {
                GinaUtil.updateComputer((String)prop.get("objectGUID"), (String)prop.get("installStatus"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateComputer(String objectGuid, String installStatus) {
        logger.log(Level.FINE, "updateComputer:: Updating the installStatus for the given ObjectGuid :: AgentComputerDetails");
        try {
            String productInstallPath = System.getProperty("server.home");
            Hashtable packageDetails = CommonUtil.getPackageDetails(productInstallPath);
            Long currentTime = System.currentTimeMillis();
            UpdateQueryImpl query = new UpdateQueryImpl("AgentComputerDetails");
            query.setCriteria(new Criteria(Column.getColumn((String)"AgentComputerDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0));
            query.setUpdateColumn("INSTALL_STATUS", (Object)installStatus);
            query.setUpdateColumn("AGENT_INSTALLED_ON", (Object)currentTime);
            query.setUpdateColumn("AGENT_VERSION", (Object)((String)packageDetails.get("AgentVersion")));
            query.setUpdateColumn("AGENT_INSTALLED_DIR", (Object)((String)packageDetails.get("AgentDirectory")));
            DataAccess.update((UpdateQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addComputer(Properties prop, DataObject dataObj) {
        logger.log(Level.FINE, "addComputer :: Add Row :: AgentComputerDetails");
        try {
            Row r = new Row("AgentComputerDetails");
            for (int j = 0; j < strLdap.length; ++j) {
                String ldapName = strLdap[j];
                String columnName = strColumn[j];
                r.set(columnName, prop.get(ldapName));
            }
            dataObj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateComputerTable(String objectGuid, Row r) {
        try {
            logger.log(Level.FINE, "Updating AgentComputerDetails table");
            UpdateQueryImpl query = new UpdateQueryImpl("AgentComputerDetails");
            query.setCriteria(new Criteria(Column.getColumn((String)"AgentComputerDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0));
            for (int i = 0; i < strColumn.length; ++i) {
                if (strColumn[i].equalsIgnoreCase("OBJECT_GUID") || r.get(strColumn[i]) == null) continue;
                query.setUpdateColumn(strColumn[i], r.get(strColumn[i]));
            }
            DataAccess.update((UpdateQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getVersionInServer(String machineName, String domainName) {
        String version = null;
        try {
            Table table = Table.getTable((String)"AgentComputerDetails");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)"AgentComputerDetails", (String)"COMPUTER_NAME"), (Object)machineName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AgentComputerDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (dataObject.size("AgentComputerDetails") != -1) {
                Row row = dataObject.getRow("AgentComputerDetails");
                version = (String)row.get("AGENT_VERSION");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return version;
    }

    public static void addRowToComputerTable(Row row) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            obj.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Row getComputerDetails(String computerName, String domainName) {
        String domainCompTableName = CommonUtil.getDomainComputerTableName(domainName.toUpperCase());
        domainCompTableName = domainCompTableName.trim();
        Row row = null;
        try {
            Table table = Table.getTable((String)domainCompTableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)domainCompTableName, (String)"NAME"), (Object)computerName, 0);
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            row = dataObject.getRow(domainCompTableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }

    public static String runCommand(ArrayList ginaInputParams, String installAction) {
        String[] commandToExecute = new String[ginaInputParams.size()];
        ginaInputParams.toArray(commandToExecute);
        CreateProcess createProc = new CreateProcess(commandToExecute);
        createProc.start();
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (!createProc.finished);
        String systemStatus = createProc.getErrorStream();
        String systemOutput = createProc.getOutputStream();
        logger.log(Level.FINE, "The systemStatus is " + systemStatus);
        logger.log(Level.FINE, "The systemOutput value is " + systemOutput);
        String installStatus = GinaUtil.getLocalizedStringStatus(installAction, systemStatus, systemOutput);
        return installStatus;
    }

    public static String getLocalizedStringStatus(String installAction, String systemStatus, String systemOutput) {
        String installStatus = null;
        if ((systemStatus == null || systemStatus.equals("")) && systemOutput.indexOf("Remote command returned 0(0x0)") != -1) {
            if (installAction.equalsIgnoreCase("Install")) {
                installStatus = "adssp_admin_gina_install_success";
            } else if (installAction.equalsIgnoreCase("Reinstall")) {
                installStatus = "adssp_admin_gina_reinstall_success";
            } else if (installAction.equalsIgnoreCase("Uninstall")) {
                installStatus = "adssp_admin_gina_uninstall_success";
            }
        } else {
            installStatus = (systemStatus == null || systemStatus.equals("")) && systemOutput.indexOf("Initiating Connection to Remote Service . . .  Ok") != -1 && systemOutput.indexOf("Remote command returned") == -1 ? "adssp_admin_gina_err_could_not_install_client_software" : (systemStatus == null || systemStatus.equals("") && systemOutput.indexOf("Remote command returned") != -1 ? systemOutput.substring(systemOutput.indexOf("Remote command returned")) : (systemStatus == null || systemStatus.equals("") && systemOutput.indexOf("Initiating Connection to Remote Service . . .  Failed") == -1 ? "adssp_admin_gina_network_path_invalid_cred" : (systemStatus == null || systemStatus.equals("") ? "adssp_admin_gina_err_couldnotconnect" : systemStatus.trim())));
        }
        if (installStatus.indexOf("\n") != -1) {
            String str;
            Pattern pattern = Pattern.compile("\n");
            Matcher matcher = pattern.matcher(installStatus);
            installStatus = str = matcher.replaceAll(".");
        }
        if (installStatus.equalsIgnoreCase("Initiating Connection to Remote Service . . .  Failed")) {
            installStatus = "adssp_admin_gina_err_remote_connection";
        } else if (installStatus.indexOf("network path was not found") != -1) {
            installStatus = "adssp_admin_gina_network_path_not_found";
        } else if (installStatus.indexOf("Couldn't copy ADSelfServicePlusClientSoftware.msi") != -1) {
            installStatus = "adssp_admin_gina_couldnt_copy_client_software";
        } else if (installStatus.indexOf("Couldn't connect to") != -1 && installStatus.indexOf("ADMIN$.Access is denied") != -1) {
            installStatus = "adssp_config_gina_err_could_not_connect_adminshare_enable";
        } else if (installStatus.indexOf("Logon Failure: The target account name is incorrect") != -1) {
            installStatus = "adssp_config_gina_err_logon_failure_target_ac_incorrect";
        } else if (installStatus.indexOf("Logon failure: unknown user name or bad password") != -1) {
            installStatus = "adssp_config_gina_err_logon_failure_unknow_user_bad_pwd";
        } else if (installStatus.equalsIgnoreCase("Install action is Null")) {
            installStatus = "adssp_admin_gina_no_install_action";
        } else if (installStatus.equalsIgnoreCase("Couldn't start remote service.Access is denied.")) {
            installStatus = "adssp_admin_gina_couldnot_start_remote_service";
        } else if (installStatus.equalsIgnoreCase("Could not parse server install path")) {
            installStatus = "adssp_admin_gina_couldnot_parse_server_install_path";
        } else if (installStatus.indexOf("Remote command returned") != -1) {
            if (installStatus.indexOf("(0x1)") != -1) {
                installStatus = "adssp_admin_gina_err_incorrect";
            } else if (installStatus.indexOf("(0x666)") != -1) {
                installStatus = "adssp_admin_gina_another_ver";
            } else if (installStatus.indexOf("(0x64E)") != -1) {
                installStatus = "adssp_admin_gina_no_product";
            } else if (installStatus.indexOf("(0x652)") != -1) {
                installStatus = "adssp_admin_gina_err_in_progress";
            } else if (installStatus.indexOf("(0x2)") != -1) {
                installStatus = "adssp_admin_gina_no_file";
            } else if (installStatus.indexOf("(0x643)") != -1) {
                installStatus = "adssp_admin_gina_err_fatal_error";
            }
        }
        return installStatus;
    }

    public static boolean isMac(String os) {
        boolean isMac = false;
        try {
            isMac = os != null && !os.equals("") && os.toLowerCase().indexOf("windows") == -1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isMac;
    }

    public static void installPackage(Properties machineProp, String userName, String passWord, String installWith) {
        logger.log(Level.FINE, "Gina installation" + machineProp);
        String os = "";
        if (machineProp.containsKey("os")) {
            os = machineProp.getProperty("os");
        }
        if (GinaUtil.isMac(os)) {
            GinaUtil.installMacPackage(machineProp, userName, passWord, installWith);
        } else {
            GinaUtil.installWindowsPackage(machineProp, userName, passWord, installWith);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installMacPackage(Properties machineProp, String userName, String passWord, String installWith) {
        String installStatus = "adssp_admin_gina_install_success";
        SSHUtil ssh = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            if (userName == null || userName.equals("")) {
                throw new Exception("adssp_config_gina_err_logon_failure_unknow_user_bad_pwd");
            }
            String host = installWith != null && installWith.equalsIgnoreCase("dNSHostName") ? machineProp.getProperty("dNSHostName") : machineProp.getProperty("sAMAccountName");
            String installAction = (String)machineProp.get("installAction");
            logger.log(Level.FINE, "host : " + host + "\t| installAction : " + installAction + " | domainName : " + machineProp.get("domainName"));
            String domainFlatName = DomainUtil.getDomainData(machineProp.getProperty("domainName"), "DOMAIN_FLAT_NAME");
            userName = domainFlatName + "\\" + userName;
            ssh = new SSHUtil(userName, passWord, host);
            if (!ssh.connectionError.equals("")) {
                throw new Exception(ssh.connectionError);
            }
            if (!ssh.isAuthenticated()) {
                throw new Exception("adssp_config_gina_err_logon_failure_unknow_user_bad_pwd");
            }
            StringBuilder tmpDir = new StringBuilder();
            try {
                tmpDir.append(ssh.executeCommand("echo $TMPDIR"));
            }
            catch (Exception e) {
                tmpDir.append("/tmp/");
            }
            logger.log(Level.FINE, "TMPDIR : " + tmpDir.toString());
            StringBuilder binDir = new StringBuilder();
            binDir.append(System.getProperty("server.dir")).append("\\bin\\");
            if (!ssh.copyTo(binDir + "\\installMacAgent.sh", tmpDir + "installMacAgent.sh")) {
                throw new Exception("adssp_config_gina_mac_err_couldnt_copy_install_sh");
            }
            Properties customProps = new Properties();
            StringBuilder cmd = new StringBuilder().append("echo ").append(StrUtil.sshEscape(passWord)).append(" | sudo -S -u root sh ").append((CharSequence)tmpDir).append("installMacAgent.sh -remoteInstall");
            if (installAction.equalsIgnoreCase("Install") || installAction.equalsIgnoreCase("Reinstall") || installAction.equalsIgnoreCase("customize")) {
                if (installAction.equalsIgnoreCase("customize")) {
                    cmd.append(" -customize");
                } else {
                    if (!ssh.copyTo(binDir + "\\ADSelfServicePlusMacLoginAgent.pkg", tmpDir + "ADSelfServicePlusMacLoginAgent.pkg")) {
                        throw new Exception("adssp_config_gina_mac_err_couldnt_copy_pkg");
                    }
                    cmd.append(" -install -pkg ").append((CharSequence)tmpDir).append("ADSelfServicePlusMacLoginAgent.pkg");
                }
                customProps = AgentSchedulerUtil.getCustomProps(new Long(-1L));
                String param = StrUtil.sshEscape((String)customProps.get("SERVER_NAME"));
                if (param != null && !param.equals("")) {
                    cmd.append(" -serverName \"").append(param + "\"");
                }
                if ((param = StrUtil.sshEscape(String.valueOf(customProps.get("PORT_NO")))) != null && !param.equals("")) {
                    cmd.append(" -portNumber \"").append(param + "\"");
                }
                if ((param = StrUtil.sshEscape((String)customProps.get("PROD_TITLE"))) != null && !param.equals("")) {
                    cmd.append(" -prodTitle \"").append(param + "\"");
                }
                if ((param = (String)customProps.get("PROTOCOL")) != null && !param.equals("")) {
                    cmd.append(" -protocol \"").append(param + "\"");
                }
                if ((param = StrUtil.sshEscape((String)customProps.get("BUTTON_TEXT"))) != null && !param.equals("")) {
                    cmd.append(" -buttonText \"").append(rb.getString(param) + "\"");
                }
                if ((param = (String)customProps.get("ICON")) != null && !param.equals("")) {
                    cmd.append(" -imagePath \"reset_icon.png\"");
                }
            } else {
                installStatus = "adssp_admin_gina_uninstall_success";
                cmd.append(" -uninstall");
            }
            String output = "";
            try {
                output = ssh.executeCommand(cmd.toString());
            }
            catch (Exception e) {
                output = e.getMessage();
            }
            if (output != null && !output.equals("") && output.indexOf("success") != -1 && (installAction.equalsIgnoreCase("Install") || installAction.equalsIgnoreCase("Reinstall") || installAction.equalsIgnoreCase("customize"))) {
                String srcPath = (String)customProps.get("ICON");
                if (srcPath != null && !srcPath.equals("") && ssh.copyTo(srcPath, tmpDir.toString())) {
                    ssh.executeCommand("echo " + passWord + " | sudo -S -u root mv " + tmpDir + "reset_icon.bmp /Library/Application\\ Support/ADSSPLoginAgent/reset_icon.png");
                }
            } else if (output != null && !output.equals("") && output.indexOf("success") == -1) {
                if (output.toLowerCase().indexOf("permission denied") != -1 || output.toLowerCase().indexOf("sudoers file") != -1) {
                    installStatus = "adssp_config_gina_mac_err_permission_denied";
                } else {
                    installStatus = "adssp_config_gina_mac_err_failed";
                    logger.log(Level.INFO, host + " : " + installAction + " result : " + output);
                }
            }
        }
        catch (Exception e) {
            installStatus = e.getMessage();
            e.printStackTrace();
        }
        finally {
            machineProp.put("installedTime", new Long(System.currentTimeMillis()));
            machineProp.put("installedDir", "/Library/Application Suppport/ADSSPLoginAgent/");
            machineProp.put("version", "1.1");
            machineProp.put("installStatus", installStatus);
            try {
                if (ssh != null) {
                    ssh.exit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void installWindowsPackage(Properties machineProp, String userName, String passWord, String installWith) {
        Properties customProps = new Properties();
        String installStatus = null;
        ArrayList<String> ginaBaseParams = new ArrayList<String>();
        ginaBaseParams.add("RemCom.exe");
        try {
            String srcPath;
            String installAction;
            Properties vpnParams;
            Properties prop = AdminHandler.getAddOnRow("ManageEngine ADSelfService Plus");
            customProps = AgentSchedulerUtil.getCustomProps(new Long(-1L));
            if (prop != null) {
                customProps.put("SERVER_NAME", prop.get("HOST"));
                customProps.put("PORT_NO", prop.get("PORT") + "");
                customProps.put("PROTOCOL", prop.get("PROTOCOL"));
            }
            if ((vpnParams = VpnUtil.getVPNProviderSettings()).containsKey("IS_VPN_ENABLED") && ((Boolean)vpnParams.get("IS_VPN_ENABLED")).booleanValue()) {
                Properties vpnSettingsParams = (Properties)vpnParams.get("VPN_SETTINGS_PARAMS");
                Long vpnProviderId = (Long)vpnParams.get("VPN_PROVIDER_ID");
                customProps.put("VPN_SERVER_NAME", StrUtil.remcomEscape((String)vpnParams.get("VPN_SERVER_NAME")));
                customProps.put("VPN_PORT_NO", StrUtil.remcomEscape((String)vpnParams.get("VPN_PORT_NO")));
                if (vpnProviderId == 2L) {
                    customProps.put("PRE_SHARED_KEY", StrUtil.remcomEscape((String)vpnSettingsParams.get("PRE_SHARED_KEY")));
                    customProps.put("IS_TP_VPN_ENABLED", "f");
                } else {
                    customProps.put("VPN_CLIENT_LOCATION", StrUtil.remcomEscape((String)vpnSettingsParams.get("VPN_CLIENT_LOCATION")));
                    customProps.put("VPN_CLIENT_LOCATION_64", StrUtil.remcomEscape((String)vpnSettingsParams.get("VPN_CLIENT_LOCATION_64")));
                    customProps.put("VPN_CONNECT_CMD", " " + StrUtil.remcomEscape((String)vpnSettingsParams.get("CONNECT_CMD")));
                    customProps.put("VPN_DISCONNECT_CMD", " " + StrUtil.remcomEscape((String)vpnSettingsParams.get("DISCONNECT_CMD")));
                    if (vpnSettingsParams.containsKey("VPN_GROUP_NAME")) {
                        customProps.put("VPN_GROUP_NAME", StrUtil.remcomEscape((String)vpnSettingsParams.get("VPN_GROUP_NAME")));
                    }
                    if (vpnSettingsParams.containsKey("VPN_DOMAIN_NAME")) {
                        customProps.put("VPN_DOMAIN_NAME", StrUtil.remcomEscape((String)vpnSettingsParams.get("VPN_DOMAIN_NAME")));
                    }
                    customProps.put("IS_TP_VPN_ENABLED", "t");
                }
                customProps.put("IS_VPN_ENABLED", "t");
                customProps.put("VPN_TYPE", StrUtil.remcomEscape((String)vpnParams.get("VPN_TYPE")));
            }
            String clientMachine = installWith != null && installWith.equalsIgnoreCase("dNSHostName") ? machineProp.getProperty("dNSHostName") : machineProp.getProperty("sAMAccountName");
            ginaBaseParams.add("\\\\" + clientMachine);
            ginaBaseParams.add("/log:" + ADSMPersUtil.getCurrentLogLevel());
            if (userName != null && userName != "") {
                userName = machineProp.get("domainName") + "\\" + userName;
                ginaBaseParams.add("/user:" + userName);
                ginaBaseParams.add("/pwd:\"" + StrUtil.ginaPasswordEscape(passWord) + "\"");
            }
            ArrayList ginaInputParams = new ArrayList();
            ginaInputParams = (ArrayList)ginaBaseParams.clone();
            ginaInputParams.add("\"msiexec");
            ginaInputParams.add("/x");
            ginaInputParams.add("{E451B224-C4E6-452E-BB61-2EFD4DC79A9C}");
            ginaInputParams.add("/norestart REBOOT=ReallySuppress /qn\"");
            installStatus = GinaUtil.runCommand(ginaInputParams, "Uninstall");
            if (installStatus.indexOf("1605(0x645)") != -1) {
                logger.log(Level.INFO, "Uninstalling the client software in 4300 branch " + clientMachine);
                ginaInputParams.clear();
                ginaInputParams = (ArrayList)ginaBaseParams.clone();
                ginaInputParams.add("\"msiexec");
                ginaInputParams.add("/x");
                ginaInputParams.add("{43930BEA-C935-42A4-AD18-B2BC11C9D4BC}");
                ginaInputParams.add("/norestart REBOOT=ReallySuppress /qn\"");
                installStatus = GinaUtil.runCommand(ginaInputParams, "Uninstall");
            }
            if ((installAction = (String)machineProp.get("installAction")).equalsIgnoreCase("Install") || installAction.equalsIgnoreCase("Reinstall")) {
                ginaInputParams.clear();
                ginaInputParams = (ArrayList)ginaBaseParams.clone();
                GinaUtil.setGinaInputParameters(ginaInputParams, customProps);
                installStatus = GinaUtil.runCommand(ginaInputParams, installAction);
            }
            if ((installStatus.equals("adssp_admin_gina_install_success") || installStatus.equals("adssp_admin_gina_reinstall_success")) && (srcPath = (String)customProps.get("ICON")) != null && !srcPath.equals("")) {
                String machineName = machineProp.getProperty("sAMAccountName");
                String destPath = "\\\\" + machineName + "\\ADMIN$\\System32\\reset_icon.bmp";
                logger.log(Level.FINE, "The source path is " + srcPath + " and the destination is " + destPath);
                ADHandler.CopyFileToClient(srcPath, destPath, machineName, (String)machineProp.get("domainName"));
            }
        }
        catch (NativeException ne) {
            logger.log(Level.INFO, "Native Exception Thrown By GinaUtil while copy file to client........");
        }
        catch (Exception e) {
            installStatus = e.getMessage();
            e.printStackTrace();
        }
        String productInstallPath = System.getProperty("server.home");
        Hashtable packageDetails = CommonUtil.getPackageDetails(productInstallPath);
        String agentVersion = (String)packageDetails.get("AgentVersion");
        String agentInstallDir = (String)packageDetails.get("AgentDirectory");
        machineProp.put("installedTime", new Long(System.currentTimeMillis()));
        machineProp.put("installedDir", agentInstallDir);
        machineProp.put("version", agentVersion);
        machineProp.put("installStatus", installStatus);
    }

    public static void setGinaInputParameters(ArrayList ginaInputParams, Properties customProps) {
        String[] vpnConstants = new String[]{"VPN_SERVER_NAME", "VPN_PORT_NO", "VPN_USER_NAME", "VPN_PASSWORD", "VPN_CLIENT_LOCATION", "VPN_CLIENT_LOCATION_64", "VPN_CONNECT_CMD", "VPN_DISCONNECT_CMD", "IS_TP_VPN_ENABLED", "IS_VPN_ENABLED", "PRE_SHARED_KEY", "VPN_GROUP_NAME", "VPN_TYPE", "VPN_DOMAIN_NAME"};
        try {
            String customText;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            ginaInputParams.add("/c");
            ginaInputParams.add("ADSelfServicePlusClientSoftware.msi");
            String serverName = (String)customProps.get("SERVER_NAME");
            ginaInputParams.add("SERVERNAME=\"" + serverName + "\"");
            String portNumber = (String)customProps.get("PORT_NO");
            ginaInputParams.add("PORTNO=\"" + portNumber + "\"");
            if (customProps.containsKey("IS_VPN_ENABLED") && customProps.get("IS_VPN_ENABLED").equals("t")) {
                for (int i = 0; i < vpnConstants.length; ++i) {
                    if (!customProps.containsKey(vpnConstants[i])) continue;
                    ginaInputParams.add("" + vpnConstants[i] + "=\"\\\"" + (String)customProps.get(vpnConstants[i]) + "\\\"\"");
                }
            }
            if ((customText = StrUtil.remcomEscape((String)customProps.get("FRAME_TEXT"))) != null && !customText.equals("")) {
                ginaInputParams.add("FRAMETEXT=\"\\\"" + rb.getString(customText) + "\\\"\"");
            }
            if ((customText = StrUtil.remcomEscape((String)customProps.get("BUTTON_TEXT"))) != null && !customText.equals("")) {
                ginaInputParams.add("BUTTONTEXT=\"\\\"" + rb.getString(customText) + "\\\"\"");
            }
            if ((customText = StrUtil.remcomEscape((String)customProps.get("SHOW_ADSSP_TILE"))) != null && !customText.equals("")) {
                ginaInputParams.add("SHOWADSSPTILE=\"\\\"" + rb.getString(customText) + "\\\"\"");
            }
            if ((customText = StrUtil.remcomEscape((String)customProps.get("SHOW_ADSSP_LINK"))) != null && !customText.equals("")) {
                ginaInputParams.add("SHOWADSSPLINK=\"\\\"" + rb.getString(customText) + "\\\"\"");
            }
            if ((customText = StrUtil.remcomEscape((String)customProps.get("WINDOWS_LOGON_TFA"))) != null && !customText.equals("")) {
                ginaInputParams.add("WINDOWSLOGONTFA=\"\\\"" + rb.getString(customText) + "\\\"\"");
            }
            if ((customText = StrUtil.remcomEscape((String)customProps.get("BYPASS_ADSSPSERVER_UNREACH"))) != null && !customText.equals("")) {
                ginaInputParams.add("BYPASS=\"\\\"" + rb.getString(customText) + "\\\"\"");
            }
            if ((customText = StrUtil.remcomEscape((String)customProps.get("SERVER_UNREACH"))) != null && !customText.equals("")) {
                ginaInputParams.add("SERVERUNREACH=\"\\\"" + rb.getString(customText) + "\\\"\"");
            }
            if ((customText = StrUtil.remcomEscape((String)customProps.get("PROD_TITLE"))) != null && !customText.equals("")) {
                ginaInputParams.add("PROD_TITLE=\"\\\"" + customText + "\\\"\"");
            }
            if ((customText = StrUtil.remcomEscape((String)customProps.get("PROTOCOL"))) != null && !customText.equals("") && (customText.equalsIgnoreCase("http") || customText.equalsIgnoreCase("https"))) {
                ginaInputParams.add("PROTOCOL=\"\\\"" + customText + "\\\"\"");
            }
            if ("DEBUG".equalsIgnoreCase(customText = ADSMPersUtil.getCurrentLogLevel())) {
                ginaInputParams.add("LOGLEVEL=\"\\\"" + customText + "\\\"\"");
            }
            ginaInputParams.add("/norestart REBOOT=ReallySuppress /qn");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

