/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class GroupUtil {
    public static String getPrimaryGroup(String domainName, String primaryGroupId) {
        String primaryGroup = null;
        try {
            if (primaryGroupId == null) {
                return null;
            }
            String userGrptable = CommonUtil.getDomainGroupTableName(domainName);
            DataObject primaryGroupObj = CommonUtil.getPersistence(new boolean[0]).get(userGrptable, new Criteria(Column.getColumn((String)userGrptable, (String)"SID_STRING"), (Object)("-" + primaryGroupId), 11));
            if (!primaryGroupObj.isEmpty()) {
                Row primaryGroupRow = primaryGroupObj.getFirstRow(userGrptable);
                primaryGroup = (String)primaryGroupRow.get("DN_STRING");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return primaryGroup;
    }

    public static ArrayList getAllGroupsOfUser(String domainName, String objGuid, String primaryGroupId) {
        ArrayList<String> groupsDN = new ArrayList<String>();
        try {
            String primaryGroup = GroupUtil.getPrimaryGroup(domainName, primaryGroupId);
            if (primaryGroup != null) {
                groupsDN.add(primaryGroup);
            }
            String groupTN = CommonUtil.getDomainGroupTableName(domainName);
            Criteria membCrit = new Criteria(Column.getColumn((String)"ADSMGroupMembers", (String)"GROUP_MEMBER_OBJECTGUID"), (Object)objGuid, 0);
            SelectQueryImpl sq = new SelectQueryImpl(new Table("ADSMGroupMembers"));
            sq.addJoin(new Join("ADSMGroupMembers", groupTN, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
            sq.addSelectColumn(Column.getColumn((String)"ADSMGroupMembers", (String)"GROUP_MEMBER_OBJECTGUID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMGroupMembers", (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)groupTN, (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)groupTN, (String)"DN_STRING"));
            sq.setCriteria(membCrit);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows(groupTN);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    groupsDN.add((String)r.get("DN_STRING"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return groupsDN;
    }

    public static boolean isMemberOfGroups(String userGuid, ArrayList groupGuids, String primaryGroupId, String domainName) {
        try {
            Row primaryGroupRow;
            SelectQueryImpl query = null;
            Criteria crit = null;
            DataObject dataObject = null;
            if (groupGuids.size() > 0) {
                query = new SelectQueryImpl(new Table("ADSMGroupMembers"));
                crit = new Criteria(Column.getColumn((String)"ADSMGroupMembers", (String)"GROUP_MEMBER_OBJECTGUID"), (Object)userGuid, 0, false);
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMGroupMembers", (String)"OBJECT_GUID"), (Object)groupGuids.toArray(new String[groupGuids.size()]), 8, false));
                query.addSelectColumn(Column.getColumn((String)"ADSMGroupMembers", (String)"*"));
                query.setCriteria(crit);
                dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                if (!dataObject.isEmpty()) {
                    return true;
                }
            }
            if (primaryGroupId == null) {
                return false;
            }
            String userGrptable = CommonUtil.getDomainGroupTableName(domainName);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get(userGrptable, new Criteria(Column.getColumn((String)userGrptable, (String)"SID_STRING"), (Object)("-" + primaryGroupId), 11));
            if (!dataObject.isEmpty() && groupGuids.contains((String)(primaryGroupRow = dataObject.getFirstRow(userGrptable)).get("OBJECT_GUID"))) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static ArrayList<String> getMailListFromGroups(String[] groupsList, String domainName) {
        ArrayList<String> mailList = new ArrayList<String>();
        try {
            String tN = CommonUtil.getDomainUserTableName(domainName);
            SelectQueryImpl query = new SelectQueryImpl(new Table(tN));
            query.addJoin(new Join(tN, "ADSMGroupMembers", new String[]{"OBJECT_GUID"}, new String[]{"GROUP_MEMBER_OBJECTGUID"}, 2));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMGroupMembers", (String)"OBJECT_GUID"), (Object)groupsList, 8);
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)tN, (String)"*"));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!obj.isEmpty()) {
                Iterator mailIt = obj.getRows(tN);
                while (mailIt.hasNext()) {
                    mailList.add((String)((Row)mailIt.next()).get("E_MAIL"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mailList;
    }

    public static Properties getGroupPropsFromDN(String groupDN, String domainName, String[] columns) {
        Properties prop = new Properties();
        try {
            String DomainGroupTable = CommonUtil.getDomainGroupTableName(domainName);
            Criteria crit = new Criteria(Column.getColumn((String)DomainGroupTable, (String)"DN_STRING"), (Object)groupDN, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(DomainGroupTable, crit);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow(DomainGroupTable);
                for (String col : columns) {
                    String value = null;
                    if (col.equalsIgnoreCase("primaryGroupToken")) {
                        String SID = (String)r.get("SID_STRING");
                        value = SID.substring(SID.lastIndexOf(45) + 1);
                    } else {
                        value = (String)r.get(col);
                    }
                    prop.put(col, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static Properties getGroupPropsFromGUID(String groupGUID, String domainName, String[] columns) {
        Properties prop = new Properties();
        try {
            String DomainGroupTable = CommonUtil.getDomainGroupTableName(domainName);
            Criteria crit = new Criteria(Column.getColumn((String)DomainGroupTable, (String)"OBJECT_GUID"), (Object)groupGUID, 12);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(DomainGroupTable, crit);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow(DomainGroupTable);
                for (String col : columns) {
                    String value = null;
                    if (col.equalsIgnoreCase("primaryGroupToken")) {
                        String SID = (String)r.get("SID_STRING");
                        value = SID.substring(SID.lastIndexOf(45) + 1);
                    } else {
                        value = (String)r.get(col);
                    }
                    prop.put(col, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }
}

