/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.AlterTableQuery;
import com.adventnet.ds.query.AlterTableQueryImpl;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.reports.AuditQueryGenerator;
import com.adventnet.sym.adsm.common.server.reports.CreateAuditTable;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.MetaTableHandler;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MoveRecreateTableHandler {
    private static MoveRecreateTableHandler moveRecreateTableHandler = null;
    private RelationalAPI relationalAPI = RelationalAPI.getInstance();
    private static Logger logger = Logger.getLogger(MoveRecreateTableHandler.class.getName());

    private MoveRecreateTableHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoveRecreateTableHandler getInstance() {
        if (moveRecreateTableHandler != null) return moveRecreateTableHandler;
        Class<MoveRecreateTableHandler> clazz = MoveRecreateTableHandler.class;
        synchronized (MoveRecreateTableHandler.class) {
            if (moveRecreateTableHandler != null) return moveRecreateTableHandler;
            moveRecreateTableHandler = new MoveRecreateTableHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return moveRecreateTableHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveRecreateTable(String tableName, AuditQueryGenerator qgObj) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.relationalAPI.getConnection();
            statement = connection.createStatement();
            Long currentTime = System.currentTimeMillis();
            String newTableName = tableName + "_" + currentTime;
            AlterTableQueryImpl alt = new AlterTableQueryImpl(tableName);
            alt.renameTable(newTableName);
            CommonUtil.getPersistence(new boolean[0]).alterTable((AlterTableQuery)alt);
            String changeQuery = "UPDATE ColumnDetails SET GENERATOR_NAME = NULL WHERE GENERATOR_NAME = '" + tableName + ".AUDIT_ID';";
            QueryUtil.executeUpdate("Removing Unique Value Gen", statement, changeQuery);
            CreateAuditTable.create(tableName);
            MetaTableHandler.addMetaTableRow(tableName, newTableName, statement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyFKConstName(String newFKName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        RelationalAPI relationalAPI = null;
        String oldFKName = null;
        String sql = "SELECT CONSTRAINT_NAME FROM CONSTRAINTDEFINITION JOIN TABLEDETAILS ON CONSTRAINTDEFINITION.TABLE_ID=TABLEDETAILS.TABLE_ID WHERE TABLEDETAILS.TABLE_NAME='SSPAudit' AND CONSTRAINT_NAME LIKE 'SSPAudit_FK%'";
        try {
            relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting Foreign Key Constraint Name From Constraint", statement, sql);
            while (resultSet.next()) {
                oldFKName = resultSet.getString("CONSTRAINT_NAME");
                logger.log(Level.INFO, "OLD FK NAME :: " + oldFKName);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (oldFKName != null && !oldFKName.equalsIgnoreCase(newFKName)) {
            try {
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ConstraintDefinition", new Criteria(Column.getColumn((String)"ConstraintDefinition", (String)"CONSTRAINT_NAME"), (Object)oldFKName, 0, false));
                if (!dataObj.isEmpty()) {
                    Row row = dataObj.getFirstRow("ConstraintDefinition");
                    row.set("CONSTRAINT_NAME", (Object)newFKName);
                    dataObj.updateRow(row);
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

