/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.DomainAction;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class OUUtil {
    public static ArrayList<String> getOUDN(ArrayList<String> ouList) {
        try {
            Criteria crit = null;
            ArrayList<String> ouDN = new ArrayList<String>();
            String[] ouCritArr = new String[ouDN.size()];
            ouCritArr = ouDN.toArray(ouCritArr);
            crit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)ouCritArr, 8);
            DataObject ouObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMOUDetails", crit);
            if (!ouObj.isEmpty()) {
                Iterator ouIterations = ouObj.getRows("ADSMOUDetails");
                while (ouIterations.hasNext()) {
                    Row ou = (Row)ouIterations.next();
                    ouDN.add((String)ou.get("DISTINGUISHED_NAME"));
                }
                return ouDN;
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ArrayList getOUProps(String domainName, ArrayList ouList) {
        ArrayList<Properties> ouProps = new ArrayList<Properties>();
        try {
            Criteria crit = null;
            for (int i = 0; i < ouList.size(); ++i) {
                crit = crit == null ? new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"), ouList.get(i), 0) : crit.or(new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"), ouList.get(i), 0));
            }
            Criteria c = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            c = c.and(crit);
            SelectQueryImpl query = new SelectQueryImpl(new Table("ADSMOUDetails"));
            query.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"*"));
            query.setCriteria(c);
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMOUDetails", (String)"NAME"), true));
            DataObject ouObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator ouIterations = ouObj.getRows("ADSMOUDetails");
            while (ouIterations.hasNext()) {
                Properties ouProp = new Properties();
                Row ou = (Row)ouIterations.next();
                ouProp.put("DISTINGUISHED_NAME", ou.get("DISTINGUISHED_NAME"));
                ouProp.put("OU_NAME", ou.get("NAME"));
                ouProp.put("OBJECT_GUID", ou.get("OBJECT_GUID"));
                ouProps.add(ouProp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ouProps;
    }

    public static ArrayList getSelDomainOUs(String domainName) {
        ArrayList<String> OUList = new ArrayList<String>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyCriteria", crit);
            Iterator iterator = obj.getRows("PolicyCriteria");
            while (iterator.hasNext()) {
                Row r = (Row)iterator.next();
                OUList.add((String)r.get("DISTINGUISHED_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return OUList;
    }

    public static String getOUProp(String columnName, String columnValue, String requiredColumn, String domainName, Long loginId) {
        String requiredValue;
        block7: {
            requiredValue = null;
            try {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)columnName), (Object)columnValue, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMOUDetails", crit);
                if (!dataObject.isEmpty()) {
                    Row r = dataObject.getFirstRow("ADSMOUDetails");
                    requiredValue = (String)r.get(requiredColumn);
                    break block7;
                }
                String[] updates = new String[]{"OU"};
                try {
                    DomainAction.addOUs(domainName, loginId, true);
                }
                catch (ADSSPException ae) {
                    ae.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Criteria c = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)columnName), (Object)columnValue, 0);
                DataObject o = CommonUtil.getPersistence(new boolean[0]).get("ADSMOUDetails", c);
                if (!o.isEmpty()) {
                    Row r = o.getFirstRow("ADSMOUDetails");
                    requiredValue = (String)r.get(requiredColumn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return requiredValue;
    }

    public static ArrayList getParentOUs(ArrayList l) {
        ArrayList list = (ArrayList)l.clone();
        block0: for (int i = 0; i < list.size(); ++i) {
            String s1 = ((String)list.get(i)).toLowerCase();
            for (int j = i + 1; j < list.size(); ++j) {
                String s2 = ((String)list.get(j)).toLowerCase();
                if (s1.endsWith(s2)) {
                    list.remove(i);
                    --i;
                    continue block0;
                }
                if (!s2.endsWith(s1)) continue;
                list.remove(j);
                --i;
                continue block0;
            }
        }
        return list;
    }

    public static ArrayList getOUList(String domainName, Criteria c) {
        return OUUtil.getOUList(domainName, c, "DISTINGUISHED_NAME");
    }

    public static ArrayList getOUList(String domainName, Criteria c, String columnName) {
        ArrayList<Object> ouList = new ArrayList<Object>();
        try {
            String tableName = "ADSMOUDetails";
            Criteria crit = null;
            if (domainName != null && !domainName.equals("")) {
                crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            }
            if (c != null) {
                crit = crit != null ? crit.and(c) : c;
            }
            DataObject roleObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            Iterator it = roleObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                ouList.add(r.get(columnName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ouList;
    }
}

