/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.common.server.reports.AuditMsSQLGenerator;
import com.adventnet.sym.adsm.common.server.reports.AuditMySQL4Generator;
import com.adventnet.sym.adsm.common.server.reports.AuditMySQL5Generator;
import com.adventnet.sym.adsm.common.server.reports.AuditPgSQLGenerator;
import com.adventnet.sym.adsm.common.server.reports.AuditQueryGenerator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryGeneratorFactory {
    private static Logger logger = Logger.getLogger(QueryGeneratorFactory.class.getName());
    private static AuditQueryGenerator qgObj;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuditQueryGenerator getQGInstance() {
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            DatabaseMetaData dbm = connection.getMetaData();
            int dbVersion = dbm.getDatabaseMajorVersion();
            String dbName = dbm.getDatabaseProductName();
            logger.log(Level.INFO, "DB NAME : VERSION :::::::::::::::: " + dbName + ":" + dbVersion);
            qgObj = "MySQL".equalsIgnoreCase(dbName) && dbVersion < 5 ? new AuditMySQL4Generator() : ("MySQL".equalsIgnoreCase(dbName) ? new AuditMySQL5Generator() : ("PostgreSQL".equalsIgnoreCase(dbName) ? new AuditPgSQLGenerator() : new AuditMsSQLGenerator()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return qgObj;
    }

    public static synchronized AuditQueryGenerator getInstance() {
        if (qgObj == null) {
            qgObj = QueryGeneratorFactory.getQGInstance();
        }
        return qgObj;
    }
}

