/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryUtil {
    private static Logger logger = Logger.getLogger(QueryUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowsCount(String query) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Integer count = 0;
        try {
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            statement = connection.createStatement();
            query = QueryUtil.escape(query);
            resultSet = QueryUtil.executeQuery("Report Count", statement, query);
            while (resultSet.next()) {
                count = resultSet.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSingleQuery(String name, String query) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            logger.log(Level.INFO, "Executing Query [{0} for [{1}]]: " + new Object[]{name, query});
            statement.execute(query);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while executing the query: " + query);
            e.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    private static String escape(String query) {
        query = query.replaceAll("\"", "&quot;");
        return query;
    }

    public static String mySqlCritEscape(String critString) {
        if (critString == null) {
            return null;
        }
        if (critString.contains("\\") || critString.contains("%") || critString.contains("*") || critString.contains("[") || critString.contains("]")) {
            critString = critString.replaceAll("\\\\", "\\\\\\\\\\\\\\\\").replaceAll("%", "\\\\\\\\%").replaceAll("\\*", "\\\\*").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]").replaceAll("_", "\\\\\\\\_");
        }
        return StrUtil.queryEscape(critString);
    }

    public static String criteriaEscape(String critString) {
        if (critString == null) {
            return null;
        }
        if (critString.contains("\\") || critString.contains("%") || critString.contains("*") || critString.contains("[") || critString.contains("]")) {
            critString = critString.replaceAll("\\\\", "\\\\\\\\").replaceAll("%", "\\\\%").replaceAll("\\*", "\\\\*").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]");
        }
        return StrUtil.queryEscape(critString);
    }

    public static String mickeyCriteriaEscape(String critString) {
        try {
            if (critString != null) {
                critString = critString.replaceAll("\\\\", "\\\\\\\\");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return critString;
    }

    public static ResultSet executeQuery(String name, Statement statement, String sql) throws Exception {
        return QueryUtil.executeQuery(name, statement, sql, true);
    }

    public static ResultSet executeQuery(String name, Statement statement, String sql, Boolean esc) throws Exception {
        ResultSet resultSet = null;
        try {
            long queryTime = System.currentTimeMillis();
            if (esc.booleanValue()) {
                sql = QueryUtil.escape(sql);
            }
            logger.log(Level.FINE, "Executing query [{0}] for [{1}]", new Object[]{sql, name});
            resultSet = statement.executeQuery(sql);
            queryTime = System.currentTimeMillis() - queryTime;
            logger.log(Level.FINE, "Time taken for executing query [{0}] for [{1}] time taken is [{2}]", new Object[]{sql, name, new Long(queryTime)});
        }
        catch (Exception e) {
            logger.log(Level.INFO, "executeQuery exception... SQL is " + sql);
            e.printStackTrace();
            throw new Exception(e);
        }
        return resultSet;
    }

    public static int executeUpdate(String name, Statement stmt, String sql) throws Exception {
        int count = 0;
        try {
            long intime2 = System.currentTimeMillis();
            logger.log(Level.FINE, "Executing query [{0}] for [{1}]", new Object[]{sql, name});
            boolean result = stmt.execute(sql);
            if (!result) {
                count = stmt.getUpdateCount();
            }
            intime2 = System.currentTimeMillis() - intime2;
            logger.log(Level.INFO, "Time taken for executing query [{0}] for [{1}] time taken is [{2}]", new Object[]{sql, name, new Long(intime2)});
        }
        catch (Exception e) {
            logger.log(Level.INFO, "executeUpdate exception... SQL is " + sql);
            e.printStackTrace();
            throw new Exception(e);
        }
        return count;
    }
}

