/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunCmd
extends Thread
implements Serializable {
    private static Logger reportLogger = Logger.getLogger(RunCmd.class.getName());
    private boolean stdoutFlag = false;
    public String command = null;
    public String[] ginaInputParams;
    public boolean useProcessBuilder = false;
    public StringBuffer stdout = new StringBuffer();
    public long timeOut = 120000L;
    public StringBuffer stderr = new StringBuffer();
    public boolean result = false;
    public int exitValue = -1;
    Process proc = null;
    RunCmd readErr = null;
    public boolean finished = false;

    RunCmd() {
    }

    RunCmd(boolean stdoutFlagArg) {
        this.stdoutFlag = stdoutFlagArg;
    }

    public RunCmd(String cmd) {
        super(cmd);
        this.command = cmd;
    }

    public RunCmd(String cmd, long executeTIme) {
        super(cmd);
        this.command = cmd;
        this.timeOut = executeTIme;
    }

    public RunCmd(String cmd, boolean stdoutFlagArg) {
        super(cmd);
        this.command = cmd;
        this.stdoutFlag = stdoutFlagArg;
    }

    public RunCmd(String[] ginaCmd, boolean isUnicode) {
        this.ginaInputParams = ginaCmd;
        this.useProcessBuilder = isUnicode;
    }

    @Override
    public void run() {
        if (!this.useProcessBuilder) {
            this.runRuntimeExec();
        } else {
            this.runProcessBuilder();
        }
        this.finished = true;
    }

    public void runRuntimeExec() {
        if (this.command == null) {
            if (this.proc == null) {
                return;
            }
            this.getStdErr();
        } else {
            Process p = null;
            Object line = null;
            try {
                p = Runtime.getRuntime().exec(this.command);
            }
            catch (Exception e) {
                this.systemerr("The command could not be executed");
                this.result = false;
            }
            boolean isPingCmd = this.command.indexOf("RemCom") != -1;
            this.result = this.runCommandStatus(p, isPingCmd);
        }
    }

    public void runProcessBuilder() {
        if (this.ginaInputParams.length == 0) {
            if (this.proc == null) {
                return;
            }
            this.getStdErr();
        } else {
            Process p = null;
            Object line = null;
            try {
                HashMap<String, String> newEnv = new HashMap<String, String>();
                newEnv.putAll(System.getenv());
                String[] i18n = new String[this.ginaInputParams.length + 2];
                i18n[0] = "cmd";
                i18n[1] = "/C";
                i18n[2] = this.ginaInputParams[0];
                for (int counter = 1; counter < this.ginaInputParams.length; ++counter) {
                    String envName = "GINA_" + counter;
                    i18n[counter + 2] = "%" + envName + "%";
                    newEnv.put(envName, this.ginaInputParams[counter]);
                }
                this.ginaInputParams = i18n;
                ProcessBuilder pb = new ProcessBuilder(this.ginaInputParams);
                Map<String, String> env = pb.environment();
                env.putAll(newEnv);
                p = pb.start();
            }
            catch (Exception e) {
                this.systemerr("The command could not be executed");
                this.result = false;
            }
            boolean isPingCmd = this.ginaInputParams[0].equals("RemCom.exe");
            this.result = this.runCommandStatus(p, isPingCmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCommandStatus(Process p, boolean isPingCmd) {
        boolean returnValue = false;
        if (p != null) {
            this.readErr = new RunCmd(this.stdoutFlag);
            this.proc = p;
            this.readErr.proc = p;
            this.readErr.stderr = this.stderr;
            this.readErr.start();
            InputStreamReader tst = new InputStreamReader(p.getInputStream());
            try {
                char c = (char)tst.read();
                if (c != '\uffffffff') {
                    this.systemout(c);
                }
                long l = System.currentTimeMillis();
                while (c != '\uffffffff') {
                    if (!tst.ready()) {
                        try {
                            p.exitValue();
                            break;
                        }
                        catch (IllegalThreadStateException itse) {
                            try {
                                Thread.sleep(100L);
                                if (!isPingCmd || System.currentTimeMillis() - l <= this.timeOut) continue;
                                this.stopCommand();
                                break;
                            }
                            catch (InterruptedException ex) {
                                continue;
                            }
                        }
                    }
                    c = (char)tst.read();
                    this.systemout(c);
                    if (!isPingCmd || System.currentTimeMillis() - l <= this.timeOut) continue;
                    this.stopCommand();
                    break;
                }
            }
            catch (IOException e) {
                this.systemerr("Error running command: " + e);
                boolean bl = returnValue;
                return bl;
            }
            finally {
                try {
                    tst.close();
                }
                catch (IOException ie) {
                    System.err.println("RunCmd : Error closing InputStream " + ie);
                }
                p.destroy();
            }
            if ((this.exitValue = p.exitValue()) == 0) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean getStdErr() {
        String line = null;
        BufferedReader tst = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
        try {
            while (true) {
                if (!tst.ready()) {
                    try {
                        this.proc.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException itse) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            continue;
                        }
                    }
                }
                line = tst.readLine();
                this.systemerr(line + "\n");
            }
        }
        catch (IOException e) {
            this.systemerr("Error running command: " + this.command + " : " + e);
            try {
                tst.close();
                return false;
            }
            catch (IOException ie) {
                System.err.println("RunCmd : Error closing ErrorStream " + ie);
            }
            return false;
        }
        try {
            tst.close();
            return true;
        }
        catch (IOException iee) {
            System.err.println("RunCmd : Error closing InputStream " + iee);
        }
        return true;
    }

    private void systemout(char ch) {
        if (this.stdoutFlag) {
            reportLogger.log(Level.INFO, Character.toString(ch));
        } else {
            this.stdout.append(ch);
        }
    }

    private void systemerr(String s) {
        if (this.stdoutFlag) {
            System.err.println(s);
        } else {
            this.stderr.append(s);
        }
    }

    public void stopCommand() {
        reportLogger.log(Level.INFO, "Stopping the command");
        System.out.println("Stopping the command");
        this.finished = true;
        this.stop();
        if (this.readErr != null) {
            this.readErr.stop();
        }
        if (this.proc != null) {
            this.proc.destroy();
        }
    }
}

