/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class SearchDBObject {
    private ArrayList guidList = null;
    private Hashtable tableRowMap = null;
    private Hashtable relationalTableRowMap = null;
    private String objectClass = null;

    public SearchDBObject(String objClass) {
        this.objectClass = objClass;
        this.guidList = new ArrayList();
        this.tableRowMap = new Hashtable();
        this.relationalTableRowMap = new Hashtable();
    }

    public void add(String guid, Hashtable map, Hashtable relationalMap) {
        if (!this.guidList.contains(guid)) {
            this.guidList.add(guid);
        }
        this.add(map, this.tableRowMap);
        this.add(relationalMap, this.relationalTableRowMap);
    }

    private void add(Hashtable map, Hashtable tableRowMap) {
        Enumeration enumeration = map.keys();
        while (enumeration.hasMoreElements()) {
            String tableName = (String)enumeration.nextElement();
            ArrayList source = (ArrayList)map.get(tableName);
            ArrayList destination = (ArrayList)tableRowMap.get(tableName);
            if (destination == null) {
                destination = new ArrayList();
                tableRowMap.put(tableName, destination);
            }
            destination.addAll(source);
        }
    }

    public String getBaseTable() {
        ObjectClass obj = SearchProfileHandler.getInstance().getObjectClass(this.objectClass);
        return obj.getBaseTable();
    }

    public String getResultTable() {
        ObjectClass obj = SearchProfileHandler.getInstance().getObjectClass(this.objectClass);
        return obj.getResultTable();
    }

    public ArrayList getGuidList() {
        return this.guidList;
    }

    public Hashtable getTableMap() {
        return this.tableRowMap;
    }

    public Hashtable getMultipleMap() {
        return this.relationalTableRowMap;
    }
}

